/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSOptionPaneBuyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class SSOptionPane {
    private static int LINE_LENGTH = 60;
    private static Icon ssoptionIcon;
    public static final int ERROR_MESSAGE = 0;

    public static int showOptionDialog(Component com, Object text, String title, Object[] options, Object defaultOption) {
        return JOptionPane.showOptionDialog(com, text, title, -1, 1, SSOptionPane.getDefaultIcon(), options, defaultOption);
    }

    public static void showRegistrationDialog(String title, String message, Object component, String statsKey, SSOptionPaneBuyHandler buyHandler) {
        Object[] options = new Object[]{Translator.getString("RegisterOnline"), Translator.getString("OK")};
        int result = JOptionPane.showOptionDialog((Component)component, StringTool.wrapLines(message, LINE_LENGTH), title, -1, 1, SSOptionPane.getDefaultIcon(), options, options[0]);
        if (result == 0) {
            buyHandler.gotoBuyHandler(statsKey);
        }
    }

    public static String showInputDialog(Component parentComponent, Object message) {
        return SSOptionPane.showInputDialog(parentComponent, message, "");
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        return (String)SSOptionPane.showInputDialog(parentComponent, message, null, 1, null, null, initialSelectionValue);
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        return JOptionPane.showInputDialog(parentComponent, StringTool.wrapLines(message, LINE_LENGTH), title, messageType, SSOptionPane.getDefaultIcon(), selectionValues, initialSelectionValue);
    }

    public static int showYesNoDialog(String title, String message) {
        return JOptionPane.showConfirmDialog(null, StringTool.wrapLines(message, LINE_LENGTH), title, 0, 1, SSOptionPane.getDefaultIcon());
    }

    public static int showYesNoDialog(Component parent, String title, String message) {
        return JOptionPane.showConfirmDialog(parent, StringTool.wrapLines(message, LINE_LENGTH), title, 0, 1, SSOptionPane.getDefaultIcon());
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        return JOptionPane.showConfirmDialog(parentComponent, StringTool.wrapLines(message, LINE_LENGTH), title, optionType, 1, SSOptionPane.getDefaultIcon());
    }

    public static void showMessageDialog(String message) {
        SSOptionPane.showMessageDialog(message, null);
    }

    public static void showMessageWithTitle(String message, String title) {
        SSOptionPane.showMessageDialog(message, title);
    }

    public static void showMessageDialog(String message, String title) {
        SSOptionPane.showMessageDialog(null, message, title, 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        SSOptionPane.showMessageDialog(parentComponent, message, null, 1);
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        if (parentComponent == null) {
            System.out.println("SSOptionPane: redirecting parentComponent");
            parentComponent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        }
        JOptionPane.showMessageDialog(parentComponent, StringTool.wrapLines(message, LINE_LENGTH), title, messageType, SSOptionPane.getDefaultIcon());
    }

    public static Icon getDefaultIcon() {
        if (ssoptionIcon == null) {
            ssoptionIcon = new ImageIcon(GraphicsTool.getImageFromJAR("globe64.png"));
        }
        return ssoptionIcon;
    }

    public static String showMultiLineInputDialog(Frame parentComponent, String message, String defaultText) {
        String data = null;
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class GetData
        extends JDialog
        implements ActionListener {
            JTextPane ta = new JTextPane();
            JButton btnOK = new JButton("   OK   ");
            JButton btnCancel = new JButton("Cancel");
            String str = null;
            final /* synthetic */ String val$message;

            public GetData(Frame defaultText, String string) {
                this.val$message = string;
                this.ta.setText((String)(defaultText == null ? "" : defaultText));
                this.ta.setPreferredSize(new Dimension(400, 100));
                this.ta.setBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2));
                this.setModal(true);
                this.setResizable(false);
                this.getContentPane().setLayout(new BorderLayout());
                ((JPanel)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
                this.setDefaultCloseOperation(2);
                this.setLocation(parentComponent.getX() + parentComponent.getWidth() / 2 - 250, parentComponent.getY() + parentComponent.getHeight() / 2 - 105);
                JPanel rightSide = new JPanel(new BorderLayout());
                JLabel label = new JLabel(this.val$message);
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 4, 0));
                rightSide.add((Component)label, "North");
                rightSide.add((Component)new JScrollPane(this.ta), "Center");
                label = new JLabel(SSOptionPane.getDefaultIcon());
                label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 20));
                label.setVerticalAlignment(1);
                this.getContentPane().add((Component)label, "West");
                this.getContentPane().add((Component)rightSide, "Center");
                JPanel jp = new JPanel(new FlowLayout(2));
                this.btnOK.addActionListener(this);
                this.btnCancel.addActionListener(this);
                jp.add(this.btnCancel);
                jp.add(this.btnOK);
                this.getContentPane().add((Component)jp, "South");
                this.pack();
                this.setVisible(true);
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (ae.getSource() == this.btnOK) {
                    this.str = this.ta.getText();
                }
                this.dispose();
            }

            public String getData() {
                return this.str;
            }
        }
        data = new GetData(parentComponent, defaultText, message).getData();
        return data;
    }
}

