/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSButton;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;

public class SSMenuItem
extends JMenuItem {
    public SSMenuItem() {
        this.setModel(new ClickButtonModel());
    }

    public SSMenuItem(String text) {
        super(text);
        this.setModel(new ClickButtonModel());
    }

    public SSMenuItem(Action a) {
        super(a);
    }

    public void setSelected(boolean value) {
        if (value && PrefsCache.buttonSound) {
            SSButton.clickSound.play();
        }
        super.setSelected(value);
    }

    public static void addCutCopyPasteMenu(Component component) {
        final JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem(new DefaultEditorKit.CutAction());
        item.setText(Translator.getString("Cut"));
        item.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem(new DefaultEditorKit.CopyAction());
        item.setText(Translator.getString("Copy"));
        item.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        item = new JMenuItem(new DefaultEditorKit.PasteAction());
        item.setText(Translator.getString("Paste"));
        item.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(item);
        component.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
    }

    public class ClickButtonModel
    extends JToggleButton.ToggleButtonModel {
        public void setArmed(boolean value) {
            if (value && PrefsCache.buttonSound) {
                SSButton.clickSound.play();
            }
            super.setArmed(value);
        }
    }
}

