/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.widgets.SSApp;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;

public class SSLink
extends JComponent
implements MouseListener {
    private String URL;
    private String displayText;
    private int prefWidth = 0;
    private boolean prefWidthSetInPaint = false;
    private static Color normalColor = new Color(71, 88, 175);
    private static Color highlightedColor = new Color(160, 0, 0);
    private static Cursor cursor = new Cursor(12);
    private static Font defaultFont;

    public SSLink(String URL2) {
        this(URL2, URL2.length() < 70 ? URL2 : URL2.substring(0, 67) + "...");
    }

    public SSLink(String URL2, String displayText) {
        if (URL2.equals("http://sillysoft.net//")) {
            URL2 = "http://sillysoft.net";
        }
        this.setBorder(null);
        this.setForeground(normalColor);
        if (defaultFont == null) {
            defaultFont = SwingTool.getGlobalFont();
        }
        this.setCursor(cursor);
        this.addMouseListener(this);
        this.setText(URL2, displayText);
    }

    public void setText(String URL2, String displayText) {
        boolean updating = URL2 != null;
        this.displayText = displayText;
        this.URL = URL2.toLowerCase().startsWith("http://") ? URL2 : "http://" + URL2;
        this.prefWidth = this.getFontMetrics(defaultFont).stringWidth(this.displayText);
        this.setMinimumSize(new Dimension(this.prefWidth, 14));
        this.setMaximumSize(new Dimension(this.prefWidth, 14));
        this.setPreferredSize(new Dimension(this.prefWidth, 14));
        if (URL2.equals(displayText)) {
            this.setToolTipText(null);
        } else {
            this.setToolTipText(URL2);
        }
        if (updating) {
            this.repaint();
            this.revalidate();
        }
    }

    public void setText(String text) {
        this.setText(text, text);
    }

    public boolean isFocusable() {
        return false;
    }

    public void paint(Graphics badg) {
        if (this.URL.equals("http://")) {
            return;
        }
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setColor(this.getForeground());
        g.drawString(this.displayText, 0, 11);
        this.prefWidth = this.getFontMetrics(g.getFont()).stringWidth(this.displayText);
        this.prefWidthSetInPaint = true;
        g.drawLine(0, 12, this.prefWidth, 12);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setForeground(highlightedColor);
        this.repaint();
    }

    public void mouseExited(MouseEvent e) {
        this.setForeground(normalColor);
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
        if ("http://Registration Window".equals(this.URL)) {
            EnterCodeWindow.show(SSApp.getInstance());
            return;
        }
        if (this.URL.equals("http://")) {
            return;
        }
        BrowserLauncher.openURL(this.URL);
        this.mouseExited(e);
    }

    public void actionPerformed(ActionEvent e) {
        BrowserLauncher.openURL(this.URL);
    }

    public String getText() {
        return this.URL;
    }

    public String toString() {
        return this.displayText;
    }
}

