/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.widgets.SSFrameWatcher;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.net.URLClassLoader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.border.Border;

public class SSFrame
extends JFrame
implements ComponentListener {
    private static String defaultIcon;
    private static SSFrameWatcher frameWatcher;
    private String locationID = null;
    private String resizeID = null;
    private boolean trackStatus = true;

    public static void setDefaultIcon(String iconfile) {
        defaultIcon = iconfile;
    }

    public static void setFrameWatcher(SSFrameWatcher newframeWatcher) {
        frameWatcher = newframeWatcher;
    }

    public SSFrame() {
        this.init();
    }

    public SSFrame(String title) {
        super(title);
        this.init();
    }

    private void init() {
        this.removeComponentListener(this);
        this.addComponentListener(this);
        this.setAutoTracking(this.trackStatus);
        if (defaultIcon != null) {
            Image icon = Toolkit.getDefaultToolkit().getImage(URLClassLoader.getSystemResource(defaultIcon));
            this.setIconImage(icon);
        }
    }

    public void setLocationID(String id) {
        this.locationID = id;
    }

    public void setResizeID(String id) {
        this.resizeID = id;
    }

    public void setAutoTracking(boolean tracking) {
        this.trackStatus = tracking;
    }

    public void show() {
        boolean maximizeWindow = false;
        if (this.resizeID != null) {
            int width = Prefs.getInt(this.resizeID + "WindowWidth", (int)this.getSize().getWidth());
            int height = Prefs.getInt(this.resizeID + "WindowHeight", (int)this.getSize().getHeight());
            this.setSize(width, height);
            Dimension dim = SwingTool.getUsableDimension();
            if ((double)(width + 10) > dim.getWidth() && (double)(height + 10) > dim.getHeight()) {
                maximizeWindow = true;
            }
        }
        if (this.locationID != null) {
            int y;
            int x;
            int inset = 35;
            Rectangle usableRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension screen = usableRect.getSize();
            Point screenOrigin = usableRect.getLocation();
            if ("alwaysCenter".equals(this.locationID) || Prefs.getInt(this.locationID + "WindowX", -666) == -666) {
                x = (int)(screen.getWidth() - (double)this.getWidth()) / 2;
                y = (int)(screen.getHeight() - (double)this.getHeight()) / 2;
            } else {
                x = Prefs.getInt(this.locationID + "WindowX", inset);
                x = Math.min(x, (int)screen.getWidth() - this.getWidth());
                x = Math.max(x, (int)screenOrigin.getX());
                y = Prefs.getInt(this.locationID + "WindowY", inset);
                y = Math.min(y, (int)screen.getHeight() - this.getHeight());
                y = Math.max(y, (int)screenOrigin.getY());
            }
            this.setLocation(x, y);
        }
        if (maximizeWindow) {
            SS.debug("SSFrame.show() setExtendedState(Frame.MAXIMIZED_BOTH) " + this);
            this.setExtendedState(6);
        }
        super.show();
        if (this.trackStatus && frameWatcher != null) {
            frameWatcher.addMe(this);
        }
    }

    public void hide() {
        super.hide();
        if (this.trackStatus && frameWatcher != null) {
            frameWatcher.killMe(this);
        }
    }

    public static Border getPlatformWindowBorder() {
        if (SS.isMacintosh) {
            return BorderFactory.createEmptyBorder(20, 20, 20, 20);
        }
        return BorderFactory.createEmptyBorder(10, 10, 10, 10);
    }

    public void componentMoved(ComponentEvent e) {
        if (this.locationID != null) {
            if (this.getLocation().x == 0 && !this.isVisible()) {
                return;
            }
            Prefs.putInt(this.locationID + "WindowX", this.getLocation().x);
            Prefs.putInt(this.locationID + "WindowY", this.getLocation().y);
            Prefs.sync();
        }
    }

    public void componentResized(ComponentEvent e) {
        if (this.resizeID != null) {
            Prefs.putInt(this.resizeID + "WindowWidth", this.getWidth());
            Prefs.putInt(this.resizeID + "WindowHeight", this.getHeight());
            Prefs.sync();
        }
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }
}

