/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.PrefsCache;
import com.sillysoft.widgets.SSButton;
import java.awt.Dimension;
import java.util.List;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SSComboBox
extends JComboBox {
    private static PopupMenuListener clickListenerInstance;

    public SSComboBox() {
        this.init();
    }

    public SSComboBox(Vector v) {
        super(v);
        this.init();
    }

    public SSComboBox(Object[] o) {
        super(o);
        this.init();
    }

    public SSComboBox(ComboBoxModel aModel) {
        super(aModel);
        this.init();
    }

    private void init() {
        this.addPopupMenuListener(SSComboBox.getClickListenerInstance());
        this.setMaximumRowCount(30);
    }

    public String getSelectedString() {
        Object selected = this.getSelectedItem();
        return selected == null ? "" : selected.toString();
    }

    public int getIndexOfItem(String title) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(title)) continue;
            return i;
        }
        return -1;
    }

    public String getTitleAt(int index) {
        return this.getItemAt(index).toString();
    }

    public void addItemList(List list) {
        for (int i = 0; i < list.size(); ++i) {
            this.addItem(list.get(i));
        }
    }

    public void addItemList(String[] list) {
        for (int i = 0; i < list.length; ++i) {
            this.addItem(list[i]);
        }
    }

    public boolean hasItem(Object item) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            if (!this.getItemAt(i).equals(item)) continue;
            return true;
        }
        return false;
    }

    public boolean isFocusable() {
        return super.isFocusable();
    }

    public static PopupMenuListener getClickListenerInstance() {
        if (clickListenerInstance == null) {
            clickListenerInstance = new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e) {
                    if (PrefsCache.buttonSound) {
                        SSButton.clickSound.play();
                    }
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    if (PrefsCache.buttonSound) {
                        SSButton.clickSound.play();
                    }
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (PrefsCache.buttonSound) {
                        SSButton.clickSound.play();
                    }
                }
            };
        }
        return clickListenerInstance;
    }

    public void setPreferredWidth(int width) {
        Dimension pref = super.getPreferredSize();
        this.setPreferredSize(new Dimension(width, (int)pref.getHeight()));
    }
}

