/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSColorChooser;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;

public class SSColorWell
extends JPanel {
    private Color color = Color.white;
    private static final int width;
    private static final int height;
    private static final Dimension defaultSize;
    private static final int gap = 5;
    private static final int heightOffset;
    private boolean selected = false;

    public SSColorWell(Color initialColor, final SSApplicationGUI luxconBridge) {
        this.color = initialColor;
        this.setMinimumSize(defaultSize);
        this.setMaximumSize(defaultSize);
        this.setPreferredSize(defaultSize);
        final SSColorWell listener = this;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (SSColorWell.this.isEnabled()) {
                    listener.selected = true;
                    listener.repaint();
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (listener.isEnabled()) {
                    SSColorChooser.showWindow(listener, luxconBridge);
                }
            }
        });
    }

    public void setColor(Color newColor) {
        SS.debug("setColor to " + newColor);
        this.color = newColor;
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void paintComponent(Graphics badg) {
        super.paintComponent(badg);
        Graphics2D g = (Graphics2D)badg;
        if (this.selected) {
            g.setColor(Color.DARK_GRAY);
        } else {
            g.setColor(Color.WHITE);
        }
        g.fillRect(0, heightOffset, width - 1, height - 1);
        if (this.isEnabled()) {
            g.setColor(this.color);
        } else {
            g.setColor(GraphicsTool.transparent(this.color, 0.6f));
        }
        g.fillRect(5, 5 + heightOffset, width - 10, height - 10);
        g.setStroke(new BasicStroke(1.0f));
        if (this.selected) {
            g.setColor(Color.BLACK);
        } else if (this.isEnabled()) {
            g.setColor(Color.GRAY);
        } else {
            g.setColor(Color.LIGHT_GRAY);
        }
        g.drawRect(0, heightOffset, width - 1, height - 1);
        if (this.isEnabled()) {
            g.setColor(this.color.darker());
        } else {
            g.setColor(GraphicsTool.transparent(this.color.darker(), 0.6f));
        }
        g.drawRect(5, 5 + heightOffset, width - 10 - 1, height - 10 - 1);
    }

    public Dimension getMaximumSize() {
        return defaultSize;
    }

    public Dimension getMinimumSize() {
        return defaultSize;
    }

    public Dimension getPreferredSize() {
        return defaultSize;
    }

    public void setSelected(boolean newSelected) {
        this.selected = newSelected;
        this.repaint();
    }

    static {
        if (SS.isMacintosh) {
            width = 53;
            height = 24;
            heightOffset = 0;
        } else {
            width = 53;
            height = 22;
            heightOffset = 0;
        }
        defaultSize = new Dimension(width, height + 1);
    }
}

