/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSColorWell;
import com.sillysoft.widgets.SSFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SSColorChooser
extends SSFrame
implements ChangeListener,
WindowListener {
    private static SSColorChooser singular = null;
    private SSColorWell activeWell = null;
    private JColorChooser tcc;

    private SSColorChooser(SSApplicationGUI luxconBridge) {
        this.setLocationID("colorChooser");
        this.setDefaultCloseOperation(2);
        if (SS.isMacintosh && luxconBridge != null) {
            this.setJMenuBar(luxconBridge.makeCommonMenuBar(this));
        }
        this.tcc = new JColorChooser();
        this.tcc.getSelectionModel().addChangeListener(this);
        this.tcc.setBorder(BorderFactory.createTitledBorder(Translator.getString("ChooseaColor")));
        this.getContentPane().add((Component)this.tcc, "Center");
        this.addWindowListener(this);
    }

    public void setActiveWell(SSColorWell _activeWell) {
        if (this.activeWell != null && this.activeWell != _activeWell) {
            this.activeWell.setSelected(false);
        }
        this.activeWell = _activeWell;
    }

    public void stateChanged(ChangeEvent e) {
        Color newColor = this.tcc.getColor();
        this.activeWell.setColor(newColor);
    }

    public static void showWindow(SSColorWell activeWell, SSApplicationGUI luxconBridge) {
        if (singular == null) {
            singular = new SSColorChooser(luxconBridge);
        }
        singular.setActiveWell(activeWell);
        singular.pack();
        singular.show();
    }

    public static void hideWindow() {
        if (singular != null) {
            singular.hide();
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        if (this.activeWell != null) {
            this.activeWell.setSelected(false);
        }
        this.activeWell = null;
    }

    public void windowClosing(WindowEvent e) {
        if (this.activeWell != null) {
            this.activeWell.setSelected(false);
        }
        this.activeWell = null;
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }
}

