/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.widgets.DocumentSizeFilter;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSChatAreaParent;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLink;
import com.sillysoft.widgets.SSTextField;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class SSChatArea
extends JPanel
implements WindowListener,
ActionListener,
KeyListener {
    private SSFrame chatWindow;
    public SSTextField chatField;
    public JTextPane textPane;
    private AbstractDocument doc;
    private JScrollPane scroller;
    private String lastCommand;
    private final int MAX_CHARACTERS = 130000;
    private SSChatAreaParent parent;
    private String userName;
    private static final String newline = "\n";
    private static final SimpleAttributeSet normalStyle = new SimpleAttributeSet();
    public static final SimpleAttributeSet emoteStyle = new SimpleAttributeSet(normalStyle);
    public static final SimpleAttributeSet heartStyle = new SimpleAttributeSet(normalStyle);
    public static final SimpleAttributeSet singStyle = new SimpleAttributeSet(normalStyle);
    public static final SimpleAttributeSet zemoteStyle = new SimpleAttributeSet(normalStyle);
    public static final int normalStyleCode = 0;
    public static final int emoteStyleCode = 1;
    private final String colorBlock = SS.isMacintosh ? "\u2589 " : "\u2588 ";
    private static Pattern racismRegex;
    private PrintWriter chatLogFileOut;
    public Runnable scrollDownRunnable = new Runnable(){

        public void run() {
            try {
                if (SSChatArea.this.scroller == null) {
                    return;
                }
                JScrollBar sb = SSChatArea.this.scroller.getVerticalScrollBar();
                SSChatArea.this.textPane.setCaretPosition(SSChatArea.this.textPane.getDocument().getLength());
            }
            catch (Throwable t) {
                SS.debug("Exception while scrolling down the chat area: " + t);
                t.printStackTrace();
            }
        }
    };
    private int placingKey = 0;

    public SSChatArea(SSChatAreaParent parent, String userName) {
        this.parent = parent;
        this.userName = userName;
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setCaretPosition(0);
        this.textPane.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 2));
        StyledDocument styledDoc = this.textPane.getStyledDocument();
        if (styledDoc instanceof AbstractDocument) {
            this.doc = (AbstractDocument)((Object)styledDoc);
            this.doc.setDocumentFilter(new DocumentSizeFilter(130000));
        } else {
            System.err.println("Text pane's document isn't an AbstractDocument!");
        }
        this.textPane.setEditable(false);
        this.scroller = new JScrollPane(this.textPane);
        this.scroller.setPreferredSize(new Dimension(350, 100));
        this.scroller.setHorizontalScrollBarPolicy(31);
        this.add((Component)this.scroller, "Center");
        this.chatField = new SSTextField("", 50);
        this.chatField.setDrawGrowBox(SS.isMacintosh);
        if (!SS.isMacintosh && !SS.isVista) {
            this.chatField.setFont(GraphicsTool.getDejaFontSized(12));
        }
        this.chatField.setMaximumSize(new Dimension((int)this.chatField.getMaximumSize().getWidth(), 25));
        this.chatField.addActionListener(this);
        this.chatField.addKeyListener(this);
        this.textPane.addKeyListener(this);
        this.chatField.setFocusTraversalKeysEnabled(false);
        this.add((Component)this.chatField, "South");
    }

    public void focusChatField() {
        if (!this.chatField.hasFocus()) {
            if (!this.chatField.isRequestFocusEnabled()) {
                this.chatField.setRequestFocusEnabled(true);
            }
            this.chatField.requestFocus();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String chat = this.chatField.getText().trim();
        this.chatField.setText("");
        if ("".equals(chat)) {
            try {
                JButton defaultButton = this.parent.getDefaultButton();
                if (defaultButton != null) {
                    defaultButton.doClick();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return;
        }
        if (chat.length() > 900) {
            chat = chat.substring(0, 900);
        }
        this.lastCommand = chat;
        this.parent.dealWithCommand(chat);
    }

    public void goSolo(String windowTitle) {
        if (this.chatWindow == null) {
            this.chatWindow = new SSFrame();
            this.chatWindow.setResizeID("chatWindowResize");
            this.chatWindow.setDefaultCloseOperation(0);
            this.chatWindow.setLocationID("Chat");
            this.chatWindow.addWindowListener(this);
        }
        if (SS.isMacintosh) {
            this.chatWindow.setJMenuBar(this.parent.getJMenuBarForChatArea(this.chatWindow));
        }
        this.chatWindow.setContentPane(this);
        this.chatWindow.setTitle(windowTitle);
        this.chatWindow.pack();
        this.chatWindow.show();
    }

    public void prepForDrawer() {
        if (this.chatWindow != null) {
            this.chatWindow.hide();
        }
    }

    public void println(String line) {
        this.println(line, 0);
    }

    public void println(String line, Color blockColor) {
        this.println(line, blockColor, false);
    }

    public void println(String line, Color blockColor, boolean doubleSided) {
        SimpleAttributeSet colored = new SimpleAttributeSet(normalStyle);
        StyleConstants.setForeground(colored, blockColor);
        try {
            this.doc.insertString(this.doc.getLength(), this.colorBlock, colored);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.println(line, 0);
        if (doubleSided) {
            try {
                this.doc.insertString(this.doc.getLength() - 2, this.colorBlock, colored);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void println(String line, int styleCode) {
        SimpleAttributeSet style;
        if (styleCode == 0) {
            style = normalStyle;
        } else if (styleCode == 1) {
            style = emoteStyle;
        } else {
            SS.debug("UNKNOWN styleCode IN CHAT: " + styleCode);
            style = normalStyle;
        }
        JScrollBar sb = this.scroller.getVerticalScrollBar();
        if (sb.getValue() + sb.getHeight() + 18 > sb.getMaximum() || sb.getHeight() == 0) {
            this.print(line + newline, style);
            SwingUtilities.invokeLater(this.scrollDownRunnable);
        } else {
            this.print(line + newline, style);
        }
    }

    public void println(String line, SimpleAttributeSet style) {
        JScrollBar sb = this.scroller.getVerticalScrollBar();
        if (sb.getValue() + sb.getHeight() + 18 > sb.getMaximum() || sb.getHeight() == 0) {
            this.print(line + newline, style);
            SwingUtilities.invokeLater(this.scrollDownRunnable);
        } else {
            this.print(line + newline, style);
        }
    }

    private void printColorBlock(Color blockColor) {
        SimpleAttributeSet colored = new SimpleAttributeSet(normalStyle);
        StyleConstants.setForeground(colored, blockColor);
        try {
            this.doc.insertString(this.doc.getLength(), this.colorBlock, colored);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void println(String line, Color blockColor, SimpleAttributeSet style) {
        if (blockColor != null) {
            this.printColorBlock(blockColor);
        }
        this.println(line, style);
    }

    private void logToFile(String text) {
        if (this.chatLogFileOut != null) {
            this.chatLogFileOut.print(text);
        }
    }

    private void print(String line, SimpleAttributeSet style) {
        if (this.doc == null) {
            return;
        }
        if (!line.startsWith(this.userName + ":")) {
            Matcher matcher = racismRegex.matcher(line);
            line = matcher.replaceAll("ninny");
        }
        try {
            int position = 0;
            String lowercase = line.toLowerCase();
            position = lowercase.indexOf("http://");
            if (position == -1) {
                position = lowercase.indexOf("www.");
            }
            if (position != -1) {
                String endString;
                String URL2;
                this.print(line.substring(0, position), style);
                int endPosition = line.indexOf(32, position);
                if (endPosition == -1) {
                    int endLinePosition = line.indexOf(10, position);
                    if (endLinePosition == -1) {
                        URL2 = line.substring(position);
                        endString = null;
                    } else {
                        URL2 = line.substring(position, endLinePosition);
                        endString = newline;
                    }
                } else {
                    URL2 = line.substring(position, endPosition);
                    endString = line.substring(endPosition);
                }
                SSLink link = new SSLink(URL2);
                link.setAlignmentY(0.8f);
                SimpleAttributeSet componentStyle = new SimpleAttributeSet(normalStyle);
                StyleConstants.setComponent(componentStyle, link);
                this.doc.insertString(this.doc.getLength(), link.toString(), componentStyle);
                this.logToFile(URL2);
                if (endString != null) {
                    this.print(endString, style);
                }
                return;
            }
            position = line.indexOf(96);
            if (position != -1 && position + 2 < line.length() && !"/".equals(line.substring(position + 1, position + 2))) {
                String endString;
                this.print(line.substring(0, position), style);
                if (line.charAt(position + 1) == '`') {
                    int linkDestinationEndPosition = line.indexOf(96, position + 2);
                    if (linkDestinationEndPosition == -1 || linkDestinationEndPosition == position + 2) {
                        endString = line.substring(position + 1);
                    } else {
                        String linkDestination = line.substring(position + 2, linkDestinationEndPosition);
                        int linkTextEndPosition = line.indexOf(96, linkDestinationEndPosition + 1);
                        if (linkTextEndPosition == -1) {
                            endString = line.substring(position + 1);
                        } else {
                            String linkText = line.substring(linkDestinationEndPosition + 1, linkTextEndPosition);
                            SSLink link = new SSLink("http://sillysoft.net/" + linkDestination, linkText);
                            link.setAlignmentY(0.8f);
                            SimpleAttributeSet componentStyle = new SimpleAttributeSet(normalStyle);
                            StyleConstants.setComponent(componentStyle, link);
                            this.doc.insertString(this.doc.getLength(), link.toString(), componentStyle);
                            this.logToFile("[url=http://sillysoft.net/" + linkDestination + "]" + linkText + "[/url]");
                            endString = line.substring(linkTextEndPosition + 1);
                        }
                    }
                } else {
                    String username;
                    int endPosition = line.indexOf(32, position);
                    int secondTildePosition = line.indexOf(96, position + 1);
                    if (secondTildePosition != -1) {
                        endPosition = secondTildePosition;
                    }
                    if (endPosition == -1) {
                        int endLinePosition = line.indexOf(10, position);
                        if (endLinePosition == -1) {
                            username = line.substring(position + 1);
                            endString = null;
                        } else {
                            username = line.substring(position + 1, endLinePosition);
                            endString = newline;
                        }
                    } else if (secondTildePosition == -1) {
                        username = line.substring(position + 1, endPosition);
                        endString = line.substring(endPosition);
                    } else {
                        username = line.substring(position + 1, secondTildePosition);
                        endString = line.substring(secondTildePosition + 1);
                    }
                    SSLink link = new SSLink("http://sillysoft.net/" + SSApp.shortNameLower() + "/rankings/user/" + URLEncoder.encode(username, "UTF-8"), username);
                    link.setAlignmentY(0.8f);
                    SimpleAttributeSet componentStyle = new SimpleAttributeSet(normalStyle);
                    StyleConstants.setComponent(componentStyle, link);
                    this.doc.insertString(this.doc.getLength(), link.toString(), componentStyle);
                    this.logToFile("[url=http://sillysoft.net/" + SSApp.shortNameLower() + "/rankings/user/" + URLEncoder.encode(username, "UTF-8") + "]" + username + "[/url]");
                }
                if (endString != null) {
                    this.print(endString, style);
                }
                return;
            }
            if (this.doc != null) {
                this.doc.insertString(this.doc.getLength(), line, style);
                this.logToFile(line);
            }
        }
        catch (Throwable t) {
            SS.debug("Exception while printing in the chat area: " + t);
            t.printStackTrace();
        }
    }

    public void windowClosing(WindowEvent e) {
        if (this.parent != null) {
            this.parent.chatAreaWindowClosing(e);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public boolean isOpaque() {
        return true;
    }

    public void kill() {
        if (this.chatLogFileOut != null) {
            this.chatLogFileOut.flush();
        }
        this.remove(this.scroller);
        this.remove(this.chatField);
        if (this.chatWindow != null) {
            this.chatWindow.removeWindowListener(this);
            SwingTool.destroyMenu(this.chatWindow.getJMenuBar());
            this.chatWindow.setJMenuBar(null);
            this.chatWindow.setMenuBar(null);
            this.chatWindow.setContentPane(new JPanel());
            this.chatWindow.dispose();
        }
        this.chatWindow = null;
        this.parent = null;
        this.textPane.removeKeyListener(this);
        this.textPane = null;
        this.scroller = null;
        this.doc = null;
        SwingTool.removeActionListeners(this.chatField);
        SwingTool.removeKeyListeners(this.chatField);
        this.chatField = null;
        this.scrollDownRunnable = null;
    }

    public SSFrame getWindow() {
        return this.chatWindow;
    }

    public void keyPressed(KeyEvent e) {
        this.placingKey = e.getKeyCode() == 49 ? 1 : (e.getKeyCode() == 50 ? 2 : (e.getKeyCode() == 51 ? 3 : (e.getKeyCode() == 52 ? 4 : (e.getKeyCode() == 53 ? 5 : (e.getKeyCode() == 54 ? 6 : (e.getKeyCode() == 55 ? 7 : (e.getKeyCode() == 56 ? 8 : (e.getKeyCode() == 57 ? 9 : (e.getKeyCode() == 90 ? 99 : -1)))))))));
        this.parent.setPlacingKey(this.placingKey);
        if (this.placingKey > 0) {
            SS.debug("placingKey = " + this.placingKey);
        }
        this.parent.cacheModKeys(e);
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.placingKey > 0) {
            String placedKeyString = this.placingKey == 99 ? "z" : "" + this.placingKey;
            this.placingKey = -1;
            this.parent.setPlacingKey(-1);
            SS.debug("placingKey = " + this.placingKey);
            if (this.parent.usedPlacedDividerKey() || this.parent.usedZeroAttack()) {
                String typed = this.chatField.getText();
                while (typed.endsWith(placedKeyString)) {
                    typed = typed.substring(0, typed.length() - 1);
                }
                this.chatField.setText(typed);
            }
        }
        if (e.getKeyCode() == 27 || e.getKeyCode() == 9) {
            String completionResult;
            if (e.getKeyCode() == 27) {
                this.parent.escapeKeyPressed();
            }
            if (!(completionResult = this.parent.getCompletionFor(this.chatField.getText())).equals(this.chatField.getText())) {
                this.chatField.setText(completionResult);
            }
        } else if (e.getKeyCode() == 38 && "".equals(this.chatField.getText().trim())) {
            this.chatField.setText(this.lastCommand);
        }
        if (SSApp.isVox) {
            this.parent.cacheModKeys(e);
        }
    }

    public String tail() {
        return this.tail(2000);
    }

    public String tail(int numChars) {
        try {
            int length = Math.min(this.doc.getLength(), numChars);
            int offset = this.doc.getLength() - length;
            return this.doc.getText(offset, length);
        }
        catch (Exception e) {
            return e.toString();
        }
    }

    static {
        StyleConstants.setItalic(emoteStyle, true);
        StyleConstants.setForeground(heartStyle, new Color(200, 20, 20));
        StyleConstants.setForeground(singStyle, new Color(20, 100, 20));
        StyleConstants.setForeground(zemoteStyle, new Color(20, 20, 200));
        racismRegex = Pattern.compile("n[il1|!]gg[e3]r", 2);
    }
}

