/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.PrefsCache;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class SSButton
extends JButton {
    private Image extraImage;
    public static final SoundEffect clickSound = new SoundEffect("buttonClick.wav");
    private int extraImageHeightOffset = -99;

    public SSButton() {
        this.setModel(new ClickButtonModel());
    }

    public SSButton(String title) {
        super(title);
        this.setModel(new ClickButtonModel());
    }

    public SSButton(Icon icon) {
        super(icon);
        this.setModel(new ClickButtonModel());
    }

    public SSButton(String text, ImageIcon icon) {
        super(text);
        this.extraImage = icon.getImage();
        this.setModel(new ClickButtonModel());
    }

    public SSButton(Action a) {
        super(a);
        this.setModel(new ClickButtonModel());
    }

    public void setPreferredWidth(int width) {
        Dimension pref = super.getPreferredSize();
        if ((double)width > pref.getWidth()) {
            this.setPreferredSize(new Dimension(width, (int)pref.getHeight()));
        }
    }

    public boolean isFocusable() {
        return super.isFocusable();
    }

    public static ButtonModel getClickButtonModel() {
        return new DefaultButtonModel(){

            public void setArmed(boolean value) {
                if (value && PrefsCache.buttonSound) {
                    clickSound.play();
                }
                super.setArmed(value);
            }
        };
    }

    public void setExtraImageHeightOffset(int h) {
        this.extraImageHeightOffset = h;
    }

    public void paintComponent(Graphics badg) {
        super.paintComponent(badg);
        if (this.extraImage == null) {
            return;
        }
        badg.drawImage(this.extraImage, this.getWidth() / 2 - 5, this.getHeight() / 2 - this.extraImage.getHeight(null) / 2 - 1, null);
    }

    public class ClickButtonModel
    extends DefaultButtonModel {
        public void setArmed(boolean value) {
            if (value && PrefsCache.buttonSound) {
                clickSound.play();
            }
            super.setArmed(value);
        }
    }
}

