/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.widgets.SSApp;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class MusicEngine
implements Runnable {
    private static String[] trackArray;
    private Thread musicThread;
    public static final int DEFAULT_VOLUME = 70;
    private static int padding;
    private static int lastSequenceID;
    private static Vector activeMusic;
    private boolean musicShouldBePlaying;
    private boolean fadeOut;
    private int[] trackPlayPattern;
    float currentGain = 100.0f;
    private static boolean pausedInBackground;
    private static SourceDataLine lastLine;

    public static void setTracks(String[] trackResourceLocations) {
        trackArray = trackResourceLocations;
    }

    public static void startTrackSequence(int sequenceID) {
        int[] trackPlayPatternNew;
        if (sequenceID == lastSequenceID && activeMusic.size() > 0) {
            return;
        }
        lastSequenceID = sequenceID;
        if (sequenceID == 1) {
            trackPlayPatternNew = new int[]{0, 1, 0, 2, 0, 3, 0, 4};
        } else if (sequenceID == 2) {
            trackPlayPatternNew = new int[]{1, 2, 3, 4, 1, 2, 3, 4, 0};
        } else if (sequenceID == 3) {
            trackPlayPatternNew = new int[]{2, 3, 4, 1, 2, 3, 4, 1, 0};
        } else if (sequenceID == 4) {
            trackPlayPatternNew = new int[]{3, 4, 1, 2, 3, 4, 1, 2, 0};
        } else if (sequenceID == 5) {
            trackPlayPatternNew = new int[]{4, 1, 2, 3, 4, 1, 2, 3, 0};
        } else if (sequenceID == 6) {
            trackPlayPatternNew = new int[]{0, 3, 5, 0, 2, 3, 4};
        } else if (sequenceID == 7) {
            trackPlayPatternNew = new int[]{2, 4, 3, 2, 0, 5};
        } else if (sequenceID == 8) {
            trackPlayPatternNew = new int[]{3, 5, 0, 3, 4, 2};
        } else if (sequenceID == 9) {
            trackPlayPatternNew = new int[]{4, 3, 0, 4, 5, 2};
        } else if (sequenceID == 10) {
            trackPlayPatternNew = new int[]{5, 3, 0, 5, 4};
        } else if (sequenceID == 11) {
            trackPlayPatternNew = new int[]{1};
        } else if (sequenceID == 12) {
            trackPlayPatternNew = new int[]{3, 5, 4, 0, 2};
        } else if (sequenceID == 21) {
            trackPlayPatternNew = new int[]{0, 0, 1, 0, 0, 2, 0, 0, 3};
        } else if (sequenceID == 22) {
            trackPlayPatternNew = new int[]{4};
        } else if (sequenceID == 23) {
            trackPlayPatternNew = new int[]{1, 2, 3};
        } else if (sequenceID == 24) {
            trackPlayPatternNew = new int[]{2, 1, 3};
        } else if (sequenceID == 25) {
            trackPlayPatternNew = new int[]{3, 2, 1};
        } else {
            SS.debug("Unknown music sequence: " + sequenceID);
            return;
        }
        if ((double)Prefs.getInt("musicVolume", 70) < 0.001 || !Prefs.getBoolean("playMusic", true)) {
            return;
        }
        MusicEngine.fadeOutMusic();
        new MusicEngine(trackPlayPatternNew);
    }

    public static void fadeOutBlocking() {
        if (pausedInBackground) {
            return;
        }
        for (int i = activeMusic.size() - 1; i > -1; --i) {
            MusicEngine active = (MusicEngine)activeMusic.get(i);
            active.fadeOut();
            try {
                active.musicThread.join(2000L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void fadeOutMusic() {
        for (int i = 0; i < activeMusic.size(); ++i) {
            ((MusicEngine)activeMusic.get(i)).fadeOut();
        }
    }

    private void fadeOut() {
        this.fadeOut = true;
    }

    private MusicEngine(int[] trackPlayPatternNew) {
        this.trackPlayPattern = trackPlayPatternNew;
        this.musicThread = new Thread((Runnable)this, "MusicEngine");
        this.musicThread.start();
    }

    public static boolean isMusicPlaying() {
        for (int i = 0; i < activeMusic.size(); ++i) {
            if (!((MusicEngine)MusicEngine.activeMusic.get((int)i)).musicShouldBePlaying) continue;
            return true;
        }
        return false;
    }

    public void run() {
        for (int i = activeMusic.size() - 1; i > -1; --i) {
            MusicEngine active = (MusicEngine)activeMusic.get(i);
            try {
                active.musicThread.join();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        activeMusic.add(this);
        Thread.currentThread().setPriority(10);
        this.musicShouldBePlaying = true;
        this.fadeOut = false;
        int trackPlayCount = 0;
        try {
            while (this.musicShouldBePlaying && !this.fadeOut) {
                this.playTrack(trackArray[this.trackPlayPattern[trackPlayCount]]);
                trackPlayCount = (trackPlayCount + 1) % this.trackPlayPattern.length;
                if (padding <= 0) continue;
                try {
                    Thread.sleep(padding);
                }
                catch (Exception ine) {
                    System.out.println(ine + " while waiting for music padding");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        activeMusic.remove(this);
        this.trackPlayPattern = null;
        this.musicThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void playTrack(String musicResourceLocation) throws IOException, UnsupportedAudioFileException, LineUnavailableException {
        Line line;
        AudioInputStream ain;
        block32: {
            block31: {
                block29: {
                    block30: {
                        ain = null;
                        line = null;
                        try {
                            try {
                                String path = (SS.isMacintosh ? DesktopTool.bundleResourcesLocation() : DesktopTool.supportFolderPath()) + "Music" + musicResourceLocation;
                                SS.debug("MusicEngine: Loading music from " + path, 1);
                                ain = AudioSystem.getAudioInputStream(new File(path));
                                AudioFormat format = ain.getFormat();
                                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                                if (!AudioSystem.isLineSupported(info)) {
                                    System.out.println("MUSIC MUST BE TRANSCODED - PERFORMANCE HIT");
                                    AudioFormat pcm = new AudioFormat(format.getSampleRate(), 16, format.getChannels(), true, false);
                                    ain = AudioSystem.getAudioInputStream(pcm, ain);
                                    format = ain.getFormat();
                                    info = new DataLine.Info(SourceDataLine.class, format);
                                }
                                line = (SourceDataLine)AudioSystem.getLine(info);
                                line.open(format);
                                lastLine = line;
                                int framesize = format.getFrameSize();
                                byte[] buffer = new byte[4096 * framesize];
                                int numbytes = 0;
                                boolean started = false;
                                while (this.musicShouldBePlaying) {
                                    if (this.fadeOut) {
                                        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                                        this.currentGain -= 0.7f;
                                        if (this.currentGain < -20.0f) {
                                            this.musicShouldBePlaying = false;
                                            Object var17_26 = null;
                                            if (line == null) break block29;
                                            break block30;
                                        }
                                        gainControl.setValue(this.currentGain);
                                    }
                                    while (pausedInBackground) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException ine) {
                                            System.out.println(ine + " while music is paused");
                                        }
                                    }
                                    int bytesread = ain.read(buffer, numbytes, buffer.length - numbytes);
                                    if (bytesread == -1) {
                                        SS.debug("MusicEngine: end of music bytes", 1);
                                        break block31;
                                    }
                                    numbytes += bytesread;
                                    if (!started) {
                                        float dB;
                                        line.start();
                                        double gain = (double)Prefs.getInt("musicVolume", 70) / 100.0;
                                        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                                        this.currentGain = dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
                                        gainControl.setValue(dB);
                                        started = true;
                                    }
                                    int bytestowrite = numbytes / framesize * framesize;
                                    line.write(buffer, 0, bytestowrite);
                                    int remaining = numbytes - bytestowrite;
                                    if (remaining > 0) {
                                        System.arraycopy(buffer, bytestowrite, buffer, 0, remaining);
                                    }
                                    numbytes = remaining;
                                }
                                line.drain();
                                break block32;
                            }
                            catch (UnsupportedAudioFileException e) {
                                System.out.println("MusicEngine: UnsupportedAudioFileException: " + e);
                                Object var17_29 = null;
                                if (line != null) {
                                    line.close();
                                }
                                if (ain == null) return;
                                ain.close();
                                return;
                            }
                            catch (NullPointerException enull) {
                                System.out.println("MusicEngine: playTrack startup glitch: " + enull);
                                try {
                                    if (line != null) {
                                        line.close();
                                    }
                                }
                                catch (Exception exx) {
                                    System.out.println("MusicEngine: playTrack1: " + exx);
                                }
                                try {
                                    if (ain != null) {
                                        ain.close();
                                    }
                                }
                                catch (Exception exx) {
                                    System.out.println("MusicEngine: playTrack2: " + exx);
                                }
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception exx) {
                                    System.out.println("MusicEngine: playTrack3: " + exx);
                                }
                                this.playTrack(musicResourceLocation);
                                Object var17_30 = null;
                                if (line != null) {
                                    line.close();
                                }
                                if (ain == null) return;
                                ain.close();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var17_31 = null;
                            if (line != null) {
                                line.close();
                            }
                            if (ain != null) {
                                ain.close();
                            }
                            line = null;
                            ain = null;
                            throw throwable;
                        }
                    }
                    line.close();
                }
                if (ain == null) return;
                ain.close();
                return;
            }
            Object var17_27 = null;
            if (line != null) {
                line.close();
            }
            if (ain == null) return;
            ain.close();
            return;
        }
        Object var17_28 = null;
        if (line != null) {
            line.close();
        }
        if (ain == null) return;
        ain.close();
    }

    public static void pause() {
        pausedInBackground = true;
    }

    public static void resume() {
        pausedInBackground = false;
    }

    public static void setVolume() {
        double gain = (double)Prefs.getInt("musicVolume", 70) / 100.0;
        System.out.println("MusicEngine.setVolume with new gain: " + gain);
        if (lastLine == null || !lastLine.isOpen()) {
            if (gain > 0.001) {
                System.out.println("MusicEngine.setVolume is starting a new track sequence");
                if (SSApp.isVox) {
                    MusicEngine.startTrackSequence(VoxClient.musicSequenceForMap(Prefs.get("mapSelector", "Tutorial Map")));
                } else {
                    MusicEngine.startTrackSequence(lastSequenceID);
                }
            } else {
                System.out.println("MusicEngine.setVolume is doing nothing");
            }
            return;
        }
        SourceDataLine line = lastLine;
        FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
        float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0);
        gainControl.setValue(dB);
        System.out.println("MusicEngine: Set volume gain at " + gain);
        if (gain < 0.001) {
            System.out.println("MusicEngine: Music is pausing since the volume is now 0");
            MusicEngine.pause();
        } else if (pausedInBackground) {
            System.out.println("MusicEngine: Music is resuming since the volume is no longer 0");
            MusicEngine.resume();
        }
    }

    static {
        padding = 0;
        lastSequenceID = -1;
        activeMusic = new Vector();
        pausedInBackground = false;
    }
}

