/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.GraphicsTool;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HeaderPanel
extends JPanel {
    private BufferedImage texture;
    private JLabel imglabel;
    private Color rightBorderColor = new Color(157, 157, 157);

    public HeaderPanel(String filetexture, String image) {
        super(new BorderLayout());
        this.texture = GraphicsTool.getBufferedImageFromJAR(filetexture);
        this.imglabel = new JLabel(new ImageIcon(GraphicsTool.getImageFromJAR(image)));
        this.imglabel.setHorizontalAlignment(2);
        this.add(this.imglabel);
        float javaVersion = 0.0f;
        try {
            javaVersion = Float.parseFloat(System.getProperty("java.class.version"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if ((double)javaVersion < 48.5) {
            this.rightBorderColor = new Color(194, 194, 194);
        }
        this.setBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, this.rightBorderColor));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.texture == null) {
            return;
        }
        Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, this.texture.getWidth(), this.texture.getHeight());
        TexturePaint tp = new TexturePaint(this.texture, tr);
        g2.setPaint(tp);
        g2.fill(g2.getClipRect());
    }

    public void paintChildren(Graphics g) {
        super.paintChildren(g);
    }
}

