/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.SS;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FitTableColumnsAction
extends AbstractAction
implements Runnable {
    private JTable table;
    private int savedWidth;

    public FitTableColumnsAction() {
        super("Fit Table Columns");
    }

    public FitTableColumnsAction(JTable table, int savedWidth) {
        super("Fit Table Columns");
        this.table = table;
        this.savedWidth = savedWidth;
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.table == null) {
            FitTableColumnsAction.fitTable((JTable)ae.getSource(), 0);
        } else {
            FitTableColumnsAction.fitTable(this.table, 0);
        }
    }

    public void run() {
        FitTableColumnsAction.fitTable(this.table, this.savedWidth);
    }

    public static void fitTable(JTable table, int useWidth) {
        FitTableColumnsAction.fitTable(table, useWidth, 150);
    }

    public static void fitTable(JTable table, int useWidth, int maxPerColumn) {
        JTableHeader header = table.getTableHeader();
        int rowCount = table.getRowCount();
        Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
        int[] preferredWidths = new int[table.getColumnCount()];
        int totalPreferredWidth = 0;
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            int col = header.getColumnModel().getColumnIndex(column.getIdentifier());
            int width = (int)table.getTableHeader().getDefaultRenderer().getTableCellRendererComponent(table, column.getIdentifier(), false, false, -1, col).getPreferredSize().getWidth();
            SS.debug("FitTable action header[" + i + "] " + table.getColumnModel().getColumn(col).getHeaderValue() + " wanted " + width, 1);
            if (!(table.getColumnModel().getColumn(col).getHeaderValue() instanceof String)) {
                width = Math.min(width, 20);
            }
            for (int row = 0; row < rowCount; ++row) {
                int preferedWidth = (int)table.getCellRenderer(row, col).getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col).getPreferredSize().getWidth();
                width = Math.max(width, preferedWidth);
            }
            if (maxPerColumn != 0) {
                width = Math.min(width, maxPerColumn);
            }
            SS.debug("FitTable action preferredWidths[" + i + "] = " + width, 1);
            preferredWidths[i] = width;
            totalPreferredWidth += width;
            ++i;
        }
        int tableWidth = useWidth;
        if (tableWidth == 0) {
            SS.debug("FitTable action tableWidth == 0. table.getPreferredWidth=" + table.getPreferredSize().getWidth() + ", table.getWidth=" + table.getWidth() + ", totalPreferredWidth=" + totalPreferredWidth + ", parent.width=" + table.getParent().getPreferredSize().getWidth(), 1);
        }
        if (tableWidth > totalPreferredWidth + 10) {
            int extraSpacePerColumn = (tableWidth - totalPreferredWidth) / table.getColumnCount();
            SS.debug("FitTable action extraSpacePerColumn " + extraSpacePerColumn, 4);
            int i2 = 0;
            while (i2 < preferredWidths.length) {
                int n = i2++;
                preferredWidths[n] = preferredWidths[n] + extraSpacePerColumn;
            }
        }
        columns = table.getColumnModel().getColumns();
        int i3 = 0;
        while (columns.hasMoreElements()) {
            TableColumn column = columns.nextElement();
            header.setResizingColumn(column);
            column.setWidth(preferredWidths[i3] + table.getIntercellSpacing().width);
            column.setPreferredWidth(preferredWidths[i3] + table.getIntercellSpacing().width);
            ++i3;
        }
    }
}

