/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class DocumentSizeFilter
extends DocumentFilter {
    int maxCharacters;
    boolean DEBUG = false;

    public DocumentSizeFilter(int maxChars) {
        this.maxCharacters = maxChars;
    }

    public void insertString(DocumentFilter.FilterBypass fb, int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.DEBUG) {
            System.out.println("in DocumentSizeFilter's insertString method");
        }
        if (fb.getDocument().getLength() + str.length() > this.maxCharacters) {
            int removeCharCount = Math.min(fb.getDocument().getLength(), Math.max(str.length() * 2, 4096));
            super.remove(fb, 0, removeCharCount);
            super.insertString(fb, offs - removeCharCount, str, a);
        } else {
            super.insertString(fb, offs, str, a);
        }
    }

    public void replace(DocumentFilter.FilterBypass fb, int offs, int length, String str, AttributeSet a) throws BadLocationException {
        if (this.DEBUG) {
            System.out.println("in DocumentSizeFilter's replace method");
        }
        if (fb.getDocument().getLength() + str.length() - length <= this.maxCharacters) {
            super.replace(fb, offs, length, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

