/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.widgets;

import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.widgets.HelpTextReciever;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class AquaButton
extends JButton
implements MouseListener {
    public static final int CENTER_ALIGN = 0;
    public static final int LEFT_ALIGN = 1;
    public static final int RIGHT_ALIGN = 2;
    public static SoundEffect enterSound = new SoundEffect("mouseOver.wav");
    public static SoundEffect clickSound = new SoundEffect("buttonClick.wav");
    public static final Color defaultTextColor = new Color(0, 0, 0);
    public static final Color textColorOnMouseOver = new Color(194, 17, 0);
    private Image icon;
    private Image iconHighlighted;
    private Font customFont;
    private boolean plainFont = false;
    private boolean highlighted = false;
    private int textAlignment;
    private Dimension size;
    private boolean switcher;
    private boolean switchedOn;
    private HelpTextReciever helpTextReciever;
    private String helpText;
    private int inset = 3;
    private String text;
    public Color textColor;
    private boolean underline = false;
    private int textWidth = 0;
    private static Map fontCache = new HashMap();
    private static Map fontCache2 = new HashMap();
    ActionListener actionListener;
    private boolean showLock = false;
    private boolean isLockable = false;
    private static Image lock;

    public AquaButton(Action a) {
        this(a, 80);
    }

    public AquaButton(Action a, int width) {
        this(a, width, 0);
    }

    public AquaButton(boolean plainFont, Action a, int width) {
        this(a, width, 0);
        this.plainFont = plainFont;
    }

    public AquaButton(boolean plainFont, Action a, int width, int textAlignment) {
        this(a, width, textAlignment);
        this.plainFont = plainFont;
    }

    public AquaButton(Action a, int width, int textAlignment) {
        super(a);
        this.text = (String)a.getValue("Name");
        this.textAlignment = textAlignment;
        this.init(width, 40);
    }

    public AquaButton(int width, int height, String text) {
        this(width, height, text, 0);
    }

    public AquaButton(String text) {
        this(80, 40, text);
    }

    public AquaButton(boolean plainFont, int width, int height, String text, int textAlignment) {
        this(width, height, text, textAlignment);
        this.plainFont = plainFont;
    }

    public AquaButton(boolean plainFont, int width, int height, String text, int textAlignment, Color c) {
        this(width, height, text, textAlignment);
        this.plainFont = plainFont;
        this.textColor = c;
    }

    public AquaButton(int width, int height, String text, int textAlignment) {
        super(text);
        this.text = text;
        this.textAlignment = textAlignment;
        this.switcher = false;
        this.switchedOn = false;
        this.init(width, height);
    }

    public AquaButton(int width, int height, String text, int textAlignment, Color textColor) {
        this(width, height, text, textAlignment);
        this.textColor = textColor;
    }

    public AquaButton(int width, int height, String text, boolean switchedOn) {
        this(width, height, text, switchedOn, 0);
    }

    public AquaButton(boolean plainFont, int width, int height, String text, boolean switchedOn, int textAlignment) {
        this(width, height, text, switchedOn, textAlignment);
        this.plainFont = plainFont;
    }

    public AquaButton(boolean plainFont, int width, int height, String text, boolean switchedOn, int textAlignment, Color c) {
        this(width, height, text, switchedOn, textAlignment);
        this.plainFont = plainFont;
        this.textColor = c;
    }

    public AquaButton(int width, int height, String text, boolean switchedOn, int textAlignment) {
        super(text);
        this.text = text;
        this.textAlignment = textAlignment;
        this.switcher = true;
        this.switchedOn = switchedOn;
        this.init(width, height);
    }

    private void init(int width, int height) {
        if (!SS.isMacintosh) {
            width += 8;
        }
        this.size = new Dimension(width, height);
        this.setPreferredSize(this.size);
        this.setMinimumSize(this.size);
        this.setMaximumSize(this.size);
        this.setSize(width, height);
        this.addMouseListener(this);
        this.setBorder(null);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void setWidth(int width) {
        int height = this.size.height;
        this.size = new Dimension(width, height);
        this.setPreferredSize(this.size);
        this.setMinimumSize(this.size);
        this.setMaximumSize(this.size);
        this.setSize(width, height);
    }

    public void setWidthForText() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int width = fontMetrics.stringWidth(this.text);
        this.setWidth(width + 22);
    }

    public void setIcon(String resourceLocation, String resourceLocationHighlighted) {
        if (resourceLocation == null) {
            this.icon = null;
            this.iconHighlighted = null;
            return;
        }
        this.icon = new ImageIcon(AquaButton.class.getResource(resourceLocation)).getImage();
        this.iconHighlighted = resourceLocationHighlighted == null ? null : new ImageIcon(AquaButton.class.getResource(resourceLocationHighlighted)).getImage();
    }

    public Dimension getPreferredSize() {
        return this.size == null ? new Dimension(147, 37) : this.size;
    }

    protected void paintComponent(Graphics g) {
        boolean drawButtonBackground;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        boolean bl = drawButtonBackground = this.getWidth() < 201;
        if (this.isDefaultButton()) {
            g2.setColor(new Color(124, 176, 230));
            g2.fillRoundRect(2, 3, this.getWidth() - 4, this.getHeight() - 4, 16, 16);
        } else if (drawButtonBackground) {
            g2.setColor(new Color(30, 30, 30));
            g2.fillRoundRect(2, 3, this.getWidth() - 4, this.getHeight() - 4, 16, 16);
        }
        int vWidth = this.getWidth();
        int vHeight = this.getHeight();
        int vButtonHeight = vHeight - this.inset * 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        if (this.text != null) {
            float x;
            if (!this.isEnabled()) {
                g2.setColor(Color.GRAY);
            } else if (this.highlighted) {
                g2.setColor(textColorOnMouseOver);
            } else if (this.showLock) {
                g2.setColor(Color.DARK_GRAY);
            } else {
                g2.setColor(this.textColor == null ? defaultTextColor : this.textColor);
            }
            String drawText = this.text;
            if (this.switcher) {
                drawText = this.text + ": " + (this.switchedOn ? "ON" : "OFF");
            }
            g2.setFont(this.getFont());
            FontMetrics vMetrics = g2.getFontMetrics();
            Rectangle2D vStringBounds = vMetrics.getStringBounds(drawText, g2);
            this.textWidth = (int)vStringBounds.getWidth();
            float y = (float)((double)(vHeight / 2) + vStringBounds.getHeight() / 2.0) - (float)vMetrics.getDescent();
            if (this.textAlignment == 0) {
                x = vWidth / 2 - this.textWidth / 2;
            } else if (this.textAlignment == 2) {
                x = vWidth - this.textWidth;
            } else {
                x = 0.0f;
                if (this.isLockable) {
                    x += 35.0f;
                } else if (this.icon != null) {
                    x += 40.0f;
                }
            }
            if (this.isLockable) {
                y += 6.0f;
            }
            g2.drawString(drawText, x, y);
            if (this.icon != null) {
                int iconX = 0;
                int iconY = vButtonHeight / 2 - 13;
                if (this.textAlignment == 2 || this.textAlignment == 0) {
                    iconX = (int)x - 50;
                }
                if (this.isLockable) {
                    iconY = -1;
                }
                if (this.highlighted && this.iconHighlighted != null) {
                    g.drawImage(this.iconHighlighted, iconX, iconY, this);
                } else {
                    g.drawImage(this.icon, iconX, iconY, this);
                }
            }
        }
        if (this.showLock) {
            if (lock == null) {
                lock = new ImageIcon(this.getClass().getResource("/lock.png")).getImage();
            }
            int x = 0;
            g.drawImage(lock, x, 7, this);
        } else if (this.isLockable) {
            // empty if block
        }
        if (this.underline) {
            int prefWidth = g.getFontMetrics().stringWidth(this.text) + 2;
            int lineHeight = g.getFontMetrics().getHeight();
            g.drawLine(0, lineHeight + 2, prefWidth, lineHeight + 2);
        }
    }

    public int getTextWidth() {
        if (this.textWidth == 0) {
            FontMetrics vMetrics = this.getFontMetrics(AquaButton.getFontForHeight(this.getHeight() - this.inset * 2, this.plainFont));
            this.textWidth = vMetrics.stringWidth(this.text);
        }
        return this.textWidth;
    }

    public static Font getFontForHeight(float vButtonHeight) {
        return AquaButton.getFontForHeight(vButtonHeight, false);
    }

    public static Font getFontForHeight(float vButtonHeight, boolean plainFont) {
        if (plainFont) {
            int integerSize = (int)((double)vButtonHeight * 0.8);
            return AquaButton.getPlainFontSized(integerSize);
        }
        int integerSize = (int)((double)vButtonHeight * 0.8);
        return AquaButton.getFontSized(integerSize);
    }

    public static Font getFontSized(int pointSize) {
        Font vFont;
        Object font = fontCache.get(new Integer(pointSize));
        if (font != null) {
            return (Font)font;
        }
        try {
            vFont = Font.createFont(0, AquaButton.class.getResourceAsStream("/Dirty Headline Commercial.ttf"));
            vFont = vFont.deriveFont(0, pointSize);
        }
        catch (Exception e) {
            SS.debug("Unable to load the desired font for AquaButton: " + e);
            vFont = new Font("Arial", 0, pointSize);
        }
        fontCache.put(new Integer(pointSize), vFont);
        return vFont;
    }

    public static Font getPlainFontSized(int pointSize) {
        Object font = fontCache2.get(new Integer(pointSize));
        if (font != null) {
            return (Font)font;
        }
        Font vFont = new Font("Arial", 0, pointSize);
        fontCache2.put(new Integer(pointSize), vFont);
        return vFont;
    }

    public boolean isOpaque() {
        return false;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            // empty if block
        }
    }

    public void addActionListener(ActionListener al) {
        this.actionListener = al;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.highlighted = true;
            this.repaint();
            if (PrefsCache.useSound && Prefs.getBoolean("soundButtons", true)) {
                enterSound.play();
            }
            if (this.helpTextReciever != null) {
                this.helpTextReciever.setHelpText(this.helpText);
            }
        }
    }

    public void mouseExited(MouseEvent e) {
        this.highlighted = false;
        this.repaint();
        if (this.helpTextReciever != null) {
            this.helpTextReciever.setHelpText(null);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (PrefsCache.useSound && Prefs.getBoolean("soundButtons", true)) {
            clickSound.play();
        }
        if (this.switcher) {
            this.switchedOn = !this.switchedOn;
        }
        this.mouseExited(null);
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.getActionCommand()));
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void addHelpText(String text, HelpTextReciever reciever) {
        this.helpText = text;
        this.helpTextReciever = reciever;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void showLock(boolean newState) {
        this.showLock = newState;
    }

    public void setIsLockable(boolean newState) {
        this.isLockable = newState;
    }

    public boolean isLocked() {
        return this.showLock;
    }

    public boolean isFocusable() {
        if (SS.isMacintosh) {
            return false;
        }
        return super.isFocusable();
    }

    public void setPreferredWidth(int width) {
        Dimension pref = super.getPreferredSize();
        if ((double)width > pref.getWidth()) {
            this.setPreferredSize(new Dimension(width, (int)pref.getHeight()));
        }
    }

    public String toString() {
        return "<AquaButton text:" + this.text + ">";
    }

    public void setUnderline(boolean value) {
        this.underline = value;
        this.repaint();
    }

    public void setCustomFont(Font newFont) {
        this.customFont = newFont;
    }

    public void setTextColor(Color c) {
        this.textColor = c;
    }

    public void doClick() {
        this.mousePressed(null);
    }

    public Font getFont() {
        if (this.customFont != null) {
            return this.customFont;
        }
        int vButtonHeight = this.getHeight() - this.inset * 2;
        Font vFont = AquaButton.getFontForHeight(vButtonHeight, this.plainFont);
        return vFont;
    }
}

