/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.command;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.command.Command;
import com.sillysoft.vox.unit.UnitKnight;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class MoveCommand
extends Command {
    private UnitStack units;
    private int fromCountryID;
    private int toCountryID;
    private Polygon moveArrow;
    private Point fromPoint;
    private Point toPoint;
    private Point displayPoint;
    private Point displayPoint2;
    public boolean draw = true;

    public String toStringXML() {
        return "<MoveCommand fromCountryID=\"" + this.fromCountryID + "\" toCountryID=\"" + this.toCountryID + "\" >" + this.units.toStringXML() + "</MoveCommand>";
    }

    public MoveCommand(UnitStack units, Country from, Country to) {
        this.units = units;
        this.fromCountryID = from.getID();
        this.toCountryID = to.getID();
        this.setPoints(from, to);
    }

    private void setPoints(Country from, Country to) {
        this.fromPoint = from.getCenter();
        this.toPoint = to.getCenter();
        if (this.units.getUnit() instanceof UnitKnight) {
            this.fromPoint = new Point(this.fromPoint.x + 10, this.fromPoint.y + 10);
            this.toPoint = new Point(this.toPoint.x + 10, this.toPoint.y + 10);
        } else {
            this.fromPoint = new Point(this.fromPoint.x - 10, this.fromPoint.y - 10);
            this.toPoint = new Point(this.toPoint.x - 10, this.toPoint.y - 10);
        }
        int distance = 15;
        double aDir = Math.atan2(this.toPoint.x - this.fromPoint.x, this.toPoint.y - this.fromPoint.y);
        this.fromPoint = new Point(this.fromPoint.x + GraphicsTool.xCor(distance, aDir), this.fromPoint.y + GraphicsTool.yCor(distance, aDir));
        aDir = Math.atan2(this.fromPoint.x - this.toPoint.x, this.fromPoint.y - this.toPoint.y);
        this.toPoint = new Point(this.toPoint.x + GraphicsTool.xCor(distance, aDir), this.toPoint.y + GraphicsTool.yCor(distance, aDir));
        this.displayPoint = to.getContainedPointAlongLine(this.fromPoint, this.toPoint);
        this.displayPoint2 = to.getOutsidePointAlongLine(this.fromPoint, this.toPoint);
    }

    public void execute(VoxWorld engine) {
        this.units = engine.countryWithID(this.fromCountryID).removeUnits(this.units);
        this.units.setOriginalCountry(engine.countryWithID(this.fromCountryID));
    }

    public void addUnits(VoxWorld engine, UnitStack group) {
        this.addUnits(engine, group, null);
    }

    public void addUnits(VoxWorld engine, UnitStack group, UnitStackGroup carriedUnits) {
        if (carriedUnits != null && carriedUnits.getTotalUnitCount() > 0) {
            SS.debug("addUnits to a move command when they are carrying transport stuffs");
        }
        UnitStack addedUnits = engine.countryWithID(this.fromCountryID).removeUnits(group);
        this.units.setCount(this.units.getCount() + addedUnits.getCount());
        this.units.addCarry(addedUnits.getCarriedUnits());
        this.units.addCarry(addedUnits.getCarriedUnitsAir());
        this.units.setOriginalCountry(engine.countryWithID(this.fromCountryID));
    }

    public void undo(VoxWorld engine) {
        Country from = engine.countryWithID(this.fromCountryID);
        this.units.setOriginalCountry(from);
        from.addUnitStack(this.units);
    }

    public void drawArrow(Graphics2D g, VoxWorld world, String theme, boolean activeVisuals) {
        if (!this.draw) {
            return;
        }
        if (this.moveArrow == null) {
            this.moveArrow = GraphicsTool.getThickArrowPolygon(this.fromPoint, this.toPoint);
        }
        Color color = !activeVisuals ? this.units.getOwner().getColor() : (this.units.getTeam().equals(world.getCountry(this.toCountryID).getTeam()) ? GraphicsTool.transparent(Color.GREEN, 0.3f) : GraphicsTool.transparent(Color.RED, 0.3f));
        g.setColor(color);
        g.fillPolygon(this.moveArrow);
        g.setColor(GraphicsTool.THICK_ARROW_COLOR);
        g.drawPolygon(this.moveArrow);
    }

    public void drawUnits(Graphics2D g, VoxWorld world, String theme) {
        this.units.drawTwoThirdsCentered(g, this.displayPoint2, theme);
        this.units.drawBubbleNumber(g, this.displayPoint.x - 6, this.displayPoint.y);
    }

    public String toString() {
        return "<MoveCommand move " + this.units + " from:" + this.fromCountryID + " to:" + this.toCountryID + ">";
    }

    public int toCountry() {
        return this.toCountryID;
    }

    public int fromCountry() {
        return this.fromCountryID;
    }

    public Player getOwner() {
        return this.units.getOwner();
    }

    public Team getTeam() {
        return this.units.getOwner().getTeam();
    }

    public Unit getUnit() {
        return this.units.getUnit();
    }

    public int getUnitCount() {
        return this.units.getCount();
    }

    public boolean battleInCountry(Country c) {
        return c.getID() == this.toCountryID;
    }

    public UnitStackGroup unitsForBattleInCountry(Country c) {
        if (this.units.getCarriedUnits() != null && this.units.getCarriedUnits().getTotalUnitCount() > 0 && this.units.isAir()) {
            UnitStackGroup result = new UnitStackGroup();
            result.add(this.units.getCarriedUnits());
            this.units.removeCarry();
            result.add(this.units);
            return result;
        }
        if (c.getID() == this.toCountryID) {
            return new UnitStackGroup(this.units);
        }
        return null;
    }

    public boolean containsPoint(Point p) {
        if (this.moveArrow == null) {
            return false;
        }
        return this.moveArrow.contains(p);
    }

    public void setDraw(boolean b) {
        this.draw = b;
    }

    public Rectangle getBounds() {
        if (this.moveArrow == null) {
            return new Rectangle();
        }
        return this.moveArrow.getBounds();
    }

    public void resetArrow(VoxWorld world) {
        this.moveArrow = null;
        this.setPoints(world.getCountry(this.fromCountryID), world.getCountry(this.toCountryID));
    }
}

