/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.command;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.command.BuildCommand;
import com.sillysoft.vox.command.MoveCommand;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public abstract class Command
implements XMLSerializable {
    public static List getCommandListFromXML(String XML, VoxServer server) {
        ArrayList<Command> list = new ArrayList<Command>();
        String item = XMLTool.extract("vcommand", XML);
        int h = 1;
        while (item != null) {
            Command object = Command.fromXML(item, server);
            list.add(object);
            item = XMLTool.extract("vcommand", XML, h);
            ++h;
        }
        return list;
    }

    public static Command fromXML(String XML, CountriesManager master) {
        try {
            if (XML.startsWith("<BuildCommand")) {
                int toCountryID = Integer.parseInt(XMLTool.extractAttribute("toCountryID", XML));
                UnitStack units = new UnitStack(XMLTool.extractContained("UnitStack", XML, 0), master);
                return new BuildCommand(units, toCountryID);
            }
            if (XML.startsWith("<MoveCommand")) {
                int toCountryID = Integer.parseInt(XMLTool.extractAttribute("toCountryID", XML));
                int fromCountryID = Integer.parseInt(XMLTool.extractAttribute("fromCountryID", XML));
                UnitStack units = new UnitStack(XMLTool.extractContained("UnitStack", XML, 0), master);
                List countries = master.getCountries();
                Country from = null;
                Country to = null;
                for (int i = 0; i < countries.size() && (from == null || to == null); ++i) {
                    if (((Country)countries.get(i)).getID() == toCountryID) {
                        to = (Country)countries.get(i);
                    }
                    if (((Country)countries.get(i)).getID() != fromCountryID) continue;
                    from = (Country)countries.get(i);
                }
                return new MoveCommand(units, from, to);
            }
        }
        catch (Exception e) {
            SS.debug("Error creating country from XML: " + XML);
            e.printStackTrace();
        }
        return null;
    }

    public abstract String toStringXML();

    public abstract void execute(VoxWorld var1);

    public abstract void undo(VoxWorld var1);

    public abstract Team getTeam();

    public abstract Player getOwner();

    public abstract Unit getUnit();

    public abstract boolean battleInCountry(Country var1);

    public abstract UnitStackGroup unitsForBattleInCountry(Country var1);

    public abstract void drawArrow(Graphics2D var1, VoxWorld var2, String var3, boolean var4);

    public abstract void drawUnits(Graphics2D var1, VoxWorld var2, String var3);

    public abstract boolean containsPoint(Point var1);

    public abstract int getUnitCount();

    public abstract void setDraw(boolean var1);

    public abstract int toCountry();

    public abstract int fromCountry();

    public abstract Rectangle getBounds();

    public abstract void resetArrow(VoxWorld var1);
}

