/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.command;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.command.Command;
import com.sillysoft.vox.unit.UnitKnight;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;

public class BuildCommand
extends Command {
    private UnitStack units;
    private int toCountryID;
    private Polygon moveArrow;
    private Point displayPoint;
    private Point toPoint;
    private Point fromPoint;
    public boolean draw = true;

    public String toStringXML() {
        return "<BuildCommand toCountryID=\"" + this.toCountryID + "\" >" + this.units.toStringXML() + "</BuildCommand>";
    }

    public BuildCommand(UnitStack units, Country to) {
        this.units = units;
        this.toCountryID = to.getID();
    }

    public BuildCommand(UnitStack units, int to) {
        this.units = units;
        this.toCountryID = to;
    }

    public void execute(VoxWorld engine) {
        engine.setMoney(this.units.getOwner(), engine.getPlayerMoney(this.units.getOwner()) - this.units.getCost());
    }

    public void addUnits(VoxWorld engine, UnitStack group) {
        this.addUnits(engine, group, null);
    }

    public void addUnits(VoxWorld engine, UnitStack group, UnitStackGroup carriedUnits) {
        engine.setMoney(this.units.getOwner(), engine.getPlayerMoney(this.units.getOwner()) - group.getCost());
        this.units.setCount(this.units.getCount() + group.getCount());
    }

    public void undo(VoxWorld engine) {
        engine.setMoney(this.units.getOwner(), engine.getPlayerMoney(this.units.getOwner()) + this.units.getCost());
    }

    public void drawArrow(Graphics2D g, VoxWorld engine, String theme, boolean activeVisuals) {
        if (this.moveArrow == null) {
            if (this.units.getUnit() instanceof UnitKnight) {
                this.toPoint = engine.countryWithID(this.toCountryID).getCenter();
                this.toPoint = new Point(this.toPoint.x + 10, this.toPoint.y);
            } else {
                this.toPoint = engine.countryWithID(this.toCountryID).getCenter();
                this.toPoint = new Point(this.toPoint.x - 10, this.toPoint.y);
            }
            this.fromPoint = new Point((int)this.toPoint.getX(), (int)(this.toPoint.getY() - 40.0));
            this.displayPoint = engine.countryWithID(this.toCountryID).getContainedPointAlongLine(this.fromPoint, this.toPoint);
            this.moveArrow = GraphicsTool.getThickArrowPolygon(this.fromPoint, this.toPoint);
        }
        Color color = !activeVisuals ? GraphicsTool.transparent(this.units.getOwner().getColor(), 0.3f) : GraphicsTool.transparent(Color.GREEN, 0.3f);
        g.setColor(color);
        g.fillPolygon(this.moveArrow);
        g.setColor(GraphicsTool.THICK_ARROW_COLOR);
        g.drawPolygon(this.moveArrow);
    }

    public void drawUnits(Graphics2D g, VoxWorld engine, String theme) {
        if (this.displayPoint == null) {
            System.out.println("BuildCommand.drawUnits() with a null displayPoint");
            return;
        }
        this.units.drawTwoThirdsCentered(g, this.displayPoint, theme);
        if (!this.units.getUnit().isCastle()) {
            this.units.drawBubbleNumber(g, this.displayPoint.x - 6, this.displayPoint.y);
        }
    }

    public void resetArrow(VoxWorld world) {
        this.moveArrow = null;
    }

    public String toString() {
        return "<BuildCommand units " + this.units + " on:" + this.toCountryID + ">";
    }

    public int toCountry() {
        return this.toCountryID;
    }

    public int fromCountry() {
        return -1;
    }

    public Player getOwner() {
        return this.units.getOwner();
    }

    public Team getTeam() {
        return this.units.getOwner().getTeam();
    }

    public Unit getUnit() {
        return this.units.getUnit();
    }

    public int getUnitCount() {
        return this.units.getCount();
    }

    public boolean battleInCountry(Country c) {
        return c.getID() == this.toCountryID;
    }

    public UnitStackGroup unitsForBattleInCountry(Country c) {
        return null;
    }

    public UnitStackGroup unitsToBuildInCountry(Country c) {
        if (c.getID() == this.toCountryID) {
            return new UnitStackGroup(this.units);
        }
        return null;
    }

    public boolean containsPoint(Point p) {
        if (this.moveArrow == null) {
            return false;
        }
        return this.moveArrow.contains(p);
    }

    public void setDraw(boolean b) {
        this.draw = b;
    }

    public Rectangle getBounds() {
        if (this.moveArrow == null) {
            return new Rectangle();
        }
        return this.moveArrow.getBounds();
    }
}

