/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.CountryPathFinder;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.command.Command;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public abstract class VoxAgentBase
implements VoxAgent {
    protected int ID;
    protected VoxWorld world;
    protected Country[] countries;
    protected Random rand = new Random();

    public void buyUnits(int money) {
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        if (bases.size() == 0) {
            this.buyCastle();
            return;
        }
        this.buyUnits22(money, (Country)bases.get(this.rand.nextInt(bases.size())));
    }

    public void buyHalfKnights(int money, Country baseCountry) {
        UnitPawn pawn = new UnitPawn(this.world.getPlayer(this.ID));
        UnitKnight knight = new UnitKnight(this.world.getPlayer(this.ID));
        int numKnight = money / knight.getCost() / 2;
        this.world.placeUnits(new UnitStack(knight, numKnight), baseCountry);
        int numInf = (money -= numKnight * knight.getCost()) / pawn.getCost();
        this.world.placeUnits(new UnitStack(pawn, numInf), baseCountry);
    }

    public void buyUnits22(int money, Country baseCountry) {
        UnitPawn pawn = new UnitPawn(this.world.getPlayer(this.ID));
        UnitKnight knight = new UnitKnight(this.world.getPlayer(this.ID));
        int numInf = 0;
        int numKnight = 0;
        while (money >= pawn.getCost()) {
            if (money >= pawn.getCost()) {
                ++numInf;
                money -= pawn.getCost();
            }
            if (money >= pawn.getCost()) {
                ++numInf;
                money -= pawn.getCost();
            }
            if (money >= knight.getCost()) {
                ++numKnight;
                money -= knight.getCost();
            }
            if (money < knight.getCost()) continue;
            ++numKnight;
            money -= knight.getCost();
        }
        this.world.placeUnits(new UnitStack(pawn, numInf), baseCountry);
        this.world.placeUnits(new UnitStack(knight, numKnight), baseCountry);
    }

    public void buyUnitsAlternating(int money, Country baseCountry) {
        UnitPawn pawn = new UnitPawn(this.world.getPlayer(this.ID));
        UnitKnight knight = new UnitKnight(this.world.getPlayer(this.ID));
        int numInf = 0;
        int numKnight = 0;
        while (money >= pawn.getCost()) {
            if (money >= pawn.getCost()) {
                ++numInf;
                money -= pawn.getCost();
            }
            if (money < knight.getCost()) continue;
            ++numKnight;
            money -= knight.getCost();
        }
        this.world.placeUnits(new UnitStack(pawn, numInf), baseCountry);
        this.world.placeUnits(new UnitStack(knight, numKnight), baseCountry);
    }

    public void buyKnights(int money, Country baseCountry) {
        UnitKnight knight = new UnitKnight(this.world.getPlayer(this.ID));
        this.world.placeUnits(new UnitStack(knight, money / knight.getCost()), baseCountry);
    }

    public void buyPawns(int money, Country baseCountry) {
        UnitPawn pawn = new UnitPawn(this.world.getPlayer(this.ID));
        this.world.placeUnits(new UnitStack(pawn, money / pawn.getCost()), baseCountry);
    }

    public boolean buyCastle() {
        Country country;
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.ID));
        if (this.world.getPlayerMoney(this.ID) >= castle.getCost() && (country = this.getBestCastleBuildCountry()) != null) {
            this.world.placeUnits(new UnitStack(castle, 1), country);
            return true;
        }
        return false;
    }

    public Country getBestCastleBuildCountry() {
        int bestValue = 0;
        Country bestCountry = null;
        for (int i = 0; i < this.countries.length; ++i) {
            Country c = this.countries[i];
            if (c.getOwner().getID() != this.ID || c.getUnitStackGroup().getTotalUnitCount() <= 4) continue;
            int value = c.getUnitStackGroup().getCost();
            if ((value += c.getBonus()) <= bestValue && (value != bestValue || this.rand.nextInt(10) <= 5)) continue;
            bestValue = value;
            bestCountry = c;
        }
        return bestCountry;
    }

    public void declareMoves(Country[] countries) {
        this.countries = countries;
    }

    public Country getWeakestBase() {
        int lowestDefence = 1000000;
        Country weakestBase = null;
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        for (int i = 0; i < bases.size(); ++i) {
            Country c = (Country)bases.get(i);
            int defence = c.getUnitStackGroup().calculateDiceRollKills(false);
            if (defence >= lowestDefence) continue;
            lowestDefence = defence;
            weakestBase = c;
        }
        return weakestBase;
    }

    public Country getStrongestBase() {
        int lowestDefence = -100;
        Country weakestBase = null;
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        for (int i = 0; i < bases.size(); ++i) {
            Country c = (Country)bases.get(i);
            int defence = c.getUnitStackGroup().calculateDiceRollKills(false);
            if (defence <= lowestDefence) continue;
            lowestDefence = defence;
            weakestBase = c;
        }
        return weakestBase;
    }

    public Country getFrontBase() {
        int lowestDistance = 1000000;
        Country weakestBase = null;
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        for (int i = 0; i < bases.size(); ++i) {
            Country c = (Country)bases.get(i);
            int defence = this.distanceToEnemy(c);
            if (defence >= lowestDistance) continue;
            lowestDistance = defence;
            weakestBase = c;
        }
        return weakestBase;
    }

    public Country getFrontBaseSafe() {
        int lowestDistance = 1000000;
        Country weakestBase = null;
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        for (int i = 0; i < bases.size(); ++i) {
            Country c = (Country)bases.get(i);
            int defence = this.distanceToEnemy(c);
            if (defence >= lowestDistance || this.countryIsInDanger(c)) continue;
            lowestDistance = defence;
            weakestBase = c;
        }
        return weakestBase;
    }

    public boolean countryIsInDanger(Country c) {
        int defend = c.getUnitStackGroup().calculateDiceRollKills(false);
        int attack = 0;
        ArrayList examine = new ArrayList();
        examine.addAll(c.getAdjoiningList());
        for (int i = 0; i < examine.size(); ++i) {
            Country border = (Country)examine.get(i);
            if (border.getTeam().equals(c.getTeam())) continue;
            attack += border.getUnitStackGroup().calculateDiceRollKills(true);
        }
        return attack > defend;
    }

    public Country getRandomBorder(Country c) {
        List adjoiningList = c.getAdjoiningList();
        return (Country)adjoiningList.get(this.rand.nextInt(adjoiningList.size()));
    }

    public Country getRandomBorder(Country c, int range) {
        List adjoiningList = c.getAdjoiningList();
        ArrayList examine = new ArrayList();
        examine.addAll(c.getAdjoiningList());
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (!border.getTeam().equals(this.world.getPlayer(this.ID).getTeam()) && !border.isEmpty()) continue;
            examine.addAll(border.getAdjoiningList());
        }
        return (Country)examine.get(this.rand.nextInt(examine.size()));
    }

    public List getEnemyBorders(Country c) {
        List adjoiningList = c.getAdjoiningList();
        ArrayList<Country> matching = new ArrayList<Country>();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (border.getTeam().equals(c.getTeam())) continue;
            matching.add(border);
        }
        return matching;
    }

    public Country getRandomEnemyBorder(Country c) {
        List adjoiningList = c.getAdjoiningList();
        ArrayList<Country> matching = new ArrayList<Country>();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (border.getTeam().equals(c.getTeam())) continue;
            matching.add(border);
        }
        if (matching.size() == 0) {
            return null;
        }
        return (Country)matching.get(this.rand.nextInt(matching.size()));
    }

    public int distanceToEnemy(Country c) {
        return CountryPathFinder.distanceToEnemy(c);
    }

    public Country directionToEnemy(Country c) {
        Country enemy = this.getRandomEnemyBorder(c);
        if (enemy != null) {
            return enemy;
        }
        int lowestPath = 1000000;
        Country lowestDirection = null;
        List adjoiningList = c.getAdjoiningList();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (!border.getTeam().equals(c.getTeam())) {
                return border;
            }
            int borderDistance = this.distanceToEnemy(border);
            if (borderDistance >= lowestPath) continue;
            lowestPath = borderDistance;
            lowestDirection = border;
        }
        return lowestDirection;
    }

    public void moveTowardsEnemySplittingUp(UnitStack units, Country from) {
        int lowestDistance = 1000000;
        ArrayList<Country> lowestDistanceBorders = new ArrayList<Country>();
        List borders = from.getAdjoiningList();
        for (int b = 0; b < borders.size(); ++b) {
            Country check = (Country)borders.get(b);
            int distance = this.distanceToEnemy(check);
            if (distance < lowestDistance) {
                lowestDistance = distance;
                lowestDistanceBorders = new ArrayList();
                lowestDistanceBorders.add(check);
                continue;
            }
            if (distance != lowestDistance) continue;
            lowestDistanceBorders.add(check);
        }
        int numberToMove = units.getCount();
        for (int m = 0; m < lowestDistanceBorders.size(); ++m) {
            this.world.moveUnit(units, from, (Country)lowestDistanceBorders.get(m), (int)Math.ceil(1.0f * (float)numberToMove / (float)lowestDistanceBorders.size()));
        }
    }

    public float getIncome(Country c) {
        return (float)c.getBonus() + c.getContinentBonusPartial(this.world);
    }

    public float getDanger(Country c) {
        float danger = 0.0f;
        ArrayList examine = new ArrayList();
        examine.addAll(c.getAdjoiningList());
        int range1size = examine.size();
        for (int i = 0; i < examine.size(); ++i) {
            Country border = (Country)examine.get(i);
            if (!border.getTeam().equals(c.getTeam())) {
                danger += (float)border.getUnitStackGroup().calculateDiceRollKills(true);
            }
            if (i >= range1size || border.getTeam().equals(c.getTeam()) && !border.isEmpty()) continue;
            List nextBorders = border.getAdjoiningList();
            examine.addAll(nextBorders);
        }
        SS.debug("getDanger of " + c + " = " + danger, 2);
        return danger;
    }

    public Country getMostValuableEnemyBorder(Country c, int range) {
        return CountryPathFinder.getMostValuableEnemyBorder(c, range, this.world);
    }

    public void setPrefs(int newID, VoxWorld theworld) {
        this.ID = newID;
        this.world = theworld;
    }

    public String name() {
        return "VoxAgentBase";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "VoxAgentBase is an abstract agent class you can subclass.";
    }

    public List getRealAdjoiningList(Object country, Country[] countryArrayReal) {
        List fakeList = ((Country)country).getAdjoiningList();
        ArrayList<Country> realList = new ArrayList<Country>();
        for (int j = 0; j < fakeList.size(); ++j) {
            realList.add(countryArrayReal[((Country)fakeList.get(j)).getID()]);
        }
        return realList;
    }

    public String youWon() {
        String[] answers = new String[]{"You should extend the youWon() method!!!", "You should extend the youWon() method!!!", "You should extend the youWon() method!!!"};
        return answers[this.rand.nextInt(answers.length)];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String message(String message, Object data) {
        if ("chat".equals(message)) {
            String text = (String)data;
            if (!text.startsWith("/t")) return null;
        }
        if ("roundIsEnding".equals(message) || !"endRoundMoves".equals(message)) return null;
        List moveList = (List)data;
        for (int j = 0; j < moveList.size(); ++j) {
            Command move = (Command)moveList.get(j);
            move.toCountry();
            move.getOwner();
        }
        return null;
    }
}

