/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.UnitStackGroupIterator;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class Nemo
implements VoxAgent {
    protected int ID;
    protected VoxWorld world;
    protected Country[] countries;
    protected Random rand = new Random();
    protected int bigValue = 999999999;
    protected int factDef = 10;
    protected int maxDist = 20;
    protected boolean landWarOver;
    protected boolean seaWarOver;
    protected boolean cannotSpendIncome = false;
    protected Unit knight;
    protected Unit infantry;
    protected Unit transportBoat;
    protected Unit cruiser;
    protected Unit sub;
    protected Unit castle;
    protected Unit base;
    protected Unit artillery;
    protected boolean[] isLandWar;
    protected int[] defence;

    public void setPrefs(int newID, VoxWorld theworld) {
        this.ID = newID;
        this.world = theworld;
        this.infantry = new UnitPawn(this.world.getPlayer(this.ID));
        this.knight = new UnitKnight(this.world.getPlayer(this.ID));
        this.transportBoat = null;
        this.cruiser = null;
        this.sub = null;
        this.castle = new UnitCastle(this.world.getPlayer(this.ID));
        this.base = null;
        this.artillery = null;
    }

    public int pickCountry() {
        return 0;
    }

    public void recon() {
        if (this.isLandWar == null) {
            this.isLandWar = new boolean[this.countries.length];
            this.defence = new int[this.countries.length];
        }
        this.landWarOver = true;
        this.seaWarOver = true;
        for (int i = 0; i < this.countries.length; ++i) {
            if (!this.countries[i].isWater() && !this.countries[i].getTeam().equals(this.world.getTeam(this.ID))) {
                this.landWarOver = false;
            }
            if (this.countries[i].isWater() && !this.countries[i].getTeam().equals(this.world.getTeam(this.ID)) && !this.countries[i].isEmpty()) {
                this.seaWarOver = false;
            }
            this.isLandWar[this.countries[i].getID()] = this.isEnemyReachableByLand(this.countries[i]);
            this.defence[this.countries[i].getID()] = this.findDefenceStrength(this.countries[i]);
        }
    }

    public boolean isEnemyReachableByLand(Country root) {
        return this.isEnemyReachableByLand(root, new Vector());
    }

    public boolean isEnemyReachableByLand(Country root, Vector seen) {
        seen.add(root);
        List around = root.getAdjoiningList();
        for (int i = 0; i < around.size(); ++i) {
            Country border = (Country)around.get(i);
            if (border.isWater() || seen.contains(border)) continue;
            if (!border.getTeam().equals(this.world.getTeam(this.ID))) {
                return true;
            }
            if (!this.isEnemyReachableByLand(border, seen)) continue;
            return true;
        }
        return false;
    }

    public void buyUnits(int money) {
        Country baseCountry;
        int i;
        UnitStack usCastle = new UnitStack(this.castle, 1);
        UnitStack usBase = new UnitStack(this.base, 1);
        for (int i2 = 0; i2 < this.countries.length; ++i2) {
            if (this.countries[i2].getBonus() < 4 || this.countries[i2].getOwner().getID() != this.ID) continue;
            UnitStack usInfantry = this.getUnitStack(this.infantry, this.countries[i2]);
            if (!this.cannotSpendIncome || money <= this.castle.getCost() || this.countries[i2].hasCastle() || !this.countries[i2].canBuildUnits(usCastle)) continue;
            this.world.placeUnits(usCastle, this.countries[i2]);
            money -= this.castle.getCost();
        }
        List factories = this.world.getCastleCountriesOwnedBy(this.ID);
        if (factories.size() == 0) {
            return;
        }
        for (i = 0; i < factories.size(); ++i) {
            baseCountry = (Country)factories.get(i);
            if (!this.isLandWar[baseCountry.getID()]) continue;
            money = this.buyLandUnits(money, baseCountry);
        }
        for (i = 0; i < factories.size(); ++i) {
            baseCountry = (Country)factories.get(i);
            if (this.isLandWar[baseCountry.getID()]) continue;
            money = this.buyFleet(money, baseCountry);
        }
        this.cannotSpendIncome = money > 20;
    }

    public int getMissingCruisers(Country from) {
        UnitStack usTransports = this.getUnitStack(this.transportBoat, from);
        int transports = 0;
        if (usTransports != null) {
            if (usTransports.getRemainingCarryCapacity() == 0) {
                return 0;
            }
            transports = usTransports.getCount();
        }
        if (transports == 2) {
            transports = 3;
        }
        UnitStack usCruiser = this.getUnitStack(this.cruiser, from);
        int cruisers = 0;
        if (usCruiser != null) {
            cruisers = usCruiser.getCount();
        }
        return transports / 3 - cruisers;
    }

    public int buyFleet(int money, Country from) {
        int numTransportBoat = 0;
        int numCruiser = 0;
        int numSub = 0;
        int unitsBought = 0;
        int bonus = from.getBonus();
        Country port = this.getPort(from);
        if (port == null) {
            return money;
        }
        boolean portOccupied = !port.getTeam().equals(this.world.getTeam(this.ID)) && !port.isEmpty();
        boolean transportsLoaded = false;
        List around = from.getAdjoiningList();
        for (int i = 0; i < around.size(); ++i) {
            Country border = (Country)around.get(i);
            UnitStack us = this.getUnitStack(this.transportBoat, border);
            if (us == null || us.getRemainingCarryCapacity() <= 0) continue;
            this.loadTransports(this.transportBoat, from, border);
            transportsLoaded = true;
        }
        for (int missingCruisers = this.getMissingCruisers(port); missingCruisers > 0 && money > this.cruiser.getCost() && unitsBought < bonus; ++unitsBought, money -= this.cruiser.getCost(), --missingCruisers) {
            ++numCruiser;
        }
        if (numCruiser > 0) {
            this.world.placeUnits(new UnitStack(this.cruiser, numCruiser), port);
            numCruiser = 0;
        }
        if (!this.seaWarOver && (this.landWarOver || this.rand.nextInt(15) == 0 || portOccupied)) {
            while (money >= this.cruiser.getCost() && unitsBought < bonus) {
                if (money >= this.cruiser.getCost() && unitsBought < bonus) {
                    ++numCruiser;
                    ++unitsBought;
                    money -= this.cruiser.getCost();
                }
                if (money < this.sub.getCost() || unitsBought >= bonus) continue;
                ++numSub;
                ++unitsBought;
                money -= this.sub.getCost();
            }
            if (numCruiser > 0) {
                this.world.placeUnits(new UnitStack(this.cruiser, numCruiser), port);
            }
            if (numSub > 0) {
                this.world.placeUnits(new UnitStack(this.sub, numSub), port);
            }
            return money;
        }
        if (transportsLoaded || this.rand.nextInt(2) == 0) {
            return this.buyLandUnits(money, from);
        }
        while (money >= this.transportBoat.getCost() && unitsBought < bonus) {
            if (money >= this.transportBoat.getCost() && unitsBought < bonus) {
                ++numTransportBoat;
                ++unitsBought;
                money -= this.transportBoat.getCost();
            }
            if (money >= this.transportBoat.getCost() && unitsBought < bonus) {
                ++numTransportBoat;
                ++unitsBought;
                money -= this.transportBoat.getCost();
            }
            if (money >= this.cruiser.getCost() && unitsBought < bonus) {
                ++numCruiser;
                ++unitsBought;
                money -= this.cruiser.getCost();
            }
            if (money < this.transportBoat.getCost() || unitsBought >= bonus) continue;
            ++numTransportBoat;
            ++unitsBought;
            money -= this.transportBoat.getCost();
        }
        if (numTransportBoat > 0) {
            this.world.placeUnits(new UnitStack(this.transportBoat, numTransportBoat), port);
        }
        if (numCruiser > 0) {
            this.world.placeUnits(new UnitStack(this.cruiser, numCruiser), port);
        }
        return money;
    }

    public Vector getPorts() {
        Vector<Country> ports = new Vector<Country>();
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        for (int i = 0; i < bases.size(); ++i) {
            Country port;
            Country baseCountry = (Country)bases.get(i);
            if (this.isLandWar[baseCountry.getID()] || (port = this.getPort(baseCountry)) == null) continue;
            ports.add(port);
        }
        return ports;
    }

    public Country getPort(Country from) {
        List adjoiningList = from.getAdjoiningList();
        Country altChoice = null;
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (!border.isWater()) continue;
            altChoice = border;
            List aroundPort = border.getAdjoiningList();
            for (int j = 0; j < aroundPort.size(); ++j) {
                Country portBorder = (Country)aroundPort.get(j);
                if (portBorder.isWater() || !this.isNearLandEnemy(portBorder)) continue;
                return border;
            }
        }
        return altChoice;
    }

    public void loadTransports(Unit transport, Country from, Country to) {
        int infantryToLoad;
        int artilleryToLoad;
        int knightsToLoad;
        UnitStack usTransport = this.getUnitStack(transport, to);
        UnitStack usKnight = this.getUnitStack(this.knight, from);
        UnitStack usInfantry = this.getUnitStack(this.infantry, from);
        UnitStack usArtillery = this.getUnitStack(this.artillery, from);
        if (usTransport == null) {
            return;
        }
        int otherRatio = 2;
        if (usKnight != null && usArtillery != null) {
            otherRatio = 3;
        }
        if (usInfantry == null || usInfantry.getCount() <= this.factDef) {
            otherRatio = 1;
        }
        if (usKnight != null && (knightsToLoad = Math.min(usKnight.getCount(), usTransport.getRemainingCarryCapacity() / (otherRatio * this.knight.transportWeight()))) > 0) {
            this.world.loadTransport(usKnight, usTransport, from, to, knightsToLoad);
        }
        if (usArtillery != null && (artilleryToLoad = Math.min(usArtillery.getCount(), usTransport.getRemainingCarryCapacity() / (otherRatio * this.artillery.transportWeight()))) > 0) {
            this.world.loadTransport(usArtillery, usTransport, from, to, artilleryToLoad);
        }
        if (usInfantry != null && (infantryToLoad = Math.min(usInfantry.getCount() - this.factDef, usTransport.getRemainingCarryCapacity() / this.infantry.transportWeight())) > 0) {
            this.world.loadTransport(usInfantry, usTransport, from, to, infantryToLoad);
        }
    }

    public int buyLandUnits(int money, Country from) {
        UnitStack us = this.getUnitStack(this.infantry, from);
        int defence = 0;
        if (us != null) {
            defence = us.getCount();
        }
        int numInf = 0;
        int numKnight = 0;
        int numArt = 0;
        int bonus = from.getBonus();
        while (money >= this.infantry.getCost() && numInf + numKnight + numArt < bonus) {
            if (money >= this.infantry.getCost() && numInf + numKnight + numArt < bonus) {
                ++numInf;
                money -= this.infantry.getCost();
            }
            if (money >= this.infantry.getCost() && numInf + numKnight + numArt < bonus) {
                ++numInf;
                money -= this.infantry.getCost();
            }
            if (money < this.knight.getCost() || numInf + numKnight + numArt >= bonus || defence + numInf < this.factDef) continue;
            ++numKnight;
            money -= this.knight.getCost();
        }
        this.world.placeUnits(new UnitStack(this.infantry, numInf), from);
        this.world.placeUnits(new UnitStack(this.knight, numKnight), from);
        return money;
    }

    public void declareMoves(Country[] countries) {
        this.countries = countries;
        this.recon();
        this.moveShips(this.sub);
        this.moveShips(this.cruiser);
        this.buyUnits(this.world.getPlayerMoney(this.ID));
        this.moveTransports();
        this.groundAttack();
        this.equalizeUnits(this.infantry);
        this.equalizeUnits(this.knight);
        if (this.rand.nextInt(3) == 0) {
            ++this.factDef;
        }
    }

    public void moveShips(Unit unit) {
        for (int i = 0; i < this.countries.length; ++i) {
            Country target;
            UnitStack us;
            if (!this.countries[i].isWater() || (us = this.getUnitStack(unit, this.countries[i])) == null || unit.getType() == this.cruiser.getType() && this.getUnitStack(this.transportBoat, this.countries[i]) != null || (target = this.navigateShips(us, this.countries[i])) == null) continue;
            this.world.moveUnit(us, this.countries[i], target, us.getCount());
        }
    }

    public void moveProtectingCruisers(Country from, Country to, int transports) {
        int numToMove;
        UnitStack usCruiser = this.getUnitStack(this.cruiser, from);
        if (usCruiser == null) {
            return;
        }
        if (transports == 1) {
            transports = 2;
        }
        if ((numToMove = Math.min(transports / 3, usCruiser.getCount())) > 0) {
            this.world.moveUnit(usCruiser, from, to, numToMove);
        }
    }

    public void moveTransports() {
        for (int i = 0; i < this.countries.length; ++i) {
            Country to;
            UnitStack us;
            if (!this.countries[i].isWater() || (us = this.getUnitStack(this.transportBoat, this.countries[i])) == null) continue;
            int emptyTransports = us.getRemainingCarryCapacity() / us.getUnit().transportCapacity();
            int fullTransports = us.getCount() - emptyTransports;
            if (fullTransports > 0 && (to = this.navigateTransport(this.findTransportAttackStrength(us), this.countries[i])) != null) {
                this.world.moveUnit(us, this.countries[i], to, fullTransports);
                this.moveProtectingCruisers(this.countries[i], to, fullTransports);
            }
            if (emptyTransports <= 0 || (to = this.navigateTransport(0, this.countries[i])) == null) continue;
            this.world.moveUnit(us, this.countries[i], to, emptyTransports);
            this.moveProtectingCruisers(this.countries[i], to, emptyTransports);
        }
    }

    public boolean isNearLandEnemy(Country from) {
        if (!from.isWater() && !from.getTeam().equals(this.world.getTeam(this.ID))) {
            return true;
        }
        List around = from.getAdjoiningList();
        for (int i = 0; i < around.size(); ++i) {
            Country border = (Country)around.get(i);
            if (border.isWater()) continue;
            if (!border.getTeam().equals(this.world.getTeam(this.ID))) {
                return true;
            }
            List aroundBorder = border.getAdjoiningList();
            for (int j = 0; j < aroundBorder.size(); ++j) {
                Country borderBorder = (Country)aroundBorder.get(j);
                if (borderBorder.isWater() || borderBorder.getTeam().equals(this.world.getTeam(this.ID))) continue;
                return true;
            }
        }
        return false;
    }

    public Country findCountryToUnloadTransports(int transportAttackStrength, Country from) {
        List around = from.getAdjoiningList();
        int weakestDefenceStrength = this.bigValue;
        Country weakestCountry = null;
        for (int i = 0; i < around.size(); ++i) {
            Country border = (Country)around.get(i);
            if (border.isWater()) continue;
            if (border.getTeam().equals(this.world.getTeam(this.ID))) {
                if (!this.isNearLandEnemy(border)) continue;
                return border;
            }
            int defenceStrength = this.defence[border.getID()];
            if (defenceStrength >= weakestDefenceStrength && (defenceStrength != weakestDefenceStrength || this.rand.nextInt(2) != 0)) continue;
            weakestDefenceStrength = defenceStrength;
            weakestCountry = border;
        }
        if (weakestCountry != null && transportAttackStrength >= Math.max(weakestDefenceStrength * 2, 8)) {
            return weakestCountry;
        }
        return null;
    }

    public Country navigateShips(UnitStack us, Country root) {
        Unit unit = us.getUnit();
        Vector ports = this.getPorts();
        for (int maxDistance = 0; maxDistance < this.maxDist; ++maxDistance) {
            Vector path = new Vector();
            Vector<Country> seen = new Vector<Country>();
            seen.add(root);
            Country target = this.navigate(root, seen, new Vector(), path, 0, maxDistance, -1, ports, us);
            if (target == null || path.size() <= 0) continue;
            return (Country)path.get(Math.min(path.size() - 1, unit.getMovement() - 1));
        }
        return null;
    }

    public Country navigateTransport(int transportAttackStrength, Country root) {
        Vector ports = this.getPorts();
        if (ports.size() == 0 && transportAttackStrength == 0) {
            return null;
        }
        for (int maxDistance = 0; maxDistance < this.maxDist; ++maxDistance) {
            Vector path = new Vector();
            Vector<Country> seen = new Vector<Country>();
            seen.add(root);
            Country target = this.navigate(root, seen, new Vector(), path, 0, maxDistance, transportAttackStrength, ports, null);
            if (path.size() > 0) {
                return (Country)path.get(Math.min(path.size() - 1, this.transportBoat.getMovement() - 1));
            }
            if (target == null) continue;
            return null;
        }
        return null;
    }

    public Country navigate(Country root, Vector seenBefore, List willSeeLater, Vector path, int distance, int maxDistance, int transportAttackStrength, Vector ports, UnitStack us) {
        Vector<Country> seen = new Vector<Country>(seenBefore);
        ++distance;
        if (root.getTeam() != this.world.getTeam(this.ID) && !root.isEmpty()) {
            if (transportAttackStrength == -1 && this.findAttackStrengthUS(us) > this.findDefenceStrength(root)) {
                return root;
            }
            return null;
        }
        if (transportAttackStrength == 0 && ports.contains(root) || transportAttackStrength == -1 && this.seaWarOver && ports.contains(root) || transportAttackStrength > 0 && this.findCountryToUnloadTransports(transportAttackStrength, root) != null) {
            return root;
        }
        if (distance < maxDistance) {
            List around = root.getAdjoiningList();
            Vector willSeeLaterOn = new Vector(willSeeLater);
            willSeeLaterOn.addAll(around);
            for (int i = 0; i < around.size(); ++i) {
                Country border = (Country)around.get(i);
                if (seen.contains(border) || willSeeLater.contains(border) || !border.isWater()) continue;
                seen.add(border);
                path.add(border);
                Country target = this.navigate(border, seen, willSeeLaterOn, path, distance, maxDistance, transportAttackStrength, ports, us);
                if (target != null) {
                    return target;
                }
                path.remove(border);
            }
        }
        return null;
    }

    public void groundAttack() {
        for (int i = 0; i < this.countries.length; ++i) {
            int attackStrength;
            UnitStackGroup usg;
            if (this.countries[i].isWater() || (usg = this.countries[i].getUnitStackGroup()).getTotalUnitCount() <= 0 || !this.countries[i].getTeam().equals(this.world.getTeam(this.ID)) || (attackStrength = this.findAttackStrength(this.countries[i])) <= 0) continue;
            this.groundAttackFrom(this.countries[i], attackStrength);
        }
    }

    public void groundAttackFrom(Country from, int attackStrength) {
        int weakestDefence = this.bigValue;
        Country weakestCountry = null;
        List adjoiningList = from.getAdjoiningList();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            int defenceStrength;
            Country border = (Country)adjoiningList.get(i);
            if (border.isWater() || border.getTeam().equals(this.world.getTeam(this.ID)) || (defenceStrength = this.getEnemyDefenceAround(border)) >= weakestDefence && (defenceStrength != weakestDefence || this.rand.nextInt(2) != 0)) continue;
            weakestDefence = defenceStrength;
            weakestCountry = border;
        }
        if (weakestCountry != null && attackStrength > weakestDefence + weakestDefence / 2) {
            this.attack(from, weakestCountry);
        }
    }

    public void attack(Country from, Country to) {
        UnitStackGroupIterator usgIter = new UnitStackGroupIterator(from);
        while (usgIter.hasNext()) {
            UnitStack us = usgIter.next();
            if (us.getUnit().getMovement() <= 0 || us.getOwner().getID() != this.ID) continue;
            this.attackWithUS(us, to);
        }
    }

    public void attackWithUS(UnitStack us, Country to) {
        Country from = us.getOriginalCountry(this.world);
        if (from.hasCastle() && us.getUnit().getType() == this.infantry.getType()) {
            if (us.getCount() > this.factDef) {
                this.world.moveUnit(us, from, to, us.getCount() - this.factDef);
            }
        } else {
            this.world.moveUnit(us, from, to, us.getCount());
        }
    }

    public int getEnemyDefenceAround(Country from) {
        int defenceStrength = this.defence[from.getID()];
        if (!from.hasCastle()) {
            List adjoiningList = from.getAdjoiningList();
            for (int i = 0; i < adjoiningList.size(); ++i) {
                Country border = (Country)adjoiningList.get(i);
                if (border.isWater() || border.getTeam().equals(this.world.getTeam(this.ID))) continue;
                defenceStrength += this.findEnemyAttackStrength(border) / 2;
            }
        }
        return defenceStrength;
    }

    public int findTransportAttackStrength(UnitStack us) {
        return this.findStrength(us.getCarriedUnits(), this.ID, true);
    }

    public int findAttackStrengthUS(UnitStack us) {
        int attackStrength = this.findStrength(us, this.ID, true);
        Country from = us.getOriginalCountry(this.world);
        if (from.hasCastle() && from.getTeam().equals(this.world.getTeam(this.ID)) && us.getUnit().getType() == this.infantry.getType()) {
            attackStrength = Math.max(attackStrength - this.factDef, 0);
        }
        return attackStrength;
    }

    public int findAttackStrength(Country from) {
        int attackStrength = this.findStrength(from.getUnitStackGroup(), this.ID, true);
        if (from.hasCastle() && from.getTeam().equals(this.world.getTeam(this.ID))) {
            attackStrength = Math.max(attackStrength - this.factDef, 0);
        }
        return attackStrength;
    }

    public int findEnemyAttackStrength(Country from) {
        return this.findStrength(from.getUnitStackGroup(), -1, true);
    }

    public int findDefenceStrength(Country from) {
        int defenceStrength = this.findStrength(from.getUnitStackGroup(), -1, false);
        if (from.hasFort()) {
            defenceStrength = (defenceStrength - this.base.getDefend()) * 2 + this.base.getDefend();
        }
        return defenceStrength;
    }

    public int findStrength(UnitStackGroup usg, int owner, boolean attack) {
        if (usg == null || usg.size() == 0) {
            return 0;
        }
        int strength = 0;
        UnitStackGroupIterator usgIter = new UnitStackGroupIterator(usg);
        while (usgIter.hasNext()) {
            strength += this.findStrength(usgIter.next(), owner, attack);
        }
        return strength;
    }

    public int findStrength(UnitStack us, int owner, boolean attack) {
        if (us != null && us.getCount() > 0 && (us.getOwner().getID() == owner || owner == -1)) {
            if (attack) {
                return us.getCount() * us.getUnit().getAttack();
            }
            return us.getCount() * us.getUnit().getDefend();
        }
        return 0;
    }

    public void equalizeUnits(Unit unit) {
        for (int i = 0; i < this.countries.length; ++i) {
            if (this.countries[i].isWater() || !this.countries[i].getTeam().equals(this.world.getTeam(this.ID))) continue;
            UnitStackGroupIterator usgIter = new UnitStackGroupIterator(this.countries[i]);
            while (usgIter.hasNext()) {
                UnitStack us = usgIter.next();
                if (us.getUnit().getType() != unit.getType() || us.getOwner().getID() != this.ID || us.getUnit().getMovement() <= 0 || us.getCount() <= 0) continue;
                this.equalizeUnitsFrom(us, this.countries[i]);
            }
        }
    }

    public void equalizeUnitsFrom(UnitStack us, Country from) {
        Unit unit = us.getUnit();
        Country to = this.findWeakestFriendAround(unit, from);
        while (to != null && us.getCount() > 0 && this.getUnitDefCount(unit, from) > this.getUnitDefCount(unit, to) + 1) {
            this.world.moveUnit(us, from, to, 1);
            to = this.findWeakestFriendAround(unit, from);
        }
    }

    public Country findWeakestFriendAround(Unit unit, Country from) {
        int weakest = this.bigValue;
        Country weakestCountry = null;
        List adjoiningList = from.getAdjoiningList();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            int unitCount;
            Country border = (Country)adjoiningList.get(i);
            if (border.isWater() || !border.getTeam().equals(this.world.getTeam(this.ID)) || (unitCount = this.getUnitDefCount(unit, border)) >= weakest) continue;
            weakest = unitCount;
            weakestCountry = border;
        }
        return weakestCountry;
    }

    public UnitStack getUnitStack(Unit unit, Country from) {
        return this.getUnitStack(unit, from.getUnitStackGroup());
    }

    public UnitStack getDefUnitStack(Unit unit, Country from) {
        return this.getUnitStack(unit, this.world.getDefendersUnitStackGroup(from));
    }

    public UnitStack getUnitStack(Unit unit, UnitStackGroup usg) {
        UnitStackGroupIterator usgIter = new UnitStackGroupIterator(usg);
        while (usgIter.hasNext()) {
            UnitStack us = usgIter.next();
            if (us.getUnit().getType() != unit.getType() || us.getOwner().getID() != this.ID) continue;
            return us;
        }
        return null;
    }

    public int getUnitDefCount(Unit unit, Country from) {
        int count = 0;
        UnitStack us = this.getDefUnitStack(unit, from);
        if (us != null) {
            count = from.hasCastle() && unit.getType() == this.infantry.getType() && from.getTeam().equals(this.world.getTeam(this.ID)) ? (count += us.getCount() - this.factDef) : (count += us.getCount());
        }
        return Math.max(count, 0);
    }

    public String name() {
        return "Nemo";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Nemo rules the oceans.";
    }

    public String youWon() {
        String[] answers = new String[]{"Duh!", "Huh, what just happened here?", "Me good. You bad.", "I wonder what I was afraid of.", "I thought humans were intelligent.", "Arrrrrr! The oceans are mine to rule."};
        return answers[this.rand.nextInt(answers.length)];
    }

    public String message(String message, Object data) {
        return null;
    }
}

