/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import java.util.ArrayList;
import java.util.List;

public class Holdem
extends VoxAgentBase
implements VoxAgent {
    public void declareMoves(Country[] countries) {
        super.declareMoves(countries);
        SS.debug("Holdem " + this.ID + " " + this.world.getPlayer(this.ID).name() + " ordering moves...........");
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        if (bases.size() == 0) {
            this.buyCastle();
        } else {
            this.buyPawns(this.world.getPlayerMoney(this.ID), this.getWeakestBase());
        }
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getUnitStackGroup().getTotalUnitCount() <= 0 || !countries[i].getTeam().equals(this.world.getTeam(this.ID))) continue;
            Country ourCountry = countries[i];
            UnitStackGroup usg = ourCountry.getUnitStackGroup();
            for (int j = usg.size() - 1; j > -1; --j) {
                UnitStack units = usg.get(j);
                if (units.getOwner().getID() != this.ID || units.getMovement() <= 0) continue;
                if (units.getUnitAttack() > 3) {
                    Country moveTo = this.getMostValuableEnemyBorder(ourCountry, units.getMovement());
                    if (moveTo != null) {
                        this.world.moveUnit(units, ourCountry, moveTo, units.getCount());
                        continue;
                    }
                    Country dir1 = this.directionToEnemy(ourCountry);
                    Country dir2 = this.directionToEnemy(dir1);
                    if (dir2.equals(ourCountry)) {
                        dir2 = dir1;
                    }
                    this.world.moveUnit(units, ourCountry, dir2, units.getCount());
                    continue;
                }
                int danger = (int)this.getDanger(ourCountry);
                int countryValue = (int)this.getIncome(ourCountry);
                if (ourCountry.hasCastle()) {
                    countryValue += 10;
                }
                int numberToMove = units.getCount();
                if (countryValue > 3 && (double)danger > 0.6) {
                    numberToMove = units.getCount() - (danger + countryValue + countryValue);
                    numberToMove = Math.max(0, numberToMove);
                }
                List borders = ourCountry.getAdjoiningList();
                ArrayList<Country> friendly = new ArrayList<Country>();
                boolean madeAttack = false;
                for (int b = 0; b < borders.size(); ++b) {
                    Country check = (Country)borders.get(b);
                    if (!check.getTeam().equals(ourCountry.getTeam())) {
                        if (madeAttack || numberToMove <= check.getUnitStackGroup().getTotalUnitCount()) continue;
                        int moveHere = check.getUnitStackGroup().getTotalUnitCount() + 2 + this.rand.nextInt(5);
                        this.world.moveUnit(units, ourCountry, check, moveHere);
                        numberToMove -= moveHere;
                        madeAttack = true;
                        continue;
                    }
                    if (this.distanceToEnemy(check) >= 3) continue;
                    friendly.add(check);
                }
                if (friendly.size() == 0) {
                    this.world.moveUnit(units, ourCountry, this.directionToEnemy(ourCountry), numberToMove);
                }
                for (int m = 0; m < friendly.size(); ++m) {
                    int move = numberToMove / friendly.size();
                    if (move <= 0) continue;
                    this.world.moveUnit(units, ourCountry, (Country)friendly.get(m), move);
                }
            }
        }
    }

    public String name() {
        return "Holdem";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Holdem tries to hold his countries";
    }

    public String youWon() {
        String[] answers = new String[]{"You've got to know when to hold 'em,\nknow when to fold 'em,\nknow when to walk out,\nand know when to run."};
        return answers[this.rand.nextInt(answers.length)];
    }
}

