/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import java.util.List;

public class Grabby
extends VoxAgentBase
implements VoxAgent {
    public void declareMoves(Country[] countries) {
        super.declareMoves(countries);
        SS.debug("Grabby " + this.ID + " " + this.world.getPlayer(this.ID).name() + " ordering moves...........");
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        if (bases.size() == 0) {
            this.buyCastle();
        } else {
            Country base = this.getFrontBaseSafe();
            if (base != null) {
                this.buyUnitsAlternating(this.world.getPlayerMoney(this.ID), base);
            } else {
                this.buyPawns(this.world.getPlayerMoney(this.ID), this.getStrongestBase());
            }
        }
        for (int i = 0; i < countries.length; ++i) {
            if (countries[i].getUnitStackGroup().getTotalUnitCount() <= 0 || !countries[i].getTeam().equals(this.world.getTeam(this.ID))) continue;
            UnitStackGroup usg = countries[i].getUnitStackGroup();
            for (int j = usg.size() - 1; j > -1; --j) {
                UnitStack units = usg.get(j);
                if (units.getOwner().getID() != this.ID || units.getMovement() <= 0) continue;
                if (units.getUnitAttack() > 3) {
                    Country moveTo = this.getMostValuableEnemyBorder(countries[i], units.getMovement());
                    if (moveTo != null) {
                        SS.debug("Grabby Knight attack from " + countries[i] + " to most valuable enemy: " + moveTo, 1);
                        this.world.moveUnit(units, countries[i], moveTo, units.getCount());
                        continue;
                    }
                    Country dir1 = this.directionToEnemy(countries[i]);
                    Country dir2 = this.directionToEnemy(dir1);
                    if (dir2.equals(countries[i])) {
                        dir2 = dir1;
                    }
                    SS.debug("Knight move-towards-enemy from " + countries[i] + " to : " + dir2);
                    this.world.moveUnit(units, countries[i], dir2, units.getCount());
                    continue;
                }
                int danger = (int)this.getDanger(countries[i]);
                int countryValue = (int)this.getIncome(countries[i]);
                if (countries[i].hasCastle()) {
                    countryValue += 5;
                }
                int numberToMove = units.getCount();
                if (countryValue > 3 && (double)danger > 0.6) {
                    numberToMove = units.getCount() - (danger + countryValue);
                    numberToMove = Math.max(0, numberToMove);
                }
                if (this.getRandomEnemyBorder(countries[i]) == null) {
                    this.moveTowardsEnemySplittingUp(units, countries[i]);
                    continue;
                }
                List enemies = this.getEnemyBorders(countries[i]);
                for (int e = 0; e < enemies.size(); ++e) {
                    this.world.moveUnit(units, countries[i], (Country)enemies.get(e), numberToMove / enemies.size());
                }
            }
        }
    }

    public String name() {
        return "Grabby";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Grabby is a demo bot";
    }

    public String youWon() {
        String[] answers = new String[]{"Gimme Gimme Got It All!", "Luck had nothing to do with it", "Trust The Computer. The Computer is your friend.", "The only legitimate use of a computer is to play games. \n          - Eugene Jarvis", "The most likely way for the world to be destroyed, most experts agree, is by accident.\n          - Nathaniel Borenstein", "Computers are useless. They can only give you answers. \n          - Pablo Picasso", "Don't trust a computer you can't throw out a window. \n          - Steve Wozniak", "My tanks were filled with gasoline and wars. I was a lead soldier. I marched against the smoke of the city....And the world closed its doors--anvils and hammers against the sleeping men--doors of the heart--cities everywhere--and litte lead soldiers. \n          - Giannina Braschi", "War is not a pathology that, with proper hygiene and treatment, can be wholly prevented.\n          - Philip Bobbitt", "War is a continuation of politics by other means. \n          - Carl von Clausewitz ", "All free men remember that in the final choice a soldier's pack is not so heavy a burden as a prisoner's chains. \n          - Dwight D. Eisenhower", "If you wish for peace, understand war. \n          - B. H. Liddell Hart", "Four things greater than all things are; \nWomen and Horses and Power and War. \n          - Rudyard Kipling", "War will not end until all of the violent people are killed. \n          - Roger Langbecker", "Men grow tired of sleep, love, singing and dancing sooner than war. \n          - Homer", "An army of sheep led by a lion would defeat an army of lions led by a sheep. ", "Great empires are not maintained by timidity. \n          - Tacitus", "EAT MY ROBOT DUST"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

