/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import com.sillysoft.vox.unit.UnitCastle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Earl
extends VoxAgentBase
implements VoxAgent {
    private int debugVersion = 102;
    private Random rand = new Random();
    private int infantryAttackValue = 1;
    private int knightAttackValue = 5;
    private int infantryDefenceValue = 3;
    private int knightDefenceValue = 2;
    private int infantryCost = 3;
    private int knightCost = 5;
    private Country[] Nodes;
    private String[] PlayerName;
    private String[] Brain;
    private String[] nodeNames;
    private String[] nodeNamesSorted;
    private int Home;
    private int myTeamID;
    private int N_attributes = 6;
    private int[][] playerAttributes;
    private int Round = 0;
    private int N_nodes;
    private int N_players;
    private String whoAmI;
    private int stop;
    private int[][] occupationTable0;
    private int[][] occupationTable1;
    private int[][] edgeCost;
    private int[][] pathCost;
    private int[][] visitNext;
    private int[] visitFrequency;
    private int[][] adjacencyList;
    private int[][][] shortestPath;
    private static final int infinity = 99999;
    private boolean[] myBorder;
    private int[][] nodesNear;
    private int[] nodeBonus3At;
    private int[] nodeBonusAt;

    @Override
    public void declareMoves(Country[] countries) {
        super.declareMoves(countries);
        ++this.Round;
        this.whoAmI = this.world.getPlayer(this.ID).name();
        this.Nodes = countries;
        if (this.Round == 1) {
            this.Round1Init();
            this.makeOccupationTable0();
            this.initOccupationTable1();
        }
        if (this.Round > 1) {
            this.makeOccupationTable0();
            this.calOccupationTable1();
        }
        this.getPlayersAttributes();
        this.myBorder = this.getMyBorder();
        this.reinforceCastles();
        this.spreadInfantry();
        this.spreadKnight();
        this.buyKnightForMyCastles();
    }

    private void buyKnightForMyCastles() {
        int N_castles = this.getN_MyCastles();
        if (N_castles == 0) {
            this.buyCastle();
            return;
        }
        int Money = this.world.getPlayerMoney(this.ID);
        int money = Money / N_castles;
        int N_knight = money / this.knightCost;
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!this.castleIsMine(c)) continue;
            int need = this.calInfantryNeededForDefenceIn1At(c);
            int N_infantry = this.getN_infantryAt(c);
            if (N_infantry < need) continue;
            this.buyKnightIn(c, N_knight);
        }
    }

    private void reinforceCastles() {
        int N_castles = this.getN_MyCastles();
        if (N_castles == 0) {
            this.stop = 0;
        }
        this.reinforceCastle(this.Home);
        for (int c = 0; c < this.N_nodes; ++c) {
            if (c == this.Home || this.castleIsNotMine(c)) continue;
            this.reinforceCastle(c);
        }
    }

    private void reinforceCastle(int C) {
        int attack = this.getAttackValueIn2Against(C);
        if (attack == 0) {
            int N_infantry = this.getN_infantryAt(C);
            this.spreadInfantryFrom(C, N_infantry);
            return;
        }
        int myDefence = this.getInfantryDefenceValueAt(C);
        float excess = myDefence - attack;
        if (excess < 0.0f) {
            int needed = (int)(Math.abs(excess) / (float)this.infantryDefenceValue);
            needed = (int)((double)needed * 0.9);
            this.buyPawnsIn(C, needed);
            return;
        }
        int unneeded = (int)(0.8 * (double)excess / (double)this.infantryDefenceValue);
        this.spreadInfantryFrom(C, unneeded);
    }

    private int[] showCol(int[][] matrix, int j) {
        int M = matrix.length;
        int[] col = new int[M];
        for (int i = 0; i < M; ++i) {
            col[i] = matrix[i][j];
        }
        return col;
    }

    private void Round1Init() {
        this.N_nodes = this.Nodes.length;
        this.makeNodeNamesSorted();
        this.N_players = this.world.getNumberOfPlayers();
        this.playerAttributes = new int[this.N_players][this.N_attributes];
        this.getPlayersHomeCastle();
        this.getPlayersTeamID();
        this.Home = this.playerAttributes[this.ID][0];
        this.myTeamID = this.playerAttributes[this.ID][1];
        this.getBrainAndPlayerName();
        this.buildShortestPathArray();
        this.make_NodesNear();
        this.makeNodeBonusAt();
    }

    private void getPlayersAttributes() {
        for (int PID = 0; PID < this.N_players; ++PID) {
            this.playerAttributes[PID][2] = this.world.getPlayerLandCount(PID);
            this.playerAttributes[PID][3] = this.world.getPlayerArmyCount(PID);
            this.playerAttributes[PID][4] = this.world.getPlayerIncome(PID);
            this.playerAttributes[PID][5] = this.world.getPlayerMoney(PID);
        }
    }

    private void getPlayersHomeCastle() {
        for (int c = 0; c < this.N_nodes; ++c) {
            boolean castle = this.Nodes[c].hasCastle();
            if (!castle) continue;
            int ownerID = this.Nodes[c].getOwner().getID();
            this.playerAttributes[ownerID][0] = c;
        }
    }

    private void getPlayersTeamID() {
        int i;
        Team[] TEAM = new Team[this.N_players];
        for (i = 0; i < this.N_players; ++i) {
            Team team_i;
            TEAM[i] = team_i = this.world.getTeam(i);
        }
        block1: for (i = 0; i < this.N_players; ++i) {
            for (int j = 0; j < this.N_players; ++j) {
                if (!TEAM[i].equals(TEAM[j])) continue;
                this.playerAttributes[i][1] = j;
                continue block1;
            }
        }
    }

    private boolean isAcastle(int C) {
        return this.occupationTable0[C][3] == 1;
    }

    private ArrayList getHostiles1From(int c) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int N_neighbors = this.adjacencyList[c].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[c][i];
            if (!(this.occupiedIn(neighbor) & this.unfriendly(c, neighbor))) continue;
            list.add(new Integer(neighbor));
        }
        return list;
    }

    private boolean unfriendly1(int c1, int c2) {
        return !this.friendly1(c1, c2);
    }

    private boolean unfriendly(int c1, int c2) {
        return !this.friendly(c1, c2);
    }

    private boolean myInfantryIn(int C) {
        return this.occupationTable1[C][1] > 0;
    }

    private boolean myKnightIn(int C) {
        return this.occupationTable1[C][2] > 0;
    }

    private int getNextUnfriendly1NodeFrom(int C) {
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int c = this.nodesNear[C][i];
            if (!this.unfriendly1(c)) continue;
            return c;
        }
        return -1;
    }

    private float getMyADratioAgainst(int C) {
        int attack = this.getMyAttackValueAgainst(C);
        if (attack == 0) {
            return 0.0f;
        }
        int defence = this.getDefenceValueAt(C);
        if (defence == 0) {
            return 99999.0f;
        }
        float ADratio = (float)attack / (float)defence;
        return ADratio;
    }

    private int getMyNearestBorderFrom(int C) {
        int min = 99999;
        int nearest = 0;
        for (int c = 0; c < this.N_nodes; ++c) {
            int d;
            if (!this.myBorder[c] || (d = this.pathCost[C][c]) >= min) continue;
            min = d;
            nearest = c;
        }
        return nearest;
    }

    private int getNearestUnfriendlyBorderFrom(int C) {
        int min = 99999;
        int nearest = -1;
        for (int c = 0; c < this.N_nodes; ++c) {
            int d;
            if (c == C || !this.myBorder[c] || !this.neighborIsUnfriendlyFrom(c) || (d = this.pathCost[C][c]) >= min) continue;
            min = d;
            nearest = c;
        }
        return nearest;
    }

    private int find1nearestBorderNodeFaceEnemy(int C) {
        int[] nearest = new int[2];
        nearest = this.find2nearestBorderNodesFaceEnemy(C);
        return nearest[0];
    }

    private int[] find2nearestBorderNodesFaceEnemy(int C) {
        int[] nearest2 = new int[]{-1, -1};
        nearest2 = new int[2];
        int k = 0;
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int c = this.nodesNear[C][i];
            if (!this.myBorder[c] || !this.neighborIsUnfriendlyFrom(c) || this.resistance(C, c)) continue;
            nearest2[k] = c;
            if (++k != 2) continue;
            return nearest2;
        }
        return nearest2;
    }

    private boolean neighborIsUnfriendlyFrom(int C) {
        int N_neighbors = this.adjacencyList[C].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[C][i];
            if (!this.unfriendly(neighbor)) continue;
            return true;
        }
        return false;
    }

    private int getMyAttackValueAgainst(int a) {
        int total = 0;
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.unfriendly(c)) continue;
            if (this.IdontOwn(c)) {
                if (this.occupationTable1[c][4] == this.ID) continue;
                continue;
            }
            if (this.pathCost[c][a] > 2) continue;
            if (this.pathCost[c][a] == 2) {
                total += this.getKnightAttackValueFrom(c);
                continue;
            }
            total += this.getHostileAttackValueFrom(c);
        }
        return total;
    }

    private ArrayList<String> getMyBorderList() {
        ArrayList<String> border = new ArrayList<String>();
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!this.myBorder[c]) continue;
            String node = c + " " + this.nodeNames[c];
            border.add(node);
        }
        return border;
    }

    private boolean[] getMyBorder() {
        boolean[] border = new boolean[this.N_nodes];
        block0: for (int c = 0; c < this.N_nodes; ++c) {
            if (this.IdontOwn(c)) continue;
            int N = this.adjacencyList[c].length;
            for (int i = 0; i < N; ++i) {
                int neighbor = this.adjacencyList[c][i];
                if (this.friendly(neighbor)) continue;
                border[c] = true;
                continue block0;
            }
        }
        return border;
    }

    private int getN_MyCastles() {
        int N = 0;
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!this.castleIsMine(c)) continue;
            ++N;
        }
        return N;
    }

    private boolean castleIsNotMine(int C) {
        return !this.castleIsMine(C);
    }

    private void moveInfantry(int N, int from, int to) {
        this.move(N, "Infantry", from, to);
    }

    private int calInfantryNeededForDefenceIn1At(int c) {
        int defence;
        int attack = this.getAttackValueIn1Against(c);
        int defenceNeed = attack - (defence = this.getInfantryDefenceValueAt(c));
        if (defenceNeed <= 0) {
            return 0;
        }
        return defenceNeed / this.infantryDefenceValue + 5;
    }

    private int getAttackValueIn1Against(int C) {
        int r = this.getAttackValueAgainst(C, 1);
        return r;
    }

    private int getAttackValueIn2Against(int C) {
        int r = this.getAttackValueAgainst(C, 2);
        return r;
    }

    private int getAttackValueAgainst(int C, int moves) {
        int distance = 0;
        int total = 0;
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int near = this.nodesNear[C][i];
            String botName = this.brainAt(near);
            if (botName.equals("Boring") || this.friendly(C, near)) continue;
            distance = this.pathCost[C][near];
            if (distance <= moves) {
                total += this.getHostileAttackValueFrom(near);
                continue;
            }
            if (distance <= moves * 2) {
                total += this.getHostileKnightAttackValueFrom(near);
                continue;
            }
            return total;
        }
        return -1;
    }

    private int getHostileKnightAttackValueFrom(int c) {
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nKnight * this.knightAttackValue;
        return total;
    }

    private int getHostileAttackValueFrom(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nInfantry * this.infantryAttackValue + nKnight * this.knightAttackValue;
        return total;
    }

    private int getHostileInfantryAttackValueFrom(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        int total = nInfantry * this.infantryAttackValue;
        return total;
    }

    private boolean resistance(int from, int to) {
        int next = this.visitNext[from][to];
        while (next != to) {
            boolean occ;
            boolean unf = this.unfriendly1(from, next);
            if (unf & (occ = this.occupiedIn(next))) {
                return true;
            }
            next = this.visitNext[next][to];
        }
        return false;
    }

    private float getADratioAtMy(int c) {
        int attack = this.getAttackValue1againstMy(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueAtMy(c);
        return (float)attack / defence;
    }

    private int getDefenceValueAtMy(int c) {
        return this.getDefenceValueAt(c);
    }

    private int getAttackValue1againstMy(int c) {
        int total = 0;
        for (int n = 0; n < this.N_nodes; ++n) {
            int between;
            String botName;
            if (this.pathCost[n][c] > 2 || this.friendly(n) || (botName = this.brainAt(n)).equals("Boring")) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getHostileAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2 || !(this.friendly(between = this.visitNext[n][c], n) | this.unoccupiedIn(between))) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private float getADratioAt(int c) {
        int attack = this.getAttackValue1Bagainst(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueAt(c);
        return (float)attack / defence;
    }

    private int getDefenceValueAt(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nInfantry * this.infantryDefenceValue + nKnight * this.knightDefenceValue;
        return total;
    }

    private int getAttackValue1Bagainst(int c) {
        int total = 0;
        for (int n = 0; n < this.N_nodes; ++n) {
            int between;
            String botName = this.brainAt(n);
            if (botName.equals("Boring") || this.friendly(c, n)) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getHostileAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2 || !(this.friendly(between = this.visitNext[n][c], n) | this.unoccupiedIn(between))) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private boolean IdontOwn(int c) {
        return !this.Iown(c);
    }

    private int calKnightNeededAgainst(int c) {
        int defence = this.getDefenceValueAt(c);
        int needed = defence / this.knightAttackValue;
        int extra = (int)((double)needed * 0.1);
        int extra2 = Math.max(extra, 3);
        return needed + extra2;
    }

    private ArrayList getFreebies1From(int c) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int N_neighbors = this.adjacencyList[c].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[c][i];
            if (!(this.unoccupiedIn(neighbor) & this.unfriendly(c, neighbor))) continue;
            list.add(new Integer(neighbor));
        }
        return list;
    }

    private ArrayList getFreebies2From(int f) {
        ArrayList list = new ArrayList();
        list = this.getFreebies1From(f);
        for (int c = 0; c < this.N_nodes; ++c) {
            int between;
            if (this.pathCost[f][c] != 2 || this.occupiedIn(c) || this.friendly(c) || this.unfriendly(f, between = this.visitNext[f][c])) continue;
            list.add(new Integer(c));
        }
        return list;
    }

    private void spreadInfantry() {
        for (int c = 0; c < this.N_nodes; ++c) {
            int N_infantry;
            if (this.unfriendly(c) || this.isAcastle(c)) continue;
            if (this.IdontOwn(c)) {
                if (this.occupationTable1[c][4] != this.ID) continue;
                N_infantry = this.occupationTable1[c][5];
                int nearest = this.find1nearestBorderNodeFaceEnemy(c);
                int next = this.visitNext[c][nearest];
                this.moveInfantry(N_infantry, c, next);
                continue;
            }
            N_infantry = this.occupationTable1[c][1];
            if (N_infantry == 0) continue;
            this.spreadInfantryFrom(c, N_infantry);
        }
    }

    private void spreadInfantryFrom(int C, int N_infantry) {
        int neighbor;
        int[] nearest2 = new int[2];
        ArrayList freebies = new ArrayList();
        freebies = this.getFreebies1From(C);
        int N_freebies = freebies.size();
        if (N_freebies == 0) {
            int needed = this.calInfantryNeededForDefenceIn1At(C);
            int surplus = N_infantry - needed;
            if (surplus < 0) {
                return;
            }
            nearest2 = this.find2nearestBorderNodesFaceEnemy(C);
            int N_infantry0 = (int)Math.ceil((double)N_infantry / 2.0);
            this.sendInfantry(N_infantry0, C, nearest2[0]);
            int N_infantry1 = N_infantry - N_infantry0;
            this.sendInfantry(N_infantry1, C, nearest2[1]);
            return;
        }
        if (N_infantry < N_freebies) {
            int[] sortedFreebieList = new int[N_freebies];
            sortedFreebieList = this.sortNodeList(freebies);
            for (int i = 0; i < N_infantry; ++i) {
                int neighbor2 = sortedFreebieList[i];
                this.move(1, "Infantry", C, neighbor2);
                this.occupationTable1[neighbor2][0] = this.ID;
                this.occupationTable1[neighbor2][1] = 1;
                this.occupationTable1[neighbor2][7] = this.myTeamID;
            }
            this.occupationTable0[C][1] = 0;
            return;
        }
        int portion = N_infantry / N_freebies;
        for (int i = 0; i < N_freebies - 1; ++i) {
            neighbor = (Integer)freebies.get(i);
            this.move(portion, "Infantry", C, neighbor);
            this.occupationTable1[neighbor][0] = this.ID;
            this.occupationTable1[neighbor][1] = portion;
            this.occupationTable1[neighbor][7] = this.myTeamID;
        }
        neighbor = (Integer)freebies.get(N_freebies - 1);
        this.move("Infantry", C, neighbor);
        this.occupationTable1[neighbor][0] = this.ID;
        this.occupationTable1[neighbor][1] = portion;
        this.occupationTable1[neighbor][7] = this.myTeamID;
        this.occupationTable0[C][1] = 0;
    }

    private void sendInfantry(int N_units, int from, int destination) {
        if (destination == -1) {
            return;
        }
        if (N_units == 0) {
            return;
        }
        int next = this.visitNext[from][destination];
        if (next == from) {
            return;
        }
        this.moveInfantry(N_units, from, next);
    }

    private void spreadKnight() {
        for (int c = 0; c < this.N_nodes; ++c) {
            int N_knight;
            if (this.unfriendly(c)) continue;
            if (this.IdontOwn(c)) {
                if (this.occupationTable0[c][4] != this.ID) continue;
                N_knight = this.occupationTable0[c][6];
            } else {
                N_knight = this.occupationTable0[c][2];
            }
            if (N_knight == 0) continue;
            this.speadKnightFrom(c, N_knight);
        }
    }

    private void speadKnightFrom(int C, int N_knight) {
        ArrayList freebies = new ArrayList();
        freebies = this.getFreebies2From(C);
        int N_freebies = freebies.size();
        int i = 0;
        while (N_freebies > 0 & N_knight > 0) {
            int neighbor = (Integer)freebies.get(i);
            ++i;
            --N_freebies;
            this.move(1, "Knight", C, neighbor);
            --N_knight;
            this.occupationTable1[neighbor][0] = this.ID;
            this.occupationTable1[neighbor][2] = 1;
            this.occupationTable1[neighbor][7] = this.myTeamID;
            int[] nArray = this.occupationTable1[C];
            nArray[8] = nArray[8] - 1;
        }
        if (N_knight > 0) {
            this.advanceKnightFrom(C, N_knight);
        }
    }

    private int find1stBeatableHostileFrom(int C, int N_knight) {
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int needed;
            int c = this.nodesNear[C][i];
            if (this.friendly1(c) || this.resistance(C, c) || N_knight < (needed = this.calKnightNeededAgainst(c))) continue;
            return c;
        }
        return -1;
    }

    private int findSuitableHostileFrom(int C, int N_knight) {
        boolean[] beatables = new boolean[this.N_nodes];
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int needed;
            int c = this.nodesNear[C][i];
            if (this.friendly1(c) || this.resistance(C, c) || N_knight < (needed = this.calKnightNeededAgainst(c))) continue;
            beatables[c] = true;
            if (!this.isAcastle(c)) continue;
            return c;
        }
        return -1;
    }

    private void advanceKnightFrom(int C, int N_knight) {
        int next;
        int needed = -1;
        int hostile = -1;
        while (N_knight > 0 && (hostile = this.find1stBeatableHostileFrom(C, N_knight)) != -1) {
            needed = this.calKnightNeededAgainst(hostile);
            next = this.visitNext[C][hostile];
            if (next != hostile) {
                next = this.visitNext[next][hostile];
            }
            this.moveKnight(needed, C, next);
            int[] nArray = this.occupationTable0[C];
            nArray[2] = nArray[2] - needed;
            N_knight -= needed;
            if (next != hostile) continue;
            this.occupationTable1[hostile][0] = this.ID;
            this.occupationTable1[hostile][1] = -1;
            this.occupationTable1[hostile][7] = this.myTeamID;
        }
        if (this.isAcastle(C) & hostile != -1) {
            needed = this.calKnightNeededAgainst(hostile);
            this.buyKnightIn(C, needed);
            return;
        }
        int nearest = this.find1nearestBorderNodeFaceEnemy(C);
        next = this.visitNext[C][nearest];
        if (next != nearest) {
            next = this.visitNext[next][nearest];
        }
        this.moveKnight(N_knight, C, next);
    }

    private void moveKnight(int N, int from, int to) {
        this.move(N, "Knight", from, to);
    }

    private boolean unfriendly(int c) {
        return !this.friendly(c);
    }

    private boolean unfriendly1(int c) {
        return !this.friendly1(c);
    }

    private boolean occupiedIn(int c) {
        return !this.unoccupiedIn(c);
    }

    private int getN_knightAt(int c) {
        return this.occupationTable0[c][2];
    }

    private int getN_infantryAt(int c) {
        return this.occupationTable0[c][1];
    }

    private String brainAt(int c) {
        int PID = this.occupationTable1[c][0];
        return this.Brain[PID];
    }

    private void getBrainAndPlayerName() {
        this.Brain = new String[this.N_players];
        this.PlayerName = new String[this.N_players];
        for (int i = 0; i < this.N_players; ++i) {
            this.PlayerName[i] = this.world.getPlayer(i).getName();
            this.Brain[i] = this.world.getPlayer(i).getAgentType();
        }
    }

    private boolean IhaveKnightAt(int c) {
        if (this.Iown(c) & this.occupationTable1[c][2] > 0) {
            return true;
        }
        return this.occupationTable1[c][4] == this.ID & this.occupationTable1[c][6] > 0;
    }

    private void make_NodesNear() {
        this.nodesNear = new int[this.N_nodes][this.N_nodes - 1];
        for (int c = 0; c < this.N_nodes; ++c) {
            this.nodesNear[c] = this.getNodesNear(c);
        }
    }

    private int[] getNodesNear(int C) {
        int[] nodesNearC = new int[this.N_nodes - 1];
        int i = 0;
        int d = 0;
        while (i < this.N_nodes - 1) {
            ++d;
            for (int c = 0; c < this.N_nodes; ++c) {
                if (this.pathCost[C][c] != d) continue;
                nodesNearC[i] = c;
                ++i;
            }
        }
        return nodesNearC;
    }

    private int[] sortNodeList(ArrayList<Integer> nodeList) {
        int i;
        int N = nodeList.size();
        int[] sortedList = new int[N];
        int[] threatBefore = new int[N];
        int[] threatAfter = new int[N];
        for (i = 0; i < N; ++i) {
            int c = nodeList.get(i);
            threatBefore[i] = this.getAttackValue1Bagainst(c);
            threatAfter[i] = threatBefore[i];
        }
        Arrays.sort(threatAfter);
        boolean[] taken = new boolean[N];
        int k = 0;
        block1: for (i = 0; i < N; ++i) {
            int threat = threatAfter[i];
            for (int j = 0; j < N; ++j) {
                if (!(!taken[j] & threat == threatBefore[j])) continue;
                sortedList[k] = nodeList.get(j);
                taken[j] = true;
                ++k;
                continue block1;
            }
        }
        return sortedList;
    }

    private boolean friendly1(int c1, int c2) {
        int team2;
        int team1 = this.getTeamIDAt(c1);
        return team1 == (team2 = this.getTeamIDAt(c2));
    }

    private int getTeamIDAt(int c) {
        return this.occupationTable0[c][7];
    }

    private void makeOccupationTable0() {
        int N_cols = 10;
        this.occupationTable0 = new int[this.N_nodes][N_cols];
        for (int c = 0; c < this.N_nodes; ++c) {
            int nodeOwnerID;
            Country ct = this.Nodes[c];
            this.occupationTable0[c][0] = nodeOwnerID = ct.getOwner().getID();
            UnitStackGroup IKCs = ct.getUnitStackGroup();
            int N_IKCs = IKCs.size();
            for (int s = 0; s < N_IKCs; ++s) {
                UnitStack IKorC = IKCs.get(s);
                Player player = IKorC.getOwner();
                int unitOwnerID = player.getID();
                int N_units = IKorC.getCount();
                String IKxorC = IKorC.getUnit().toString();
                if (nodeOwnerID == unitOwnerID) {
                    if (IKxorC.equals("Infantry")) {
                        this.occupationTable0[c][1] = N_units;
                    }
                    if (IKxorC.equals("Pawn")) {
                        this.occupationTable0[c][1] = N_units;
                    }
                    if (IKxorC.equals("Knight")) {
                        this.occupationTable0[c][2] = N_units;
                        if (unitOwnerID == this.ID) {
                            this.occupationTable0[c][8] = N_units;
                        }
                    }
                    if (!IKxorC.equals("Castle")) continue;
                    this.occupationTable0[c][3] = 1;
                    continue;
                }
                this.occupationTable0[c][4] = unitOwnerID;
                if (IKxorC.equals("Infantry")) {
                    this.occupationTable0[c][5] = N_units;
                }
                if (IKxorC.equals("Pawn")) {
                    this.occupationTable0[c][5] = N_units;
                }
                if (!IKxorC.equals("Knight")) continue;
                this.occupationTable0[c][6] = N_units;
            }
            this.occupationTable0[c][7] = this.playerAttributes[nodeOwnerID][1];
        }
    }

    private void initOccupationTable1() {
        int N_cols = this.occupationTable0[0].length;
        this.occupationTable1 = new int[this.N_nodes][N_cols];
        for (int c = 0; c < this.N_nodes; ++c) {
            for (int i = 0; i < N_cols; ++i) {
                this.occupationTable1[c][i] = this.occupationTable0[c][i];
            }
        }
    }

    private void calOccupationTable1() {
        int N_cols = 9;
        for (int c = 0; c < this.N_nodes; ++c) {
            for (int i = 0; i < N_cols; ++i) {
                this.occupationTable1[c][i] = this.occupationTable0[c][i];
            }
            int[] nArray = this.occupationTable1[c];
            nArray[9] = nArray[9] + (this.occupationTable1[c][8] - this.occupationTable0[c][8]);
        }
    }

    private boolean unoccupiedIn(int c) {
        int IKCs = this.occupationTable1[c][1] + this.occupationTable1[c][2] + this.occupationTable1[c][3] + this.occupationTable1[c][5] + this.occupationTable1[c][6];
        return IKCs == 0;
    }

    public void gatherTo(int C, int ... exceptions) {
        for (int from = 0; from < this.N_nodes; ++from) {
            int next;
            if (this.in(from, exceptions)) continue;
            UnitStack unitForce = this.getKnight(from);
            if (unitForce != null) {
                next = this.visitNext[from][C];
                next = this.visitNext[next][C];
                this.moveKnight(from, next);
            }
            if ((unitForce = this.getInfantry(from)) == null) continue;
            next = this.visitNext[from][C];
            this.moveInfantry(from, next);
        }
    }

    public void gatherKnightTo(int c, int ... exceptions) {
        for (int from = 0; from < this.N_nodes; ++from) {
            UnitStack unitForce;
            if (this.in(from, exceptions) || (unitForce = this.getKnight(from)) == null) continue;
            int next = this.visitNext[from][c];
            next = this.visitNext[next][c];
            this.moveKnight(from, next);
        }
    }

    private boolean in(int k, int[] S) {
        for (int s : S) {
            if (k != s) continue;
            return true;
        }
        return false;
    }

    private boolean Iown(int c) {
        return this.occupationTable0[c][0] == this.ID;
    }

    private int getInfantryDefenceValueAt(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        return nInfantry * this.infantryDefenceValue;
    }

    private int getKnightDefenceValueAt(int c) {
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nKnight * this.knightDefenceValue;
        return total;
    }

    private void makeNodeNamesSorted() {
        this.nodeNames = new String[this.N_nodes];
        this.nodeNamesSorted = new String[this.N_nodes];
        for (int c = 0; c < this.N_nodes; ++c) {
            Country ct = this.Nodes[c];
            int t1 = ct.getID();
            this.nodeNames[c] = ct.getName();
            this.nodeNamesSorted[c] = this.nodeNames[c] + ' ' + c;
        }
        Arrays.sort(this.nodeNamesSorted);
    }

    private int getMyInfantryAttackValueFrom(int c) {
        int cOwnerID = this.occupationTable0[c][0];
        if (this.friendly(c)) {
            return 0;
        }
        if (cOwnerID == this.ID) {
            int nInfantry = this.occupationTable0[c][1];
            int total = nInfantry * this.infantryAttackValue;
            return total;
        }
        int nInfantry = this.occupationTable0[c][5];
        int total = nInfantry * this.infantryAttackValue;
        return total;
    }

    private int getMyKnightAttackValueAt(int C) {
        int N_knight;
        int total = 0;
        if (this.occupationTable1[C][0] == this.ID) {
            N_knight = this.occupationTable0[C][2];
            total = N_knight * this.knightAttackValue;
        }
        if (this.occupationTable1[C][4] == this.ID) {
            N_knight = this.occupationTable0[C][6];
            total = N_knight * this.knightAttackValue;
        }
        return total;
    }

    private int getMyAttackValueFrom(int c) {
        int total = this.getMyInfantryAttackValueFrom(c);
        return total += this.getMyKnightAttackValueAt(c);
    }

    private int getKnightAttackValueFrom(int c) {
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nKnight * this.knightAttackValue;
        return total;
    }

    private void buyCastleFor(int c) {
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.ID));
        UnitStack castle2 = new UnitStack(castle, 1);
        this.world.placeUnits(castle2, this.Nodes[c]);
    }

    private void move(String KnightOrInfantry, int from, int to) {
        this.move(99999, KnightOrInfantry, from, to);
    }

    private void moveInto(int c) {
        this.moveInfantriesInto(c);
        this.moveKnightInto(c);
    }

    private void move(int from, int to) {
        this.move("Infantry", from, to);
        this.move("Knight", from, to);
    }

    private void moveInfantry(int from, int to) {
        this.move("Infantry", from, to);
    }

    private void moveInfantriesInto(int c) {
        int n = this.adjacencyList[c].length;
        for (int i = 0; i < n; ++i) {
            int neighbor = this.adjacencyList[c][i];
            this.move("Infantry", neighbor, c);
        }
    }

    private void moveKnight(int from, int to) {
        this.move("Knight", from, to);
    }

    private void moveKnightInto(int C) {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.IdontOwn(c) || this.pathCost[c][C] >= 3) continue;
            this.move("Knight", c, C);
        }
    }

    private UnitStack getKnightOrInfantry(int c, int movement) {
        Country ct = this.Nodes[c];
        UnitStackGroup CKIs = ct.getUnitStackGroup();
        int N_usg = CKIs.size();
        for (int s = 0; s < N_usg; ++s) {
            int m;
            UnitStack CKorI = CKIs.get(s);
            int ID2 = CKorI.getOwner().getID();
            if (ID2 != this.ID || (m = CKorI.getUnit().getMovement()) != movement) continue;
            return CKorI;
        }
        return null;
    }

    private UnitStack getKnight(int c) {
        return this.getKnightOrInfantry(c, 2);
    }

    private UnitStack getInfantry(int c) {
        return this.getKnightOrInfantry(c, 1);
    }

    private boolean enemyForceAt(int c) {
        if (this.friendly(c)) {
            return false;
        }
        int total = this.occupationTable0[c][1] + this.occupationTable0[c][2] + this.occupationTable0[c][3] + this.occupationTable0[c][5] + this.occupationTable0[c][6];
        return total != 0;
    }

    private boolean castleIsMine(int c) {
        return this.occupationTable0[c][3] == 1 & this.occupationTable0[c][0] == this.ID;
    }

    private boolean friendly1(int c) {
        return this.myTeamOwns1(c);
    }

    private boolean friendly(int c) {
        return this.myTeamOwns(c);
    }

    private boolean myTeamOwns1(int c) {
        return this.occupationTable1[c][7] == this.playerAttributes[this.ID][1];
    }

    private boolean myTeamOwns(int c) {
        return this.occupationTable0[c][7] == this.playerAttributes[this.ID][1];
    }

    private boolean friendly(int c1, int c2) {
        return this.occupationTable0[c1][7] == this.occupationTable0[c2][7];
    }

    private void buildShortestPathArray() {
        int k;
        int n;
        int j;
        int i;
        this.edgeCost = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                this.edgeCost[i][j] = 99999;
            }
            this.edgeCost[i][i] = 0;
        }
        this.adjacencyList = new int[this.N_nodes][];
        for (int c = 0; c < this.N_nodes; ++c) {
            Country ct = this.Nodes[c];
            List adjoiningList = ct.getAdjoiningList();
            n = adjoiningList.size();
            this.adjacencyList[c] = new int[n];
            for (j = 0; j < n; ++j) {
                Country ct2 = (Country)adjoiningList.get(j);
                k = ct2.getID();
                this.edgeCost[c][k] = 1;
                this.adjacencyList[c][j] = k;
            }
        }
        this.pathCost = new int[this.N_nodes][this.N_nodes];
        int[][] visitThru = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                this.pathCost[i][j] = this.edgeCost[i][j];
                visitThru[i][j] = -1;
            }
        }
        for (k = 0; k < this.N_nodes; ++k) {
            for (i = 0; i < this.N_nodes; ++i) {
                for (j = 0; j < this.N_nodes; ++j) {
                    if (this.pathCost[i][k] + this.pathCost[k][j] >= this.pathCost[i][j]) continue;
                    this.pathCost[i][j] = this.pathCost[i][k] + this.pathCost[k][j];
                    visitThru[i][j] = k;
                }
            }
        }
        this.shortestPath = new int[this.N_nodes][this.N_nodes][];
        this.visitNext = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                int next;
                if (i == j) {
                    this.visitNext[i][j] = i;
                    continue;
                }
                if (this.edgeCost[i][j] == 1) {
                    this.visitNext[i][j] = j;
                    continue;
                }
                String path = this.shortestPath(i, j, visitThru);
                path = path.replaceAll("^\\s+", "");
                int i2 = path.indexOf(" ");
                String nextS = path.substring(0, i2);
                this.visitNext[i][j] = next = Integer.valueOf(nextS).intValue();
                path = path.substring(i2);
                n = this.pathCost[i][j] - 1;
                this.shortestPath[i][j] = new int[n];
                this.shortestPath[i][j][0] = next;
                for (k = 1; k < n; ++k) {
                    path = path.replaceAll("^\\s+", "");
                    i2 = path.indexOf(" ");
                    nextS = path.substring(0, i2);
                    this.shortestPath[i][j][k] = next = Integer.valueOf(nextS).intValue();
                    path = path.substring(i2);
                }
            }
        }
        this.visitFrequency = new int[this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < i; ++j) {
                int n2 = k = this.visitNext[i][j];
                this.visitFrequency[n2] = this.visitFrequency[n2] + 1;
            }
        }
    }

    private String shortestPath(int i, int j, int[][] visitThru) {
        int k = visitThru[i][j];
        if (k == -1) {
            return " ";
        }
        return this.shortestPath(i, k, visitThru) + " " + k + " " + this.shortestPath(k, j, visitThru);
    }

    @Override
    public String name() {
        return "Earl";
    }

    @Override
    public float version() {
        return 1.0f;
    }

    @Override
    public String description() {
        return "Earl";
    }

    @Override
    public String youWon() {
        String[] messages = new String[]{"A court is an assembly of noble and distinguished beggars.\n          - Charles Maurice de Talleyrand ", "Duke, Duke, Duke, Duke of Earl", "A noble heart cannot suspect in others the pettiness and malice that it has never felt.\n          - Jean Racine ", "A noble heart will always capitulate to reason.\nFriedrich Schiller ", "A noble person attracts noble people, \nand knows how to hold on to them.\n          - Johann Wolfgang von Goethe ", "A sovereign's great example forms a people; \nthe public breast is noble or vile as he inspires it.\n          - David Mallet ", "All noble enthusiasms pass through a feverish stage, and grow wiser and more serene.\n          - William Ellery Channing ", "All noble things are as difficult as they are rare.\n          - Baruch Spinoza ", "All that is noble in the world's past history, \nand especially the minds of the great and the good, are never lost.\n          - James Martineau ", "Ambition is the last infirmity of noble minds.\n          - James M. Barrie ", "Be noble minded! Our own heart, and not other men's opinions of us, forms our true honor.\n          - Friedrich Schiller ", "Besides the noble art of getting things done, \nthere is the noble art of leaving things undone. \nThe wisdom of life consists in the elimination of non-essentials.\n          - Lin Yutang ", "Better not be at all than not be noble.\n          - Alfred Lord Tennyson ", "Do noble things, not dream them all day long.\n          - Charles Kingsley ", "Egoism is the very essence of a noble soul.\n          - Friedrich Nietzsche ", "Every noble work is at first impossible.\n          - Thomas Carlyle ", "Gratitude is the sign of noble souls.\n          - Aesop ", "He never is alone that is accompanied with noble thoughts.\n          - John Fletcher ", "Idealism is the noble toga that political gentlemen drape over their will to power.\n          - Aldous Huxley ", "In the name of noble purposes men have committed unspeakable acts of cruelty against one another.\n          - J. William Fulbright ", "Innocence in genius, \nand candor in power, \nare both noble qualities.\n          - Madame de Stael ", "Instead of noblemen, \nlet us have noble villages of men.\n          - Henry David Thoreau ", "It is finer to bring one noble human being into the world and rear it well... than to kill ten thousand.\n          - Olive Schreiner ", "It is part of a good man to do great and noble deeds, though he risk everything.\n          - Plutarch ", "No speech can stain what is noble by nature.\n          - Sophocles ", "Noble bold is an accident of fortune; \nnoble actions characterize the great.\n          - Carlo Goldoni ", "Noble deeds and hot baths are the best cures for depression.\n          - Dodie Smith ", "Noble life demands a noble architecture for noble uses of noble men. Lack of culture means what it has always meant: ignoble civilization and therefore imminent downfall.\n          - Frank Lloyd Wright ", "Over all our happy country, \nover all our Nation spread, \nIs a band of noble heroes, \nis our Army of the Dead.\n          - Will Carleton ", "Tears are the noble language of the eye.\n          - Robert Herrick ", "There is a noble and a base side \nto every history.\n          - Thomas Wentworth ", "There is nothing noble in being superior to your fellow men. True nobility lies in being superior to your former self.\n          - Elijah Wood ", "Time, which wears down and diminishes all things, augments and increases good deeds, because a good turn liberally offered to a reasonable man grows continually through noble thought and memory.\n          - Francois Rabelais ", "To appreciate the noble is a gain which can never be torn from us.\n          - Johann Wolfgang von Goethe ", "To be good is noble; but to show others how to be good is nobler and no trouble.\n          - Mark Twain ", "Treachery is noble when aimed at tyranny.\n          - Pierre Corneille ", "We should be too big to take offense \nand too noble to give it.\n          - Abraham Lincoln "};
        return messages[this.rand.nextInt(messages.length)];
    }

    private void move(int N_units, String KnightOrInfantry, int from, int to) {
        UnitStack unitForce;
        if (from == to) {
            return;
        }
        if (to == -1) {
            return;
        }
        Country ct = this.Nodes[from];
        if (KnightOrInfantry.equals("Knight")) {
            int via;
            unitForce = this.getKnight(from);
            if (from == -1 | to == -1) {
                this.stop = 0;
            }
            if (this.pathCost[from][to] == 2 && this.enemyForceAt(via = this.visitNext[from][to])) {
                to = via;
            }
        } else {
            unitForce = this.getInfantry(from);
        }
        if (unitForce == null) {
            return;
        }
        int ID2 = unitForce.getOwner().getID();
        if (ID2 != this.ID) {
            return;
        }
        if (N_units == 99999) {
            N_units = unitForce.getCount();
        }
        this.world.moveUnit(unitForce, ct, this.Nodes[to], N_units);
        if (KnightOrInfantry.equals("Knight")) {
            int[] nArray = this.occupationTable1[from];
            nArray[8] = nArray[8] - N_units;
            int[] nArray2 = this.occupationTable1[to];
            nArray2[8] = nArray2[8] + N_units;
        }
    }

    private void buyKnightIn(int C, int N_units) {
        if (N_units == 0) {
            return;
        }
        int m = N_units * this.knightCost;
        this.buyKnights(m, this.Nodes[C]);
        int[] nArray = this.occupationTable1[C];
        nArray[8] = nArray[8] + N_units;
    }

    private void buyPawnsIn(int c, int units) {
        if (units == 0) {
            return;
        }
        int m = units * this.infantryCost;
        int Money = this.world.getPlayerMoney(this.ID);
        if (Money >= m) {
            this.buyPawns(m, this.Nodes[c]);
        } else {
            this.buyPawns(Money, this.Nodes[c]);
        }
    }

    private void makeNodeBonusAt() {
        this.nodeBonus3At = new int[this.N_nodes];
        this.nodeBonusAt = new int[this.N_nodes];
        for (int c = 0; c < this.N_nodes; ++c) {
            int bonus;
            int bonus3;
            this.nodeBonus3At[c] = bonus3 = (int)this.Nodes[c].getContinentBonusPartial(this.world);
            this.nodeBonusAt[c] = bonus = this.Nodes[c].getBonus();
        }
    }
}

