/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroupIterator;
import com.sillysoft.vox.agent.Nemo;
import java.util.List;
import java.util.Vector;

public class Capitalist
extends Nemo {
    protected Vector ignore = new Vector();
    protected Vector[] comboAttacks;
    protected Vector[] backupMoves;

    public void groundAttack() {
        int i;
        super.groundAttack();
        for (i = 0; i < this.countries.length; ++i) {
            UnitStack us;
            int j;
            if (this.comboAttacks[this.countries[i].getID()] == null) continue;
            int defenceStrength = this.getEnemyDefenceAround(this.countries[i]);
            int attackStrength = 0;
            for (j = 0; j < this.comboAttacks[this.countries[i].getID()].size(); ++j) {
                us = (UnitStack)this.comboAttacks[this.countries[i].getID()].get(j);
                attackStrength += this.findAttackStrengthUS(us);
            }
            if (attackStrength <= defenceStrength + defenceStrength / 2) continue;
            for (j = 0; j < this.comboAttacks[this.countries[i].getID()].size(); ++j) {
                us = (UnitStack)this.comboAttacks[this.countries[i].getID()].get(j);
                this.attackWithUS(us, this.countries[i]);
            }
        }
        for (i = 0; i < this.countries.length; ++i) {
            if (this.backupMoves[this.countries[i].getID()] == null) continue;
            for (int j = 0; j < this.backupMoves[this.countries[i].getID()].size(); ++j) {
                UnitStack us = (UnitStack)this.backupMoves[this.countries[i].getID()].get(j);
                if (us.getCount() <= 0) continue;
                this.attackWithUS(us, this.countries[i]);
            }
        }
    }

    public void groundAttackFrom(Country from, int attackStrength) {
        boolean getTheCastle = false;
        UnitStackGroupIterator usgIter = new UnitStackGroupIterator(from);
        while (usgIter.hasNext()) {
            Country bestMove;
            UnitStack us = usgIter.next();
            if (us.getUnit().getMovement() <= 0 || us.getOwner().getID() != this.ID || us.isAir() || (bestMove = this.bestMoveTowardsEnemyFact(us)) == null) continue;
            getTheCastle = true;
            if (bestMove.getTeam().equals(this.world.getTeam(this.ID))) {
                this.attackWithUS(us, bestMove);
                continue;
            }
            if (this.comboAttacks[bestMove.getID()] == null) {
                this.comboAttacks[bestMove.getID()] = new Vector();
            }
            this.comboAttacks[bestMove.getID()].add(us);
        }
        if (getTheCastle) {
            this.ignore.add(from);
        } else {
            super.groundAttackFrom(from, attackStrength);
        }
    }

    public void equalizeUnitsFrom(UnitStack us, Country from) {
        if (!this.ignore.contains(from)) {
            super.equalizeUnitsFrom(us, from);
        }
    }

    public void recon() {
        this.ignore.clear();
        this.comboAttacks = new Vector[this.countries.length];
        this.backupMoves = new Vector[this.countries.length];
        super.recon();
    }

    public Country getAdjEnemyFact(Country from) {
        List adjoiningList = from.getAdjoiningList();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (border.isWater() || border.getTeam().equals(this.world.getTeam(this.ID)) || !border.hasCastle()) continue;
            return border;
        }
        return null;
    }

    public boolean isAdjEnemyFact(Country from) {
        return !from.isWater() && this.getAdjEnemyFact(from) != null;
    }

    public boolean isNearEnemyFact(Country from) {
        if (from.isWater()) {
            return false;
        }
        if (this.isAdjEnemyFact(from)) {
            return true;
        }
        List adjoiningList = from.getAdjoiningList();
        for (int i = 0; i < adjoiningList.size(); ++i) {
            Country border = (Country)adjoiningList.get(i);
            if (!this.isAdjEnemyFact(border)) continue;
            return true;
        }
        return false;
    }

    public Country bestMoveTowardsEnemyFact(UnitStack us) {
        Country from = us.getOriginalCountry(this.world);
        if (us.getUnit().getMovement() == 1) {
            return this.bestMoveTowardsEnemyFact(us, from, true);
        }
        return this.bestMoveTowardsEnemyFact(us, from, false);
    }

    public Country bestMoveTowardsEnemyFact(UnitStack us, Country from, boolean lastMove) {
        List adjoiningList;
        Country best = this.getAdjEnemyFact(from);
        if (best != null) {
            return best;
        }
        if (this.isNearEnemyFact(from)) {
            adjoiningList = from.getAdjoiningList();
            for (int i = 0; i < adjoiningList.size(); ++i) {
                Country border = (Country)adjoiningList.get(i);
                if (!this.isAdjEnemyFact(border) || !this.isBetterChoice(best, border)) continue;
                best = border;
            }
        } else {
            adjoiningList = from.getAdjoiningList();
            for (int i = 0; i < adjoiningList.size(); ++i) {
                Country border = (Country)adjoiningList.get(i);
                if (!this.isNearEnemyFact(border) || !this.isBetterChoice(best, border)) continue;
                best = border;
            }
        }
        if (lastMove || best == null || best.getTeam() != this.world.getTeam(this.ID)) {
            return best;
        }
        Country secondMove = this.bestMoveTowardsEnemyFact(us, best, true);
        if (secondMove == null) {
            return best;
        }
        if (this.backupMoves[best.getID()] == null) {
            this.backupMoves[best.getID()] = new Vector();
        }
        this.backupMoves[best.getID()].add(us);
        return secondMove;
    }

    public boolean isBetterChoice(Country best, Country candidate) {
        if (best == null) {
            return true;
        }
        if (!best.getTeam().equals(this.world.getTeam(this.ID)) && candidate.getTeam().equals(this.world.getTeam(this.ID))) {
            return true;
        }
        if (best.getTeam().equals(this.world.getTeam(this.ID)) && !candidate.getTeam().equals(this.world.getTeam(this.ID))) {
            return false;
        }
        if (!best.getTeam().equals(this.world.getTeam(this.ID)) && !candidate.getTeam().equals(this.world.getTeam(this.ID))) {
            return this.getEnemyDefenceAround(candidate) < this.getEnemyDefenceAround(best) || this.getEnemyDefenceAround(candidate) == this.getEnemyDefenceAround(best) && this.rand.nextInt(2) == 0;
        }
        if (best.getTeam().equals(this.world.getTeam(this.ID)) && candidate.getTeam().equals(this.world.getTeam(this.ID))) {
            return this.defence[candidate.getID()] > this.defence[best.getID()] || this.defence[candidate.getID()] == this.defence[best.getID()] && this.rand.nextInt(2) == 0;
        }
        return false;
    }

    public String name() {
        return "Capitalist";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Capitalist will try to take over your capitals.";
    }

    public String youWon() {
        String[] answers = new String[]{"That was fun. Let's do it again.", "I got you this time.", "Next!", "Oh come on. You can do better than that.", "Capitalism rules."};
        return answers[this.rand.nextInt(answers.length)];
    }
}

