/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import java.util.List;
import java.util.Random;

public class Bubbles
extends VoxAgentBase
implements VoxAgent {
    public Bubbles() {
        this.rand = new Random();
    }

    public void buyUnits(int money) {
        List bases = this.world.getCastleCountriesOwnedBy(this.ID);
        if (bases.size() == 0) {
            this.buyCastle();
            return;
        }
        Country baseCountry = this.getWeakestBase();
        this.buyUnitsAlternating(money, baseCountry);
    }

    public void declareMoves(Country[] countries) {
        super.declareMoves(countries);
        this.buyUnits(this.world.getPlayerMoney(this.ID));
        SS.debug("Bubbles is ordering moves...........");
        for (int i = 0; i < countries.length; ++i) {
            try {
                if (countries[i].getUnitStackGroup().getTotalUnitCount() <= 0 || !countries[i].getTeam().equals(this.world.getTeam(this.ID))) continue;
                UnitStackGroup usg = countries[i].getUnitStackGroup();
                for (int unit = 0; unit < usg.size(); ++unit) {
                    UnitStack ug = usg.get(unit);
                    if (ug.getOwner().getID() != this.ID || ug.getUnit().getMovement() <= 0) continue;
                    List matchingBorders = countries[i].getAdjoiningList();
                    int toMove = ug.getCount();
                    int b = 0;
                    while (toMove > 0) {
                        Country moveTo = (Country)matchingBorders.get(b % matchingBorders.size());
                        this.world.moveUnit(ug, countries[i], moveTo, 1);
                        --toMove;
                        ++b;
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                SS.debug("\n\n");
            }
        }
    }

    public String name() {
        return "Bubbles";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "Bubbles doesn't stick together.";
    }

    public String youWon() {
        String[] answers = new String[]{"Bubbly Success!"};
        return answers[this.rand.nextInt(answers.length)];
    }
}

