/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import com.sillysoft.vox.unit.UnitCastle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AI3
extends VoxAgentBase
implements VoxAgent {
    private Random rand = new Random();
    private int infantryAttackValue = 1;
    private int knightAttackValue = 5;
    private int infantryDefenceValue = 3;
    private int knightDefenceValue = 2;
    private int infantryCost = 3;
    private int knightCost = 5;
    private Country[] Nodes;
    private String[] brain;
    private String[] nodeNames;
    private String[] nodeNamesSorted;
    private int Home0;
    private int Home1;
    private int Home2;
    private int myTeamID;
    private int[] nodeBonusAt;
    private int[][] playerAttributes;
    private int friendsID;
    private int Round = 0;
    private int N_nodes;
    private int N_players;
    private String whoAmI;
    private int stop;
    private int[][] occupationTable0;
    private int[][] occupationTable1;
    private int[][] edgeCost;
    private int[][] pathCost;
    private int[][] visitNext;
    private int[] visitFrequency;
    private int[][] adjacencyList;
    private int[][][] shortestPath;
    private int infinity = 99999;
    private int money;
    private boolean[] myBorder;
    private int[][] nodesNear;

    @Override
    public void declareMoves(Country[] countries) {
        this.Nodes = countries;
        this.money = this.world.getPlayerMoney(this.ID);
        ++this.Round;
        this.whoAmI = this.world.getPlayer(this.ID).name();
        if (this.Round == 1) {
            this.Round1Init();
            this.myBorder = this.getMyBorder();
            this.spreadInfantry();
            this.buyKnightIn(this.Home0);
            return;
        }
        this.makeOccupationTables();
        this.myBorder = this.getMyBorder();
        if (this.Round == 2) {
            this.round2attack();
            this.spreadInfantry();
            this.buyKnightIn(this.Home0);
            return;
        }
        if (this.Round == 3) {
            this.reinforceHomes();
            this.spreadInfantryDefensively();
            this.advanceKnight();
            this.buyKnightIn(this.Home0);
            return;
        }
        if (this.Round > 3) {
            this.reinforceHomes();
            this.advanceKnight();
            this.spreadInfantryDefensively();
            this.buyKnightIn(this.Home0, this.Round);
            return;
        }
    }

    private boolean isAcastle(int C) {
        return this.occupationTable0[C][3] == 1;
    }

    private void spreadInfantryDefensivelyFrom(int C) {
        int neighbor;
        if (this.isAcastle(C)) {
            return;
        }
        if (this.IdontOwn(C)) {
            if (this.occupationTable1[C][4] != this.ID) {
                return;
            }
            int N_infantry = this.occupationTable1[C][5];
            this.stop = 0;
            return;
        }
        int N_infantry = this.occupationTable1[C][1];
        if (N_infantry == 0) {
            return;
        }
        int needed = this.calInfantryNeededIn1For(C);
        int diff = N_infantry - needed;
        if (diff < 0) {
            return;
        }
        N_infantry = (int)((double)N_infantry - (double)needed * 1.4);
        ArrayList freebieNeighbors = new ArrayList();
        freebieNeighbors = this.getFreebies1From(C);
        int N_neighbors = freebieNeighbors.size();
        if (N_neighbors == 0) {
            ArrayList hostilesNeighbors = new ArrayList();
            hostilesNeighbors = this.getHostiles1From(C);
            N_neighbors = hostilesNeighbors.size();
            if (N_neighbors == 0) {
                int nearest = this.getNextUnfriendlyNodeFrom(C);
                int next = this.visitNext[C][nearest];
                this.moveInfantry(N_infantry, C, next);
                return;
            }
            int hostile = (Integer)hostilesNeighbors.get(0);
            float ADratio = this.getMyADratioAgainst(hostile);
            if ((double)ADratio > 1.3) {
                this.moveInfantry(C, hostile);
                this.occupationTable0[C][1] = 0;
                this.occupationTable1[hostile][0] = this.ID;
                this.occupationTable1[hostile][1] = -1;
                this.occupationTable1[hostile][7] = this.myTeamID;
            }
            return;
        }
        if (N_infantry < N_neighbors) {
            int[] sortedFreebieList = new int[N_neighbors];
            sortedFreebieList = this.sortNodeList(freebieNeighbors);
            for (int i = 0; i < N_infantry; ++i) {
                int neighbor2 = sortedFreebieList[i];
                this.move(1, "Infantry", C, neighbor2);
                this.occupationTable1[neighbor2][0] = this.ID;
                this.occupationTable1[neighbor2][1] = 1;
                this.occupationTable1[neighbor2][7] = this.myTeamID;
            }
            this.occupationTable0[C][1] = 0;
            return;
        }
        int portion = N_infantry / N_neighbors;
        for (int i = 0; i < N_neighbors - 1; ++i) {
            neighbor = (Integer)freebieNeighbors.get(i);
            this.move(portion, "Infantry", C, neighbor);
            this.occupationTable1[neighbor][0] = this.ID;
            this.occupationTable1[neighbor][1] = portion;
            this.occupationTable1[neighbor][7] = this.myTeamID;
        }
        neighbor = (Integer)freebieNeighbors.get(N_neighbors - 1);
        this.move("Infantry", C, neighbor);
        this.occupationTable1[neighbor][0] = this.ID;
        this.occupationTable1[neighbor][1] = portion;
        this.occupationTable1[neighbor][7] = this.myTeamID;
        this.occupationTable0[C][1] = 0;
    }

    private void buyKnightIn(int c, int units) {
        int m = units * this.knightCost;
        if (this.money >= m) {
            this.buyKnight(m, c);
        } else {
            this.buyKnightIn(c);
        }
    }

    private void buyKnight(int mon, int C) {
        this.buyKnights(mon, this.Nodes[C]);
    }

    private void midgame() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.IdontOwn(c) || this.unoccupiedIn(c)) continue;
            if (this.myKnightIn(c)) {
                // empty if block
            }
            if (!this.myInfantryIn(c)) continue;
            this.spreadInfantryFrom(c);
        }
    }

    private ArrayList getFreebies1From(int c) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int N_neighbors = this.adjacencyList[c].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[c][i];
            if (!(this.unoccupiedIn(neighbor) & this.unfriendly(c, neighbor))) continue;
            list.add(new Integer(neighbor));
        }
        return list;
    }

    private ArrayList getHostiles1From(int c) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int N_neighbors = this.adjacencyList[c].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[c][i];
            if (!(this.occupiedIn(neighbor) & this.unfriendly(c, neighbor))) continue;
            list.add(new Integer(neighbor));
        }
        return list;
    }

    private boolean unfriendly(int c1, int c2) {
        return !this.friendly(c1, c2);
    }

    private boolean myInfantryIn(int C) {
        return this.occupationTable1[C][1] > 0;
    }

    private boolean myKnightIn(int C) {
        return this.occupationTable1[C][2] > 0;
    }

    private int getNextUnfriendlyNodeFrom(int C) {
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int c = this.nodesNear[C][i];
            if (!this.unfriendly(c)) continue;
            return c;
        }
        return -1;
    }

    private void spreadInfantryFrom(int C) {
        int neighbor;
        int N_infantry;
        if (this.IdontOwn(C)) {
            if (this.occupationTable1[C][4] != this.ID) {
                return;
            }
            N_infantry = this.occupationTable1[C][5];
        } else {
            N_infantry = this.occupationTable1[C][1];
        }
        if (N_infantry == 0) {
            return;
        }
        ArrayList freebieNeighbors = new ArrayList();
        freebieNeighbors = this.getFreebies1From(C);
        int N_neighbors = freebieNeighbors.size();
        if (N_neighbors == 0) {
            ArrayList hostilesNeighbors = new ArrayList();
            hostilesNeighbors = this.getHostiles1From(C);
            N_neighbors = hostilesNeighbors.size();
            if (N_neighbors == 0) {
                int nearest = this.getNextUnfriendlyNodeFrom(C);
                int next = this.visitNext[C][nearest];
                this.moveInfantry(C, next);
                return;
            }
            int myAttack = N_infantry * this.infantryAttackValue;
            int hostile = (Integer)hostilesNeighbors.get(0);
            int defence = this.getDefenceValueAt(hostile);
            if ((double)myAttack > 0.8 * (double)defence) {
                this.moveInfantry(C, hostile);
                this.occupationTable0[C][1] = 0;
                this.occupationTable1[hostile][0] = this.ID;
                this.occupationTable1[hostile][1] = -1;
                this.occupationTable1[hostile][7] = this.myTeamID;
            }
            return;
        }
        if (N_infantry < N_neighbors) {
            int[] sortedFreebieList = new int[N_neighbors];
            sortedFreebieList = this.sortNodeList(freebieNeighbors);
            for (int i = 0; i < N_infantry; ++i) {
                int neighbor2 = sortedFreebieList[i];
                this.move(1, "Infantry", C, neighbor2);
                this.occupationTable1[neighbor2][0] = this.ID;
                this.occupationTable1[neighbor2][1] = 1;
                this.occupationTable1[neighbor2][7] = this.myTeamID;
            }
            this.occupationTable0[C][1] = 0;
            return;
        }
        int portion = N_infantry / N_neighbors;
        for (int i = 0; i < N_neighbors - 1; ++i) {
            neighbor = (Integer)freebieNeighbors.get(i);
            this.move(portion, "Infantry", C, neighbor);
            this.occupationTable1[neighbor][0] = this.ID;
            this.occupationTable1[neighbor][1] = portion;
            this.occupationTable1[neighbor][7] = this.myTeamID;
        }
        neighbor = (Integer)freebieNeighbors.get(N_neighbors - 1);
        this.move("Infantry", C, neighbor);
        this.occupationTable1[neighbor][0] = this.ID;
        this.occupationTable1[neighbor][1] = portion;
        this.occupationTable1[neighbor][7] = this.myTeamID;
        this.occupationTable0[C][1] = 0;
    }

    private float getMyADratioAgainst(int C) {
        int attack = this.getMyAttackValueAgainst(C);
        if (attack == 0) {
            return 0.0f;
        }
        int defence = this.getDefenceValueAt(C);
        if (defence == 0) {
            return this.infinity;
        }
        float ADratio = (float)attack / (float)defence;
        return ADratio;
    }

    private int getMyNearestBorderFrom(int C) {
        int min = this.infinity;
        int nearest = 0;
        for (int c = 0; c < this.N_nodes; ++c) {
            int d;
            if (!this.myBorder[c] || (d = this.pathCost[C][c]) >= min) continue;
            min = d;
            nearest = c;
        }
        return nearest;
    }

    private int getNearestUnfriendlyBorderFrom(int C) {
        int min = this.infinity;
        int nearest = -1;
        for (int c = 0; c < this.N_nodes; ++c) {
            int d;
            if (!this.myBorder[c] || !this.neighborIsUnfriendlyFrom(c) || (d = this.pathCost[C][c]) >= min) continue;
            min = d;
            nearest = c;
        }
        return nearest;
    }

    private boolean neighborIsUnfriendlyFrom(int C) {
        int N_neighbors = this.adjacencyList[C].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[C][i];
            if (!this.unfriendly(neighbor)) continue;
            return true;
        }
        return false;
    }

    private int getMyAttackValueAgainst(int a) {
        int total = 0;
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.unfriendly(c)) continue;
            if (this.IdontOwn(c)) {
                if (this.occupationTable1[c][4] == this.ID) continue;
                continue;
            }
            if (this.pathCost[c][a] > 2) continue;
            if (this.pathCost[c][a] == 2) {
                total += this.getKnightAttackValueFrom(c);
                continue;
            }
            total += this.getHostileAttackValueFrom(c);
        }
        return total;
    }

    private ArrayList<String> getMyBorderList() {
        ArrayList<String> border = new ArrayList<String>();
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!this.myBorder[c]) continue;
            String node = c + " " + this.nodeNames[c];
            border.add(node);
        }
        return border;
    }

    private boolean[] getMyBorder() {
        boolean[] border = new boolean[this.N_nodes];
        block0: for (int c = 0; c < this.N_nodes; ++c) {
            if (this.IdontOwn(c)) continue;
            int N = this.adjacencyList[c].length;
            for (int i = 0; i < N; ++i) {
                int neighbor = this.adjacencyList[c][i];
                if (this.friendly(neighbor)) continue;
                border[c] = true;
                continue block0;
            }
        }
        return border;
    }

    private void reinforceHomes() {
        this.reinforceHome0();
        for (int c = 0; c < this.N_nodes; ++c) {
            if (c == this.Home0 || this.castleIsNotMine(c)) continue;
            this.reinforceCastle(c);
        }
    }

    private void reinforceCastle(int C) {
        int myDefence;
        int attack = this.getAttackValueIn2Against(C);
        float diff = attack - (myDefence = this.getInfantryDefenceValueAt(C));
        if (diff > 0.0f) {
            int needed = (int)(1.3 * (double)Math.abs(diff) / (double)this.infantryDefenceValue);
            this.buyPawnsIn(C, needed);
            return;
        }
        if (attack == 0) {
            int neighbor = this.adjacencyList[C][0];
            this.moveInfantry(C, neighbor);
        }
    }

    private int getN_forceUnits0At(int C) {
        return this.occupationTable0[C][1] + this.occupationTable0[C][2];
    }

    private boolean castleIsNotMine(int C) {
        return !this.castleIsMine(C);
    }

    private void reinforceHome0() {
        int defence;
        int attack = this.getAttackValueIn2Against(this.Home0);
        float diff = attack - (defence = this.getInfantryDefenceValueAt(this.Home0));
        if (diff > 0.0f) {
            this.buyPawnsIn(this.Home0, (int)((double)diff * 1.3));
            return;
        }
        double diff2 = (double)diff * -0.7;
        int N_infantry = (int)(diff2 / (double)this.infantryDefenceValue);
        this.moveInfantry(N_infantry, this.Home0, this.Home1);
    }

    private void moveInfantry(int N, int from, int to) {
        this.move(N, "Infantry", from, to);
    }

    private int calInfantryNeededIn1For(int c) {
        int defence;
        int attack = this.getAttackValueIn1AgainstMy(c);
        int defenceNeed = attack - (defence = this.getInfantryDefenceValueAt(c));
        if (defenceNeed <= 0) {
            return 0;
        }
        return defenceNeed / this.infantryDefenceValue + 5;
    }

    private int getAttackValueIn1AgainstMy(int C) {
        int i = 0;
        int distance = 0;
        int total = 0;
        while (distance < 3) {
            int near = this.nodesNear[C][i];
            String botName = this.brainAt(near);
            if (this.friendly(C, near)) {
                ++i;
                continue;
            }
            if (botName.equals("Boring")) {
                ++i;
                continue;
            }
            distance = this.pathCost[C][near];
            if (distance >= 3) continue;
            total += this.getHostileAttackValueFrom(near);
            ++i;
        }
        return total;
    }

    private int calInfantryNeededIn2For(int c) {
        int defence;
        int attack = this.getAttackValueIn2Against(c);
        int defenceNeed = attack - (defence = this.getInfantryDefenceValueAt(c));
        if (defenceNeed <= 0) {
            return 0;
        }
        return defenceNeed / this.infantryDefenceValue + 5;
    }

    private int getAttackValueIn2Against(int C) {
        int i = 0;
        int distance = 0;
        int total = 0;
        while (distance < 5) {
            int near = this.nodesNear[C][i];
            String botName = this.brainAt(near);
            if (botName.equals("Boring")) {
                ++i;
                continue;
            }
            if (this.friendly(C, near)) {
                ++i;
                continue;
            }
            distance = this.pathCost[C][near];
            if (distance < 3) {
                total += this.getHostileAttackValueFrom(near);
                ++i;
                continue;
            }
            if (distance >= 5) continue;
            total += this.getKnightAttackValueFrom(near);
            ++i;
        }
        return total;
    }

    private float getADratioAtMy(int c) {
        int attack = this.getAttackValue1againstMy(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueAtMy(c);
        return (float)attack / defence;
    }

    private int getDefenceValueAtMy(int c) {
        return this.getDefenceValueAt(c);
    }

    private int getAttackValue1againstMy(int c) {
        int total = 0;
        for (int n = 0; n < this.N_nodes; ++n) {
            int between;
            String botName;
            if (this.pathCost[n][c] > 2 || this.friendly(n) || (botName = this.brainAt(n)).equals("Boring")) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getHostileAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2 || !(this.friendly(between = this.visitNext[n][c], n) | this.unoccupiedIn(between))) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private float getADratioAt(int c) {
        int attack = this.getAttackValue1Bagainst(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueAt(c);
        return (float)attack / defence;
    }

    private int getDefenceValueAt(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nInfantry * this.infantryDefenceValue + nKnight * this.knightDefenceValue;
        return total;
    }

    private int getAttackValue1Bagainst(int c) {
        int total = 0;
        for (int n = 0; n < this.N_nodes; ++n) {
            int between;
            String botName = this.brainAt(n);
            if (botName.equals("Boring") || this.friendly(c, n)) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getHostileAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2 || !(this.friendly(between = this.visitNext[n][c], n) | this.unoccupiedIn(between))) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private boolean IdontOwn(int c) {
        return !this.Iown(c);
    }

    private int calKnightNeededAgainst(int c) {
        int defence = this.getDefenceValueAt(c);
        return 3 + defence / this.knightAttackValue;
    }

    private void advanceKnightFrom(int C) {
        int N_knight;
        if (this.IdontOwn(C)) {
            if (this.occupationTable1[C][4] != this.ID) {
                return;
            }
            N_knight = this.occupationTable1[C][6];
        } else {
            N_knight = this.occupationTable1[C][2];
        }
        if (N_knight == 0) {
            return;
        }
        ArrayList freebieNeighbors = new ArrayList();
        freebieNeighbors = this.getFreebies2From(C);
        int N_neighbors = freebieNeighbors.size();
        if (N_neighbors == 0 && N_knight > 0) {
            float ADratio;
            float bonus;
            int next;
            int hostile = this.getNextUnfriendlyNodeFrom(C);
            int needed = this.calKnightNeededAgainst(hostile);
            if (N_knight >= needed) {
                next = this.visitNext[C][hostile];
                if (next != hostile) {
                    next = this.visitNext[next][hostile];
                }
                this.moveKnight(N_knight, C, next);
                N_knight -= needed;
                if (next == hostile) {
                    this.occupationTable1[hostile][0] = this.ID;
                    this.occupationTable1[hostile][1] = -1;
                    this.occupationTable1[hostile][7] = this.myTeamID;
                }
            }
            if ((bonus = this.Nodes[hostile].getContinentBonusPartial(this.world)) >= 3.0f && (double)(ADratio = this.getMyADratioAgainst(hostile)) > 1.3) {
                this.moveKnightInto(hostile);
                return;
            }
            int nearest = this.getMyNearestBorderFrom(C);
            next = this.visitNext[C][nearest];
            if (next != nearest) {
                next = this.visitNext[next][nearest];
            }
            this.moveKnight(N_knight, C, next);
            return;
        }
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = (Integer)freebieNeighbors.get(i);
            this.move(1, "Knight", C, neighbor);
            this.occupationTable1[neighbor][0] = this.ID;
            this.occupationTable1[neighbor][1] = 1;
            this.occupationTable1[neighbor][7] = this.myTeamID;
        }
    }

    private void moveKnight(int N, int from, int to) {
        this.move(N, "Knight", from, to);
    }

    private int get1stUnfriendly2from(int C) {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.pathCost[C][c] > 2 || this.friendly(c)) continue;
            return c;
        }
        return -1;
    }

    private ArrayList getFreebies2From(int f) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.pathCost[f][c] > 2 || this.occupiedIn(c) || this.friendly(c)) continue;
            list.add(new Integer(c));
        }
        return list;
    }

    private boolean unfriendly(int c) {
        return !this.friendly(c);
    }

    private boolean occupiedIn(int c) {
        return !this.unoccupiedIn(c);
    }

    private int getN_knightAt(int c) {
        return this.occupationTable0[c][2];
    }

    private String brainAt(int c) {
        int PID = this.occupationTable1[c][0];
        return this.brain[PID];
    }

    private void Round1Init() {
        this.N_nodes = this.Nodes.length;
        this.makeNodeNamesSorted();
        this.makeNodeBonusAt();
        this.N_players = this.world.getNumberOfPlayers();
        this.makePlayerAttributes();
        this.makeOccupationTables();
        this.getBrain();
        this.buildShortestPathArray();
        this.getHome0();
        this.makeNodesNear();
        this.getHome12();
    }

    private void makePlayerAttributes() {
        int i;
        int N_attributes = 2;
        this.playerAttributes = new int[this.N_players][N_attributes];
        for (int c = 0; c < this.N_nodes; ++c) {
            boolean castle = this.Nodes[c].hasCastle();
            if (!castle) continue;
            int ownerID = this.Nodes[c].getOwner().getID();
            this.playerAttributes[ownerID][0] = c;
        }
        Team[] TEAM = new Team[this.N_players];
        for (i = 0; i < this.N_players; ++i) {
            Team team_i;
            TEAM[i] = team_i = this.world.getTeam(i);
        }
        block2: for (i = 0; i < this.N_players; ++i) {
            for (int j = 0; j < this.N_players; ++j) {
                if (!TEAM[i].equals(TEAM[j])) continue;
                this.playerAttributes[i][1] = j;
                continue block2;
            }
        }
        this.myTeamID = this.playerAttributes[this.ID][1];
    }

    private void getBrain() {
        this.brain = new String[this.N_players];
        for (int i = 0; i < this.N_players; ++i) {
            String brainAt;
            this.brain[i] = brainAt = this.world.getPlayer(i).getAgentType();
        }
    }

    private void getHome0() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!(this.occupationTable0[c][0] == this.ID & this.occupationTable0[c][3] == 1)) continue;
            this.Home0 = c;
            return;
        }
    }

    private int gethostileID() {
        int i;
        int[] castleDistances = new int[this.N_players];
        for (i = 0; i < this.N_players; ++i) {
            int home_i = this.playerAttributes[i][0];
            castleDistances[i] = home_i == -1 ? this.infinity : this.pathCost[this.Home0][home_i];
        }
        int d = 1;
        block1: while (true) {
            i = 0;
            while (true) {
                if (i >= this.N_players) continue block1;
                if (d == castleDistances[i] && i != this.friendsID) {
                    return i;
                }
                ++d;
                ++i;
            }
            break;
        }
    }

    private void spreadInfantry() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.unfriendly(c)) continue;
            this.spreadInfantryFrom(c);
        }
    }

    private void spreadInfantryDefensively() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.unfriendly(c)) continue;
            this.spreadInfantryDefensivelyFrom(c);
        }
    }

    private void spreadForces() {
        this.spreadInfantry();
        this.spreadKnight();
    }

    private void spreadKnight() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.unfriendly(c)) continue;
            this.advanceKnightFrom(c);
        }
    }

    private void advanceKnight() {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (!this.Iown(c)) continue;
            this.advanceKnightFrom(c);
        }
    }

    private void round2attack() {
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            float bonus;
            int c = this.nodesNear[this.Home0][i];
            if (!(!this.friendly(c) & !this.unoccupiedIn(c)) || !((bonus = this.Nodes[c].getContinentBonusPartial(this.world)) >= 3.0f)) continue;
            this.moveKnightInto(c);
            return;
        }
    }

    private void makeNodeBonusAt() {
        this.nodeBonusAt = new int[this.N_nodes];
        for (int c = 0; c < this.N_nodes; ++c) {
            int bonus;
            this.nodeBonusAt[c] = bonus = (int)this.Nodes[c].getContinentBonusPartial(this.world);
        }
    }

    private void getHome12() {
        for (int i = 0; i < this.N_nodes - 1; ++i) {
            int c = this.nodesNear[this.Home0][i];
            if (this.occupationTable0[c][0] != this.ID) continue;
            if (this.Home1 == 0) {
                this.Home1 = c;
                continue;
            }
            this.Home2 = c;
            return;
        }
    }

    private void makeNodesNear() {
        this.nodesNear = new int[this.N_nodes][this.N_nodes - 1];
        for (int c = 0; c < this.N_nodes; ++c) {
            this.nodesNear[c] = this.getNodesNear(c);
        }
    }

    private int[] getNodesNear(int C) {
        int[] nodesNearC = new int[this.N_nodes - 1];
        int i = 0;
        int d = 0;
        while (i < this.N_nodes - 1) {
            ++d;
            for (int c = 0; c < this.N_nodes; ++c) {
                if (this.pathCost[C][c] != d) continue;
                nodesNearC[i] = c;
                ++i;
            }
        }
        return nodesNearC;
    }

    private int[] sortNodeList(ArrayList<Integer> nodeList) {
        int i;
        int N = nodeList.size();
        int[] sortedList = new int[N];
        int[] threatBefore = new int[N];
        int[] threatAfter = new int[N];
        for (i = 0; i < N; ++i) {
            int c = nodeList.get(i);
            threatBefore[i] = this.getAttackValue1Bagainst(c);
            threatAfter[i] = threatBefore[i];
        }
        Arrays.sort(threatAfter);
        boolean[] taken = new boolean[N];
        int k = 0;
        block1: for (i = 0; i < N; ++i) {
            int threat = threatAfter[i];
            for (int j = 0; j < N; ++j) {
                if (!(!taken[j] & threat == threatBefore[j])) continue;
                sortedList[k] = nodeList.get(j);
                taken[j] = true;
                ++k;
                continue block1;
            }
        }
        return sortedList;
    }

    private ArrayList getUnfriendlyNoIKCs(int c) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int N_neighbors = this.adjacencyList[c].length;
        for (int i = 0; i < N_neighbors; ++i) {
            int neighbor = this.adjacencyList[c][i];
            if (!(this.unoccupiedIn(neighbor) & !this.friendly1(c, neighbor))) continue;
            list.add(new Integer(neighbor));
        }
        return list;
    }

    private boolean friendly1(int c1, int c2) {
        int team2;
        int team1 = this.getTeamIDAt(c1);
        return team1 == (team2 = this.getTeamIDAt(c2));
    }

    private int getTeamIDAt(int c) {
        return this.occupationTable1[c][7];
    }

    private void makeOccupationTables() {
        int c;
        int N_cols = 8;
        this.occupationTable0 = new int[this.N_nodes][N_cols];
        for (c = 0; c < this.N_nodes; ++c) {
            int nodeOwnerID;
            Country ct = this.Nodes[c];
            this.occupationTable0[c][0] = nodeOwnerID = ct.getOwner().getID();
            UnitStackGroup IKCs = ct.getUnitStackGroup();
            int N_IKCs = IKCs.size();
            for (int s = 0; s < N_IKCs; ++s) {
                UnitStack IKorC = IKCs.get(s);
                Player player = IKorC.getOwner();
                int unitOwnerID = player.getID();
                int N_units = IKorC.getCount();
                String IKxorC = IKorC.getUnit().toString();
                if (nodeOwnerID == unitOwnerID) {
                    if (IKxorC.equals("Infantry")) {
                        this.occupationTable0[c][1] = N_units;
                    }
                    if (IKxorC.equals("Knight")) {
                        this.occupationTable0[c][2] = N_units;
                    }
                    if (!IKxorC.equals("Castle")) continue;
                    this.occupationTable0[c][3] = 1;
                    continue;
                }
                this.occupationTable0[c][4] = unitOwnerID;
                if (IKxorC.equals("Infantry")) {
                    this.occupationTable0[c][5] = N_units;
                }
                if (!IKxorC.equals("Knight")) continue;
                this.occupationTable0[c][6] = N_units;
            }
            this.occupationTable0[c][7] = this.playerAttributes[nodeOwnerID][1];
        }
        this.occupationTable1 = new int[this.N_nodes][N_cols];
        for (c = 0; c < this.N_nodes; ++c) {
            for (int i = 0; i < N_cols; ++i) {
                this.occupationTable1[c][i] = this.occupationTable0[c][i];
            }
        }
    }

    private boolean unoccupiedIn(int c) {
        int IKCs = this.occupationTable1[c][1] + this.occupationTable1[c][2] + this.occupationTable1[c][3] + this.occupationTable1[c][3] + this.occupationTable1[c][5] + this.occupationTable1[c][6];
        return IKCs == 0;
    }

    public void gatherTo(int c, int ... exceptions) {
        for (int from = 0; from < this.N_nodes; ++from) {
            int next;
            if (this.in(from, exceptions)) continue;
            UnitStack unitForce = this.getKnight(from);
            if (unitForce != null) {
                next = this.visitNext[from][c];
                next = this.visitNext[next][c];
                this.moveKnight(from, next);
            }
            if ((unitForce = this.getInfantry(from)) == null) continue;
            next = this.visitNext[from][c];
            this.moveInfantry(from, next);
        }
    }

    public void gatherKnightTo(int c, int ... exceptions) {
        for (int from = 0; from < this.N_nodes; ++from) {
            UnitStack unitForce;
            if (this.in(from, exceptions) || (unitForce = this.getKnight(from)) == null) continue;
            int next = this.visitNext[from][c];
            next = this.visitNext[next][c];
            this.moveKnight(from, next);
        }
    }

    private void buyPawnsIn(int c, int units) {
        int m = units * this.infantryCost;
        if (this.money >= m) {
            this.buyPawns(m, this.Nodes[c]);
        } else {
            this.buyPawns(this.money, this.Nodes[c]);
        }
    }

    private void buyPawnsIn(int c) {
        this.buyPawns(this.money, this.Nodes[c]);
    }

    private boolean in(int k, int[] S) {
        for (int s : S) {
            if (k != s) continue;
            return true;
        }
        return false;
    }

    private boolean Iown(int c) {
        return this.occupationTable0[c][0] == this.ID;
    }

    private int getInfantryDefenceValueAt(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        return nInfantry * this.infantryDefenceValue;
    }

    private int getKnightDefenceValueAt(int c) {
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nKnight * this.knightDefenceValue;
        return total;
    }

    private void makeNodeNamesSorted() {
        this.nodeNames = new String[this.N_nodes];
        this.nodeNamesSorted = new String[this.N_nodes];
        for (int c = 0; c < this.N_nodes; ++c) {
            Country ct = this.Nodes[c];
            int t1 = ct.getID();
            this.nodeNames[c] = ct.getName();
            this.nodeNamesSorted[c] = this.nodeNames[c] + ' ' + c;
        }
        Arrays.sort(this.nodeNamesSorted);
    }

    private int getHostileAttackValueFrom(int c) {
        int nInfantry = this.occupationTable0[c][1] + this.occupationTable0[c][5];
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nInfantry * this.infantryAttackValue + nKnight * this.knightAttackValue;
        return total;
    }

    private int getMyInfantryAttackValueFrom(int c) {
        int cOwnerID = this.occupationTable0[c][0];
        if (this.friendly(c)) {
            return 0;
        }
        if (cOwnerID == this.ID) {
            int nInfantry = this.occupationTable0[c][1];
            int total = nInfantry * this.infantryAttackValue;
            return total;
        }
        int nInfantry = this.occupationTable0[c][5];
        int total = nInfantry * this.infantryAttackValue;
        return total;
    }

    private int getMyKnightAttackValueAt(int C) {
        int N_knight;
        int total = 0;
        if (this.occupationTable1[C][0] == this.ID) {
            N_knight = this.occupationTable0[C][2];
            total = N_knight * this.knightAttackValue;
        }
        if (this.occupationTable1[C][4] == this.ID) {
            N_knight = this.occupationTable0[C][6];
            total = N_knight * this.knightAttackValue;
        }
        return total;
    }

    private int getMyAttackValueFrom(int c) {
        int total = this.getMyInfantryAttackValueFrom(c);
        return total += this.getMyKnightAttackValueAt(c);
    }

    private int getKnightAttackValueFrom(int c) {
        int nKnight = this.occupationTable0[c][2] + this.occupationTable0[c][6];
        int total = nKnight * this.knightAttackValue;
        return total;
    }

    private int getOwnerID(int c) {
        Player player = this.Nodes[c].getOwner();
        return player.getID();
    }

    private void buyKnightIn(int c) {
        this.buyKnights(this.money, this.Nodes[c]);
    }

    private void buyKnight() {
        this.buyKnights(this.money, this.Nodes[this.Home0]);
    }

    private void buyCastleFor(int c) {
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.ID));
        UnitStack castle2 = new UnitStack(castle, 1);
        this.world.placeUnits(castle2, this.Nodes[c]);
    }

    private void move(String KnightOrInfantry, int from, int to) {
        this.move(this.infinity, KnightOrInfantry, from, to);
    }

    private void moveInto(int c) {
        this.moveInfantriesInto(c);
        this.moveKnightInto(c);
    }

    private void move(int from, int to) {
        this.move("Infantry", from, to);
        this.move("Knight", from, to);
    }

    private void moveInfantry(int from, int to) {
        this.move("Infantry", from, to);
    }

    private void moveInfantriesInto(int c) {
        int n = this.adjacencyList[c].length;
        for (int i = 0; i < n; ++i) {
            int neighbor = this.adjacencyList[c][i];
            this.move("Infantry", neighbor, c);
        }
    }

    private void moveKnight(int from, int to) {
        this.move("Knight", from, to);
    }

    private void moveKnightInto(int C) {
        for (int c = 0; c < this.N_nodes; ++c) {
            if (this.IdontOwn(c) || this.pathCost[c][C] >= 3) continue;
            this.move("Knight", c, C);
        }
    }

    private UnitStack getKnightOrInfantry(int c, int movement) {
        Country ct = this.Nodes[c];
        UnitStackGroup CKIs = ct.getUnitStackGroup();
        int N_usg = CKIs.size();
        for (int s = 0; s < N_usg; ++s) {
            int m;
            UnitStack CKorI = CKIs.get(s);
            int ID2 = CKorI.getOwner().getID();
            if (ID2 != this.ID || (m = CKorI.getUnit().getMovement()) != movement) continue;
            return CKorI;
        }
        return null;
    }

    private UnitStack getKnight(int c) {
        return this.getKnightOrInfantry(c, 2);
    }

    private UnitStack getInfantry(int c) {
        return this.getKnightOrInfantry(c, 1);
    }

    private boolean enemyForceAt(int c) {
        if (this.friendly(c)) {
            return false;
        }
        int total = this.occupationTable0[c][1] + this.occupationTable0[c][2] + this.occupationTable0[c][3] + this.occupationTable0[c][5] + this.occupationTable0[c][6];
        return total != 0;
    }

    private boolean castleIsMine(int c) {
        return this.occupationTable0[c][3] == 1 & this.occupationTable0[c][0] == this.ID;
    }

    private boolean friendly(int c) {
        return this.myTeamOwns(c);
    }

    private boolean myTeamOwns(int c) {
        return this.occupationTable1[c][7] == this.playerAttributes[this.ID][1];
    }

    private boolean friendly(int c1, int c2) {
        return this.occupationTable1[c1][7] == this.occupationTable1[c2][7];
    }

    private void buildShortestPathArray() {
        int k;
        int n;
        int j;
        int i;
        this.edgeCost = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                this.edgeCost[i][j] = this.infinity;
            }
            this.edgeCost[i][i] = 0;
        }
        this.adjacencyList = new int[this.N_nodes][];
        for (int c = 0; c < this.N_nodes; ++c) {
            Country ct = this.Nodes[c];
            List adjoiningList = ct.getAdjoiningList();
            n = adjoiningList.size();
            this.adjacencyList[c] = new int[n];
            for (j = 0; j < n; ++j) {
                Country ct2 = (Country)adjoiningList.get(j);
                k = ct2.getID();
                this.edgeCost[c][k] = 1;
                this.adjacencyList[c][j] = k;
            }
        }
        this.pathCost = new int[this.N_nodes][this.N_nodes];
        int[][] visitThru = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                this.pathCost[i][j] = this.edgeCost[i][j];
                visitThru[i][j] = -1;
            }
        }
        for (k = 0; k < this.N_nodes; ++k) {
            for (i = 0; i < this.N_nodes; ++i) {
                for (j = 0; j < this.N_nodes; ++j) {
                    if (this.pathCost[i][k] + this.pathCost[k][j] >= this.pathCost[i][j]) continue;
                    this.pathCost[i][j] = this.pathCost[i][k] + this.pathCost[k][j];
                    visitThru[i][j] = k;
                }
            }
        }
        this.shortestPath = new int[this.N_nodes][this.N_nodes][];
        this.visitNext = new int[this.N_nodes][this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < this.N_nodes; ++j) {
                int next;
                if (i == j) {
                    this.visitNext[i][j] = i;
                    continue;
                }
                if (this.edgeCost[i][j] == 1) {
                    this.visitNext[i][j] = j;
                    continue;
                }
                String path = this.shortestPath(i, j, visitThru);
                path = path.replaceAll("^\\s+", "");
                int i2 = path.indexOf(" ");
                String nextS = path.substring(0, i2);
                this.visitNext[i][j] = next = Integer.valueOf(nextS).intValue();
                path = path.substring(i2);
                n = this.pathCost[i][j] - 1;
                this.shortestPath[i][j] = new int[n];
                this.shortestPath[i][j][0] = next;
                for (k = 1; k < n; ++k) {
                    path = path.replaceAll("^\\s+", "");
                    i2 = path.indexOf(" ");
                    nextS = path.substring(0, i2);
                    this.shortestPath[i][j][k] = next = Integer.valueOf(nextS).intValue();
                    path = path.substring(i2);
                }
            }
        }
        this.visitFrequency = new int[this.N_nodes];
        for (i = 0; i < this.N_nodes; ++i) {
            for (j = 0; j < i; ++j) {
                int n2 = k = this.visitNext[i][j];
                this.visitFrequency[n2] = this.visitFrequency[n2] + 1;
            }
        }
    }

    private String shortestPath(int i, int j, int[][] visitThru) {
        int k = visitThru[i][j];
        if (k == -1) {
            return " ";
        }
        return this.shortestPath(i, k, visitThru) + " " + k + " " + this.shortestPath(k, j, visitThru);
    }

    @Override
    public String name() {
        return "TonyAI";
    }

    @Override
    public float version() {
        return 1.0f;
    }

    @Override
    public String description() {
        return "AI bot.";
    }

    @Override
    public String youWon() {
        return "AI won.";
    }

    private void move(int N_units, String KnightOrInfantry, int from, int to) {
        UnitStack unitForce;
        if (from == to) {
            return;
        }
        if (to == -1) {
            return;
        }
        Country ct = this.Nodes[from];
        if (KnightOrInfantry.equals("Knight")) {
            int via;
            unitForce = this.getKnight(from);
            if (from == -1 | to == -1) {
                this.stop = 0;
            }
            if (this.pathCost[from][to] == 2 && this.enemyForceAt(via = this.visitNext[from][to])) {
                to = via;
            }
        } else {
            unitForce = this.getInfantry(from);
        }
        if (unitForce == null) {
            return;
        }
        int ID2 = unitForce.getOwner().getID();
        if (ID2 != this.ID) {
            return;
        }
        if (N_units == this.infinity) {
            N_units = unitForce.getCount();
        }
        this.world.moveUnit(unitForce, ct, this.Nodes[to], N_units);
        if (from == 46 & to == 74) {
            this.stop = 0;
        }
    }
}

