/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import com.sillysoft.vox.unit.UnitCastle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class AI2
extends VoxAgentBase
implements VoxAgent {
    private Random rand = new Random();
    private int infantryAttackValue = 1;
    private int knightAttackValue = 5;
    private int infantryDefenceValue = 3;
    private int knightDefenceValue = 2;
    private int infantryCost = 3;
    private int SitcaCastle = 88;
    private int CentralGoldmine = 59;
    private int SitcaSW = 102;
    private int SitcaBridgeS = 13;
    private int SitcaBridgeN = 56;
    private int SitcaNW = 67;
    private int SitcaGoldmine = 3;
    private int SartrusCastle = 57;
    private int SartrusSE = 101;
    private int ZonlorCastle = 46;
    private int LaceCastle = 12;
    private Country[] Countries;
    private String[] CountryNames;
    private String[] CountryNamesSorted;
    private int N_teams = 4;
    private int[] ID2teamID = new int[]{0, 0, 1, 1, 2, 2, 3};
    private int friendID;
    private int myTeamID;
    private int humanID = -1;
    private int humanFriendlyID = -1;
    private int humanCastleI;
    private int humanFriendlyCastleI;
    private boolean humanPlaysNomads;
    private int Round = 0;
    private Team humanTeamName;
    private Team myTeam;
    private int N_Countries;
    private int N_players;
    private int N_SitcaHomeCountrySet;
    private String whoAmI;
    private Player humanFriendlyPlayer;
    private Player AIplayer;
    private int stop;
    private Team[] ID2Team;
    private boolean[] IDisaTonyAI;
    private int[][] occupationTable;
    private boolean SitcaBridgeScastleIsMine;
    private boolean CentralGoldmineCastleIsMine;
    private int[][] edgeCost;
    private int[][] pathCost;
    private int[][] visitNext;
    private int[] N_neighbors;
    private int[][] adjacencyList;
    private int[][][] shortestPath;
    private int infinity = 99999;
    private int money;
    private int[] SitcaHome = new int[]{3, 97, 98, 87, 88, 89, 13, 84, 85, 54, 71, 72, 73, 102, 69, 68, 67, 59};
    private ArrayList[] CountriesBelongTo;

    public void declareMoves(Country[] countries) {
        this.Countries = countries;
        this.money = this.world.getPlayerMoney(this.ID);
        ++this.Round;
        if (this.Round == 1) {
            this.Round1Init();
        }
        if (this.humanPlaysNomads) {
            this.wandering();
            return;
        }
        this.makeCountriesBelongTo();
        this.makeOccupationTable();
        switch (this.ID) {
            case 0: {
                this.buyKnightIn(this.ZonlorCastle);
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                this.buyKnightIn(this.LaceCastle);
                break;
            }
            case 4: {
                this.playSitca();
                break;
            }
            case 5: {
                this.buyKnightIn(this.SartrusCastle);
                break;
            }
        }
    }

    private void playSitca() {
        if (this.Round == 1) {
            this.SitcaRound1();
            return;
        }
        if (this.Round == 2) {
            this.SitcaRound2();
            return;
        }
        if (this.Round == 3) {
            this.SitcaRound3();
            return;
        }
        if (this.Round == 4) {
            this.SitcaRound4();
            return;
        }
        int n = this.calInfantryNeededIn1(this.SitcaBridgeS);
        this.buyPawnsIn(this.SitcaNW, n);
        this.move(n, "Infantry", this.SitcaNW, this.SitcaBridgeS);
        if (!this.friendly(this.CentralGoldmine)) {
            this.moveInto(this.CentralGoldmine);
            this.gatherTo(this.CentralGoldmine, this.SitcaBridgeS);
            return;
        }
        n = this.calInfantryNeededIn1(this.CentralGoldmine);
        this.buyPawnsIn(this.SitcaNW, n);
        this.move(n, "Infantry", this.SitcaNW, this.CentralGoldmine);
        n = this.calInfantryNeededIn1(this.SitcaSW);
        this.buyPawnsIn(this.SitcaSW, n);
    }

    private int calInfantryNeededIn1(int c) {
        int defence;
        int attack = this.getAttackValueIn1Against(c);
        int defenceNeed = attack - (defence = this.getInfantryDefenceValueAt(c));
        if (defenceNeed <= 0) {
            return 0;
        }
        return defenceNeed / this.infantryDefenceValue + 5;
    }

    private int getAttackValueIn1Against(int c) {
        int total = 0;
        int cTeamID = this.getTeamID(c);
        for (int n = 0; n < this.N_Countries; ++n) {
            int neighborTeamID;
            String controller = this.getControllerAt(n);
            if (controller.equals("Boring") || cTeamID == (neighborTeamID = this.getTeamID(n))) continue;
            int distance = this.pathCost[n][c];
            if (distance < 3) {
                total += this.getAttackValueFrom(n);
                continue;
            }
            if (distance >= 5) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private boolean noObstacleInPath(int c1, int c2) {
        int next = this.visitNext[c1][c2];
        while (next != c2) {
            if (!this.NoIKCsIn(next) & !this.friendly(c1, next)) {
                return false;
            }
            next = this.visitNext[next][c2];
        }
        return true;
    }

    private String reinforceCentralGoldmine() {
        float ADratio = this.getADratioAt(this.CentralGoldmine);
        if ((double)ADratio <= 0.6) {
            return "low threat";
        }
        if ((double)ADratio <= 0.8) {
            this.moveInto(this.CentralGoldmine);
            this.buyPawnsIn(this.CentralGoldmine, 5);
            return "medium threat";
        }
        this.gatherTo(this.CentralGoldmine, new int[0]);
        this.buyKnightIn(this.SitcaBridgeS);
        return "high threat";
    }

    private void attackCentralGoldmine() {
        String status;
        int ownerID = this.occupationTable[this.CentralGoldmine][0];
        if (ownerID == 6) {
            this.attackNomadsCentralGoldmine();
        }
        if ((status = this.reinforceSitcaBridgeS()).equals("low threat")) {
            int defenceG = this.getDefenceValueAt(this.CentralGoldmine);
            int aKnight = (int)((double)defenceG * 2.5 / (double)this.knightAttackValue);
            int dKnight = this.occupationTable[this.SitcaBridgeS][2] - aKnight;
            int InfantryDefenceB = this.getInfantryDefenceValueAt(this.SitcaBridgeS);
            int KnightDefenceB = dKnight * this.knightDefenceValue;
            float attackB = this.getAttackValueAgainst(this.SitcaBridgeS);
            float ADratio = attackB / (float)(InfantryDefenceB + KnightDefenceB);
            if ((double)ADratio > 0.8) {
                this.gatherTo(this.SitcaBridgeS, new int[0]);
                this.buyPawnsIn(this.SitcaBridgeS);
                return;
            }
            if (dKnight < 0) {
                this.gatherTo(this.SitcaBridgeS, new int[0]);
                this.buyKnightIn(this.SitcaBridgeS);
                return;
            }
            this.move(aKnight, "Knight", this.SitcaBridgeS, this.CentralGoldmine);
            this.gatherTo(this.CentralGoldmine, this.SitcaBridgeS);
        }
    }

    private void attackNomadsCentralGoldmine() {
        this.buyKnightIn(this.SitcaBridgeS);
        this.moveInto(this.CentralGoldmine);
    }

    private int calInfantryNeeded(int c) {
        int defence;
        int attack = this.getAttackValueAgainst(c);
        int defenceNeed = attack - (defence = this.getInfantryDefenceValueAt(c));
        if (defenceNeed <= 0) {
            return 0;
        }
        return defenceNeed / this.infantryDefenceValue + 5;
    }

    private int getAttackValueAgainst(int c) {
        int total = 0;
        int cTeamID = this.getTeamID(c);
        for (int n = 0; n < this.N_Countries; ++n) {
            int between;
            int neighborTeamID;
            String controller = this.getControllerAt(n);
            if (controller.equals("Boring") || cTeamID == (neighborTeamID = this.getTeamID(n))) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2 || !(this.friendly(between = this.visitNext[n][c], n) | this.NoIKCsIn(between))) continue;
            total += this.getKnightAttackValueFrom(n);
        }
        return total;
    }

    private boolean NoIKCsIn(int c) {
        int IKCs = this.occupationTable[c][1] + this.occupationTable[c][2] + this.occupationTable[c][3] + this.occupationTable[c][3] + this.occupationTable[c][5] + this.occupationTable[c][6];
        return IKCs == 0;
    }

    private String reinforceSitcaBridgeS() {
        float ADratio = this.getADratioAt(this.SitcaBridgeS);
        if ((double)ADratio <= 0.6) {
            return "low threat";
        }
        if ((double)ADratio <= 0.8) {
            this.buyPawnsIn(this.SitcaBridgeS, 5);
            return "medium threat";
        }
        this.buyPawnsIn(this.SitcaBridgeS);
        return "high threat";
    }

    private void SitcaRound1() {
        this.move(5, "Infantry", this.SitcaCastle, 84);
        this.move(2, "Knight", this.SitcaCastle, this.SitcaGoldmine);
        this.move(1, "Infantry", this.SitcaCastle, 89);
        this.move("Infantry", this.SitcaCastle, this.SitcaGoldmine);
        this.move(1, "Infantry", 87, 97);
        this.move(1, "Infantry", 87, 98);
        this.move(4, "Infantry", 87, 54);
        this.move(1, "Infantry", 85, 71);
        this.move(2, "Infantry", 85, 72);
        this.move(3, "Infantry", 85, 88);
        this.buyKnightIn(this.SitcaCastle);
    }

    private void SitcaRound2() {
        this.moveInfantry(84, 73);
        this.moveInfantry(this.SitcaCastle, 89);
        this.moveInfantriesInto(this.SitcaSW);
        this.move(1, "Infantry", 72, 69);
        this.move(1, "Infantry", 72, 68);
        this.move(this.SitcaGoldmine, 89);
        this.gatherTo(this.SitcaGoldmine, 89);
        this.buyPawnsIn(this.SitcaCastle);
    }

    private void SitcaRound3() {
        this.move(73, this.SitcaNW);
        this.buyCastleFor(this.SitcaSW);
        this.moveInto(this.SitcaBridgeS);
        this.gatherTo(this.SitcaNW, new int[0]);
        this.buyPawnsIn(this.SitcaCastle);
    }

    private void SitcaRound4() {
        this.buyCastleFor(this.SitcaNW);
        float ADratio = this.getADratioAt(this.SitcaBridgeS);
        if ((double)ADratio > 0.6) {
            this.gatherTo(this.SitcaBridgeS, new int[0]);
            return;
        }
        this.gatherTo(this.SitcaNW, new int[0]);
    }

    private void buildSitcaNWCastle() {
        String status = this.reinforceSitcaBridgeS();
        float ADratio = this.getADratioFor(this.CentralGoldmine);
        if ((double)ADratio <= 0.6) {
            this.buyCastleFor(this.CentralGoldmine);
            int spare = this.getSpareKnightAt(this.SitcaBridgeS);
            this.move(spare, "Knight", this.SitcaBridgeS, 72);
            return;
        }
        this.gatherTo(this.CentralGoldmine, this.SitcaBridgeS);
    }

    private void buildCentralGoldmineCastle() {
        String status = this.reinforceSitcaBridgeS();
        float ADratio = this.getADratioFor(this.CentralGoldmine);
        if ((double)ADratio <= 0.6) {
            this.buyCastleFor(this.CentralGoldmine);
            int spare = this.getSpareKnightAt(this.SitcaBridgeS);
            this.move(spare, "Knight", this.SitcaBridgeS, 72);
            return;
        }
        this.gatherTo(this.CentralGoldmine, this.SitcaBridgeS);
    }

    private String reinforceSitcaBridgeS0() {
        float ADratio = this.getADratioAt(this.SitcaBridgeS);
        if ((double)ADratio <= 0.6) {
            return "low threat";
        }
        if ((double)ADratio <= 0.8) {
            this.buyPawnsIn(this.SitcaBridgeS, 5);
            return "medium threat";
        }
        this.buyPawnsIn(this.SitcaBridgeS);
        return "high threat";
    }

    private String reinforceSitcaSW() {
        int c = this.SitcaSW;
        float ADratio = this.getADratioAt(c);
        if ((double)ADratio <= 0.6) {
            return "low threat";
        }
        if ((double)ADratio <= 0.8) {
            this.moveInto(c);
            this.buyPawnsIn(c, 5);
            return "medium threat";
        }
        this.gatherTo(c, new int[0]);
        int n = this.calInfantryNeeded(c);
        this.buyPawnsIn(c, n);
        return "high threat";
    }

    private void buildSitcaSWcastle() {
        String status = this.reinforceSitcaBridgeS();
        if (status.equals("high threat")) {
            return;
        }
        status = this.reinforceCentralGoldmine();
        if (status.equals("high threat")) {
            return;
        }
        float ADratio = this.getADratioAt(this.SitcaSW);
        if ((double)ADratio <= 0.6) {
            this.buyCastleFor(this.SitcaSW);
        }
        this.gatherTo(this.SitcaSW, new int[0]);
    }

    private String doCentralGoldmine() {
        float ADratio;
        if (this.castlePeaceful(this.CentralGoldmine)) {
            return "peaeful";
        }
        if (!this.friendly(this.CentralGoldmine)) {
            int totalAttack;
            int defence = this.getDefenceValueFor(this.CentralGoldmine);
            int myAttack = this.getMyAttackValueAgainst(this.CentralGoldmine);
            if ((double)myAttack > 1.2 * (double)defence & (double)(myAttack / (totalAttack = this.getAttackValueAgainst(this.CentralGoldmine))) > 0.6) {
                this.gatherTo(this.CentralGoldmine, this.SitcaBridgeS);
                this.move("Knight", this.SitcaBridgeS, this.CentralGoldmine);
                return "attack it";
            }
            this.gatherTo(67, this.SitcaBridgeS);
            return "prepare to attack";
        }
        if (this.Iown(this.CentralGoldmine) && (double)(ADratio = this.getADratioAt(this.CentralGoldmine)) > 0.8) {
            this.gatherTo(this.CentralGoldmine, new int[0]);
            return "under threat";
        }
        return "friendly";
    }

    private void buildSitcaBridgeScastle() {
        float ADratio = this.getADratioFor(this.SitcaBridgeS);
        this.gatherTo(this.SitcaBridgeS, new int[0]);
        if ((double)ADratio <= 0.8) {
            this.buyCastleFor(this.SitcaBridgeS);
        }
        this.buyPawnsIn(this.SitcaCastle);
    }

    private int getSpareKnightAt(int c) {
        float infantryDefence;
        int attack = this.getAttackValueAgainst(c);
        float ADratio = (float)attack / (infantryDefence = (float)this.getInfantryDefenceValueAt(c));
        if ((double)ADratio < 0.8) {
            int spare = this.occupationTable[c][2];
            return spare;
        }
        return 0;
    }

    private void attackSitcaBridgeS() {
        this.gatherTo(this.SitcaBridgeS, new int[0]);
        int C = this.getMyCastleNear(this.SitcaBridgeS);
        if (C == -1) {
            int c = this.getMyCountryNear(this.SitcaBridgeS);
            this.buyCastleFor(c);
        } else {
            this.buyKnightIn(C);
        }
    }

    private int getMyCastleNear(int c) {
        ArrayList myCastleList = new ArrayList();
        myCastleList = this.getCastleList(this.ID);
        int d = this.infinity;
        int nearestCastle = -1;
        for (Integer C : myCastleList) {
            if (this.pathCost[c][C] >= d) continue;
            nearestCastle = C;
        }
        return nearestCastle;
    }

    private int getMyCountryNear(int c) {
        ArrayList clist = new ArrayList();
        clist = this.CountriesBelongTo[this.ID];
        int d = this.infinity;
        int nearestCountry = -1;
        for (Integer C : clist) {
            if (this.pathCost[c][C] >= d) continue;
            nearestCountry = C;
        }
        return nearestCountry;
    }

    private ArrayList getCastleList(int id) {
        ArrayList<Integer> castleList = new ArrayList<Integer>();
        for (int c = 0; c < this.N_Countries; ++c) {
            if (!(this.occupationTable[c][0] == id & this.occupationTable[c][3] == 1)) continue;
            castleList.add(new Integer(c));
        }
        return castleList;
    }

    private void attackSitcaSW() {
        float ADratio = this.getADratioAt(this.SitcaSW);
        this.gatherTo(this.SitcaSW, this.CentralGoldmine, this.SitcaBridgeS);
    }

    private float getADratioAt(int c) {
        int attack = this.getAttackValueAgainst(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueAt(c);
        return (float)attack / defence;
    }

    private float getADratioFor(int c) {
        int attack = this.getAttackValueAgainst(c);
        if (attack == 0) {
            return 0.0f;
        }
        float defence = this.getDefenceValueFor(c);
        return (float)attack / defence;
    }

    private boolean castle(int c) {
        return this.occupationTable[c][3] == 1;
    }

    private boolean castlePeaceful(int c) {
        float ADratio = this.getADratioAt(c);
        return this.castleIsMine(c) & (double)ADratio <= 0.2;
    }

    private boolean castleLowThreat(int c) {
        float ADratio = this.getADratioAt(c);
        if ((double)ADratio > 0.2 & (double)ADratio <= 0.6) {
            if (this.castleIsMine(c)) {
                this.buyPawnsIn(c);
            } else {
                this.buyCastleFor(c);
            }
            return true;
        }
        return false;
    }

    public void gatherTo(int c, int ... exceptions) {
        for (int from = 0; from < this.N_Countries; ++from) {
            int next;
            if (this.in(from, exceptions)) continue;
            UnitStack unitForce = this.getKnight(from);
            if (unitForce != null) {
                next = this.visitNext[from][c];
                next = this.visitNext[next][c];
                this.moveKnight(from, next);
            }
            if ((unitForce = this.getInfantry(from)) == null) continue;
            next = this.visitNext[from][c];
            this.moveInfantry(from, next);
        }
    }

    private void buyPawnsIn(int c, int units) {
        int m = units * this.infantryCost;
        if (this.money >= m) {
            this.buyPawns(m, this.Countries[c]);
        } else {
            this.buyPawns(this.money, this.Countries[c]);
        }
    }

    private void buyPawnsIn(int c) {
        this.buyPawns(this.money, this.Countries[c]);
    }

    private boolean in(int k, int[] S) {
        for (int s : S) {
            if (k != s) continue;
            return true;
        }
        return false;
    }

    private boolean Iown(int c) {
        return this.occupationTable[c][0] == this.ID;
    }

    private int getInfantryDefenceValueAt(int c) {
        int nInfantry = this.occupationTable[c][1] + this.occupationTable[c][5];
        return nInfantry * this.infantryDefenceValue;
    }

    private String getControllerAt(int c) {
        return this.Countries[c].getOwner().getControllerName();
    }

    private int getDefenceValueFor(int c) {
        int total = this.getDefenceValueAt(c);
        int cTeamID = this.getTeamID(c);
        for (int n = 0; n < this.N_Countries; ++n) {
            int neighborTeamID = this.getTeamID(n);
            if (cTeamID != neighborTeamID) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getDefenceValueAt(n);
            }
            if (this.pathCost[n][c] != 2) continue;
            total += this.getKnightDefenceValueAt(n);
        }
        return total;
    }

    private int getKnightDefenceValueAt(int c) {
        int nKnight = this.occupationTable[c][2] + this.occupationTable[c][6];
        int total = nKnight * this.knightDefenceValue;
        return total;
    }

    private int getDefenceValueAt(int c) {
        int nInfantry = this.occupationTable[c][1] + this.occupationTable[c][5];
        int nKnight = this.occupationTable[c][2] + this.occupationTable[c][6];
        int total = nInfantry * this.infantryDefenceValue + nKnight * this.knightDefenceValue;
        return total;
    }

    private void Round1Init() {
        this.myTeamID = this.ID2teamID[this.ID];
        this.N_players = this.world.getNumberOfPlayers();
        this.N_Countries = this.Countries.length;
        this.CountriesBelongTo = new ArrayList[this.N_players];
        this.N_SitcaHomeCountrySet = this.SitcaHome.length;
        this.friendID = this.getFriendID();
        this.makeID2Team();
        this.makeCountryNamesSorted();
        this.getHumanFriend();
        this.buildShortestPathArray();
        this.getHumanID();
        this.whoAmI = this.world.getPlayer(this.ID).name();
        this.AIplayer = this.world.getPlayer(this.ID);
        this.myTeam = this.world.getTeam(this.ID);
    }

    private void makeID2Team() {
        this.ID2Team = new Team[this.N_players];
        for (int i = 0; i < this.N_players; ++i) {
            Team team_i;
            this.ID2Team[i] = team_i = this.world.getTeam(i);
        }
    }

    private void getHumanFriend() {
        for (int i = 0; i < this.N_players; ++i) {
            Team team_i = this.world.getTeam(i);
            if (this.humanID <= -1 || i == this.humanID || !team_i.equals(this.humanTeamName)) continue;
            this.humanFriendlyID = i;
            this.humanFriendlyPlayer = this.world.getPlayer(this.humanFriendlyID);
            break;
        }
        this.humanFriendlyCastleI = this.humanFriendlyID == -1 ? -1 : this.get1CastleOwnedBy(this.humanFriendlyID);
        this.humanCastleI = this.get1CastleOwnedBy(this.humanID);
    }

    private int getFriendID() {
        for (int i = 0; i < this.N_players; ++i) {
            if (!(i != this.ID & this.myTeamID == this.ID2teamID[i])) continue;
            return i;
        }
        return -1;
    }

    private void makeCountryNamesSorted() {
        this.CountryNames = new String[this.N_Countries];
        this.CountryNamesSorted = new String[this.N_Countries];
        for (int c = 0; c < this.N_Countries; ++c) {
            Country ct = this.Countries[c];
            int t1 = ct.getID();
            this.CountryNames[c] = ct.getName();
            this.CountryNamesSorted[c] = this.CountryNames[c] + ' ' + c;
        }
        Arrays.sort(this.CountryNamesSorted);
    }

    private void getHumanID() {
        this.IDisaTonyAI = new boolean[this.N_players];
        for (int i = 0; i < this.N_players; ++i) {
            Player player_i = this.world.getPlayer(i);
            String name = player_i.getAgentType();
            if (name.equals("TonyAI")) {
                this.IDisaTonyAI[i] = true;
                continue;
            }
            boolean human = player_i.isHuman();
            if (!human) continue;
            this.humanTeamName = this.world.getTeam(i);
            this.humanID = i;
            if (i != 6) continue;
            this.humanPlaysNomads = true;
        }
    }

    private void playSartrus() {
        switch (this.Round) {
            case 1: {
                this.move(2, "Knight", 57, 101);
                this.gatherTo(this.CentralGoldmine, new int[0]);
                this.buyKnightIn(57);
                break;
            }
        }
    }

    private void playZonlor() {
    }

    private int getTeamID(int c) {
        int OwnerID = this.getOwnerID(c);
        int OwnerTeamID = this.ID2teamID[OwnerID];
        return OwnerTeamID;
    }

    private int getMyAttackValueAgainst(int c) {
        int total = 0;
        int cTeamID = this.getTeamID(c);
        for (int n = 0; n < this.N_Countries; ++n) {
            int neighborTeamID = this.getTeamID(n);
            if (cTeamID == neighborTeamID) continue;
            if (this.pathCost[n][c] == 1) {
                total += this.getMyAttackValueFrom(n);
            }
            if (this.pathCost[n][c] != 2) continue;
            total += this.getMyKnightAttackValueFrom(n);
        }
        return total;
    }

    private int getAttackValueFrom(int c) {
        int nInfantry = this.occupationTable[c][1] + this.occupationTable[c][5];
        int nKnight = this.occupationTable[c][2] + this.occupationTable[c][6];
        int total = nInfantry * this.infantryAttackValue + nKnight * this.knightAttackValue;
        return total;
    }

    private int getMyInfantryAttackValueFrom(int c) {
        int cOwnerID = this.occupationTable[c][0];
        int cTeamID = this.ID2teamID[cOwnerID];
        if (cTeamID != this.myTeamID) {
            return 0;
        }
        if (cOwnerID == this.ID) {
            int nInfantry = this.occupationTable[c][1];
            int total = nInfantry * this.infantryAttackValue;
            return total;
        }
        int nInfantry = this.occupationTable[c][5];
        int total = nInfantry * this.infantryAttackValue;
        return total;
    }

    private int getMyKnightAttackValueFrom(int c) {
        int cOwnerID = this.occupationTable[c][0];
        int cTeamID = this.ID2teamID[cOwnerID];
        if (cTeamID != this.myTeamID) {
            return 0;
        }
        if (cOwnerID == this.ID) {
            int nKnight = this.occupationTable[c][2];
            int total = nKnight * this.knightAttackValue;
            return total;
        }
        int nKnight = this.occupationTable[c][6];
        int total = nKnight * this.knightAttackValue;
        return total;
    }

    private int getMyAttackValueFrom(int c) {
        int total = this.getMyInfantryAttackValueFrom(c);
        return total += this.getMyKnightAttackValueFrom(c);
    }

    private int getKnightAttackValueFrom(int c) {
        int nKnight = this.occupationTable[c][2] + this.occupationTable[c][6];
        int total = nKnight * this.knightAttackValue;
        return total;
    }

    private int getOwnerID(int c) {
        Player player = this.Countries[c].getOwner();
        return player.getID();
    }

    private void makeCountriesBelongTo() {
        int i;
        for (i = 0; i < this.N_players; ++i) {
            this.CountriesBelongTo[i] = new ArrayList();
        }
        for (i = 0; i < this.N_Countries; ++i) {
            Player player = this.Countries[i].getOwner();
            int id = player.getID();
            this.CountriesBelongTo[id].add(new Integer(i));
        }
    }

    private void buyKnightIn(int c) {
        this.buyKnights(this.money, this.Countries[c]);
    }

    private void buyCastleFor(int c) {
        UnitCastle castle = new UnitCastle(this.world.getPlayer(this.ID));
        UnitStack castle2 = new UnitStack(castle, 1);
        this.world.placeUnits(castle2, this.Countries[c]);
    }

    private void move(String KnightOrInfantry, int from, int to) {
        this.move(this.infinity, KnightOrInfantry, from, to);
    }

    private void moveInto(int c) {
        this.moveInfantriesInto(c);
        this.moveKnightInto(c);
    }

    private void move(int from, int to) {
        this.move("Infantry", from, to);
        this.move("Knight", from, to);
    }

    private void moveInfantry(int from, int to) {
        this.move("Infantry", from, to);
    }

    private void moveInfantriesInto(int c) {
        int n = this.adjacencyList[c].length;
        for (int i = 0; i < n; ++i) {
            int neighbor = this.adjacencyList[c][i];
            this.move("Infantry", neighbor, c);
        }
    }

    private void moveKnight(int from, int to) {
        this.move("Knight", from, to);
    }

    private void moveKnightInto(int c) {
        for (int i = 0; i < this.N_Countries; ++i) {
            if (this.pathCost[i][c] >= 3) continue;
            this.move("Knight", i, c);
        }
    }

    private UnitStack getKnightOrInfantry(int c, int movement) {
        Country ct = this.Countries[c];
        UnitStackGroup CKIs = ct.getUnitStackGroup();
        int N_usg = CKIs.size();
        for (int s = 0; s < N_usg; ++s) {
            int m;
            UnitStack CKorI = CKIs.get(s);
            int ID2 = CKorI.getOwner().getID();
            if (ID2 != this.ID || (m = CKorI.getUnit().getMovement()) != movement) continue;
            return CKorI;
        }
        return null;
    }

    private UnitStack getKnight(int c) {
        return this.getKnightOrInfantry(c, 2);
    }

    private UnitStack getInfantry(int c) {
        return this.getKnightOrInfantry(c, 1);
    }

    private boolean enemyForceAt(int c) {
        if (this.friendly(c)) {
            return false;
        }
        int total = this.occupationTable[c][1] + this.occupationTable[c][2] + this.occupationTable[c][3] + this.occupationTable[c][5] + this.occupationTable[c][6];
        return total != 0;
    }

    private void makeOccupationTable() {
        this.occupationTable = new int[this.N_Countries][7];
        for (int c = 0; c < this.N_Countries; ++c) {
            int cOwnerID;
            Country ct = this.Countries[c];
            this.occupationTable[c][0] = cOwnerID = ct.getOwner().getID();
            UnitStackGroup IKCs = ct.getUnitStackGroup();
            int N_IKCs = IKCs.size();
            for (int s = 0; s < N_IKCs; ++s) {
                UnitStack IKorC = IKCs.get(s);
                Player player = IKorC.getOwner();
                int unitOwnerID = player.getID();
                int N_units = IKorC.getCount();
                String IKxorC = IKorC.getUnit().toString();
                if (cOwnerID == unitOwnerID) {
                    if (IKxorC.equals("Infantry")) {
                        this.occupationTable[c][1] = N_units;
                    }
                    if (IKxorC.equals("Knight")) {
                        this.occupationTable[c][2] = N_units;
                    }
                    if (!IKxorC.equals("Castle")) continue;
                    this.occupationTable[c][3] = 1;
                    continue;
                }
                this.occupationTable[c][4] = unitOwnerID;
                if (IKxorC.equals("Infantry")) {
                    this.occupationTable[c][5] = N_units;
                }
                if (!IKxorC.equals("Knight")) continue;
                this.occupationTable[c][6] = N_units;
            }
        }
        this.SitcaBridgeScastleIsMine = this.castleIsMine(this.SitcaBridgeS);
        this.CentralGoldmineCastleIsMine = this.castleIsMine(this.CentralGoldmine);
    }

    private boolean castleIsMine(int c) {
        return this.occupationTable[c][3] == 1 & this.occupationTable[c][0] == this.ID;
    }

    private boolean friendOwn(int c) {
        return this.occupationTable[c][0] == this.friendID;
    }

    private boolean friendly(int c) {
        if (this.Iown(c)) {
            return true;
        }
        return this.friendOwn(c);
    }

    private boolean friendly(int c1, int c2) {
        int owner1 = this.occupationTable[c1][0];
        int team1 = this.ID2teamID[owner1];
        int owner2 = this.occupationTable[c2][0];
        int team2 = this.ID2teamID[owner2];
        return team1 == team2;
    }

    private void wandering() {
        Country c;
        int i;
        List castleList = this.world.getCastleCountriesOwnedBy(this.ID);
        int n = castleList.size();
        if (n > 0) {
            i = this.rand.nextInt(n);
            c = (Country)castleList.get(i);
            this.buyUnitsAlternating(this.money, c);
        }
        for (i = 0; i < this.Countries.length; ++i) {
            c = this.Countries[i];
            UnitStackGroup usg = c.getUnitStackGroup();
            int IKCtotal = usg.getTotalUnitCount();
            Team team_i = c.getTeam();
            if (IKCtotal <= 0 || !team_i.equals(this.myTeam)) continue;
            Country ourCountry = c;
            int N_usg = usg.size();
            for (int j = N_usg - 1; j > -1; --j) {
                Country dir1;
                Country dir2;
                UnitStack us = usg.get(j);
                int ID2 = us.getOwner().getID();
                Unit usUnit = us.getUnit();
                int stepSize = usUnit.getMovement();
                if (ID2 != this.ID || stepSize <= 0) continue;
                Country moveTo = this.getRandomBorder(ourCountry);
                if (moveTo == null && (dir2 = this.directionToEnemy(dir1 = this.directionToEnemy(ourCountry))).equals(ourCountry)) {
                    moveTo = dir1;
                }
                int N_units = us.getCount();
                this.world.moveUnit(us, ourCountry, moveTo, N_units);
            }
        }
    }

    private int get1CastleOwnedBy(int ID) {
        List castleList = this.world.getCastleCountriesOwnedBy(ID);
        if (castleList.size() == 0) {
            return -1;
        }
        Country ct = (Country)castleList.get(0);
        return ct.getID();
    }

    private void buildShortestPathArray() {
        int k;
        int n;
        int c;
        int j;
        int i;
        this.edgeCost = new int[this.N_Countries][this.N_Countries];
        for (i = 0; i < this.N_Countries; ++i) {
            for (j = 0; j < this.N_Countries; ++j) {
                this.edgeCost[i][j] = this.infinity;
            }
            this.edgeCost[i][i] = 0;
        }
        this.adjacencyList = new int[this.N_Countries][];
        for (c = 0; c < this.N_Countries; ++c) {
            Country ct = this.Countries[c];
            List adjoiningList = ct.getAdjoiningList();
            n = adjoiningList.size();
            this.adjacencyList[c] = new int[n];
            for (j = 0; j < n; ++j) {
                Country ct2 = (Country)adjoiningList.get(j);
                k = ct2.getID();
                this.edgeCost[c][k] = 1;
                this.adjacencyList[c][j] = k;
            }
        }
        this.N_neighbors = new int[this.N_Countries];
        for (c = 0; c < this.N_Countries; ++c) {
            this.N_neighbors[c] = 0;
            for (j = 0; j < this.N_Countries; ++j) {
                if (this.edgeCost[c][j] != 1) continue;
                int n2 = c;
                this.N_neighbors[n2] = this.N_neighbors[n2] + 1;
            }
        }
        this.pathCost = new int[this.N_Countries][this.N_Countries];
        int[][] visitThru = new int[this.N_Countries][this.N_Countries];
        for (i = 0; i < this.N_Countries; ++i) {
            for (j = 0; j < this.N_Countries; ++j) {
                this.pathCost[i][j] = this.edgeCost[i][j];
                visitThru[i][j] = -1;
            }
        }
        for (k = 0; k < this.N_Countries; ++k) {
            for (i = 0; i < this.N_Countries; ++i) {
                for (j = 0; j < this.N_Countries; ++j) {
                    if (this.pathCost[i][k] + this.pathCost[k][j] >= this.pathCost[i][j]) continue;
                    this.pathCost[i][j] = this.pathCost[i][k] + this.pathCost[k][j];
                    visitThru[i][j] = k;
                }
            }
        }
        this.shortestPath = new int[this.N_Countries][this.N_Countries][];
        this.visitNext = new int[this.N_Countries][this.N_Countries];
        for (i = 0; i < this.N_Countries; ++i) {
            for (j = 0; j < this.N_Countries; ++j) {
                int next;
                if (i == j) {
                    this.visitNext[i][j] = i;
                    continue;
                }
                if (this.edgeCost[i][j] == 1) {
                    this.visitNext[i][j] = j;
                    continue;
                }
                String path = this.shortestPath(i, j, visitThru);
                path = path.replaceAll("^\\s+", "");
                int i2 = path.indexOf(" ");
                String nextS = path.substring(0, i2);
                this.visitNext[i][j] = next = Integer.valueOf(nextS).intValue();
                path = path.substring(i2);
                n = this.pathCost[i][j] - 1;
                this.shortestPath[i][j] = new int[n];
                this.shortestPath[i][j][0] = next;
                for (k = 1; k < n; ++k) {
                    path = path.replaceAll("^\\s+", "");
                    i2 = path.indexOf(" ");
                    nextS = path.substring(0, i2);
                    this.shortestPath[i][j][k] = next = Integer.valueOf(nextS).intValue();
                    path = path.substring(i2);
                }
            }
        }
    }

    private String shortestPath(int i, int j, int[][] visitThru) {
        int k = visitThru[i][j];
        if (k == -1) {
            return " ";
        }
        return this.shortestPath(i, k, visitThru) + " " + k + " " + this.shortestPath(k, j, visitThru);
    }

    public String name() {
        return "TonyAI";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "AI bot.";
    }

    public String youWon() {
        return "AI won.";
    }

    private boolean symmetric(int[][] matrix) {
        int n = matrix.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (matrix[i][j] == matrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    private void move(int N_units, String KnightOrInfantry, int from, int to) {
        UnitStack unitForce;
        if (from == to) {
            return;
        }
        Country ct = this.Countries[from];
        if (KnightOrInfantry.equals("Knight")) {
            int via;
            unitForce = this.getKnight(from);
            if (this.pathCost[from][to] == 2 && this.enemyForceAt(via = this.visitNext[from][to])) {
                to = via;
            }
        } else {
            unitForce = this.getInfantry(from);
        }
        if (unitForce == null) {
            return;
        }
        int ID2 = unitForce.getOwner().getID();
        if (ID2 != this.ID) {
            return;
        }
        if (N_units == this.infinity) {
            N_units = unitForce.getCount();
        }
        this.world.moveUnit(unitForce, ct, this.Countries[to], N_units);
    }
}

