/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox.agent;

import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.agent.VoxAgentBase;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class AI1
extends VoxAgentBase
implements VoxAgent {
    private String[] CountryNames;
    private String[] CountryNamesSorted;
    private int humanID = -1;
    private int humanFriendlyID = -1;
    private Country humanFriendlyCastle;
    private int humanCastleI;
    private int humanFriendlyCastleI;
    private int Round = 0;
    private Team humanTeamName;
    private Team myTeam;
    private int N_countries;
    private int N_players;
    private String AI1name;
    private Player humanFriendlyPlayer;
    private Player AI1player;
    private int stop;
    private Team team_i;
    private List castleList;
    private boolean[] IDisAI1Bot;
    private int[][] edgeCost;
    private int[][] pathCost;
    private int[][] visitThru;
    private int[] N_neighbors;
    private int[][] adjacencyList;
    private Random rand = new Random();

    private void Round1Init(Country[] countries) {
        int k;
        Country ct;
        int j;
        int i;
        int c;
        int infinity = 9999;
        this.N_players = this.world.getNumberOfPlayers();
        this.N_countries = countries.length;
        this.AI1name = this.world.getPlayer(this.ID).name();
        this.AI1player = this.world.getPlayer(this.ID);
        this.myTeam = this.world.getTeam(this.ID);
        this.IDisAI1Bot = new boolean[this.N_players];
        for (c = 0; c < this.N_players; ++c) {
            Player player_i = this.world.getPlayer(c);
            String name = player_i.getAgentType();
            if (name.equals("AI1")) {
                this.IDisAI1Bot[c] = true;
                continue;
            }
            boolean human = player_i.isHuman();
            if (!human) continue;
            this.humanTeamName = this.world.getTeam(c);
            this.humanID = c;
        }
        for (i = 0; i < this.N_players; ++i) {
            this.team_i = this.world.getTeam(i);
            if (this.humanID <= -1 || i == this.humanID || !this.team_i.equals(this.humanTeamName)) continue;
            this.humanFriendlyID = i;
            this.humanFriendlyPlayer = this.world.getPlayer(this.humanFriendlyID);
            break;
        }
        this.humanFriendlyCastleI = this.get1CastleOwnedBy(this.humanFriendlyID);
        this.humanCastleI = this.get1CastleOwnedBy(this.humanID);
        this.edgeCost = new int[this.N_countries][this.N_countries];
        for (c = 0; c < this.N_countries; ++c) {
            for (j = 0; j < this.N_countries; ++j) {
                this.edgeCost[c][j] = infinity;
            }
        }
        this.CountryNames = new String[this.N_countries];
        this.CountryNamesSorted = new String[this.N_countries];
        for (c = 0; c < this.N_countries; ++c) {
            ct = countries[c];
            int t1 = ct.getID();
            this.CountryNames[c] = ct.getName();
            this.CountryNamesSorted[c] = this.CountryNames[c] + ' ' + c;
            this.edgeCost[c][c] = 0;
        }
        Arrays.sort(this.CountryNamesSorted);
        this.adjacencyList = new int[this.N_countries][];
        for (c = 0; c < this.N_countries; ++c) {
            ct = countries[c];
            List adjoiningList = ct.getAdjoiningList();
            int n = adjoiningList.size();
            this.adjacencyList[c] = new int[n];
            for (j = 0; j < n; ++j) {
                Country ct2 = (Country)adjoiningList.get(j);
                k = ct2.getID();
                this.edgeCost[c][k] = 1;
                this.adjacencyList[c][j] = k;
            }
        }
        boolean t = this.symmetric(this.edgeCost);
        this.N_neighbors = new int[this.N_countries];
        for (c = 0; c < this.N_countries; ++c) {
            this.N_neighbors[c] = 0;
            for (j = 0; j < this.N_countries; ++j) {
                if (this.edgeCost[c][j] != 1) continue;
                int n = c;
                this.N_neighbors[n] = this.N_neighbors[n] + 1;
            }
        }
        this.pathCost = new int[this.N_countries][this.N_countries];
        this.visitThru = new int[this.N_countries][this.N_countries];
        for (int c1 = 0; c1 < this.N_countries; ++c1) {
            for (int c2 = 0; c2 < this.N_countries; ++c2) {
                this.pathCost[c1][c2] = this.edgeCost[c1][c2];
                this.visitThru[c1][c2] = -1;
            }
        }
        for (k = 0; k < this.N_countries; ++k) {
            for (i = 0; i < this.N_countries; ++i) {
                for (j = 0; j < this.N_countries; ++j) {
                    if (this.pathCost[i][k] + this.pathCost[k][j] >= this.pathCost[i][j]) continue;
                    this.pathCost[i][j] = this.pathCost[i][k] + this.pathCost[k][j];
                    this.visitThru[i][j] = k;
                }
            }
        }
    }

    private int get1CastleOwnedBy(int ID) {
        this.castleList = this.world.getCastleCountriesOwnedBy(ID);
        Country ct = (Country)this.castleList.get(0);
        return ct.getID();
    }

    private String shortestPath(int i, int j) {
        int k = this.visitThru[i][j];
        if (k == -1) {
            return " ";
        }
        return this.shortestPath(i, k) + " " + k + " " + this.shortestPath(k, j);
    }

    private boolean symmetric(int[][] matrix) {
        int n = matrix.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (matrix[i][j] == matrix[j][i]) continue;
                return false;
            }
        }
        return true;
    }

    public void declareMoves(Country[] countries) {
        ++this.Round;
        int money = this.world.getPlayerMoney(this.ID);
        if (this.Round == 1) {
            this.Round1Init(countries);
            Country castle = this.getStrongestBase();
            this.buyKnights(money, castle);
            return;
        }
        if (this.humanID > -1 && this.myTeam.equals(this.humanTeamName)) {
            return;
        }
        money = this.world.getPlayerMoney(this.ID);
        Country castle = this.getStrongestBase();
        if (castle != null) {
            this.buyKnights(money, castle);
        }
        for (int from_c = 0; from_c < this.N_countries; ++from_c) {
            Country ct = countries[from_c];
            UnitStackGroup usg = ct.getUnitStackGroup();
            int IKCtotal = usg.getTotalUnitCount();
            this.team_i = ct.getTeam();
            if (IKCtotal <= 0 || !this.team_i.equals(this.myTeam)) continue;
            int N_usg = usg.size();
            for (int s = N_usg - 1; s > -1; --s) {
                int next_c;
                UnitStack us = usg.get(s);
                int ID2 = us.getOwner().getID();
                Unit usUnit = us.getUnit();
                int m = usUnit.getMovement();
                if (ID2 != this.ID || m <= 0) continue;
                Player player = countries[this.humanFriendlyCastleI].getOwner();
                if (player.equals(this.humanFriendlyPlayer)) {
                    next_c = this.visitNext(from_c, this.humanFriendlyCastleI);
                } else {
                    player = countries[this.humanCastleI].getOwner();
                    int id = player.getID();
                    if (id == this.humanID) {
                        next_c = this.visitNext(from_c, this.humanCastleI);
                    } else {
                        Country moveTo = this.getRandomEnemyBorder(countries[from_c]);
                        if (moveTo == null) {
                            moveTo = this.getRandomBorder(countries[from_c]);
                        }
                        next_c = moveTo.getID();
                    }
                }
                int N_units = us.getCount();
                this.world.moveUnit(us, ct, countries[next_c], N_units);
            }
        }
    }

    private int visitNext(int from, int to) {
        if (this.edgeCost[from][to] == 1) {
            return to;
        }
        String path = this.shortestPath(from, to);
        path = path.replaceAll("^\\s+", "");
        int i = path.indexOf(" ");
        String ct = path.substring(0, i);
        return Integer.valueOf(ct);
    }

    public String name() {
        return "AI1";
    }

    public float version() {
        return 1.0f;
    }

    public String description() {
        return "AI1 bot.";
    }

    public String youWon() {
        return "AI won.";
    }
}

