/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Visuals;
import com.sillysoft.vox.VoxClient;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;

public class WidthBar
extends JComponent {
    public static final int BOTTOM_BAR_HEIGHT = 34;
    private static Image shine;
    protected boolean colorsAreSet;
    protected boolean showTimer;
    private int usableTurnBoxWidth;
    private int currentPlayer;
    private Color[] colors;
    private float[] widths;
    private VoxClient control;
    private int secondsLeft;
    private static int timerWidth;

    public WidthBar(int width, int height, VoxClient control) {
        this.setSize(width, height);
        this.control = control;
        if ((int)this.bounds().getHeight() != 34) {
            SS.debug("WARNING: widthBar.getHeight() != BOTTOM_BAR_HEIGHT");
        }
        this.colorsAreSet = false;
        this.currentPlayer = 0;
        this.usableTurnBoxWidth = width;
        if (this.gameUsesTimer()) {
            this.usableTurnBoxWidth -= timerWidth;
        }
        if (shine == null) {
            shine = GraphicsTool.getImageFromJAR("shine.png");
        }
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
        this.colorsAreSet = true;
        this.widths = new float[colors.length];
        this.setToolTipText("tooltip");
    }

    public String turnTimeString() {
        int hours = this.secondsLeft / 3600;
        int minutes = this.secondsLeft % 3600 / 60;
        int seconds = this.secondsLeft % 60;
        if (hours == 0) {
            return "Turn Timer: " + minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
        }
        return "Turn Timer: " + hours + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (seconds < 10 ? "0" : "") + seconds;
    }

    public String getToolTipText(MouseEvent event) {
        int widthSoFar;
        int x = event.getPoint().x;
        int n = widthSoFar = this.gameUsesTimer() ? timerWidth + 3 : 3;
        if (x < widthSoFar) {
            return this.gameUsesTimer() ? this.turnTimeString() : "Player Strength Bar";
        }
        for (int i = 0; i < this.widths.length; ++i) {
            if (x >= (widthSoFar = (int)((float)widthSoFar + this.widths[i]))) continue;
            Player p = this.control.getPlayer(i);
            return p.getTeam().getSymbol() + " " + (i == 0 ? "neutrals" : p.getName()) + (p.isHuman() ? " - " + p.getBrain() : "");
        }
        return "Player Strength Bar";
    }

    public void gotoPlayer(int player) {
        this.currentPlayer = player;
        this.repaintColors();
    }

    public void resetPlayer() {
        this.currentPlayer = 0;
        this.repaintColors();
    }

    public void clearView() {
        this.colorsAreSet = false;
        this.currentPlayer = 0;
        this.repaint();
    }

    void kill() {
        this.control = null;
    }

    public void paintComponent(Graphics badg) {
        Graphics2D g = (Graphics2D)badg;
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.BLACK);
        g.fill(g.getClipBounds());
        if (this.colorsAreSet) {
            int startingX;
            int x = startingX = this.gameUsesTimer() ? timerWidth + 3 : 3;
            for (int i = 0; i < this.widths.length; ++i) {
                if (!((double)this.widths[i] > 0.001)) continue;
                g.setColor(this.colors[i]);
                g.fillRect(x, 3, (int)Math.ceil(this.widths[i]), 28);
                x += (int)Math.ceil(this.widths[i]);
            }
            if (x != startingX && x < this.usableTurnBoxWidth + startingX) {
                g.fillRect(x, 3, this.usableTurnBoxWidth + startingX, 28);
            }
            g.drawImage(shine, startingX, 1, this.usableTurnBoxWidth + startingX, 32, null);
            if (this.gameUsesTimer() && this.showTimer) {
                this.secondsLeft = this.control.getTurnSecondsLeft();
                if (this.secondsLeft < 0) {
                    this.secondsLeft = 0;
                }
                if (this.secondsLeft != 0) {
                    g.setFont(Visuals.arial24);
                    g.setColor(Color.RED);
                    if (this.secondsLeft < 10) {
                        g.drawString(this.secondsLeft + "s", 10, 25);
                    } else if (this.secondsLeft < 100) {
                        g.drawString(this.secondsLeft + "s", 6, 25);
                    } else if (this.secondsLeft > 5400) {
                        float hours = Math.round((double)this.secondsLeft / 3600.0);
                        if (hours < 10.0f) {
                            g.drawString((int)hours + "H", 7, 25);
                        } else {
                            g.drawString((int)hours + "H", 3, 25);
                        }
                    } else {
                        float minutes = Math.round((double)this.secondsLeft / 60.0);
                        if (minutes < 10.0f) {
                            g.drawString((int)minutes + "m", 7, 25);
                        } else {
                            g.drawString((int)minutes + "m", 1, 25);
                        }
                    }
                }
            }
        }
    }

    protected void calculateWidths() {
        int i;
        for (int i2 = 0; i2 < this.widths.length; ++i2) {
            this.widths[i2] = 0.0f;
        }
        int divideBy = 0;
        for (i = 0; i < this.widths.length; ++i) {
            this.widths[i] = this.control.stats == null ? 0.0f : (float)(this.control.stats.getArmies(i) + this.control.stats.getOwned(i) + this.control.stats.getIncome(i));
            divideBy = (int)((float)divideBy + this.widths[i]);
        }
        i = 0;
        while (i < this.widths.length) {
            int n = i++;
            this.widths[n] = this.widths[n] * ((float)this.usableTurnBoxWidth / (float)Math.max(1, divideBy));
        }
    }

    public void recacheWidth() {
        int width = this.getWidth();
        this.setPreferredSize(new Dimension(width, 34));
        super.setSize(width, 34);
        this.usableTurnBoxWidth = width;
        if (this.gameUsesTimer()) {
            this.usableTurnBoxWidth -= timerWidth;
        }
        this.repaint();
    }

    public void setSize(int width, int height) {
        this.setPreferredSize(new Dimension(width, 34));
        super.setSize(width, 34);
    }

    public Dimension getMaximumSize() {
        Dimension parent = super.getMaximumSize();
        return new Dimension((int)parent.getWidth(), 34);
    }

    public void repaintColors() {
        this.repaint(0L, 0, 0, this.usableTurnBoxWidth + 50, 34);
    }

    public boolean isOpaque() {
        return true;
    }

    private boolean gameUsesTimer() {
        return this.control != null && this.control.ops != null && this.control.ops.useTurnTimer;
    }

    public void showTimer(boolean value) {
        this.showTimer = value;
    }

    static {
        timerWidth = 45;
    }
}

