/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.vox.Board;
import com.sillysoft.vox.Continent;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.CountryPathFinder;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.SSClassLoaderVox;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitPack;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.Vox;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxWorldManager;
import com.sillysoft.vox.agent.Boring;
import com.sillysoft.vox.agent.VoxAgent;
import com.sillysoft.vox.command.BuildCommand;
import com.sillysoft.vox.command.Command;
import com.sillysoft.vox.command.MoveCommand;
import com.sillysoft.vox.unit.UnitAbstract;
import com.sillysoft.vox.unit.UnitCastle;
import com.sillysoft.vox.unit.UnitKnight;
import com.sillysoft.vox.unit.UnitPawn;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class VoxWorld {
    public static final Random rand = new Random();
    private VoxWorldManager manager;
    private List players;
    private int[] playerMoney;
    private int[] playerResearch;
    private List[] playerBuyableUnits;
    protected List countries;
    protected List continents;
    List orderedCountries = null;
    private List commandList = new Vector();
    int playerID = -1;
    public CountryPathFinder pathFinder = new CountryPathFinder();
    VoxAgent agent;
    int[] agentsIncomes;
    UnitStackGroup[] agentsBoughtUnits;
    Board board;
    int roundCount = 0;
    boolean killed = false;
    boolean allHumansAreDead = false;
    protected boolean visualWorld = false;
    private boolean airAttackInProgress = false;
    private Country airAttackFrom = null;
    private Country airAttackTo = null;
    private MoveCommand airAttackComand = null;
    private UnitStackGroup landingPattern = new UnitStackGroup();

    public VoxWorld(VoxWorldManager parent, int playerID) {
        this.manager = parent;
        this.playerID = playerID;
    }

    void setCountries(List countries) {
        this.countries = countries;
    }

    void setContinents(List data) {
        this.continents = data;
    }

    void setPlayers(List players) {
        this.players = players;
        this.playerMoney = new int[players.size()];
        this.playerResearch = new int[players.size()];
        this.playerBuyableUnits = new List[players.size()];
        this.allHumansAreDead = false;
    }

    protected void setupBot(Player p) {
        this.board = new Board(this);
        this.board.setCountries(this.countries);
        this.board.finished();
        if (p.isHuman()) {
            this.agent = new Boring();
        } else {
            String agentString = p.getAgentType();
            if (agentString != null) {
                this.agent = SSClassLoaderVox.getVoxAgentNamed(agentString);
            }
        }
        if (this.agent == null) {
            this.agent = new Boring();
        }
        this.agent.setPrefs(this.playerID, this);
        SS.debug("setupBot: " + p.getAgentType() + " named " + p.getName(), 1);
    }

    public List getCountries() {
        return this.countries;
    }

    public Country getCountry(int ID) {
        return (Country)this.countries.get(ID);
    }

    public boolean airAttackInProgress() {
        return this.airAttackInProgress;
    }

    public void clearAirAttackInProgress() {
        this.undoCommand(this.airAttackComand);
        this.airAttackInProgress = false;
        this.airAttackFrom = null;
        this.airAttackTo = null;
        this.airAttackComand = null;
    }

    public Country getAirAttackTo() {
        return this.airAttackTo;
    }

    public boolean moveUnit(UnitStack ug, Country from, Country to, int numberOfUnits) {
        if (from == null || to == null) {
            SS.debug("Cannot moveUnit with a null Country!  " + ug + " from:" + from + " to:" + to);
            return false;
        }
        if (numberOfUnits < 1) {
            SS.debug("Cannot moveUnit with a number of " + numberOfUnits + " " + ug + " from:" + from + " to:" + to);
            return false;
        }
        Country fromLocal = from;
        Country toLocal = to;
        from = this.countryWithID(from.getID());
        to = this.countryWithID(to.getID());
        Unit unit = ug.getUnit();
        if (from.equals(to)) {
            SS.debug("Cannot moveUnit to the same country it's already on");
            return true;
        }
        if (!this.unitCanReach(ug, from, to)) {
            if (this.visualWorld) {
                VoxClient.invalidSound.play();
            }
            SS.debug("Those units cannot move that far. Tried to move " + ug + " from " + from + " to " + to);
            return true;
        }
        if (!unit.isWater() && to.isWater()) {
            SS.debug("Land units cannot move into water. You must load them onto a transport.");
            return true;
        }
        if ((numberOfUnits = Math.min(numberOfUnits, ug.getCount())) == 0) {
            return false;
        }
        if (unit.isWater() && !to.isWater()) {
            SS.debug("Water to land not implemented yet.");
            return true;
        }
        for (int i = 0; i < this.commandList.size(); ++i) {
            MoveCommand command;
            if (!(this.commandList.get(i) instanceof MoveCommand) || (command = (MoveCommand)this.commandList.get(i)).fromCountry() != from.getID() || command.toCountry() != to.getID() || command.getUnit().getType() != ug.getUnit().getType() || command.getOwner() != ug.getOwner()) continue;
            if (this.visualWorld) {
                VoxClient.clickSound.play();
            }
            command.addUnits(this, new UnitStack(ug.getUnit(), numberOfUnits), ug.getCarriedUnits());
            return ug.getCount() > 0;
        }
        UnitStack moving = new UnitStack(ug.getUnit(), numberOfUnits, ug.getOriginalCountryID(), ug.getCarriedUnits(), ug.getCarriedUnitsAir(), ug.getCarriedUnitsMissiles());
        moving.setDrawPoint(ug.getDrawPoint());
        MoveCommand com = new MoveCommand(moving, from, to);
        this.addCommand(com);
        if (this.visualWorld) {
            if (moving.getTeam().equals(to.getTeam())) {
                VoxClient.defendSound.play();
            } else {
                VoxClient.attackSound.play();
            }
        }
        return ug.getCount() > 0;
    }

    public int getNumberOfUnits(int totalUnits, boolean shift, boolean control, boolean alt, boolean meta) {
        int numberOfUnits = 1;
        if (shift) {
            numberOfUnits = totalUnits;
        } else if (alt) {
            numberOfUnits = Math.min(10, totalUnits);
        } else if (control || meta) {
            numberOfUnits = Math.min(5, totalUnits);
        }
        return numberOfUnits;
    }

    public boolean loadTransport(UnitStack ug, UnitStack transport, int from, int to, int numberOfUnits) {
        return this.loadTransport(ug, transport, this.countryWithID(from), this.countryWithID(to), numberOfUnits);
    }

    public boolean loadTransport(UnitStack ug, UnitStack transport, Country from, Country to, int numberOfUnits) {
        if (ug.isWater()) {
            return true;
        }
        numberOfUnits = Math.min(numberOfUnits, ug.getCount());
        int roomOnTransport = transport.getRemainingCarryCapacity();
        if (ug.expiresAfterAttack()) {
            roomOnTransport = transport.getRemainingCarryCapacityMissiles();
        } else if (ug.isAir()) {
            roomOnTransport = transport.getRemainingCarryCapacityAir();
        }
        int maxUnitsCanLoad = roomOnTransport / ug.getUnit().transportWeight();
        numberOfUnits = Math.min(numberOfUnits, maxUnitsCanLoad);
        if (numberOfUnits == 0) {
            SS.debug("You cannot load those units on this transport");
            return true;
        }
        if (from != to && !this.unitCanReach(ug, from, to)) {
            SS.debug("Unit cannot reach the transport");
            return true;
        }
        return ug.getCount() > 0;
    }

    protected void clearCommands() {
        this.commandList = new Vector();
    }

    protected Rectangle clearCommands(Country target) {
        Rectangle bounds = new Rectangle();
        for (int i = this.commandList.size() - 1; i > -1; --i) {
            Command c = (Command)this.commandList.get(i);
            if (c.toCountry() != target.getID()) continue;
            this.commandList.remove(c);
            bounds = bounds.union(c.getBounds());
        }
        return bounds;
    }

    public List getCommands() {
        if (this.commandList == null) {
            return new ArrayList();
        }
        return this.commandList;
    }

    public boolean hasBuildCommands() {
        if (this.commandList == null) {
            return false;
        }
        for (int i = 0; i < this.commandList.size(); ++i) {
            if (!(this.commandList.get(i) instanceof BuildCommand)) continue;
            return true;
        }
        return false;
    }

    private void addCommand(Command com) {
        try {
            com.execute(this);
            this.commandList.add(com);
        }
        catch (Exception e) {
            SS.debug("*****");
            SS.debug("World AddCommand failed (ID " + this.playerID + " " + this.manager + "): " + com);
            SS.debug(" -> " + e.getMessage());
            e.printStackTrace();
            SS.debug("*****");
        }
    }

    public void debugCountryUnits(String identifier) {
        SS.debug("** debugCountryUnits " + identifier + " **");
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (c.getUnitStackGroup().size() <= 0) continue;
            SS.debug(c.toStringWithUnits());
        }
        SS.debug("** end debugCountryUnits " + identifier + " **");
    }

    protected void addCommands(List commands) {
        if (commands == null) {
            return;
        }
        for (int i = 0; i < commands.size(); ++i) {
            if (this.commandList.contains(commands.get(i))) continue;
            this.addCommand((Command)commands.get(i));
        }
    }

    public Command undoCommand() {
        if (this.commandList == null || this.commandList.size() == 0) {
            return null;
        }
        Command lastCommand = (Command)this.commandList.get(this.commandList.size() - 1);
        this.undoCommand(lastCommand);
        return lastCommand;
    }

    public void undoCommand(Command com) {
        SS.debug("UndoCommand: " + com, 1);
        com.undo(this);
        this.commandList.remove(com);
        if (com instanceof BuildCommand) {
            this.manager.refreshBuyPanel(null);
        }
    }

    protected void undoAllCommands(Player p) {
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command com = (Command)this.commandList.get(i);
            if (!com.getOwner().equals(p)) continue;
            this.undoCommand(com);
            --i;
        }
    }

    protected boolean hasCommandsFrom(Player p) {
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command com = (Command)this.commandList.get(i);
            if (!com.getOwner().equals(p)) continue;
            return true;
        }
        return false;
    }

    protected void undoAllBuilds(Player p) {
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command com = (Command)this.commandList.get(i);
            if (!com.getOwner().equals(p) || !(com instanceof BuildCommand)) continue;
            this.undoCommand(com);
            --i;
        }
    }

    public boolean placeUnits(UnitStack us, Country c) {
        return this.placeUnits(us, c, us.getCount());
    }

    public boolean placeUnits(UnitStack us, Country c, int numberOfUnits) {
        Player owner = us.getOwner();
        if (numberOfUnits < 1) {
            SS.debug(owner.getName() + "-" + owner.getAgentType() + " is trying to build " + numberOfUnits + " units of " + us.getUnit() + " in " + c + " ???");
            return true;
        }
        SS.debug("placeUnits: " + numberOfUnits + " of " + us + ", on " + c + ", ", 2);
        StringBuffer errorMessage = new StringBuffer();
        if (!c.canBuildUnits(us, errorMessage)) {
            if (this.visualWorld) {
                VoxClient.invalidSound.play();
            }
            this.manager.showNotice(errorMessage.toString(), c.getCenter(), 5000L);
            return true;
        }
        int maxBuild = this.maxBuildable(c, owner);
        numberOfUnits = Math.min(numberOfUnits, maxBuild);
        int moneyLeft = this.getPlayerMoney(owner.getID());
        if ((numberOfUnits = Math.min(numberOfUnits, moneyLeft / us.getUnit().getCost())) < 1) {
            if (this.manager.isHuman(owner.getID())) {
                this.manager.showNotice("This castle is already building its \nmaximum capacity for this turn", c.getCenter(), 5000L);
            } else {
                SS.debug(owner.getName() + "-" + owner.getAgentType() + " is trying to build over capacity on castle in " + c);
            }
            return true;
        }
        UnitStack units = new UnitStack(us.getUnit(), numberOfUnits);
        for (int i = 0; i < this.commandList.size(); ++i) {
            BuildCommand command;
            if (!(this.commandList.get(i) instanceof BuildCommand) || (command = (BuildCommand)this.commandList.get(i)).toCountry() != c.getID() || command.getUnit().getType() != us.getUnit().getType() || command.getOwner() != owner) continue;
            if (us.getUnit().isFort() || us.getUnit().isCastle()) {
                return true;
            }
            us.setCount(us.getCount() - numberOfUnits);
            command.addUnits(this, units);
            return us.getCount() > 0;
        }
        int leftForVisuals = Math.max(us.getCount() - numberOfUnits, 0);
        us.setCount(leftForVisuals);
        BuildCommand com = new BuildCommand(units, c);
        this.addCommand(com);
        return us.getCount() > 0;
    }

    public int maxBuildable(Country c, Player owner) {
        return 1000000;
    }

    protected int getNumberOfUnitsBuilding(Country c, Player owner) {
        int building = 0;
        for (int i = 0; i < this.commandList.size(); ++i) {
            BuildCommand command;
            if (!(this.commandList.get(i) instanceof BuildCommand) || (command = (BuildCommand)this.commandList.get(i)).toCountry() != c.getID() || !command.getOwner().equals(owner)) continue;
            building += command.getUnitCount();
        }
        return building;
    }

    protected void replacePlayerUnitTypes(Player p, String oldType, String newType) {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            c.replacePlayerUnitTypes(p, oldType, newType);
        }
        List buyable = this.getBuyableUnitsForPlayer(p);
        for (int i = 0; i < buyable.size(); ++i) {
            Unit u = (Unit)buyable.get(i);
            if (!u.getShortString().equalsIgnoreCase(oldType)) continue;
            buyable.remove(i);
            buyable.add(i, UnitPack.createUnitSafe(newType, p));
        }
    }

    protected void setUnitOriginalCountries() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            c.setUnitOriginalCountries();
        }
    }

    protected void resolveNavalBuildBattles() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.isWater() || !this.hasBattle(c)) continue;
            SS.debug("Naval build battle in country " + c);
            this.resolveBattlesInCountry(c);
        }
    }

    List getCountriesOrderedGeographically() {
        if (this.orderedCountries == null) {
            this.orderedCountries = new ArrayList();
            this.orderedCountries.addAll(this.countries);
            boolean changeMade = true;
            while (changeMade) {
                changeMade = false;
                for (int i = 0; i < this.orderedCountries.size() - 1; ++i) {
                    Country c = (Country)this.orderedCountries.get(i);
                    Country c2 = (Country)this.orderedCountries.get(i + 1);
                    if (!((double)c.getBounds().x + (double)c.getBounds().y / 7.0 > (double)c2.getBounds().x + (double)c2.getBounds().y / 7.0)) continue;
                    Country move = c;
                    this.orderedCountries.remove(move);
                    this.orderedCountries.add(i + 1, move);
                    changeMade = true;
                }
            }
        }
        return this.orderedCountries;
    }

    protected void resolveBattles() {
        List orderedCountries = this.getCountriesOrderedGeographically();
        for (int i = 0; i < orderedCountries.size() && !this.killed; ++i) {
            Country c = (Country)orderedCountries.get(i);
            this.resolveBattlesInCountry(c);
        }
        if (!this.allHumansAreDead) {
            this.allHumansAreDead = true;
            for (int p = 0; p < this.players.size(); ++p) {
                if (!this.getPlayer(p).isHuman() || this.getPlayerArmyCount(p) <= 0) continue;
                this.allHumansAreDead = false;
            }
        }
    }

    protected void landAirUnits() {
        while (this.landingPattern.size() > 0) {
            UnitStack us = this.landingPattern.remove(0);
            Country c = this.countryWithID(us.getLandingCountryID());
            SS.debug("Landing units " + us + " in " + c);
            if (c == null) {
                SS.debug("XXXX NO LANDING COUNTRY FOR units " + us + " -> DESTROYED");
                continue;
            }
            if (c.isWater()) {
                UnitStackGroup ugs = c.getUnitStackGroup();
                boolean landedOnCarrier = false;
                for (int u = 0; u < ugs.size() && !landedOnCarrier; ++u) {
                    UnitStack carrierTest = ugs.get(u);
                    if (!carrierTest.getTeam().equals(us.getTeam()) || carrierTest.getRemainingCarryCapacityAir() < us.getUnit().transportWeight()) continue;
                    SS.debug(" -> Landing units " + us + " on a carrier in " + c);
                    carrierTest.addCarry(us);
                }
                if (landedOnCarrier) continue;
                SS.debug(" -> Landing units has no carrier here to land on -> they have sunk =( in " + c);
                continue;
            }
            if (c.getTeam().equals(us.getTeam())) {
                c.addUnitStack(us);
                c.consolidateUnits();
                continue;
            }
            Country bestLandingSpot = null;
            int bestLandingStrength = -1;
            List borders = c.getAdjoiningList();
            for (int i = 0; i < borders.size(); ++i) {
                Country test = (Country)borders.get(i);
                if (test.isWater() || !test.getTeam().equals(us.getTeam()) || test.getUnitStackGroup().getTotalUnitCount() <= bestLandingStrength) continue;
                bestLandingSpot = test;
                bestLandingStrength = test.getUnitStackGroup().getTotalUnitCount();
            }
            if (bestLandingSpot != null) {
                SS.debug(" --> units couldn't land in that spot, but were diverted to " + bestLandingSpot);
                bestLandingSpot.addUnitStack(us);
                bestLandingSpot.consolidateUnits();
                continue;
            }
            SS.debug(" --> units couldn't land in that spot, and could not be diverted. They were destroyed");
        }
    }

    private void resolveBattlesInCountry(Country c) {
        boolean hasBattle = this.hasBattle(c);
        boolean castleConquered = false;
        UnitStackGroup defenders = this.getDefendersUnitStackGroup(c);
        List attackerList = this.getAttackerUnitStackGroups(c);
        int numberTeamsInvolved = attackerList.size();
        if (defenders.getTotalUnitCount() > 0) {
            ++numberTeamsInvolved;
        }
        UnitStackGroup lastTurnDefenders = c.getUnitStackGroup();
        if (hasBattle) {
            boolean hasFort = c.hasFort();
            boolean hasCastle = c.hasCastle();
            boolean firstRound = true;
            while (defenders.getTotalUnitCount() > 0 && attackerList.size() > 0) {
                UnitStackGroup ugl;
                int a;
                SS.debug("runBattleInCountry round in " + c + ", \n\tdefenders=" + defenders + ", \n\tattackers=" + attackerList, 3);
                int attackersKilled = 0;
                int[] defendersKilledPerTeam = new int[attackerList.size()];
                attackersKilled = defenders.calculateDiceRollKills(false);
                if (hasFort) {
                    attackersKilled *= 2;
                }
                for (a = 0; a < attackerList.size(); ++a) {
                    defendersKilledPerTeam[a] = ((UnitStackGroup)attackerList.get(a)).calculateDiceRollKills(true);
                }
                SS.debug(" --> All attackers combined kills " + ArrayTool.sum(defendersKilledPerTeam) + " units. Defend kills " + attackersKilled + " units.", 3);
                while (attackersKilled > 0 && attackerList.size() > 0) {
                    for (a = 0; a < attackerList.size() && attackersKilled > 0; ++a) {
                        ugl = (UnitStackGroup)attackerList.get(a);
                        ugl.killUnits(1);
                        this.manager.orderExplosion(this.playerID, c.getID());
                        --attackersKilled;
                        if (ugl.getTotalUnitCount() != 0) continue;
                        attackerList.remove(ugl);
                        --a;
                    }
                }
                for (a = 0; a < attackerList.size(); ++a) {
                    ugl = (UnitStackGroup)attackerList.get(a);
                    ugl.removeExpireAfterAttackUnits();
                    if (ugl.getTotalUnitCount() >= 1) continue;
                    attackerList.remove(ugl);
                    --a;
                }
                if (defenders.getTotalUnitCount() > 0) {
                    SS.debug(" ----> killing " + ArrayTool.sum(defendersKilledPerTeam) + " units from the defenders", 3);
                    defenders.killUnits(ArrayTool.sum(defendersKilledPerTeam));
                    this.manager.orderExplosion(this.playerID, c.getID());
                    this.manager.orderExplosion(this.playerID, c.getID());
                    this.manager.orderExplosion(this.playerID, c.getID());
                } else {
                    SS.debug(" ----> there are no defenders left", 3);
                    if (attackerList.size() > 1) {
                        SS.debug(" ----> multiple attacker teams must fight", 3);
                        this.resolveMultipleAttackerBattle(c, attackerList);
                        return;
                    }
                }
                firstRound = false;
            }
            if (defenders.getTotalUnitCount() > 0) {
                SS.debug("Battle in country " + c + ": Defenders fought them off", 3);
                c.setNewUnits(defenders);
            } else if (attackerList.size() > 1) {
                SS.debug(" ----> Multi-attacker fight starting", 3);
                this.resolveMultipleAttackerBattle(c, attackerList);
            } else if (attackerList.size() == 1) {
                UnitStackGroup usg = (UnitStackGroup)attackerList.get(0);
                SS.debug("Battle in country " + c + ": won by attacker " + usg.getDominantOwner(), 3);
                SS.debug("Winning units: " + attackerList.get(0), 3);
                c.setNewUnits(usg);
                if (usg.size() > 0) {
                    c.setOwner(usg.getDominantOwner());
                }
            } else {
                SS.debug("Battle in country " + c + " everyone killed each other off", 3);
                c.setNewUnits(new UnitStackGroup());
            }
            if (hasCastle && !c.hasCastle()) {
                if (c.getUnitStackGroup().getTotalUnitCount() > 0) {
                    castleConquered = true;
                }
                c.addUnits(new UnitCastle(c.getOwner()), 1);
                c.initialUnitSanityCheck();
            }
            c.flashing = false;
            this.sleep(this.battleDelay());
        } else {
            c.setNewUnits(defenders);
            if (lastTurnDefenders.getTotalUnitCount() != defenders.getTotalUnitCount()) {
                this.sleep(this.battleDelay() / 2);
            }
        }
        this.buildUnitsInCountry(c);
        this.manager.updateCountry(c, castleConquered);
    }

    private void buildUnitsInCountry(Country buildSpot) {
        for (int c = 0; c < this.commandList.size(); ++c) {
            BuildCommand command;
            UnitStackGroup ugs;
            if (!(this.commandList.get(c) instanceof BuildCommand) || (ugs = (command = (BuildCommand)this.commandList.get(c)).unitsToBuildInCountry(buildSpot)) == null) continue;
            if (buildSpot.getTeam().equals(ugs.getTeam())) {
                buildSpot.addUnitStack(ugs);
                boolean castleBuilt = false;
                if (ugs.hasCastle()) {
                    castleBuilt = true;
                    SS.debug(buildSpot + " building a castle: " + ugs);
                    this.manager.updateCountry(buildSpot, castleBuilt, true);
                    continue;
                }
                this.manager.updateCountry(buildSpot, castleBuilt);
                continue;
            }
            SS.debug(buildSpot + "Castle was taken over while recruiting. Lost units: " + ugs);
        }
    }

    public void sleep(long delay) {
        if (Vox.superfast) {
            return;
        }
        if (delay < 1L) {
            return;
        }
        try {
            Thread.sleep(delay);
        }
        catch (Exception e) {
            SS.debug("VoxWorld.sleep exception: " + e);
        }
    }

    private boolean listContainsEnemyUnits(List attackerList, Player friend) {
        for (int a = 0; a < attackerList.size(); ++a) {
            UnitStackGroup ugl = (UnitStackGroup)attackerList.get(a);
            if (ugl.getTotalUnitCount() <= 0 || ugl.getDominantOwner().getTeam().equals(friend.getTeam())) continue;
            return true;
        }
        return false;
    }

    private void resolveMultipleAttackerBattle(Country c, List attackerList) {
        int a;
        SS.debug("resolveMultipleAttackerBattle with " + attackerList, 1);
        int[] killsPerTeam = new int[attackerList.size()];
        Player[] owner = new Player[attackerList.size()];
        for (a = 0; a < attackerList.size(); ++a) {
            killsPerTeam[a] = ((UnitStackGroup)attackerList.get(a)).calculateDiceRollKills(true);
            owner[a] = ((UnitStackGroup)attackerList.get(a)).getDominantOwner();
        }
        for (a = 0; a < attackerList.size(); ++a) {
            SS.debug("resolveMultipleAttackerBattle attacker " + ((UnitStackGroup)attackerList.get(a)).getDominantOwner() + " kills " + killsPerTeam[a] + " units", 1);
            if (killsPerTeam[a] <= 0) continue;
            int killFromID = rand.nextInt(attackerList.size());
            while (killsPerTeam[a] > 0 && this.listContainsEnemyUnits(attackerList, owner[a])) {
                UnitStackGroup ugl;
                if (a != killFromID && (ugl = (UnitStackGroup)attackerList.get(killFromID)).getTotalUnitCount() > 0) {
                    ugl.killUnits(1);
                    int n = a;
                    killsPerTeam[n] = killsPerTeam[n] - 1;
                }
                if (++killFromID != attackerList.size()) continue;
                killFromID = 0;
            }
        }
        for (a = 0; a < attackerList.size(); ++a) {
            UnitStackGroup ugl = (UnitStackGroup)attackerList.get(a);
            if (ugl.getTotalUnitCount() != 0) continue;
            attackerList.remove(ugl);
            --a;
        }
        if (attackerList.size() == 0) {
            SS.debug("Multi-attack battle in country " + c + ": Everyone was killed on each side!!!");
            c.setNewUnits(new UnitStackGroup());
        } else if (attackerList.size() == 1) {
            SS.debug("Multi-attack battle in country " + c + " won by " + ((UnitStackGroup)attackerList.get(0)).getDominantOwner());
            UnitStackGroup airUnits = ((UnitStackGroup)attackerList.get(0)).removeNonLandableAirUnits();
            airUnits.removeExpireAfterAttackUnits();
            if (airUnits.getTotalUnitCount() > 0) {
                SS.debug("AIR UNITS must land elsewhere: " + airUnits);
                this.landingPattern.add(airUnits);
            }
            if (((UnitStackGroup)attackerList.get(0)).getTotalUnitCount() > 0) {
                c.setNewUnits((UnitStackGroup)attackerList.get(0));
                c.setOwner(((UnitStackGroup)attackerList.get(0)).getDominantOwner());
            } else {
                c.setNewUnits(new UnitStackGroup());
            }
        } else {
            this.resolveMultipleAttackerBattle(c, attackerList);
        }
    }

    public void flashBattles() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!this.hasBattle(c)) continue;
            c.setFlashing(true);
        }
    }

    public int flashingBattlesCount() {
        int count = 0;
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.flashing) continue;
            ++count;
        }
        return count;
    }

    public void stopFlashing() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            c.setFlashing(false);
        }
    }

    private boolean hasBattle(Country c) {
        ArrayList<Team> teamList = new ArrayList<Team>();
        if (!c.isWater()) {
            teamList.add(c.getTeam());
        } else if (c.getUnitStackGroup().size() > 0) {
            teamList.add(c.getUnitStackGroup().get(0).getTeam());
        }
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command command = (Command)this.commandList.get(i);
            if (!command.battleInCountry(c) || teamList.contains(command.getTeam())) continue;
            teamList.add(command.getTeam());
        }
        return teamList.size() > 1;
    }

    public UnitStackGroup getDefendersUnitStackGroup(Country c) {
        UnitStackGroup result = new UnitStackGroup();
        result.add(c.getUnitStackGroup());
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command command = (Command)this.commandList.get(i);
            if (!command.battleInCountry(c) || !command.getTeam().equals(c.getTeam())) continue;
            result.add(command.unitsForBattleInCountry(c));
        }
        if (c.isWater()) {
            this.scrambleCarriedAircraft(result, c);
        }
        result.consolidateUnits();
        return result;
    }

    private void scrambleCarriedAircraft(UnitStackGroup result, Country c) {
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i).getCarriedUnitCountAir() <= 0) continue;
            result.get(i).getCarriedUnitsAir().setLandingCountry(c);
            result.add(result.get(i).getCarriedUnitsAir());
            result.get(i).removeCarryAir();
        }
    }

    public UnitStackGroup getAttackerUnitStackGroup(Country c, Player player) {
        List allTeams = this.getAttackerUnitStackGroups(c);
        for (int i = 0; i < allTeams.size(); ++i) {
            UnitStackGroup usg = (UnitStackGroup)allTeams.get(i);
            if (!usg.getDominantOwner().equals(player)) continue;
            return usg;
        }
        return new UnitStackGroup();
    }

    public List getAttackerUnitStackGroups(Country c) {
        UnitStackGroup ugl;
        Hashtable<Team, UnitStackGroup> teamLists = new Hashtable<Team, UnitStackGroup>();
        for (int i = 0; i < this.commandList.size(); ++i) {
            Command command = (Command)this.commandList.get(i);
            if (!command.battleInCountry(c) || command.getTeam().equals(c.getTeam())) continue;
            command.setDraw(false);
            ugl = (UnitStackGroup)teamLists.get(command.getTeam());
            if (ugl == null) {
                ugl = new UnitStackGroup();
                ugl.add(command.unitsForBattleInCountry(c));
                teamLists.put(command.getTeam(), ugl);
                continue;
            }
            ugl.add(command.unitsForBattleInCountry(c));
        }
        ArrayList<UnitStackGroup> result = new ArrayList<UnitStackGroup>();
        Enumeration e = teamLists.elements();
        while (e.hasMoreElements()) {
            ugl = (UnitStackGroup)e.nextElement();
            if (c.isWater()) {
                this.scrambleCarriedAircraft(ugl, c);
            }
            ugl.consolidateUnits();
            result.add(ugl);
        }
        return result;
    }

    protected void getBotMoves() {
        this.clearCommands();
        try {
            this.agent.declareMoves(this.getCountriesArray());
        }
        catch (Throwable e) {
            SS.debug(this.agent.name() + " threw an exception, and probably missed some of his turn!!!");
            e.printStackTrace();
        }
        this.manager.finishedMoves(this.playerID);
    }

    public Country[] getCountriesArray() {
        Country[] dupe = new Country[this.countries.size()];
        for (int i = 0; i < this.countries.size(); ++i) {
            dupe[i] = (Country)this.countries.get(i);
        }
        return dupe;
    }

    public Team getTeam(int playerID) {
        return this.getPlayer(playerID).getTeam();
    }

    public Player getPlayer(int playerID) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (((Player)this.players.get(i)).getID() != playerID) continue;
            return (Player)this.players.get(i);
        }
        return null;
    }

    public int getNumberOfPlayers() {
        return this.players.size();
    }

    public void calculateIncomes() {
        this.agentsIncomes = new int[this.players.size()];
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            int id = c.getOwner().getID();
            if (id == -1) continue;
            int n = id;
            this.agentsIncomes[n] = this.agentsIncomes[n] + c.getBonus();
        }
    }

    public void addIncomes() {
        for (int i = 0; i < this.agentsIncomes.length; ++i) {
            Player p = (Player)this.players.get(i);
            this.playerMoney[p.getID()] = this.playerMoney[p.getID()] + this.agentsIncomes[i];
        }
    }

    public int getPlayerMoney(Player player) {
        return this.playerMoney[player.getID()];
    }

    public int getPlayerMoney(int playerID) {
        return this.playerMoney[playerID];
    }

    public boolean unitCanReach(UnitStack units, Country from, Country to) {
        if (units == null || from == null || to == null) {
            return false;
        }
        from = this.countryWithID(from.getID());
        if ((to = this.countryWithID(to.getID())).isWater()) {
            return false;
        }
        return CountryPathFinder.canUnitReachLand(units, from, to);
    }

    public Country countryWithID(int ID) {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (c.getID() != ID) continue;
            return c;
        }
        return null;
    }

    public List getCastleCountriesOwnedBy(int ID) {
        Player p = this.getPlayer(ID);
        ArrayList<Country> result = new ArrayList<Country>();
        if (p == null) {
            return result;
        }
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.getTeam().equals(p.getTeam()) || !c.hasCastle(p)) continue;
            result.add(c);
        }
        return result;
    }

    public void setMoney(Player player, int money) {
        if (money < 0) {
            SS.debug("setMoney(" + player + ", " + money + ") adjusting to 0 money");
            money = 0;
        }
        this.playerMoney[player.getID()] = money;
    }

    public int getMoney(int playerID) {
        return this.playerMoney[playerID];
    }

    public List getBuyableUnitsForPlayer(Player player) {
        if (this.playerBuyableUnits[player.getID()] == null) {
            this.playerBuyableUnits[player.getID()] = this.getDefaultBuyableUnitsForPlayer(player);
        }
        return this.playerBuyableUnits[player.getID()];
    }

    public List getDefaultBuyableUnitsForPlayer(Player player) {
        ArrayList<UnitAbstract> units = new ArrayList<UnitAbstract>();
        units.add(new UnitPawn(player));
        units.add(new UnitKnight(player));
        units.add(new UnitCastle(player));
        return units;
    }

    public int getPlayerID() {
        return this.playerID;
    }

    public int getContinentSize(int ID) {
        int size = 0;
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (c.getContinentID() != ID) continue;
            ++size;
        }
        return size;
    }

    public Continent getContinent(int ID) {
        for (int i = 0; i < this.continents.size(); ++i) {
            Continent c = (Continent)this.continents.get(i);
            if (c.getID() != ID) continue;
            return c;
        }
        return null;
    }

    public String youWonText() {
        return this.agent.youWon();
    }

    public int getPlayerIncome(int playerID) {
        return this.manager.getStats().getIncome(playerID);
    }

    public int getPlayerLandCount(int playerID) {
        return this.manager.getStats().getOwned(playerID);
    }

    public int getPlayerArmyCount(int playerID) {
        return this.manager.getStats().getArmies(playerID);
    }

    public int getArmyCountMoving(int playerID) {
        int result = 0;
        for (int i = 0; i < this.commandList.size(); ++i) {
            MoveCommand command;
            if (!(this.commandList.get(i) instanceof MoveCommand) || (command = (MoveCommand)this.commandList.get(i)).getOwner().getID() != playerID) continue;
            result += command.getUnitCount() * command.getUnit().getCost();
        }
        return result;
    }

    public int battleDelay() {
        if (Vox.headless && this.manager.getOps().useTurnTimer) {
            if (this.manager.getOps().turnTimerLength >= 3600) {
                return 1000;
            }
            if (this.manager.getOps().turnTimerLength >= 1800) {
                return 800;
            }
            if (this.manager.getOps().turnTimerLength >= 600) {
                return 600;
            }
            if (this.manager.getOps().turnTimerLength >= 300) {
                return 500;
            }
            if (this.manager.getOps().turnTimerLength > 60) {
                return 400;
            }
            if (this.manager.getOps().turnTimerLength > 180) {
                return 350;
            }
            return 200;
        }
        return Prefs.getInt("battleDelay", 757);
    }

    public void chat(Object data) {
        try {
            this.agent.message("chat", data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendChat(String chat) {
        this.manager.AIChat(this.playerID, chat);
    }

    public void showAllCommands(List fullCommandList) {
        try {
            this.agent.message("endRoundMoves", fullCommandList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void roundIsEnding() {
        try {
            this.agent.message("roundIsEnding", null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

