/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.VoxNetClient;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.widgets.SSApp;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public class VoxTracker
implements Runnable {
    static final String trackerAddress = "http://sillysoft.net/vox/";
    private static Thread regThread;
    private static boolean initialRun;
    private static boolean registering;
    private VoxServer boss;
    private static Hashtable teamDictionary;
    private static int teamCounter;

    public VoxTracker(VoxServer boss) {
        this.boss = boss;
        initialRun = true;
        new Thread((Runnable)this, "VoxTracker").start();
    }

    public void setNumberOfPlayers(int newNum) {
        this.update();
    }

    public void update() {
        if (regThread != null) {
            regThread.interrupt();
        }
    }

    public void run() {
        regThread = Thread.currentThread();
        registering = true;
        while (registering) {
            try {
                if (initialRun) {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception sleepex) {
                        SS.debug("VoxTracker initial run: " + sleepex);
                    }
                    this.boss.printMessage("Registering with the VoxTracker...");
                }
                String requestPage = "http://sillysoft.net/vox/host1.php";
                StringBuffer request = new StringBuffer("name=");
                request.append(URLEncoder.encode(this.boss.serverName(), "UTF-8"));
                request.append("&");
                request.append(VoxTracker.cookie());
                try {
                    request.append("&boardSize=");
                    String map = this.boss.ops.mapTitle;
                    map = map.substring(map.lastIndexOf(47) + 1);
                    request.append(URLEncoder.encode(map, "UTF-8"));
                    if (this.boss.ops.useTurnTimer) {
                        String timeString;
                        request.append("&turnTimerLength=");
                        if (this.boss.ops.turnTimerLength < 3600) {
                            int secondsLeft;
                            int minutesLeft;
                            if (this.boss.ops.turnTimerLength >= 600 && (minutesLeft = (secondsLeft = this.boss.getTurnSecondsLeft()) / 60) >= 0) {
                                request.append(minutesLeft);
                                request.append(" / ");
                            }
                            float minutes = (float)this.boss.ops.turnTimerLength / 60.0f;
                            DecimalFormat format = new DecimalFormat("##0.#");
                            timeString = format.format(minutes);
                            request.append(timeString);
                            if ("1".equals(timeString)) {
                                request.append(URLEncoder.encode(" minute"));
                            } else {
                                request.append(URLEncoder.encode(" minutes"));
                            }
                        } else {
                            int secondsLeft;
                            int hoursLeft;
                            if (!this.boss.isGameOver() && (hoursLeft = Math.round((float)(secondsLeft = this.boss.getTurnSecondsLeft()) / 3600.0f)) >= 0) {
                                request.append(hoursLeft);
                                request.append(" / ");
                            }
                            float hours = (float)this.boss.ops.turnTimerLength / 3600.0f;
                            DecimalFormat format = new DecimalFormat("##0.#");
                            timeString = format.format(hours);
                            request.append(timeString);
                            if ("1".equals(timeString)) {
                                request.append(URLEncoder.encode(" hour"));
                            } else {
                                request.append(URLEncoder.encode(" hours"));
                            }
                        }
                    } else {
                        request.append("&turnTimerLength=--");
                    }
                    int playersLeft = 0;
                    int computerPlayers = 0;
                    for (int i = 1; i < this.boss.ops.players.size(); ++i) {
                        Player p = (Player)this.boss.ops.players.get(i);
                        if (p.isHuman()) {
                            request.append("&");
                            request.append(URLEncoder.encode("playerNames[]"));
                            request.append("=");
                            request.append(URLEncoder.encode(p.getBrain(), "UTF-8"));
                        } else if (this.boss.stats.getArmies(i) > 14) {
                            ++computerPlayers;
                        }
                        if (this.boss.stats == null || this.boss.stats.getArmies(i) <= 14) continue;
                        ++playersLeft;
                    }
                    request.append("&waitingFor=");
                    request.append(URLEncoder.encode(this.boss.waitingForList(), "UTF-8"));
                    request.append("&connectedNames=");
                    request.append(URLEncoder.encode(this.boss.connectedNamesList(), "UTF-8"));
                    request.append("&robotCount=");
                    request.append(computerPlayers);
                    request.append("&playersLeft=");
                    request.append(this.boss.getNumberOfHumanPlayersAlive());
                    request.append(URLEncoder.encode("/"));
                    request.append(this.boss.getNumberOfHumanPlayersAlive() + computerPlayers);
                    request.append("&gameStarted=");
                    request.append(this.boss.ops.gameStartedTime);
                    request.append("&gameEnded=");
                    request.append(this.boss.isGameOver() ? this.boss.ops.gameEndedTime : 0L);
                    request.append("&round=");
                    request.append(this.boss.round());
                    request.append("&port=");
                    request.append(this.boss.socketPort);
                    request.append("&numberOfPlayers=");
                    request.append(this.boss.getNumberOfHumansConnected());
                    request.append("&humanPlayers=");
                    request.append(this.boss.getNumberOfHumanPlayersAlive());
                    request.append("&numberOfGuestOnly=");
                    request.append(this.boss.getNumberOfGuestOnly());
                    List guests = this.boss.getGuestNameList();
                    for (int i = 0; i < guests.size(); ++i) {
                        request.append("&");
                        request.append(URLEncoder.encode("guestNames[]"));
                        request.append("=");
                        request.append(URLEncoder.encode((String)guests.get(i), "UTF-8"));
                    }
                    request.append("&description=");
                    request.append(URLEncoder.encode(this.boss.description == null ? "" : this.boss.description, "UTF-8"));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (registering) {
                    String contents = URLTool.postToURL(requestPage, request.toString(), "UTF-8", 10000);
                    String input = XMLTool.extract("ip", contents);
                    if (input != null) {
                        if (initialRun) {
                            this.boss.printMessage(Translator.getString("RegisteredsuccessfullywithLuxTrackerfromaddress") + " " + input);
                        }
                        this.boss.setNetworkKey(XMLTool.extract("networkKey", contents));
                    } else {
                        input = XMLTool.extract("error", contents);
                        if (input == null) {
                            input = "Unknown error";
                        }
                        if (initialRun) {
                            this.boss.printMessage("ERROR connecting to the VoxTracker: " + input);
                            SS.beep();
                        }
                        SS.debug("Vox -> Error connecting to the VoxTracker: " + input);
                    }
                }
                initialRun = false;
            }
            catch (Throwable e) {
                this.boss.printMessage("Error connecting to the VoxTracker: Either the host is not connected to the internet or the VoxTracker is currently offline");
                SS.debug("Vox -> Couldn't connect to the VoxTracker: " + e);
                this.boss.log("Couldn't connect to the VoxTracker: " + e);
            }
            try {
                Thread.sleep(300000L);
            }
            catch (Throwable throwable) {}
        }
        registering = false;
        regThread = null;
        this.boss = null;
        SS.debug("Vox -> VoxTracker thread ending");
    }

    public void stop() {
        registering = false;
        if (regThread != null) {
            try {
                SS.debug("Vox -> Stopping the VoxTracker");
                String result = URLTool.getURL("http://sillysoft.net/vox/host_remove.php?port=" + this.boss.socketPort);
            }
            catch (Exception e) {
                SS.debug("Vox -> Error stopping the VoxTracker: " + e);
            }
            if (regThread != null) {
                regThread.interrupt();
            }
        }
    }

    public static String cookie() {
        int clientID = Prefs.getInt("clientID", 0);
        if (clientID == 0) {
            clientID = new Random().nextInt(1000000) + 1;
            Prefs.putInt("clientID", clientID);
        }
        StringBuffer addressBuffer = new StringBuffer("version=");
        addressBuffer.append(SSApp.version());
        addressBuffer.append("&");
        addressBuffer.append("userKey=");
        try {
            addressBuffer.append(URLEncoder.encode(Prefs.getUserKey(), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        addressBuffer.append("&id=");
        addressBuffer.append(clientID);
        return addressBuffer.toString();
    }

    public static String getHostList() throws MalformedURLException, IOException {
        StringBuffer addressBuffer = new StringBuffer(trackerAddress);
        addressBuffer.append("list1.php?");
        addressBuffer.append(VoxTracker.cookie());
        return URLTool.getURL(addressBuffer.toString(), "UTF-8");
    }

    public static String isNameKeyValid(VoxNetClient n, Vector activeAliasReturn, String mapTitle, boolean longTimerGame) throws MalformedURLException, IOException {
        String URL2 = "http://sillysoft.net/vox/nick_check1.php?name=" + URLEncoder.encode(n.name(), "UTF-8") + "&key=" + URLEncoder.encode(n.key(), "UTF-8") + "&map=" + URLEncoder.encode(mapTitle, "UTF-8") + "&longTimerGame=" + longTimerGame + (n.ip() != null ? "&ip=" + URLEncoder.encode(n.ip()) : "") + "&hl=" + Translator.getLocale() + "&version=" + SSApp.version();
        String nickCheck = URLTool.getURL(URL2);
        String aliasCheck = XMLTool.extract("alias", nickCheck);
        if (activeAliasReturn != null && aliasCheck != null && !"".equals(aliasCheck)) {
            activeAliasReturn.add(aliasCheck);
        }
        String modCheck = XMLTool.extract("mod", nickCheck);
        if (n != null && modCheck != null && "true".equals(modCheck)) {
            n.setModerator(true);
        }
        return XMLTool.extract("result", nickCheck);
    }

    public static String getTeam(String forName) {
        if (teamDictionary == null) {
            return "";
        }
        Object result = teamDictionary.get(forName);
        if (result == null) {
            return "";
        }
        return "[" + result.toString() + "] ";
    }

    static {
        teamCounter = 0;
    }
}

