/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.lux.gui.TurnTimerManager;
import com.sillysoft.lux.gui.TurnTimerTask;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.CountryPathFinder;
import com.sillysoft.vox.IDable;
import com.sillysoft.vox.MapLoader;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Stats;
import com.sillysoft.vox.StatsHistory;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Vox;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxNetClient;
import com.sillysoft.vox.VoxOptions;
import com.sillysoft.vox.VoxTracker;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.VoxWorldManager;
import com.sillysoft.vox.agent.Human;
import com.sillysoft.vox.command.Command;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSOptionPane;
import java.awt.Point;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class VoxServer
implements VoxWorldManager,
CountriesManager,
TurnTimerManager,
Runnable {
    private List teams;
    private List countries;
    private List continents;
    private List lines;
    private VoxWorld masterWorld;
    private VoxWorld[] worlds;
    private boolean[] waitingForPlayer;
    private boolean[] tookLastTurn;
    private boolean[] givenUp;
    private Team soloGameSurrenderWinner;
    private boolean waitingForAnyone = true;
    private Hashtable botTakeoverMemory = new Hashtable();
    public VoxOptions ops;
    public String map;
    protected String humanPlayer;
    private List chatlog = new ArrayList();
    private List connections = new ArrayList();
    protected Stats stats;
    private StatsHistory statsHistory;
    private Timer turnTimer;
    private long currentTurnStartedAtTime;
    private boolean gameOver = false;
    private String gameOverText = null;
    private Thread gameLoopThread;
    private boolean endGameLoop = false;
    protected boolean gameStarted = false;
    protected int socketPort;
    public boolean portFinalized = false;
    public boolean loadedProperly = false;
    private String networkKey;
    protected String description = Vox.descParam != null ? Vox.descParam : "Welcome to online Castle Vox server v1.2. Type /play to join the game.";
    protected static final int lameDuckCount = 14;
    private VoxTracker voxTracker;
    private boolean savedGame = false;
    private String serverName;
    private boolean createNewOps = false;
    ServerSocket sock;
    boolean killed = false;

    protected VoxServer(String map, String humanPlayer, String difficulty, boolean allowNetworkPlayers, int port, String serverName) {
        this.savedGame = false;
        this.map = map;
        this.humanPlayer = humanPlayer;
        this.socketPort = port;
        this.serverName = serverName;
        this.ops = new VoxOptions(allowNetworkPlayers, difficulty);
        this.loadMap();
        this.turnTimer = new Timer();
        this.turnTimer.schedule((TimerTask)new TurnTimerTask(this), 1000L, 1000L);
        if (allowNetworkPlayers) {
            new Thread((Runnable)this, "VoxServer-listenForClients").start();
        }
    }

    protected VoxServer(String savedGameLocation) {
        this.savedGame = true;
        this.humanPlayer = "<saved game player>";
        this.socketPort = -1;
        this.serverName = "savedGameServer";
        this.ops = new VoxOptions(false, "-- saved difficulty --");
        this.loadMap(savedGameLocation);
        String savedGameXML = FileTool.fileToString(savedGameLocation);
        this.ops.difficulty = XMLTool.extract("difficulty", savedGameXML);
        List savedCommands = Command.getCommandListFromXML(savedGameXML, this);
        int humanID = this.getFirstHumanID();
        if (humanID > -1) {
            this.worlds[humanID].addCommands(savedCommands);
        }
        this.turnTimer = new Timer();
        this.turnTimer.schedule((TimerTask)new TurnTimerTask(this), 1000L, 1000L);
        String statsXML = XMLTool.extract("SH", savedGameXML);
        this.statsHistory = new StatsHistory(statsXML);
    }

    public void run() {
        this.listenForClients();
    }

    private void startNewGame() {
        if (this.masterWorld != null) {
            this.masterWorld.killed = true;
        }
        if (this.gameLoopThread != null) {
            this.endGameLoop = true;
            try {
                this.gameLoopThread.join();
            }
            catch (Exception e) {
                SS.debug("while joining the old game loop thread: " + e);
            }
        }
        this.printMessage("Starting a new game");
        this.endGameLoop = false;
        this.gameOver = false;
        this.gameOverText = null;
        this.savedGame = false;
        if (this.createNewOps) {
            this.ops = new VoxOptions(this.ops.allowNetworkPlayers, this.ops.difficulty);
            this.createNewOps = false;
        }
        this.ops.borderWidth = 7;
        try {
            this.loadMap();
        }
        catch (Throwable t) {
            this.printMessage("There was an error starting the game: " + t);
        }
    }

    public void loadMap() {
        this.loadMap(DesktopTool.supportFolderPath() + "Maps" + File.separator + this.map + ".voxb");
    }

    public void loadMap(String fileLocation) {
        block2: {
            try {
                this.loadedProperly = false;
                this.chatlog = new ArrayList();
                MapLoader.loadMap(fileLocation, this);
                this.loadedProperly = true;
            }
            catch (Throwable e) {
                SS.debug(e);
                e.printStackTrace();
                if (Vox.headless) break block2;
                SSOptionPane.showMessageDialog("Map Error: " + e.getMessage());
            }
        }
    }

    public void setMapInfo(int width, int height, String title, String theme) {
        this.ops.width = width;
        this.ops.height = height;
        this.ops.mapTitle = title;
        this.ops.mapTheme = theme;
        if (this.savedGame) {
            this.map = title;
        }
    }

    public void setCountries(List countries) {
        this.orderByID(countries);
        this.countries = countries;
    }

    public void setContinents(List conts) {
        this.continents = conts;
    }

    public List getContinents() {
        return this.continents;
    }

    public List getCountries() {
        return this.countries;
    }

    public void orderByID(List list) {
        for (int i = 0; i < list.size(); ++i) {
            int ID = ((IDable)list.get(i)).getID();
            for (int j = 0; j < list.size(); ++j) {
                int jID = ((IDable)list.get(j)).getID();
                if (ID != jID || i == j) continue;
                throw new RuntimeException("Duplicate ID found: " + ID + ", " + list.get(i) + ", " + list.get(j));
            }
        }
        boolean changeMade = false;
        do {
            changeMade = false;
            for (int i = 0; i < list.size(); ++i) {
                int pID = ((IDable)list.get(i)).getID();
                if (pID == i) continue;
                list.add(pID, list.remove(i));
                changeMade = true;
            }
        } while (changeMade);
    }

    public void setPlayers(List players) {
        this.orderByID(players);
        this.ops.players = players;
        Player p = this.getPlayer(0);
        p.setAgentType("Boring");
        p.controlledBy = null;
        p.controlledByKey = null;
        p.controlledByPrevious = null;
        p.controlledByKeyPrevious = null;
        for (int i = 1; i < this.ops.players.size(); ++i) {
            p = this.getPlayer(i);
            p.setAgentType(this.getAgentTypeForDifficulty(this.ops.difficulty));
            if (p.controlledBySaved || this.savedGame) continue;
            p.controlledBy = null;
            p.controlledByKey = null;
        }
    }

    private void setHumanPlayers() {
        SS.debug("server adding in humans", 1);
        for (int c = 0; c < this.connections.size(); ++c) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(c);
            if (!vc.guestOnly()) {
                int playerID = this.getAItoReplace();
                if (playerID > -1) {
                    Player p = this.getPlayer(playerID);
                    p.setAgentType("Human");
                    p.controlledBy = vc.name();
                    p.controlledByKey = vc.key();
                    vc.setPlayerID(playerID);
                    vc.encodeln("addGameStartedCount: ");
                    continue;
                }
                vc.setPlayerID(-1);
                continue;
            }
            vc.setPlayerID(-1);
        }
    }

    private int getAItoReplace() {
        if (this.humanPlayer != null) {
            if ("-- None --".equals(this.humanPlayer) || ("-- " + Translator.getString("None") + " --").equals(this.humanPlayer)) {
                return -1;
            }
            if ("<saved game player>".equals(this.humanPlayer)) {
                for (int i = 0; i < this.ops.players.size(); ++i) {
                    Player p = this.getPlayer(i);
                    if (!"Human".equals(p.getAgentType())) continue;
                    SS.debug("Changing humanPlayer from " + this.humanPlayer + " to " + p.getName());
                    this.humanPlayer = p.getName();
                    return i;
                }
                return -1;
            }
            if (!"-- Random --".equals(this.humanPlayer) || ("-- " + Translator.getString("Random") + " --").equals(this.humanPlayer)) {
                for (int i = 0; i < this.ops.players.size(); ++i) {
                    Player p = this.getPlayer(i);
                    if (p.isHuman() || !p.getName().equals(this.humanPlayer)) continue;
                    return i;
                }
            }
        }
        int randStart = SS.rand.nextInt(this.ops.players.size());
        for (int i = 0; i < this.ops.players.size(); ++i) {
            int checkPlayer = (randStart + i) % this.ops.players.size();
            Player p = this.getPlayer(checkPlayer);
            if (p.isHuman() || this.stats.getArmies(checkPlayer) <= 0 || checkPlayer == 0) continue;
            return checkPlayer;
        }
        return -1;
    }

    private int getAItoReplace(String desiredPlayer) {
        if (desiredPlayer != null) {
            for (int i = 0; i < this.ops.players.size(); ++i) {
                Player p = this.getPlayer(i);
                if (p.isHuman() || !p.getName().equalsIgnoreCase(desiredPlayer) || i == 0) continue;
                return i;
            }
        }
        return -1;
    }

    public List getPlayers() {
        return this.ops.players;
    }

    public boolean isHuman(int ID) {
        Player p = this.getPlayer(ID);
        return p.isHuman();
    }

    public int getFirstHumanID() {
        for (int i = 0; i < this.ops.players.size(); ++i) {
            Player p = this.getPlayer(i);
            if (!p.isHuman()) continue;
            return i;
        }
        return -1;
    }

    public int getNumberOfPlayers() {
        return this.ops.players.size();
    }

    public void setTeams(List teams) {
        this.teams = teams;
    }

    public void setGameRound(int gameRound) {
        this.masterWorld.roundCount = gameRound;
    }

    public void setPlayerInfoLocation(String pointString) {
        this.ops.playerInfoPointString = pointString;
    }

    public void setCountryBorderWidth(String pointString) {
        this.ops.borderWidth = Integer.parseInt(pointString);
    }

    public void setLines(List lines) {
        this.lines = lines;
    }

    public void finishedLoading() {
        VoxNetClient vc;
        Player p;
        int i;
        for (i = 0; i < this.countries.size(); ++i) {
            ((Country)this.countries.get(i)).initialUnitSanityCheck();
        }
        this.ops.setStartTime();
        this.masterWorld = new VoxWorld(this, -1);
        this.masterWorld.setPlayers(this.ops.players);
        this.masterWorld.setCountries(this.countries);
        this.masterWorld.setContinents(this.continents);
        this.masterWorld.setUnitOriginalCountries();
        this.worlds = new VoxWorld[this.ops.players.size()];
        this.waitingForPlayer = new boolean[this.worlds.length];
        this.tookLastTurn = new boolean[this.worlds.length];
        this.givenUp = new boolean[this.worlds.length];
        this.botTakeoverMemory = new Hashtable();
        this.soloGameSurrenderWinner = null;
        for (i = 0; i < this.worlds.length; ++i) {
            this.worlds[i] = new VoxWorld(this, i);
            this.worlds[i].roundCount = this.masterWorld.roundCount;
            this.worlds[i].setPlayers(this.ops.players);
            this.worlds[i].setCountries(this.cloneCountries());
            this.worlds[i].setContinents(this.continents);
            this.worlds[i].setupBot(this.getPlayer(i));
            this.tookLastTurn[i] = true;
            this.givenUp[i] = false;
        }
        this.stats = new Stats(this, this.getNumberOfPlayers());
        this.statsHistory = new StatsHistory();
        this.currentTurnStartedAtTime = new Date().getTime();
        for (i = 0; i < this.ops.players.size(); ++i) {
            p = this.getPlayer(i);
            int startingMoney = 0;
            if (p.startingMoney == null) {
                startingMoney = this.stats.getIncome(i);
            } else {
                try {
                    startingMoney = Integer.parseInt(p.startingMoney);
                }
                catch (Exception t) {
                    SS.debug("Error restoring saved money values: " + t);
                }
            }
            startingMoney = Math.max(startingMoney, 0);
            this.masterWorld.setMoney(p, startingMoney);
            for (int w = 0; w < this.worlds.length; ++w) {
                this.worlds[w].setMoney(p, startingMoney);
            }
        }
        this.setHumanPlayers();
        for (i = 0; i < this.connections.size(); ++i) {
            vc = (VoxNetClient)this.connections.get(i);
            vc.setVoxOptions(this.ops);
            vc.setExtraLines(this.lines, this.ops.height);
            vc.setContinents(this.continents);
            vc.setWorldData(this.countries);
        }
        for (i = 0; i < this.connections.size(); ++i) {
            vc = (VoxNetClient)this.connections.get(i);
            vc.startNewRound(this.turnTimeLeft());
            this.sendMoneyInfo(vc);
            Player p2 = this.getPlayerFor(vc.name());
            if (p2 == null) continue;
            vc.setPlayerID(p2.getID());
        }
        if (this.connections.size() - this.getNumberOfGuestOnly() > 0) {
            for (int w = 1; w < this.worlds.length; ++w) {
                p = this.getPlayer(w);
                this.println(p.name() + " on team " + p.getTeam() + " : " + p.getAgentType() + (p.controlledBy != null ? " " + p.controlledBy : ""));
            }
        }
        boolean startingGame = false;
        if ("-- None --".equals(this.humanPlayer) || this.numberHumanPlayers() > 0 && !this.savedGame) {
            startingGame = true;
        } else {
            SS.debug("Server finished loading map with no clients. don't start the game yet", 1);
            this.printMessage("There are no human players, so the game will not start yet");
            this.currentTurnStartedAtTime = 0L;
            this.gameStarted = false;
        }
        if (startingGame) {
            this.doTurnMoves();
            this.startGameLoopThread();
        }
        this.updateTracker();
    }

    public int numberHumanPlayers() {
        int count = 0;
        for (int i = 0; i < this.ops.players.size(); ++i) {
            Player p = this.getPlayer(i);
            if (!p.isHuman()) continue;
            ++count;
        }
        return count;
    }

    public void revealAllMoves() {
        int i;
        for (int i2 = 0; i2 < this.worlds.length; ++i2) {
            this.worlds[i2].roundIsEnding();
        }
        SS.debug("Server CommandList.round-" + this.masterWorld.roundCount + ":", 3);
        ArrayList fullCommandList = new ArrayList();
        for (i = 0; i < this.worlds.length; ++i) {
            List commands = this.worlds[i].getCommands();
            for (int c = 0; c < commands.size(); ++c) {
                SS.debug("Server fullCommandList.round-" + this.masterWorld.roundCount + "-" + commands.get(c), 3);
                fullCommandList.add(commands.get(c));
            }
            this.worlds[i].clearCommands();
        }
        System.out.println("");
        for (i = 0; i < this.connections.size(); ++i) {
            ((VoxNetClient)this.connections.get(i)).showAllCommands(fullCommandList);
        }
        for (i = 0; i < this.worlds.length; ++i) {
            this.worlds[i].showAllCommands(fullCommandList);
        }
        this.masterWorld.clearCommands();
        this.masterWorld.addCommands(fullCommandList);
    }

    public void updateCountry(Country c, boolean castleConquered) {
        this.updateCountry(c, castleConquered, false);
    }

    public void updateCountry(Country c, boolean castleConquered, boolean castleBuilt) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ((VoxNetClient)this.connections.get(i)).encodeln("updateCountry: " + c.getID() + " " + castleConquered + " " + c.getUnitStackGroup().toStringXML());
        }
        if (castleBuilt) {
            this.printMessage(c.getUnitStackGroup().getCastle().getOwner().getName() + " built a Castle in " + c.getName() + "!", true);
        } else if (castleConquered) {
            this.printMessage(c.getName() + " conquered by " + c.getOwner().getName() + "!", true);
        }
    }

    public void endOfRound() {
        int i;
        int i2;
        SS.debug("SERVER endOfRound", 1);
        boolean[] replaceWithBots = new boolean[this.ops.players.size()];
        for (i2 = 0; i2 < this.ops.players.size(); ++i2) {
            replaceWithBots[i2] = false;
            Player p = this.getPlayer(i2);
            if (p.isHuman() && !this.tookLastTurn[i2] && !this.masterWorld.hasCommandsFrom(p) && this.stats.getArmies(i2) > 14 && !this.givenUp[i2]) {
                replaceWithBots[i2] = true;
            }
            this.tookLastTurn[i2] = this.masterWorld.hasCommandsFrom(p);
        }
        this.masterWorld.resolveBattles();
        this.masterWorld.calculateIncomes();
        this.masterWorld.setUnitOriginalCountries();
        this.setCountries(this.masterWorld.getCountries());
        for (i2 = 0; i2 < this.worlds.length; ++i2) {
            this.worlds[i2].setCountries(this.cloneCountries());
        }
        this.statsHistory.addRound(this.getNumberOfPlayers(), this.stats);
        this.stats = new Stats(this, this.getNumberOfPlayers());
        this.currentTurnStartedAtTime = new Date().getTime();
        Team possibleWinner = this.gameOverConditions();
        if (possibleWinner != null) {
            this.gameOver = true;
            Team winnerTeam = possibleWinner;
            Player winner = this.getPlayer(this.stats.getLargestPlayer());
            String agentWinText = "All your Vox are Belong to Us!";
            if (winner.getTeam().equals(winnerTeam)) {
                agentWinText = winner.isHuman() ? Human.youWonStatic() : this.worlds[winner.getID()].youWonText();
            } else {
                SS.debug("winning case 283745669");
                agentWinText = Human.youWonStatic();
            }
            ArrayList<Player> winningPlayers = new ArrayList<Player>();
            for (int i3 = 0; i3 < this.ops.players.size(); ++i3) {
                Player p = this.getPlayer(i3);
                if (!p.getTeam().equals(winnerTeam)) continue;
                winningPlayers.add(p);
            }
            boolean changeMade = false;
            do {
                changeMade = false;
                for (int i4 = 0; i4 < winningPlayers.size() - 1; ++i4) {
                    int pID = ((Player)winningPlayers.get(i4)).getID();
                    int pID2 = ((Player)winningPlayers.get(i4 + 1)).getID();
                    if (this.stats.getArmies(pID) >= this.stats.getArmies(pID2)) continue;
                    winningPlayers.add(i4, (Player)winningPlayers.remove(i4 + 1));
                    changeMade = true;
                }
            } while (changeMade);
            String playerlist = "";
            boolean needSeperator = false;
            for (int i5 = 0; i5 < winningPlayers.size(); ++i5) {
                Player p = (Player)winningPlayers.get(i5);
                playerlist = needSeperator ? playerlist + " " + Translator.getString("and") + " " + p.getBrain() : playerlist + " " + p.getBrain();
                needSeperator = true;
            }
            agentWinText = "\"" + agentWinText + "\"";
            try {
                agentWinText = URLEncoder.encode(agentWinText, "UTF-8");
            }
            catch (Exception eex) {
                SS.debug("could not encode: " + agentWinText);
                eex.printStackTrace();
            }
            agentWinText = agentWinText.replaceAll("\n", "```");
            this.statsHistory.gameOverText = this.gameOverText = playerlist + "```" + winnerTeam.getName() + " " + winnerTeam.getSymbol() + " " + Translator.getString("Wins") + "! ``` ```" + agentWinText + "";
            this.statsHistory.winningTeamName = winnerTeam.getName();
            this.ops.setEndTime();
            this.printMessage("Game over after round " + this.masterWorld.roundCount + ", lasted for " + this.ops.gameLengthReadable() + "!", true);
            this.gameOver(this.gameOverText);
            if (this.ops.allowNetworkPlayers && this.ops.internetPublic) {
                this.sendGameRecord();
            }
            return;
        }
        ++this.masterWorld.roundCount;
        for (i = 0; i < this.worlds.length; ++i) {
            ++this.worlds[i].roundCount;
        }
        this.giveOutIncomes();
        this.masterWorld.clearCommands();
        for (i = 0; i < this.connections.size() && !this.killed; ++i) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(i);
            vc.startNewRound(this.turnTimeLeft());
            this.sendMoneyInfo(vc);
        }
        this.doTurnMoves();
        if (this.ops.allowNetworkPlayers) {
            for (i = 0; i < replaceWithBots.length; ++i) {
                if (!replaceWithBots[i]) continue;
                Player p = this.getPlayer(i);
                this.printMessage(p.controlledBy + " hasn't moved the last 2 turns, replacing with a bot", true);
                this.botTakeoverMemory.put(p.controlledByKey, p.getName());
                this.dealWithChat("/setAI " + i + " Holdem", null);
            }
        }
    }

    private void sendGameRecord() {
        if (this.numberHumanPlayers() + this.botTakeoverMemory.size() < 2) {
            System.out.println("Less then 2 human players, don't send results to the online DB");
            return;
        }
        StringBuffer varlist = new StringBuffer("version=");
        varlist.append(1.2f);
        varlist.append("&networkKey=");
        varlist.append(this.networkKey);
        try {
            varlist.append("&map=");
            varlist.append(URLEncoder.encode(this.map, "UTF-8"));
            varlist.append("&hostName=");
            varlist.append(URLEncoder.encode(this.serverName(), "UTF-8"));
            varlist.append("&startTime=");
            varlist.append(this.ops.gameStartedTime);
            varlist.append("&endTime=");
            varlist.append(this.ops.gameEndedTime);
            varlist.append("&timer=");
            varlist.append(this.ops.useTurnTimer ? this.ops.turnTimerLength : 0);
            varlist.append("&rounds=");
            varlist.append(this.masterWorld.roundCount);
            varlist.append("&statsHistory=");
            varlist.append(URLEncoder.encode(this.statsHistory.toStringXML(), "UTF-8"));
            varlist.append("&playerList=");
            Player.exportingWithKeys = true;
            varlist.append(URLEncoder.encode(XMLTool.getListXML(this.ops.players, "vplayer"), "UTF-8"));
            Player.exportingWithKeys = false;
            varlist.append("&extraInfo=");
            for (int m = 0; m < this.chatlog.size(); ++m) {
                ChatEntry chat = (ChatEntry)this.chatlog.get(m);
                if (chat.from != null) continue;
                varlist.append(URLEncoder.encode(chat.text, "UTF-8"));
                varlist.append(URLEncoder.encode(chat.text, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException unex) {
            unex.printStackTrace();
            this.printMessage("Error: UnsupportedEncodingException.");
        }
        String urlstring = "http://sillysoft.net/vox/addranking1.php";
        String postData = varlist.toString();
        for (int tries = 0; tries < 5; ++tries) {
            try {
                String inputFull = URLTool.postToURL(urlstring, postData, "UTF-8");
                String input = XMLTool.extract("message", inputFull);
                if (input != null && !"".equals(input.trim())) {
                    StringTokenizer tok = new StringTokenizer(input, "~");
                    while (tok.hasMoreTokens()) {
                        String line = tok.nextToken();
                        this.printMessage(line, true);
                        System.out.println(line);
                    }
                    return;
                }
                if (tries >= 4) continue;
                this.printMessage("Error sending rankings (empty response). Vox will try again in 10 seconds.");
                Thread.sleep(10000L);
                continue;
            }
            catch (Throwable t) {
                if (tries < 4) {
                    try {
                        this.printMessage("Error sending rankings (" + t + "). Vox will try again in 10 seconds.");
                        Thread.sleep(10000L);
                    }
                    catch (Throwable y) {
                        // empty catch block
                    }
                }
                System.out.println("Vox -> Error adding internet record info: ");
                t.printStackTrace();
            }
        }
        this.printMessage(Translator.getString("errorSendingRankings"), true);
    }

    private void doTurnMoves() {
        SS.debug("doTurnMoves round " + this.masterWorld.roundCount, 1);
        this.waitingForAnyone = true;
        for (int i = 0; i < this.worlds.length; ++i) {
            this.waitingForPlayer[i] = true;
        }
        new Thread("BotMoves"){

            public void run() {
                for (int i = 0; VoxServer.this.worlds != null && i < VoxServer.this.worlds.length; ++i) {
                    if (VoxServer.this.isHuman(i)) continue;
                    VoxWorld localWorld = VoxServer.this.worlds[i];
                    SS.debug("Player " + i + "-" + VoxServer.this.getPlayer(i).getName() + " starting to think...", 1);
                    localWorld.getBotMoves();
                }
            }
        }.start();
    }

    private void gameOver(String gameOverText) {
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(i);
            vc.startNewRound(this.turnTimeLeft());
            vc.gameOver(this.statsHistory);
        }
        this.updateTracker();
        boolean autoplay = false;
        if (autoplay) {
            this.autoplayHandler();
        }
    }

    public void autoplayHandler() {
        Runnable autoplayRunnable = new Runnable(){

            public void run() {
                if (!PrefsCache.superfast) {
                    for (int i = 0; i < 60; ++i) {
                        if (i % 10 == 0) {
                            VoxServer.this.printMessage("tra: 3 :Autoplaygamewillstart: " + (60 - i) + " :seconds: - " + (VoxServer.this.connections.size() - VoxServer.this.getNumberOfGuestOnly()) + "/" + VoxServer.this.connections.size() + " :players:");
                        }
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception e) {
                            SS.debug("autoplay exception 83746");
                        }
                    }
                }
                if (VoxServer.this.gameOver) {
                    VoxServer.this.startNewGame();
                }
            }
        };
        new Thread(autoplayRunnable, "Headless-Autoplay-runner").start();
    }

    public List cloneCountries() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            result.add(c.clone());
        }
        return result;
    }

    public void giveOutIncomes() {
        for (int i = 0; i < this.ops.players.size(); ++i) {
            Player p = this.getPlayer(i);
            int oldMoney = this.masterWorld.getPlayerMoney(p);
            this.masterWorld.setMoney(p, oldMoney + this.stats.getIncome(i));
            for (int w = 0; w < this.worlds.length; ++w) {
                this.worlds[w].setMoney(p, oldMoney + this.stats.getIncome(i));
            }
            if (this.masterWorld.getPlayerMoney(p) >= 0) continue;
            Thread.dumpStack();
        }
    }

    public void refreshBuyPanel(Object foo) {
    }

    public Player getPlayer(int playerID) {
        for (int i = 0; i < this.ops.players.size(); ++i) {
            if (((Player)this.ops.players.get(i)).getID() != playerID) continue;
            return (Player)this.ops.players.get(i);
        }
        return null;
    }

    public void orderExplosion(int playerID, int country) {
    }

    public void orderExplosion(int playerID, int country, boolean nuke) {
        SS.debug("control superclass explode nuke");
    }

    public void dealWithChat(String chat) {
        this.dealWithChat(chat, null);
    }

    public void dealWithChat(String chat, VoxNetClient from) {
        try {
            if (chat.startsWith("/")) {
                if (Vox.headless) {
                    System.out.println(from != null ? from.name() + ": " + chat : chat);
                }
                if (chat.startsWith("/forceend")) {
                    this.currentTurnStartedAtTime = 0L;
                    this.turnTimerExpired();
                } else if (chat.equals("/start")) {
                    if (!this.ops.allowNetworkPlayers || this.fullPowers(from) || this.numberHumanPlayers() < this.numberAvailablePlayers() || this.gameOver || !Vox.headless && from.name().equals(this.serverName())) {
                        if (this.gameOver && !this.ops.gameOver1Turn()) {
                            this.printToFrom(from, "Castle Vox waits 1 turn time before starting a new game, so everyone has a chance to see the game-over graph (" + StringTool.timeFormat((long)(this.ops.turnTimerLength * 1000) - this.ops.gameOverForHowLong()) + " left)");
                            return;
                        }
                        this.startNewGame();
                    } else {
                        this.printToFrom(from, "Restart is not allowed at this time");
                    }
                } else if (chat.startsWith("/settime")) {
                    if (this.fullPowers(from)) {
                        String time = chat.substring(chat.indexOf(" ") + 1);
                        int seconds = Integer.parseInt(time);
                        if (seconds != 0) {
                            seconds = Math.max(seconds, 15);
                        }
                        Prefs.putInt("turnTimerSeconds", seconds);
                        Prefs.putBoolean("turnTimer", seconds != 0);
                        Vox.timeParam = seconds;
                        this.createNewOps = true;
                        this.printMessage("The turn time for the next game has been set to " + seconds + " seconds");
                    }
                } else if (chat.startsWith("/map")) {
                    if (chat.length() < 5) {
                        this.printToFrom(from, "tra: 3 Enter the name of a map to change to. Example: /map Hex Lords");
                        return;
                    }
                    if (this.longTimer()) {
                        this.printToFrom(from, "tra: 3 You cannot change the map in long-timer hosts");
                        return;
                    }
                    String desiredMap = chat.substring(5).toLowerCase();
                    Vector mapList = PluginManager.getInstance().getMapList();
                    for (int j = 0; j < mapList.size(); ++j) {
                        String mapCheck = (String)mapList.get(j);
                        if (!mapCheck.toLowerCase().equals(desiredMap)) continue;
                        this.printMessage("tra: 3 The map for the next game has been set to " + mapCheck);
                        this.map = mapCheck;
                        Vox.mapParam = mapCheck;
                        Prefs.put("mapSelector", mapCheck);
                        return;
                    }
                    this.printMessage("tra: 3 :Error:: No map found named '" + chat.substring(5) + "'");
                } else if (chat.equals("/u") || chat.equals("/users")) {
                    this.sendUserlist(from);
                } else if (chat.equals("/g") || chat.equals("/guest")) {
                    if (from.watchOnly()) {
                        from.guestOnly = true;
                        from.printMessage("You have guest-only status in this room and cannot play. You need to ``vox/buy/?source=guestin`Register Castle Vox` to play long-term games online");
                        return;
                    }
                    boolean bl = from.guestOnly = !from.guestOnly();
                    if (from.guestOnly) {
                        this.printMessage(from.name() + " has guested out");
                    } else {
                        this.printMessage(from.name() + " is available to play");
                    }
                } else if (chat.equals("/go")) {
                    if (!from.guestOnly) {
                        from.guestOnly = true;
                        this.printMessage(from.name() + " has guested out");
                    }
                } else if (chat.equals("/gi")) {
                    if (from.watchOnly()) {
                        from.guestOnly = true;
                        from.printMessage("You have guest-only status in this room and cannot play. You need to ``vox/buy/?source=guestin`Register Castle Vox` to play long-term games online");
                        return;
                    }
                    if (from.guestOnly) {
                        from.guestOnly = false;
                        this.printMessage(from.name() + " is available to play");
                    }
                } else if (chat.equals("/quit")) {
                    if (from == null || this.fullPowers(from)) {
                        this.kill();
                    } else {
                        from.printMessage("No Thanks");
                    }
                } else if (chat.startsWith("/debug")) {
                    String extraText = chat.substring(6);
                    if ("".equals(extraText.trim())) {
                        this.printToFrom(from, "Please enter a single line summary with your report. i.e: /debug the player info table is broken");
                        return;
                    }
                    String logReport = "Vox " + from.name() + " DEBUG: " + chat + "\n" + ((LogFile)System.out).getLog() + "\n\n" + Prefs.exportSubtree() + "\n\n";
                    SSApp.alertSillysoft(logReport);
                    this.printToFrom(from, "Your debugging info has been sent to Sillysoft. Email any extra details to vox@sillysoft.net");
                } else if (chat.startsWith("/report")) {
                    String extraText = chat.substring(7);
                    if ("".equals(extraText.trim())) {
                        this.printToFrom(from, "Please enter a single line summary with your report. i.e: /report BadApple is being abusive");
                        return;
                    }
                    String logReport = "Vox " + from.name() + " report: " + chat + "\n";
                } else if (chat.trim().equals("/t")) {
                    this.printToFrom(from, "You must enter a message for team-chat. i.e.: /t protect my castle!");
                } else if (chat.startsWith("/t ")) {
                    this.chatlog.add(new ChatEntry(chat, from == null ? null : from.name()));
                    Team t = this.getTeamFor(from);
                    String output = chat.substring(chat.indexOf(" ") + 1);
                    if (from != null) {
                        output = from.name() + ": " + output;
                    }
                    for (int i = 0; this.connections != null && i < this.connections.size(); ++i) {
                        VoxNetClient vc = (VoxNetClient)this.connections.get(i);
                        Team t2 = this.getTeamFor(vc);
                        if ((t != null || t2 != null) && (t == null || !t.equals(t2))) continue;
                        vc.takeChatColored(output, null);
                    }
                    for (int j = 1; j < this.ops.players.size(); ++j) {
                        if (!this.getPlayer(j).getTeam().equals(t) || this.getPlayer((int)j).controlledBy != null) continue;
                        this.worlds[j].chat("/t " + output);
                    }
                } else if (chat.startsWith("/play")) {
                    if (from.watchOnly()) {
                        from.printMessage("You have guest-only status in this room and cannot play. You need to ``vox/buy/?source=guestin`Register Castle Vox` to play long-term games online");
                        return;
                    }
                    Player alreadyControlling = this.getPlayerFor(from.name());
                    if (alreadyControlling != null) {
                        from.printMessage("You already control player " + alreadyControlling.name());
                        return;
                    }
                    if (this.numberHumanPlayers() == this.ops.players.size() - 1) {
                        from.printMessage("This game is full of human players. Try another room, hosts listed in green have open player positions");
                        return;
                    }
                    String desiredPlayer = chat.length() > 6 ? chat.substring(6) : null;
                    Object previousPlayer = this.botTakeoverMemory.get(from.key());
                    if (previousPlayer != null) {
                        if (desiredPlayer == null || desiredPlayer.equals(previousPlayer)) {
                            if (!this.transferBot(from, previousPlayer.toString())) {
                                from.printMessage("Could not transfer player " + desiredPlayer);
                            }
                        } else {
                            from.printMessage("You used to control " + previousPlayer + ". You cannot take control of a different player");
                        }
                        return;
                    }
                    if (!this.transferBot(from, desiredPlayer)) {
                        from.printMessage("Could not transfer player " + desiredPlayer);
                    }
                } else if (chat.equals("/me")) {
                    this.printToFrom(from, "Please enter an action. i.e.: /me laughs");
                } else if (chat.startsWith("/me ")) {
                    this.chatlog.add(new ChatEntry(chat, from == null ? null : from.name()));
                    String output = chat.substring(chat.indexOf(" ") + 1);
                    if (from != null) {
                        output = from.name() + " " + output;
                    }
                    for (int i = 0; this.connections != null && i < this.connections.size(); ++i) {
                        VoxNetClient vc = (VoxNetClient)this.connections.get(i);
                        vc.encodeln("EMOTE: " + output);
                    }
                    this.sendMessageToBots("/me " + output);
                } else if (chat.startsWith("/getMostValuableEnemyBorder")) {
                    int ID = Integer.parseInt(chat.substring(chat.indexOf(" ") + 1));
                    Country fromCountry = this.masterWorld.getCountriesArray()[ID];
                    Country dest = CountryPathFinder.getMostValuableEnemyBorder(fromCountry, 2, this.masterWorld);
                    this.printToFrom(from, "getMostValuableEnemyBorder(" + fromCountry + ", range 2) = " + dest);
                } else if (chat.startsWith("/saveGame")) {
                    from.encodeln("saveGame: " + this.statsHistory.toStringXML());
                } else if (chat.trim().equals("/desc")) {
                    this.printToFrom(from, this.description);
                } else if (chat.trim().equals("/surrender")) {
                    this.surrender(from);
                } else if (chat.trim().equalsIgnoreCase("/pingtracker") || chat.trim().equalsIgnoreCase("/ping")) {
                    this.updateTracker();
                } else if (chat.trim().equalsIgnoreCase("/pingfix")) {
                    if (this.ops.internetPublic) {
                        this.voxTracker.stop();
                        this.voxTracker = new VoxTracker(this);
                    }
                } else if (chat.trim().equalsIgnoreCase("/version")) {
                    this.printToFrom(from, "Castle Vox server version 1.2");
                } else if (chat.startsWith("/desc ")) {
                    if (this.fullPowers(from)) {
                        this.description = chat.substring(chat.indexOf(" ") + 1);
                        this.printMessage(this.description);
                        this.updateTracker();
                    }
                } else if (chat.startsWith("/boot ")) {
                    if (this.fullPowers(from)) {
                        String name = chat.substring(chat.indexOf(" ") + 1);
                        VoxNetClient vc = this.getConnectionNamed(name);
                        if (vc == null) {
                            this.printToFrom(from, "No client found with that name");
                        } else {
                            vc.kill();
                        }
                    } else {
                        from.printMessage("Not allowed to boot");
                    }
                } else if (chat.startsWith("/setAI")) {
                    if (from != null && from.watchOnly()) {
                        from.printMessage("You have guest-only status in this room and cannot play. You need to ``vox/buy/?source=guestin`Register Castle Vox` to play long-term games online");
                        return;
                    }
                    if (this.ops.internetPublic && !this.fullPowers(from)) {
                        this.printToFrom(from, "AI changes are not allowed in public multi-player games. Type /play in the chat to join the game");
                        return;
                    }
                    int IDpos = chat.indexOf(" ") + 1;
                    int ID = Integer.parseInt(chat.substring(IDpos, chat.indexOf(" ", IDpos + 1)));
                    String newAI = chat.substring(chat.indexOf(" ", IDpos + 1) + 1);
                    this.switchAI(ID, newAI, from);
                } else if (chat.startsWith("/waiting") || chat.equals("/w")) {
                    String result = this.waitingForList();
                    this.printToFrom(from, "Game is waiting for: " + result);
                } else {
                    this.printToFrom(from, "Unknown command: " + chat);
                }
            } else {
                this.chatlog.add(new ChatEntry(chat, from == null ? null : from.name()));
                String output = chat;
                if (from != null) {
                    output = from.name() + ": " + output;
                }
                this.sendToAllClients(output);
                if ("play".equals(chat) || "help".equals(chat)) {
                    this.printToFrom(from, "Enter a slash before a word for command words like " + chat + ". Try: /" + chat);
                }
            }
        }
        catch (Throwable t) {
            SS.debug("Exception in dealWithChat(" + chat + ", " + from);
            t.printStackTrace();
        }
    }

    public void printToFrom(VoxNetClient from, String text) {
        if (from == null) {
            System.out.println(text);
        } else {
            from.printMessage(text);
        }
    }

    public String connectedNamesList() {
        String result = "";
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient n = (VoxNetClient)this.connections.get(i);
            result = result + n.name() + ", ";
        }
        if (result.length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        return result;
    }

    boolean longTimer() {
        return this.ops.useTurnTimer && this.ops.turnTimerLength > 28800;
    }

    public String waitingForList() {
        if (this.masterWorld.roundCount == 1 && this.ops.internetPublic && this.ops.useTurnTimer && this.getNumberOfHumanPlayersAlive() < this.getNumberOfPlayers() - 1) {
            return "more human players" + (this.getNumberOfHumanPlayersAlive() == 0 ? "" : ", or first round timer to run out");
        }
        if (this.gameOver) {
            if ((long)(this.ops.turnTimerLength * 1000) - this.ops.gameOverForHowLong() > 0L) {
                return StringTool.timeFormat((long)(this.ops.turnTimerLength * 1000) - this.ops.gameOverForHowLong()) + " before a restart is allowed";
            }
            return "someone to restart it";
        }
        String result = "";
        for (int j = 0; j < this.waitingForPlayer.length; ++j) {
            if (!this.waitingForPlayer[j] || this.stats.getArmies(j) <= 14 || this.givenUp[j]) continue;
            result = result + this.getPlayer(j).getBrain() + ", ";
        }
        if (result.length() > 2) {
            result = result.substring(0, result.length() - 2);
        }
        if (result.equals("") && this.isGameOver()) {
            result = (long)(this.ops.turnTimerLength * 1000) - this.ops.gameOverForHowLong() > 0L ? StringTool.timeFormat((long)(this.ops.turnTimerLength * 1000) - this.ops.gameOverForHowLong()) + " before a restart is allowed" : "someone to restart it";
        }
        return result;
    }

    private boolean fullPowers(VoxNetClient from) {
        if (from == null) {
            return true;
        }
        if (from.name().equals("dustin")) {
            return true;
        }
        if (from.isModerator()) {
            return true;
        }
        return from.isLocalclient();
    }

    private Team getTeamFor(VoxNetClient vc) {
        if ("BOTKEY".equals(vc.key())) {
            for (int m = 0; m < this.ops.players.size(); ++m) {
                Player p = this.getPlayer(m);
                if (!vc.name().endsWith(p.name())) continue;
                return p.getTeam();
            }
        }
        return this.getTeamFor(vc.name());
    }

    private Team getTeamFor(String vcName) {
        for (int m = 0; m < this.ops.players.size(); ++m) {
            Player p = this.getPlayer(m);
            if (p.controlledBy == null || !p.controlledBy.equalsIgnoreCase(vcName)) continue;
            return p.getTeam();
        }
        return null;
    }

    private VoxNetClient getConnectionNamed(String name) {
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient n = (VoxNetClient)this.connections.get(i);
            if (!n.name().equalsIgnoreCase(name)) continue;
            return n;
        }
        return null;
    }

    private Player getPlayerFor(String vcName) {
        for (int m = 0; m < this.ops.players.size(); ++m) {
            Player p = this.getPlayer(m);
            if (p.controlledBy == null || !p.controlledBy.equalsIgnoreCase(vcName)) continue;
            return p;
        }
        return null;
    }

    private void sendUserlist(VoxNetClient from) {
        if (from == null) {
            System.out.println("  " + Translator.getString("UserList") + " - " + (this.connections.size() - this.getNumberOfGuestOnly()) + "/" + this.connections.size() + " " + Translator.getString("players") + ":");
            for (int i = 0; i < this.connections.size(); ++i) {
                VoxNetClient n = (VoxNetClient)this.connections.get(i);
                System.out.println("    " + n.name() + " " + (n.guestOnly() ? "(" + Translator.getString("guestonly") + ")" : "") + " - " + n.ip());
            }
            return;
        }
        from.takeChat("  " + Translator.getString("UserList") + " - " + (this.connections.size() - this.getNumberOfGuestOnly()) + "/" + this.connections.size() + " " + Translator.getString("players") + ":");
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient n = (VoxNetClient)this.connections.get(i);
            from.takeChat("    " + n.name() + " " + (n.guestOnly() ? "(" + Translator.getString("guestonly") + ")" : ""));
        }
    }

    protected void printMessage(String output) {
        this.printMessage(output, false);
    }

    protected void printMessage(String output, boolean persist) {
        this.sendToAllClients("\u2731 " + output + " \u2731");
        SS.debug(output, 1);
        if (persist) {
            this.persistMessage(output);
        }
    }

    private void println(String output) {
        this.sendToAllClients(output);
    }

    private void sendToAllClients(String output) {
        for (int i = 0; this.connections != null && i < this.connections.size(); ++i) {
            ((VoxNetClient)this.connections.get(i)).takeChat(output);
        }
        if (Vox.headless) {
            System.out.println(output);
        }
        this.sendMessageToBots(output);
    }

    private void sendMessageToBots(String output) {
        for (int j = 1; j < this.ops.players.size(); ++j) {
            if (this.getPlayer((int)j).controlledBy != null) continue;
            try {
                this.worlds[j].chat(output);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void AIChat(int playerID, String chat) {
        if (chat.startsWith("/") && !chat.startsWith("/t ")) {
            return;
        }
        this.dealWithChat(chat, VoxNetClient.botClient(this.getPlayer(playerID)));
    }

    private VoxNetClient clientWithName(String name) {
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(i);
            if (!vc.name().equals(name)) continue;
            return vc;
        }
        return null;
    }

    public void finishedMoves(int playerID) {
        if (this.killed || playerID < 0) {
            return;
        }
        if (!this.waitingForPlayer[playerID]) {
            SS.debug("Player " + playerID + "-" + this.getPlayer(playerID).getName() + " has ALREADY finished their moves - ignore this");
            return;
        }
        SS.debug("Player " + playerID + "-" + this.getPlayer(playerID).getName() + " has finished their moves", 1);
        this.waitingForPlayer[playerID] = false;
        this.updateTracker();
        this.tookLastTurn[playerID] = true;
        for (int i = 1; i < this.waitingForPlayer.length; ++i) {
            if (!this.waitingForPlayer[i] || this.stats.getArmies(i) <= 14 || this.givenUp[i]) continue;
            return;
        }
        if (this.masterWorld.roundCount == 1 && this.ops.internetPublic && this.ops.useTurnTimer && this.getNumberOfHumanPlayersAlive() < this.getNumberOfPlayers() - 1) {
            this.printMessage("Round " + this.masterWorld.roundCount + " will last until the timer runs out, or every player is human");
            return;
        }
        this.printMessage("All players have finished their moves for round " + this.masterWorld.roundCount, true);
        SS.debug(" ", 1);
        SS.debug("** All players have finished their moves for round " + this.masterWorld.roundCount + " -> Resolve the round.... **", 1);
        this.waitingForAnyone = false;
    }

    private void startGameLoopThread() {
        this.gameStarted = true;
        this.gameLoopThread = new Thread("EndOfRound-loop"){

            public void run() {
                VoxServer.this.endOfRoundLoop();
            }
        };
        this.gameLoopThread.start();
    }

    private void endOfRoundLoop() {
        SS.debug("start endOfRoundLoop() in round " + this.masterWorld.roundCount, 1);
        while (!(this.killed || this.gameOver || this.endGameLoop)) {
            while (this.waitingForAnyone && !this.killed && !this.endGameLoop) {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception timex) {}
            }
            try {
                if (!this.killed && !this.endGameLoop) {
                    this.revealAllMoves();
                    if (!Vox.superfast) {
                        Thread.sleep(Prefs.getInt("turnDelay", 100));
                    }
                }
                if (this.killed || this.endGameLoop) continue;
                this.endOfRound();
            }
            catch (Exception e) {
                if (this.killed) continue;
                e.printStackTrace();
            }
        }
        SS.debug("finished endOfRoundLoop()", 1);
        SS.debug(" ", 1);
    }

    public void sendHumanMoves(List humanMoves, int playerID) {
        SS.debug("Server got " + humanMoves.size() + " human moves from " + this.getPlayer((int)playerID).controlledBy, 1);
        this.worlds[playerID].undoAllCommands(this.getPlayer(playerID));
        this.worlds[playerID].addCommands(humanMoves);
    }

    public void showNotice(String text, Point p, long length) {
    }

    private void sendMoneyInfo(VoxNetClient vc) {
        for (int m = 0; m < this.ops.players.size(); ++m) {
            Player p = this.getPlayer(m);
            int money = this.masterWorld.getPlayerMoney(p);
            vc.setMoney(m, money);
        }
        vc.doneMoneys();
    }

    void addClient(VoxNetClient vc) {
        int controlID;
        if (this.ops.internetPublic) {
            try {
                Vector activeAlias = new Vector();
                String keyCheck = VoxTracker.isNameKeyValid(vc, activeAlias, this.ops.mapTitle, this.ops.useTurnTimer && this.ops.turnTimerLength > 3600);
                if (!"1".equals(keyCheck)) {
                    if ("2".equals(keyCheck)) {
                        vc.setPlayable(false);
                    } else {
                        vc.printMessage("tra: 3 ERROR: " + keyCheck);
                        vc.kill();
                        return;
                    }
                }
                if (activeAlias.size() > 0) {
                    vc.printMessage("tra: 3 WARNING: :Aliascheck1:" + activeAlias.get(0) + "). If you play with this new name, you will reset your other player's RAW");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                vc.printMessage("ERROR: The server could not be reached to validate your nickname for Internet Public games. Please try again later");
                vc.kill();
                return;
            }
        }
        if ((controlID = this.playerIDcontrolledBy(vc)) > -1 && this.ops.allowNetworkPlayers) {
            Player p = this.getPlayer(controlID);
            if (!vc.key().equals(p.controlledByKey)) {
                vc.printMessage("Somebody is already playing here using the name " + vc.name() + ". If that's really you, try re-entering your ``contact/registration.php`registration code`. Otherwise, choose a new name and try again.");
                vc.encodeln("KILL:");
                vc.kill();
                return;
            }
        }
        vc.setVoxOptions(this.ops);
        vc.setExtraLines(this.lines, this.ops.height);
        vc.setContinents(this.continents);
        vc.setWorldData(this.countries);
        vc.setGameRound(this.masterWorld.roundCount - 1);
        Team joinerTeam = this.getTeamFor(vc);
        for (int m = 0; m < this.chatlog.size(); ++m) {
            String output;
            ChatEntry chat = (ChatEntry)this.chatlog.get(m);
            if (chat.text.startsWith("/t ")) {
                Team fromTeam = this.getTeamFor(chat.from);
                if ((joinerTeam != null || fromTeam != null) && (joinerTeam == null || !joinerTeam.equals(fromTeam))) continue;
                String output2 = chat.from == null ? chat.text.substring(3) : chat.from + ": " + chat.text.substring(3);
                vc.takeChatColored(output2, null);
                continue;
            }
            if (chat.text.startsWith("/me ")) {
                output = chat.text.substring(chat.text.indexOf(" ") + 1);
                if (chat.from != null) {
                    output = chat.from + " " + output;
                }
                vc.encodeln("EMOTE: " + output);
                continue;
            }
            if (chat.from == null) {
                output = chat.text;
                vc.printMessage(output);
                continue;
            }
            output = chat.from + ": " + chat.text;
            vc.takeChat(output);
        }
        vc.startNewRound(this.turnTimeLeft());
        this.sendMoneyInfo(vc);
        this.connections.add(vc);
        if (vc.guestOnly()) {
            this.printMessage(vc.name() + " has joined as guest only in round " + this.masterWorld.roundCount);
        } else {
            this.printMessage(vc.name() + " has joined in round " + this.masterWorld.roundCount);
        }
        this.sendUserlist(vc);
        vc.printMessage(this.description);
        int ID = this.playerIDcontrolledBy(vc);
        if (ID > -1) {
            vc.setPlayerID(ID);
            vc.showOwnedCommands(this.worlds[ID].getCommands());
            if (this.savedGame) {
                this.doTurnMoves();
                this.startGameLoopThread();
            } else if (!this.waitingForPlayer[ID]) {
                vc.encodeln("notwaiting: ");
            }
            if (this.gameOver) {
                vc.gameOver(this.statsHistory);
                vc.encodeln("doneJoining:");
                return;
            }
            vc.encodeln("doneJoining:");
            return;
        }
        if (this.gameOver) {
            vc.gameOver(this.statsHistory);
            vc.encodeln("doneJoining:");
            return;
        }
        if (!this.ops.allowNetworkPlayers) {
            this.transferBot(vc, null);
        }
        vc.encodeln("doneJoining:");
        this.updateTracker();
    }

    private boolean transferBot(VoxNetClient vc, String desiredBot) {
        SS.debug("transferBot(" + vc.name() + ", " + desiredBot);
        int ID = this.getAItoReplace();
        if (desiredBot != null) {
            ID = this.getAItoReplace(desiredBot);
        }
        if (ID == -1) {
            return false;
        }
        if (ID > -1) {
            Player p = this.getPlayer(ID);
            p.setAgentType("Human");
            if (!this.savedGame || !p.controlledBySaved) {
                p.controlledBy = vc.name();
                p.controlledByKey = vc.key();
            }
            vc.setPlayerID(ID);
            vc.encodeln("addGameStartedCount: ");
            this.waitingForPlayer[ID] = true;
            if (this.savedGame) {
                vc.showOwnedCommands(this.worlds[ID].getCommands());
            }
            this.setControlling(ID, p.controlledBy);
            this.printMessage(vc.name() + " now controls player " + this.getPlayer(ID).getName() + " on team " + this.getPlayer(ID).getTeam(), true);
        }
        if (this.numberHumanPlayers() == 1 && !this.gameStarted) {
            SS.debug("Added first human player, order bot moves and start the game loop", 1);
            this.currentTurnStartedAtTime = new Date().getTime();
            this.doTurnMoves();
            this.startGameLoopThread();
            for (int i = 0; i < this.connections.size(); ++i) {
                VoxNetClient vci = (VoxNetClient)this.connections.get(i);
                vci.setGameRound(this.masterWorld.roundCount - 1);
                vci.startNewRound(this.turnTimeLeft());
            }
        }
        return true;
    }

    private void setControlling(int ID, String name) {
        for (int c = 0; c < this.connections.size(); ++c) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(c);
            vc.encodeln("setControlling: " + ID + " " + name);
        }
    }

    private void setAI(int ID, String name) {
        for (int c = 0; c < this.connections.size(); ++c) {
            VoxNetClient vc = (VoxNetClient)this.connections.get(c);
            vc.encodeln("setAI: " + ID + " " + name);
        }
    }

    private int playerIDcontrolledBy(VoxNetClient vc) {
        for (int m = 0; m < this.ops.players.size(); ++m) {
            Player p = this.getPlayer(m);
            if (vc.name().equalsIgnoreCase(p.controlledBy)) {
                return m;
            }
            if (!"<saved game player>".equals(vc.name()) || !p.isHuman()) continue;
            return m;
        }
        return -1;
    }

    void removeClient(VoxNetClient vc) {
        if (this.connections == null) {
            return;
        }
        if (this.connections.remove(vc)) {
            this.printMessage(vc.name() + " has exited ");
        }
        if (!(this.connections.size() != 0 || this.ops.allowNetworkPlayers && Vox.headless)) {
            this.kill();
        } else {
            this.updateTracker();
        }
    }

    protected void acceptLocalClient(VoxClient localClient) {
        try {
            PipedOutputStream serverOut = new PipedOutputStream();
            PipedInputStream clientIn = new PipedInputStream(serverOut);
            PipedOutputStream clientOut = new PipedOutputStream();
            PipedInputStream serverIn = new PipedInputStream(clientOut);
            localClient.setInputOutput(clientIn, clientOut);
            new VoxNetClient(serverIn, serverOut, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void listenForClients() {
        try {
            this.sock = new ServerSocket(this.socketPort);
            Vox.localServerAddress = InetAddress.getLocalHost().getHostAddress();
            SS.debug("Starting VoxServer with local IP " + Vox.localServerAddress + " port " + this.socketPort + " and waiting for players to join...");
            if (this.ops.internetPublic) {
                this.voxTracker = new VoxTracker(this);
            }
            this.portFinalized = true;
            boolean desireMoreClients = true;
            while (!this.killed && desireMoreClients) {
                Socket incoming = null;
                try {
                    incoming = this.sock.accept();
                }
                catch (SocketException e) {
                    SS.debug("ServerSocket exception: " + e);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                if (incoming == null) continue;
                incoming.setKeepAlive(true);
                new VoxNetClient(incoming, this);
                if (this.ops.allowNetworkPlayers) continue;
                desireMoreClients = false;
            }
        }
        catch (BindException e) {
            SS.debug("VoxServer -> There's already a server running on port " + this.socketPort + ", will try on " + (this.socketPort + 1));
            ++this.socketPort;
            this.listenForClients();
            return;
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.voxTracker != null) {
            this.voxTracker.stop();
        }
        SS.debug("VoxServer.listenForClients() thread finished");
        if (Vox.headless) {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception e) {
                SS.debug("sleep exception 2873465");
            }
            System.exit(0);
        }
    }

    public void listenOnTerminal() {
        new Thread("headless-stdin-reader"){

            public void run() {
                try {
                    String temp;
                    BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
                    while ((temp = in.readLine()) != null) {
                        try {
                            if ("".equals(temp.trim())) continue;
                            VoxServer.this.dealWithChat(temp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                SS.debug("VoxServer.listonOnTerminal() thread finished");
            }
        }.start();
    }

    private void turnTimerExpired() {
        if (this.ops.useTurnTimer && this.gameStarted && !this.gameOver && this.waitingForAnyone) {
            this.printMessage("Time ran out in round " + this.masterWorld.roundCount, true);
            this.waitingForAnyone = false;
        }
    }

    public void turnTimerTick() {
        long currentTime;
        int turnSecondsLeft;
        if (this.ops.useTurnTimer && (turnSecondsLeft = (int)((double)this.ops.turnTimerLength - (double)((currentTime = new Date().getTime()) - this.currentTurnStartedAtTime) / 1000.0)) < 1) {
            this.currentTurnStartedAtTime = 0L;
            this.turnTimerExpired();
        }
    }

    public int getNumberOfHumansConnected() {
        return this.connections.size();
    }

    public int getNumberOfHumanPlayersAlive() {
        int count = 0;
        for (int i = 0; i < this.ops.players.size(); ++i) {
            Player p = this.getPlayer(i);
            if (!p.isHuman() || this.stats.getArmies(i) <= 14) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfGuestOnly() {
        int count = 0;
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient net = (VoxNetClient)this.connections.get(i);
            if (!net.guestOnly()) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfTotalPlayersAlive() {
        int count = 0;
        for (int i = 0; i < this.ops.players.size(); ++i) {
            Player p = this.getPlayer(i);
            if (this.stats.getArmies(i) <= 14) continue;
            ++count;
        }
        return count;
    }

    public int numberAvailablePlayers() {
        int count = 0;
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient net = (VoxNetClient)this.connections.get(i);
            if (net.guestOnly()) continue;
            ++count;
        }
        return count;
    }

    List getGuestNameList() {
        Vector<String> result = new Vector<String>();
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient net = (VoxNetClient)this.connections.get(i);
            if (this.getPlayerFor(net.name()) != null) continue;
            result.add(net.name());
        }
        return result;
    }

    static void debugPlayerList(List players) {
        SS.debug("playerlist:");
        for (int i = 0; i < players.size(); ++i) {
            Player p = (Player)players.get(i);
            SS.debug("player " + p.getID() + " - " + p.name() + " on " + p.getTeam() + " agent " + p.getAgentType());
        }
    }

    static void debugList(List l) {
        SS.debug("debuglist:");
        for (int i = 0; i < l.size(); ++i) {
            SS.debug("list item " + i + " = " + l.get(i));
        }
    }

    void debugCountry(int worldID, int countryID) {
        SS.debug("debugCountry world " + worldID + ": " + ((Country)this.worlds[worldID].getCountries().get(countryID)).toStringWithUnits());
    }

    private void kill() {
        this.killed = true;
        try {
            this.sock.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.turnTimer != null) {
            this.turnTimer.cancel();
            this.turnTimer = null;
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            VoxNetClient net = (VoxNetClient)this.connections.get(i);
            net.closeSocket();
        }
        this.teams = null;
        this.countries = null;
        this.continents = null;
        this.masterWorld = null;
        this.worlds = null;
        this.waitingForPlayer = null;
        this.ops = null;
        this.map = null;
        this.humanPlayer = null;
        this.chatlog = null;
        this.connections = null;
    }

    public Stats getStats() {
        return this.stats;
    }

    public VoxOptions getOps() {
        return this.ops;
    }

    public String getAgentTypeForDifficulty(String difficulty) {
        if ("-- Easy --".equals(difficulty) || ("-- " + Translator.getString("Easy") + " --").equals(difficulty)) {
            String[] bots = Vox.getBotsEasy();
            return bots[SS.rand.nextInt(bots.length)];
        }
        if ("-- Medium --".equals(difficulty) || ("-- " + Translator.getString("Medium") + " --").equals(difficulty)) {
            String[] bots = Vox.getBotsMedium();
            return bots[SS.rand.nextInt(bots.length)];
        }
        if ("-- Hard --".equals(difficulty) || ("-- " + Translator.getString("Hard") + " --").equals(difficulty)) {
            String[] bots = Vox.getBotsHard();
            return bots[SS.rand.nextInt(bots.length)];
        }
        if ("-- Random --".equals(difficulty) || ("-- " + Translator.getString("Random") + " --").equals(difficulty)) {
            Object[] bots = Vox.getBots();
            return (String)bots[SS.rand.nextInt(bots.length)];
        }
        return difficulty;
    }

    public String serverName() {
        if (this.serverName == null) {
            return "null";
        }
        return this.serverName;
    }

    public void setNetworkKey(String networkKey) {
        this.networkKey = networkKey;
    }

    public void log(String info) {
    }

    public void updateTracker() {
        if (this.voxTracker != null) {
            this.voxTracker.update();
        }
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public int round() {
        return this.masterWorld.roundCount;
    }

    public int getTurnSecondsLeft() {
        if (this.gameOver) {
            return 0;
        }
        if (!this.ops.useTurnTimer) {
            return 1000000;
        }
        long currentTime = new Date().getTime();
        int turnSecondsLeft = (int)((double)this.ops.turnTimerLength - (double)(currentTime - this.currentTurnStartedAtTime) / 1000.0);
        return turnSecondsLeft;
    }

    private long turnTimeLeft() {
        if (this.gameOver) {
            return 0L;
        }
        if (!this.ops.useTurnTimer) {
            return 1000000L;
        }
        long currentTime = new Date().getTime();
        long turnTimeLeft = (long)(this.ops.turnTimerLength * 1000) - (currentTime - this.currentTurnStartedAtTime);
        return turnTimeLeft;
    }

    private void surrender(VoxNetClient vc) {
        int ID = this.playerIDcontrolledBy(vc);
        if (ID < 0) {
            return;
        }
        if (!this.givenUp[ID]) {
            this.givenUp[ID] = true;
            this.printMessage(vc.name() + " yields to the pressure, and raises the white flag of surrender", true);
            if (!this.ops.allowNetworkPlayers) {
                this.soloGameSurrenderWinner = this.getLargestTeam();
            }
            if (this.gameOverConditions() != null) {
                this.waitingForAnyone = false;
            }
        }
    }

    public Team getLargestTeam() {
        int i;
        int largestCount = 0;
        Team largestTeam = null;
        boolean[] outputPlayer = new boolean[this.ops.players.size()];
        for (i = 0; i < this.ops.players.size(); ++i) {
            outputPlayer[i] = false;
        }
        for (i = 0; i < this.ops.players.size(); ++i) {
            if (outputPlayer[i]) continue;
            Player p = this.getPlayer(i);
            Team t = p.getTeam();
            int count = 0;
            for (int j = 0; j < this.ops.players.size(); ++j) {
                Player jp = this.getPlayer(j);
                if (outputPlayer[j] || !jp.getTeam().equals(p.getTeam())) continue;
                count += this.stats.getArmies(jp.getID());
            }
            if (count <= largestCount) continue;
            largestCount = count;
            largestTeam = t;
        }
        return largestTeam;
    }

    protected Team gameOverConditions() {
        if (this.soloGameSurrenderWinner != null) {
            return this.soloGameSurrenderWinner;
        }
        boolean testingGameOver = true;
        Team possibleWinner = null;
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.hasCastle() || this.givenUp[c.getOwner().getID()]) continue;
            if (possibleWinner == null) {
                possibleWinner = c.getTeam();
                continue;
            }
            if (possibleWinner.equals(c.getTeam())) continue;
            testingGameOver = false;
        }
        if (possibleWinner == null) {
            SS.debug("case 238746511");
            testingGameOver = false;
        }
        if (testingGameOver) {
            return possibleWinner;
        }
        return null;
    }

    public VoxWorld getWorld() {
        return this.masterWorld;
    }

    protected void exitBotTakeover(int ID, String newAI, VoxNetClient from) {
        String key = from.key();
        String value = this.getPlayerFor(from.name()).getName();
        this.botTakeoverMemory.put(key, value);
        this.switchAI(ID, newAI, from);
    }

    private void switchAI(int ID, String newAI, VoxNetClient from) {
        Player p = this.getPlayer(ID);
        boolean switchToHuman = false;
        if ("Human".equalsIgnoreCase(newAI)) {
            switchToHuman = true;
            for (int m = 0; m < this.ops.players.size(); ++m) {
                Player match = this.getPlayer(m);
                if (!from.name().equalsIgnoreCase(match.controlledBy)) continue;
                String swapAI = p.getBrain();
                if (swapAI.equalsIgnoreCase(from.name())) {
                    return;
                }
                match.controlledBy = null;
                match.controlledByKey = null;
                match.setAgentType(swapAI);
                this.worlds[m].setupBot(match);
                this.printMessage(match.name() + " is now powered by " + match.getAgentType() + (match.controlledBy != null ? " " + match.controlledBy : ""), true);
                this.setAI(m, swapAI);
                this.setControlling(m, match.controlledBy);
                this.worlds[m].getBotMoves();
            }
            p.controlledBy = from.name();
            p.controlledByKey = from.key();
            from.setPlayerID(ID);
        } else {
            if (this.masterWorld.roundCount > 1) {
                p.controlledByPrevious = p.controlledBy;
                p.controlledByKeyPrevious = p.controlledByKey;
            }
            p.controlledBy = null;
            p.controlledByKey = null;
            p.agentOverride = false;
        }
        p.setAgentType(newAI);
        this.printMessage(p.name() + " is now powered by " + p.getAgentType() + (p.controlledBy != null ? " " + p.controlledBy : ""), true);
        this.setAI(ID, newAI);
        this.setControlling(ID, p.controlledBy);
        if (switchToHuman) {
            this.waitingForPlayer[ID] = true;
        } else {
            this.worlds[ID].undoAllCommands(p);
            this.worlds[ID].getBotMoves();
        }
    }

    protected void persistMessage(String message) {
        this.chatlog.add(new ChatEntry(message, null));
    }

    private class ChatEntry {
        public String text;
        public String from;

        public ChatEntry(String text, String from) {
            this.text = text;
            this.from = from;
        }
    }
}

