/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Vox;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VoxOptions
implements Serializable,
XMLSerializable {
    static final long serialVersionUID = -6252907239237927233L;
    public List players;
    public int width;
    public int height;
    public String mapTitle;
    public String mapTheme;
    public String playerInfoPointString;
    public String difficulty;
    public boolean useScenario;
    public boolean allowNetworkPlayers;
    public boolean internetPublic;
    public boolean useTurnTimer;
    public int turnTimerLength;
    public int borderWidth = 7;
    public long gameStartedTime;
    public long gameEndedTime;

    public VoxOptions(boolean allowNetworkPlayers, String difficulty) {
        this.setStartTime();
        if (Vox.headless) {
            this.useTurnTimer = Vox.timeParam > 7;
            this.turnTimerLength = Vox.timeParam;
        } else {
            this.useTurnTimer = Prefs.getBoolean("turnTimer", false);
            this.turnTimerLength = Prefs.getInt("turnTimerSeconds", 120);
        }
        this.difficulty = difficulty;
        this.useScenario = true;
        this.allowNetworkPlayers = allowNetworkPlayers;
        this.internetPublic = allowNetworkPlayers && Prefs.getBoolean("internetPublic", false);
    }

    public VoxOptions(String XML) {
        try {
            this.useTurnTimer = Boolean.parseBoolean(XMLTool.extractAttribute("useTurnTimer", XML));
            this.turnTimerLength = Integer.parseInt(XMLTool.extractAttribute("turnTimerLength", XML));
            this.width = Integer.parseInt(XMLTool.extractAttribute("width", XML));
            this.height = Integer.parseInt(XMLTool.extractAttribute("height", XML));
            String borderWidthString = XMLTool.extractAttribute("borderWidth", XML);
            this.borderWidth = borderWidthString == null ? 7 : Integer.parseInt(borderWidthString);
            this.borderWidth = Math.min(this.borderWidth, 14);
            this.mapTitle = XMLTool.extractAttribute("mapTitle", XML);
            this.mapTheme = XMLTool.extractAttribute("mapTheme", XML);
            this.difficulty = XMLTool.extractAttribute("difficulty", XML);
            this.allowNetworkPlayers = Boolean.parseBoolean(XMLTool.extractAttribute("allowNetworkPlayers", XML));
            this.internetPublic = Boolean.parseBoolean(XMLTool.extractAttribute("internetPublic", XML));
            this.playerInfoPointString = XMLTool.extractAttribute("playerInfoPointString", XML);
            ArrayList<Player> list = new ArrayList<Player>();
            String item = XMLTool.extract("vplayer", XML);
            int h = 1;
            while (item != null) {
                Player object = new Player(item);
                list.add(object);
                item = XMLTool.extract("vplayer", XML, h);
                ++h;
            }
            this.players = list;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.useScenario = true;
    }

    public String toStringXML() {
        return "<VoxOptions width=\"" + this.width + "\" height=\"" + this.height + "\" allowNetworkPlayers=\"" + this.allowNetworkPlayers + "\" internetPublic=\"" + this.internetPublic + "\" mapTitle=\"" + this.mapTitle + "\" mapTheme=\"" + this.mapTheme + "\" useScenario=\"" + this.useScenario + "\" useTurnTimer=\"" + this.useTurnTimer + "\" turnTimerLength=\"" + this.turnTimerLength + "\" playerInfoPointString=\"" + this.playerInfoPointString + "\" borderWidth=\"" + this.borderWidth + "\" difficulty=\"" + this.difficulty + "\" >" + XMLTool.getListXML(this.players, "vplayer") + "</VoxOptions>";
    }

    public String toString() {
        return super.toString() + ": " + ",\n\t width=" + this.width + ",\n\t height=" + this.height + ",\n\t allowNetworkPlayers=" + this.allowNetworkPlayers + ",\n\t internetPublic=" + this.internetPublic + ",\n\t mapTitle=" + this.mapTitle + ",\n\t useScenario=" + this.useScenario + ",\n\t useTurnTimer=" + this.useTurnTimer + ",\n\t turnTimerLength=" + this.turnTimerLength;
    }

    public void setEndTime() {
        this.gameEndedTime = System.currentTimeMillis();
    }

    public int getGameMinutes() {
        long gameTime = (this.gameEndedTime == 0L ? System.currentTimeMillis() : this.gameEndedTime) - this.gameStartedTime;
        return Math.round((float)gameTime / 60000.0f);
    }

    public boolean gameOver1Turn() {
        if (!this.useTurnTimer) {
            return true;
        }
        return System.currentTimeMillis() - this.gameEndedTime >= (long)(this.turnTimerLength * 1000);
    }

    public long gameOverForHowLong() {
        if (this.gameEndedTime == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.gameEndedTime;
    }

    public String gameLengthReadable() {
        return StringTool.timeFormat((this.gameEndedTime == 0L ? System.currentTimeMillis() : this.gameEndedTime) - this.gameStartedTime);
    }

    protected void setStartTime() {
        this.gameStartedTime = System.currentTimeMillis();
    }
}

