/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.SS;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;

public class VoxNetTalker {
    protected Socket sock;
    protected InputStream in;
    protected OutputStream out;
    private byte[] byteBuffer = new byte[20];
    private int byteBufferCount = 0;

    public void setSocket(Socket s) {
        this.sock = s;
        try {
            this.in = this.sock.getInputStream();
            this.out = this.sock.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setInputOutput(InputStream in, OutputStream out) {
        this.sock = null;
        this.in = in;
        this.out = out;
    }

    synchronized void encodeln(String message) {
        block4: {
            try {
                this.out.write((message + "\n").getBytes("UTF-8"));
                this.out.flush();
            }
            catch (SocketException e) {
                if (!"KILL:".equals(message)) {
                    this.kill();
                }
            }
            catch (Throwable e) {
                SS.debug("NetTalker -> caught (" + e + ") in encodeln()");
                if ("KILL:".equals(message)) break block4;
                this.kill();
            }
        }
    }

    protected String readLine() {
        try {
            boolean done = false;
            while (!done) {
                int next = this.in.read();
                if (next == -1) {
                    SS.debug("Vox -> readLine() got a -1 (EOS) buf=" + this.getStringFromByteBuffer(), 1);
                    return null;
                }
                char n = (char)next;
                if (n == '\r' || n == '\n') {
                    done = true;
                    continue;
                }
                this.addByteToBuffer((byte)next);
            }
            return this.getStringFromByteBuffer();
        }
        catch (Throwable t) {
            return null;
        }
    }

    private void clearByteBuffer() {
        this.byteBufferCount = 0;
    }

    private void addByteToBuffer(byte b) {
        if (this.byteBufferCount == this.byteBuffer.length) {
            byte[] newBuffer = new byte[this.byteBuffer.length * 2];
            for (int i = 0; i < this.byteBuffer.length; ++i) {
                newBuffer[i] = this.byteBuffer[i];
            }
            this.byteBuffer = newBuffer;
        }
        this.byteBuffer[this.byteBufferCount] = b;
        ++this.byteBufferCount;
    }

    private String getStringFromByteBuffer() {
        String result;
        try {
            result = new String(this.byteBuffer, 0, this.byteBufferCount, "UTF-8");
        }
        catch (Exception e) {
            result = "";
        }
        this.clearByteBuffer();
        return result;
    }

    public void kill() {
    }

    public void closeSocket() {
        try {
            this.in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.sock.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.in = null;
        this.out = null;
        this.sock = null;
    }

    public String ip() {
        if (this.sock == null || this.sock.getInetAddress() == null) {
            return "null-IP";
        }
        return this.sock.getInetAddress().getHostAddress();
    }
}

