/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.StatsHistory;
import com.sillysoft.vox.VoxNetTalker;
import com.sillysoft.vox.VoxOptions;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.vox.command.Command;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.List;

public class VoxNetClient
extends VoxNetTalker
implements Runnable {
    private VoxServer server;
    private Thread listenThread;
    private float remoteVersion;
    private String remoteName;
    private String remoteUserKey;
    protected boolean guestOnly;
    private boolean readingHeaders;
    private boolean killed = false;
    private boolean moderator = false;
    private boolean localclient = false;
    private boolean notAllowedToPlay = false;
    private static VoxNetClient fakeClient;

    public VoxNetClient(String name) {
        this.remoteName = name;
        this.remoteUserKey = "BOTKEY";
    }

    public VoxNetClient(Socket s, VoxServer server) {
        this.setSocket(s);
        this.server = server;
        new Thread((Runnable)this, "VoxNetClient").start();
    }

    public VoxNetClient(InputStream in, OutputStream out, VoxServer server) {
        this.server = server;
        this.localclient = true;
        this.setInputOutput(in, out);
        new Thread((Runnable)this, "VoxNetClient").start();
    }

    public boolean isLocalclient() {
        return this.localclient;
    }

    public void run() {
        this.listenThread = Thread.currentThread();
        try {
            String input = this.readLine();
            if (input != null && input.startsWith("VOXCONNECT-")) {
                float remoteVersion = Float.parseFloat(input.substring(11, input.indexOf(":")));
                if (remoteVersion < 0.9f) {
                    this.encodeln("VOXCONNECT-" + remoteVersion + ":server");
                    this.printMessage(Translator.getString("oldVersion"));
                    this.printMessage(Translator.getString("goDownload"));
                    this.closeSocket();
                    return;
                }
                this.encodeln("VOXCONNECT-0.9:server");
                this.remoteName = input.substring(input.indexOf(":") + 1);
                String nextLine = this.readLine();
                this.readingHeaders = true;
                while (!"".equals(nextLine.trim())) {
                    this.decode(nextLine);
                    nextLine = this.readLine();
                }
                this.readingHeaders = false;
                this.server.addClient(this);
                if (0.9f < remoteVersion) {
                    SS.debug("Warning: Client '" + this.remoteName + "' has newer networkVersion. They=" + remoteVersion + ", us=" + 0.9f);
                }
            } else {
                if (input != null && input.startsWith("VOXTRACKER-")) {
                    this.encodeln("VOXTRACKER-0.1:verify");
                    this.closeSocket();
                    return;
                }
                this.closeSocket();
                return;
            }
            while (!this.killed) {
                input = this.readLine();
                if (input == null) {
                    this.kill();
                    continue;
                }
                try {
                    this.decode(input);
                }
                catch (Throwable t) {
                    SS.debug("decode failed with input of (" + input + "): " + t);
                    t.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            SS.debug("VoxNetConnection.run caught an exception");
            e.printStackTrace();
        }
        this.kill();
        this.closeSocket();
        this.listenThread = null;
        this.server = null;
    }

    public synchronized void kill() {
        if (this.server != null) {
            this.server.removeClient(this);
        }
        if (this.killed) {
            return;
        }
        this.killed = true;
        SS.debug("VoxNetClient " + this.remoteName + " kill()");
        this.encodeln("KILL:");
        this.closeSocket();
    }

    public void decode(String command) {
        SS.debug("server of " + this.remoteName + " decode: " + command, 5);
        String[] params = StringTool.tokenize(command, " ");
        if (params.length == 0) {
            return;
        }
        if (params[0].equals("CHAT:")) {
            this.server.dealWithChat(command.substring(6), this);
        } else if (params[0].equals("KILL:")) {
            this.kill();
        } else if (params[0].equals("finishedMoves:")) {
            this.server.finishedMoves(Integer.parseInt(params[1]));
        } else if (params[0].equals("sendHumanMoves:")) {
            List list = Command.getCommandListFromXML(command.substring(params[0].length() + params[1].length() + 2), this.server);
            this.server.sendHumanMoves(list, Integer.parseInt(params[1]));
        } else if (params[0].equals("userKey:")) {
            this.remoteUserKey = params.length > 1 ? params[1] : "";
        } else if (params[0].equals("guestOnly:")) {
            this.guestOnly = true;
        } else if (params[0].equals("exitsetAI:")) {
            int ID = Integer.parseInt(params[1]);
            String newAI = params[2];
            this.server.exitBotTakeover(ID, newAI, this);
        } else if (!params[0].equals("remote-version:")) {
            SS.debug("VoxNC -> Unknown network command: " + command);
        }
    }

    private void hackAttempt(final String message) {
        SS.debug("Oopsalon?!?!?! - " + message);
        new Thread(){

            public void run() {
                this.setPriority(1);
                try {
                    URLTool.getURL("http://sillysoft.net/lux/alert.php?message=" + URLEncoder.encode(message) + "&attackerIP=" + URLEncoder.encode(VoxNetClient.this.ip()) + "&attackerKey=" + URLEncoder.encode(VoxNetClient.this.remoteUserKey) + "&attackerNick=" + URLEncoder.encode(VoxNetClient.this.remoteName) + "&server=" + VoxNetClient.this.server);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }.start();
    }

    public String name() {
        return this.remoteName;
    }

    public String key() {
        return this.remoteUserKey;
    }

    public boolean guestOnly() {
        return this.guestOnly;
    }

    public void startNewRound(long turnTimeLeft) {
        this.encodeln("startNewRound: " + turnTimeLeft);
    }

    public void setWorldData(List countries) {
        this.encodeln("countries: " + XMLTool.getListXML(countries, "vcountry"));
    }

    public void gameOver(StatsHistory statsHistory) {
        this.encodeln("gameOver: " + statsHistory.toStringXML());
    }

    public void setMoney(int playerID, int money) {
        this.encodeln("setMoney: " + playerID + " " + money);
    }

    public void doneMoneys() {
        this.encodeln("doneMoneys:");
    }

    public void setVoxOptions(VoxOptions ops) {
        this.encodeln("voxOptions: " + ops.toStringXML());
    }

    public void setGameRound(int roundCount) {
        this.encodeln("setGameRound: " + roundCount);
    }

    public void setExtraLines(List list, int height) {
        String itemName = "elines";
        StringBuffer buf = new StringBuffer("<" + itemName + "list>");
        for (int i = 0; i < list.size(); ++i) {
            ExtraLine ob = (ExtraLine)list.get(i);
            buf.append("<" + itemName + ">");
            buf.append(ob.getXML(height));
            buf.append("</" + itemName + ">");
        }
        buf.append("</" + itemName + "list>");
        String result = buf.toString();
        this.encodeln("setExtraLines: " + result);
    }

    public void setContinents(List continents) {
        this.encodeln("setContinents: " + XMLTool.getListXML(continents, "vcont"));
    }

    public void setPlayerID(int ID) {
        this.encodeln("setPlayerID: " + ID);
    }

    public void showAllCommands(List fullCommandList) {
        this.encodeln("showCommands: " + XMLTool.getListXML(fullCommandList, "vcommand"));
    }

    public void showOwnedCommands(List fullCommandList) {
        this.encodeln("showOwnedCommands: " + XMLTool.getListXML(fullCommandList, "vcommand"));
    }

    public void takeChat(String text) {
        this.encodeln("CHAT: " + text);
    }

    public void takeChatColored(String text, Object color) {
        this.encodeln("CHATCOLOR: color " + text);
    }

    protected void printMessage(String output) {
        this.takeChat("\u2731 " + output + " \u2731");
    }

    protected void setModerator(boolean value) {
        this.moderator = value;
    }

    public boolean isModerator() {
        return this.moderator;
    }

    public void setPlayable(boolean value) {
        boolean bl = this.notAllowedToPlay = !value;
        if (!this.guestOnly && this.notAllowedToPlay) {
            this.guestOnly = true;
        }
    }

    public boolean watchOnly() {
        return this.notAllowedToPlay;
    }

    public static VoxNetClient botClient(Player p) {
        return new VoxNetClient(p.getBrain() + " AI " + p.getName());
    }
}

