/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.lux.editor.MapEditor;
import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.gui.RankingController;
import com.sillysoft.lux.gui.UpdateController;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.DirectoryTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.FolderLauncher;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.PrefsCache;
import com.sillysoft.tools.RemoteImageFetcher;
import com.sillysoft.tools.RemoteImageListener;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.AboutWindowVox;
import com.sillysoft.vox.Achievements;
import com.sillysoft.vox.PluginWindowVox;
import com.sillysoft.vox.PreferencesWindowVox;
import com.sillysoft.vox.VJoinGame;
import com.sillysoft.vox.Vox;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.Newsletter;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSApplicationGUI;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSFrameWatcher;
import com.sillysoft.widgets.SSLink;
import com.sillysoft.widgets.SSMenuItem;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSTextField;
import com.sillysoft.widgets.TexturedPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.DefaultEditorKit;
import net.roydesign.mac.MRJAdapter;

public class VoxGUI
extends Vox
implements SSApplicationGUI,
SSFrameWatcher,
ActionListener,
WindowListener,
RemoteImageListener {
    private boolean fillingMapSelector = false;
    protected SSFrame newGameWindow;
    private JMenuBar menuBar;
    protected SSTextField playerName;
    protected SSComboBox mapSelector;
    protected SSComboBox mapStartingConditions;
    protected SSComboBox difficulty;
    protected SSComboBox controlPlayer;
    private SSButton playButton;
    private SSButton enterCodeButton;
    private SSButton orderNowButton;
    private JLabel registration;
    private JLabel mapStartingConditionsWords;
    private JLabel pluginImage;
    private JPanel regLabelPanel;
    private Font regfont;
    public static String username;
    protected Vector windows = new Vector();
    protected Vector activeGames = new Vector();
    public static final String WHITE_STAR = "\u2606";
    public static final String BLACK_STAR = "\u2605";
    public static final String PLAYER_STAR = "\u265c";
    VoxServer server;
    public static boolean networkGameClosing;
    public static boolean quitting;

    public static VoxGUI getInstance() {
        return (VoxGUI)sharedVox;
    }

    public VoxGUI() {
        SSApp.setInstance(this);
        this.sharewareVersion = true;
        if (!"".equals(Prefs.get("regCode", "").trim())) {
            this.sharewareVersion = false;
        }
        this.createNewGameWindow();
        this.showNewGameWindow();
        SSFrame.setFrameWatcher(this);
        UpdateController.initUpdateController("http://sillysoft.net/", 1.2f, this);
        UpdateController.checkForUpdate(null);
        MusicEngine.setTracks(new String[]{"/Music/CV_Main Theme.ogg", "/Music/CV_Victory.ogg", "/Music/CV_Civil War.ogg", "/Music/CV_Medieval.ogg", "/Music/CV_Modern Military.ogg", "/Music/CV_Roman.ogg"});
        MusicEngine.startTrackSequence(6);
        Prefs.putInt("launchCount", Prefs.getInt("launchCount", 0) + 1);
        if (SS.isMacintosh) {
            try {
                MRJAdapter.addAboutListener((ActionListener)new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        AboutWindowVox.show(SSApp.getInstance());
                    }
                });
                MRJAdapter.addPreferencesListener((ActionListener)new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        PreferencesWindowVox.show();
                    }
                });
                MRJAdapter.addQuitApplicationListener((ActionListener)new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        VoxGUI.this.quit();
                    }
                });
            }
            catch (Throwable t) {
                System.out.println("ERROR: Vox could not find some parts of itself that it needs to integrate into the MacOS X environment. Perhaps this was caused by running the Linux installer on a Macintosh. This is not currently supported. Please go to http://sillysoft.net/vox/ to get the Macintosh package if you want to run Lux on your Mac. You may be able to get around this error by putting the MRJAdapter.jar jar on the classpath when running Lux.");
                t.printStackTrace();
            }
        }
    }

    private void createNewGameWindow() {
        this.newGameWindow = new SSFrame("Castle Vox");
        this.newGameWindow.setAutoTracking(false);
        this.newGameWindow.addWindowListener(this);
        this.newGameWindow.setResizable(false);
        JPanel innerSettingsPanel = new JPanel();
        innerSettingsPanel.setLayout(new BoxLayout(innerSettingsPanel, 1));
        innerSettingsPanel.add(Box.createVerticalGlue());
        this.mapSelector = new SSComboBox();
        this.mapSelector.setMaximumRowCount(30);
        this.mapSelector.setOpaque(false);
        if (!SS.isMacintosh) {
            this.mapSelector.setFont(GraphicsTool.getDejaFontSized(12));
        }
        innerSettingsPanel.add(this.mapSelector);
        JPanel mapButtonPanel = new JPanel();
        mapButtonPanel.setLayout(new BoxLayout(mapButtonPanel, 0));
        SSButton button = new SSButton(" ", new ImageIcon(GraphicsTool.class.getResource("/arrow_plugin_left.png")));
        button.setVerticalAlignment(1);
        button.setOpaque(false);
        button.setPreferredWidth(60);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int next = VoxGUI.this.mapSelector.getSelectedIndex() - 1;
                if (next < 0) {
                    next = VoxGUI.this.mapSelector.getItemCount() - 1;
                }
                if (VoxGUI.this.mapSelector.getItemAt(next).equals(" \u221e " + Translator.getString("Getmoremaps"))) {
                    next -= 2;
                }
                VoxGUI.this.mapSelector.setSelectedIndex(next);
            }
        });
        button.putClientProperty("JButton.buttonType", "text");
        mapButtonPanel.add(button);
        String pluginButtonText = Translator.getString("PluginsButton");
        for (int i = pluginButtonText.length(); i < 18; i += 2) {
            pluginButtonText = " " + pluginButtonText + " ";
        }
        button = new SSButton(pluginButtonText);
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PluginWindowVox.show();
            }
        });
        mapButtonPanel.add(Box.createHorizontalGlue());
        mapButtonPanel.add(button);
        mapButtonPanel.add(Box.createHorizontalGlue());
        button = new SSButton(" ", new ImageIcon(GraphicsTool.class.getResource("/arrow_plugin_right.png")));
        button.setPreferredWidth(60);
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int next = VoxGUI.this.mapSelector.getSelectedIndex() + 1;
                if (next >= VoxGUI.this.mapSelector.getItemCount()) {
                    next = 0;
                }
                if (VoxGUI.this.mapSelector.getItemAt(next).equals(" \u221e " + Translator.getString("MapEditor") + "...")) {
                    next = 0;
                }
                VoxGUI.this.mapSelector.setSelectedIndex(next);
            }
        });
        mapButtonPanel.add(button);
        mapButtonPanel.setOpaque(false);
        innerSettingsPanel.add(mapButtonPanel);
        JPanel panel = GraphicsTool.getNonOpaqueJPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createVerticalGlue());
        panel.add(new JLabel("    "));
        innerSettingsPanel.add(panel);
        int popupControlWidth = 200;
        username = Prefs.get("playerNames0", null);
        if (username == null) {
            username = System.getProperty("user.name").trim();
            int spacePos = username.indexOf(32);
            if (spacePos != -1) {
                username = username.substring(0, spacePos);
            }
            if (username.toLowerCase().trim().equals("default")) {
                username = "general" + SS.rand.nextInt(1000);
            } else if (username.toLowerCase().trim().startsWith("admin")) {
                username = "voxer" + SS.rand.nextInt(1000);
            }
            if (username.length() > 6) {
                username = username.substring(0, 6) + SS.rand.nextInt(100);
            }
            Prefs.put("playerNames0", username);
        }
        this.playerName = new SSTextField(username, 16);
        JPanel playerNamePanel = new JPanel();
        playerNamePanel.setLayout(new BoxLayout(playerNamePanel, 0));
        playerNamePanel.setOpaque(false);
        playerNamePanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        playerNamePanel.add(new JLabel(" " + Translator.getString("Name") + ": "));
        playerNamePanel.add(Box.createHorizontalGlue());
        JPanel borderPanel = new JPanel(new FlowLayout(2, 0, 0));
        borderPanel.setOpaque(false);
        borderPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        borderPanel.add(this.playerName);
        playerNamePanel.add(borderPanel);
        if (SS.isMacintosh) {
            playerNamePanel.add(Box.createHorizontalStrut(6));
        }
        innerSettingsPanel.add(playerNamePanel);
        this.controlPlayer = new SSComboBox(new Object[]{"need to load players from the selected map"});
        this.controlPlayer.setOpaque(false);
        this.controlPlayer.setPreferredWidth(popupControlWidth);
        if (!SS.isMacintosh) {
            this.controlPlayer.setFont(GraphicsTool.getDejaFontSized(12));
        }
        JPanel playAsPanel = GraphicsTool.getNonOpaqueJPanel();
        playAsPanel.setLayout(new BoxLayout(playAsPanel, 0));
        playAsPanel.add(new JLabel(" " + Translator.getString("playas") + "    "));
        playAsPanel.add(Box.createHorizontalGlue());
        playAsPanel.add(this.controlPlayer);
        innerSettingsPanel.add(playAsPanel);
        if (!SS.isMacintosh) {
            innerSettingsPanel.add(Box.createVerticalStrut(2));
        }
        this.difficulty = new SSComboBox();
        this.difficulty.setOpaque(false);
        if (!SS.isMacintosh) {
            this.difficulty.setFont(GraphicsTool.getDejaFontSized(12));
        }
        this.difficulty.addItem("-- " + Translator.getString("Easy") + " --");
        this.difficulty.addItemList(Vox.getBotsEasy());
        this.difficulty.addItem("-- " + Translator.getString("Medium") + " --");
        this.difficulty.addItemList(Vox.getBotsMedium());
        this.difficulty.addItem("-- " + Translator.getString("Hard") + " --");
        this.difficulty.addItemList(Vox.getBotsHard());
        String[] possibleAgents = DirectoryTool.listFilesWithSuffix(DesktopTool.supportFolderPath() + "Agents", ".class");
        if (possibleAgents.length > 0) {
            this.difficulty.addItem("-- " + Translator.getString("Other") + " --");
            this.difficulty.addItemList(possibleAgents);
        }
        this.difficulty.addItem("-- " + Translator.getString("Random") + " --");
        this.difficulty.setPreferredWidth(popupControlWidth);
        playAsPanel = GraphicsTool.getNonOpaqueJPanel();
        playAsPanel.setLayout(new BoxLayout(playAsPanel, 0));
        playAsPanel.add(new JLabel(" " + Translator.getString("difficulty")));
        playAsPanel.add(Box.createHorizontalGlue());
        if (!SS.isMacintosh) {
            playAsPanel.add(Box.createHorizontalStrut(4));
        }
        playAsPanel.add(this.difficulty);
        innerSettingsPanel.add(playAsPanel);
        innerSettingsPanel.add(Box.createVerticalGlue());
        TexturedPanel borderedSettingsPanel = new TexturedPanel(new Color(154, 155, 132, 114));
        borderedSettingsPanel.setLayout(new BoxLayout(borderedSettingsPanel, 0));
        borderedSettingsPanel.setOpaque(false);
        TitledBorder tBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), Translator.getString("mainGuiTitle"), 4, 1, new Font("Verdana", 1, 18), Color.BLACK);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(tBorder, BorderFactory.createEmptyBorder(6, 5, 3, 14));
        borderedSettingsPanel.setBorder(compoundBorder);
        innerSettingsPanel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        innerSettingsPanel.setOpaque(false);
        borderedSettingsPanel.add(innerSettingsPanel);
        borderedSettingsPanel.add(Box.createHorizontalStrut(10));
        this.pluginImage = new JLabel();
        this.pluginImage.setBorder(null);
        this.pluginImage.setIconTextGap(0);
        this.pluginImage.setMinimumSize(new Dimension(170, 140));
        this.pluginImage.setVerticalAlignment(1);
        this.pluginImage.setHorizontalAlignment(0);
        JPanel pluginImagePanel = new JPanel(new BorderLayout());
        pluginImagePanel.setLayout(new BoxLayout(pluginImagePanel, 1));
        pluginImagePanel.setOpaque(false);
        pluginImagePanel.add((Component)this.pluginImage, "North");
        pluginImagePanel.setBorder(null);
        pluginImagePanel.setMinimumSize(new Dimension(170, 140));
        pluginImagePanel.setPreferredSize(new Dimension(170, 140));
        borderedSettingsPanel.add(pluginImagePanel);
        int preferredButtonWidth = 240;
        JPanel leftButtonPanel = GraphicsTool.getNonOpaqueJPanel();
        leftButtonPanel.setLayout(new BoxLayout(leftButtonPanel, 1));
        leftButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel rightButtonPanel = GraphicsTool.getNonOpaqueJPanel();
        rightButtonPanel.setLayout(new BoxLayout(rightButtonPanel, 1));
        rightButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        button = new SSButton(Translator.getString("Instructions"));
        button.setOpaque(false);
        button.setPreferredWidth(preferredButtonWidth);
        button.setActionCommand("instructions");
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(button);
        leftButtonPanel.add(borderPanel);
        button = new SSButton(Translator.getString("MapEditor"));
        button.setOpaque(false);
        button.setPreferredWidth(preferredButtonWidth);
        button.setActionCommand("mapEditor");
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(button);
        leftButtonPanel.add(borderPanel);
        button = new SSButton(Translator.getString("Preferences"));
        button.setOpaque(false);
        button.setPreferredWidth(preferredButtonWidth);
        button.setActionCommand("preferences");
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(button);
        leftButtonPanel.add(borderPanel);
        button = new SSButton(Translator.getString("Achievements"));
        button.setOpaque(false);
        button.setPreferredWidth(preferredButtonWidth);
        button.setActionCommand("achievements");
        button.addActionListener(this);
        button.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(button);
        rightButtonPanel.add(borderPanel);
        SSButton joinButton = new SSButton(Translator.getString("ShowNetworkGames"));
        joinButton.setOpaque(false);
        joinButton.setPreferredWidth(preferredButtonWidth);
        joinButton.setActionCommand("showJoinWindow");
        joinButton.addActionListener(this);
        joinButton.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(joinButton);
        rightButtonPanel.add(borderPanel);
        this.playButton = new SSButton(Translator.getString("StartNewGame"));
        this.playButton.setOpaque(false);
        this.playButton.setPreferredWidth(preferredButtonWidth);
        this.playButton.setActionCommand("startGame");
        this.playButton.addActionListener(this);
        this.playButton.setAlignmentX(0.5f);
        borderPanel = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        borderPanel.add(this.playButton);
        rightButtonPanel.add(borderPanel);
        JPanel lowerButtonPanel = new JPanel(new BorderLayout());
        lowerButtonPanel.setOpaque(false);
        lowerButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        lowerButtonPanel.add((Component)leftButtonPanel, "West");
        lowerButtonPanel.add((Component)rightButtonPanel, "East");
        JPanel registrationPanel = GraphicsTool.getNonOpaqueJPanel();
        registrationPanel.setLayout(new BoxLayout(registrationPanel, 1));
        this.registration = new JLabel("CASTLE VOX VERSION 1.2 - next generation strategy", 0);
        this.regfont = new Font(this.registration.getFont().getName(), 0, this.registration.getFont().getSize() - 2);
        this.registration.setFont(this.regfont);
        if (this.sharewareVersion) {
            // empty if block
        }
        this.regLabelPanel = new JPanel(new FlowLayout(1, 0, 0));
        this.regLabelPanel.setOpaque(false);
        this.setRegistration();
        registrationPanel.add(this.regLabelPanel);
        lowerButtonPanel.add((Component)registrationPanel, "South");
        JPanel controlPanel = new JPanel();
        controlPanel.setOpaque(false);
        controlPanel.setLayout(new BoxLayout(controlPanel, 1));
        controlPanel.add(borderedSettingsPanel);
        controlPanel.add(lowerButtonPanel);
        TexturedPanel contentPanel = new TexturedPanel("Vox_Interface_background.png", true, false, new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 12));
        contentPanel.add((Component)controlPanel, "Center");
        contentPanel.add((Component)new JLabel(new ImageIcon(GraphicsTool.class.getResource("/Vox_Logo_Small_Vertical.png"))), "West");
        this.newGameWindow.setContentPane(contentPanel);
        PrefsCache.reloadStatics();
        this.fillMapSelector(Prefs.get("mapSelector", "Tutorial Map"));
        this.difficulty.setSelectedItem(Prefs.get("difficulty", "-- " + Translator.getString("Random") + " --"));
        this.mapSelector.addActionListener(new ActionListener(){
            private String lastItem = Prefs.get("mapSelector", "Tutorial Map");

            public void actionPerformed(ActionEvent e) {
                if (VoxGUI.this.fillingMapSelector) {
                    return;
                }
                if ((" \u221e " + Translator.getString("Getmoremaps")).equals(VoxGUI.this.getSelectedMapName())) {
                    PluginWindowVox.show();
                    if (this.lastItem != null) {
                        VoxGUI.this.mapSelector.setSelectedItem(this.lastItem);
                    }
                } else if ((" \u221e " + Translator.getString("MapEditor") + "...").equals(VoxGUI.this.getSelectedMapName())) {
                    MapEditor ed = new MapEditor(VoxGUI.getInstance(), true);
                    VoxGUI.this.newGameWindow.hide();
                    VoxGUI.this.saveSelections();
                    if (this.lastItem != null) {
                        VoxGUI.this.mapSelector.setSelectedItem(this.lastItem);
                    }
                } else if ((" \u221e " + Translator.getString("GotoSavedBoards")).equals(VoxGUI.this.getSelectedMapName())) {
                    FolderLauncher.openPath(DesktopTool.supportFolderPath() + "Maps");
                    if (this.lastItem != null) {
                        VoxGUI.this.mapSelector.setSelectedItem(this.lastItem);
                    }
                } else {
                    if (!"-- Random --".equals(VoxGUI.this.controlPlayer.getSelectedString()) || !"-- Random --".equals(Prefs.get("controlPlayer_" + VoxGUI.this.stripStars(this.lastItem), "-- Random --"))) {
                        Prefs.put("controlPlayer_" + VoxGUI.this.stripStars(this.lastItem), VoxGUI.this.controlPlayer.getSelectedString());
                    }
                    VoxGUI.this.loadInfoForSelectedMap();
                    VoxGUI.this.setPreviewImage();
                }
                this.lastItem = VoxGUI.this.mapSelector.getSelectedString();
            }
        });
        this.loadInfoForSelectedMap();
        this.setPreviewImage();
        this.menuBar = this.makeCommonMenuBar(this.newGameWindow);
        this.newGameWindow.setJMenuBar(this.menuBar);
        this.newGameWindow.pack();
        this.newGameWindow.setLocationID("newGame");
    }

    public JMenuBar makeCommonMenuBar(JFrame forWindow) {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.makeFileMenu(forWindow));
        menuBar.add(this.makeEditMenu());
        menuBar.add(this.makeOnlineMenu());
        menuBar.add(this.makeHelpMenu());
        return menuBar;
    }

    public JMenu makeFileMenu(JFrame forWindow) {
        return this.makeFileMenu(forWindow, true);
    }

    public JMenu makeFileMenu(JFrame forWindow, boolean loadSavedMapShortcut) {
        return this.makeFileMenu(forWindow, true, false);
    }

    public JMenu makeFileMenu(JFrame forWindow, boolean loadSavedMapShortcut, boolean sendCloseToListeners) {
        JMenu menu = new JMenu(Translator.getString("File"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(70);
        }
        SSMenuItem menuItem = new SSMenuItem(Translator.getString("NewGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showNewGameWindow");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("OpenSavedGame"));
        if (loadSavedMapShortcut) {
            menuItem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        }
        menuItem.setActionCommand("openSavedGame");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("JoinNetworkGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(74, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showJoinWindow");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("Preferences"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(44, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("preferences");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Achievements"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("achievements");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("PluginManager"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("plugins");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("MapEditor"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("mapEditor");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        if (this.sharewareVersion) {
            menuItem = new SSMenuItem(Translator.getString("EnterCode"));
            menuItem.setActionCommand("enterCode");
            menuItem.addActionListener(this);
            menu.add(menuItem);
            menuItem = new SSMenuItem(Translator.getString("RegisterOnline"));
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    UpdateController.gotoBuy("luxmenu");
                }
            });
            menu.add(menuItem);
        } else {
            menuItem = new SSMenuItem(Translator.getString("ChangeRegistration"));
            menuItem.setActionCommand("enterCode");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        if (forWindow != null) {
            menu.addSeparator();
            menuItem = new SSMenuItem(Translator.getString("Close"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            final JFrame closeTarget = forWindow;
            final boolean useListeners = sendCloseToListeners;
            menuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (useListeners) {
                        try {
                            WindowListener[] wls = closeTarget.getWindowListeners();
                            if (wls.length > 0) {
                                for (int i = 0; i < wls.length; ++i) {
                                    wls[i].windowClosing(null);
                                }
                                return;
                            }
                        }
                        catch (Exception exception) {}
                    } else {
                        closeTarget.hide();
                        closeTarget.dispose();
                    }
                }
            });
            menu.add(menuItem);
        }
        if (!SS.isMacintosh) {
            menuItem = new SSMenuItem(Translator.getString("ExitLux"));
            menuItem.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            menuItem.setActionCommand("quit");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        return menu;
    }

    public JMenu makeEditMenu() {
        JMenu menu = new JMenu(Translator.getString("Edit"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(69);
        }
        SSMenuItem menuItem = new SSMenuItem(new DefaultEditorKit.CutAction());
        menuItem.setText(Translator.getString("Cut"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        menuItem = new SSMenuItem(new DefaultEditorKit.CopyAction());
        menuItem.setText(Translator.getString("Copy"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        menuItem = new SSMenuItem(new DefaultEditorKit.PasteAction());
        menuItem.setText(Translator.getString("Paste"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menu.add(menuItem);
        return menu;
    }

    public JMenu makeOnlineMenu() {
        JMenu menu = new JMenu(Translator.getString("Online"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(79);
        }
        SSMenuItem menuItem = new SSMenuItem("Sillysoft Games");
        menuItem.setActionCommand("gotoSillysoft");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem("Castle Vox " + Translator.getString("Forums"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("gotoForums");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("UserWiki"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("gotoWiki");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("MakeYourOwnMap"));
        menuItem.setActionCommand("showMapNotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("CodeYourOwnAI"));
        menuItem.setActionCommand("showAINotes");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("SillysoftNewsletter"));
        menuItem.setActionCommand("newsletter");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem("Email Feedback");
        menuItem.setActionCommand("featureRequest");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem("Debug Report");
        menuItem.setActionCommand("debug");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("CheckForUpdate"));
        menuItem.setActionCommand("updateCheck");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        return menu;
    }

    public JMenu makeHelpMenu() {
        JMenu menu = new JMenu(Translator.getString("Help"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(72);
        }
        SSMenuItem menuItem = new SSMenuItem("Castle Vox " + Translator.getString("Instructions"));
        menuItem.setActionCommand("instructions");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem("Castle Vox " + Translator.getString("Shortcuts"));
        menuItem.setActionCommand("showKeyboardShortcuts");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        if (!SS.isMacintosh) {
            menu.addSeparator();
            menuItem = new SSMenuItem(Translator.getString("About") + " Castle Vox");
            menuItem.setActionCommand("showAboutWindow");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        return menu;
    }

    public void actionPerformed(ActionEvent event) {
        block52: {
            try {
                String command = event.getActionCommand();
                if ("startGame".equals(command)) {
                    try {
                        ++Vox.localServerPort;
                        boolean netGame = Prefs.getBoolean("allowNetworkPlayers", false);
                        boolean publicGame = netGame && Prefs.getBoolean("internetPublic", false);
                        int port = netGame ? 3319 : SS.rand.nextInt(6000) + 3400;
                        this.server = new VoxServer(this.getSelectedMapName(), this.getSelectedPlayerName(), this.difficulty.getSelectedString(), netGame, port, this.playerName.getText().trim());
                        if (this.server.loadedProperly) {
                            this.newGameWindow.hide();
                            this.saveSelections();
                            VoxClient client = new VoxClient(this.server, this.playerName.getText().trim(), Prefs.get("regCode", ""), netGame);
                        }
                        break block52;
                    }
                    catch (Exception sx) {
                        sx.printStackTrace();
                        SSOptionPane.showMessageDialog(null, "Error loading '" + this.getSelectedMapName() + "'. \n\n" + sx, Translator.getString("Error"), 0);
                        return;
                    }
                }
                if ("openSavedGame".equals(command)) {
                    if (VoxClient.fullscreen) {
                        SS.beep();
                        return;
                    }
                    FileDialog d = new FileDialog((Frame)this.newGameWindow, Translator.getEditorString("Selectaboardfile"), 0);
                    d.setDirectory(DesktopTool.savedGameDir());
                    d.pack();
                    d.show();
                    String dir = d.getDirectory();
                    String file = d.getFile();
                    d.dispose();
                    if (dir != null && file != null) {
                        SS.debug("Load saved game: " + dir + file);
                        this.newGameWindow.hide();
                        this.server = new VoxServer(dir + file);
                        VoxClient client = new VoxClient(this.server);
                    }
                    break block52;
                }
                if ("showNewGameWindow".equals(command)) {
                    this.showNewGameWindow();
                    this.saveSelections();
                    break block52;
                }
                if ("showJoinWindow".equals(command)) {
                    VJoinGame.show();
                    this.newGameWindow.hide();
                    this.saveSelections();
                    break block52;
                }
                if ("quit".equals(command)) {
                    this.quit();
                    break block52;
                }
                if ("recordBook".equals(command)) {
                    RankingController.show();
                    break block52;
                }
                if ("mapEditor".equals(command)) {
                    MapEditor ed = new MapEditor(this, true);
                    this.newGameWindow.hide();
                    this.saveSelections();
                    break block52;
                }
                if ("showRulesNotes".equals(command)) {
                    UpdateController.notesRules();
                    break block52;
                }
                if ("showPrefsNotes".equals(command)) {
                    UpdateController.notesPrefs();
                    break block52;
                }
                if ("showHostingNotes".equals(command)) {
                    UpdateController.notesHosting();
                    break block52;
                }
                if ("showKeyboardShortcuts".equals(command)) {
                    BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + Translator.getString("Castle_Vox_Shortcuts.html"));
                    break block52;
                }
                if ("showChangelog".equals(command)) {
                    UpdateController.notesChangelog();
                    break block52;
                }
                if ("showAboutWindow".equals(command)) {
                    AboutWindowVox.show(this);
                    break block52;
                }
                if ("showMapNotes".equals(command)) {
                    BrowserLauncher.openURL("http://sillysoft.net/vox/maps/developer.php");
                    break block52;
                }
                if ("showAINotes".equals(command)) {
                    UpdateController.gotoAI();
                    break block52;
                }
                if ("bugReport".equals(command)) {
                    UpdateController.gotoBugReport();
                    break block52;
                }
                if ("debug".equals(command)) {
                    try {
                        String javaVersion = System.getProperty("java.version");
                        String javaVersionMinor = javaVersion.substring(javaVersion.indexOf("_") + 1);
                        int minorVersion = Integer.parseInt(javaVersionMinor);
                        if (!SS.isMacintosh && minorVersion < 21) {
                            SSOptionPane.showMessageDialog(this.newGameWindow, "It looks like you have an old version of Java on your computer. Castle Vox uses Java to run and older versions can cause problems. Please go to www.java.com and update your Java, this might solve your problem.", "", 1);
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    String input = JOptionPane.showInputDialog(this.newGameWindow, (Object)"This will send your log file to Sillysoft for analysis.\n\nPlease describe your bug report:");
                    if (input != null) {
                        SSOptionPane.showMessageDialog(this.newGameWindow, "Your report has been sent to Sillysoft, thank you.", "", 1);
                        String logReport = "Vox GUI " + username + " DEBUG: " + input + "\n" + ((LogFile)System.out).getLog() + "\n\n" + Prefs.exportSubtree() + "\n\n";
                        SSApp.alertSillysoft(logReport);
                    }
                    break block52;
                }
                if ("featureRequest".equals(command)) {
                    UpdateController.sendEmail();
                } else if ("gotoForums".equals(command)) {
                    UpdateController.gotoForums();
                } else if ("gotoWiki".equals(command)) {
                    UpdateController.gotoWiki();
                } else if ("gotoRankings".equals(command)) {
                    UpdateController.gotoRankings();
                } else if ("gotoSillysoft".equals(command)) {
                    UpdateController.gotoSillysoftHomepage();
                } else if (command.equalsIgnoreCase("plugins")) {
                    PluginWindowVox.show();
                } else if (command.equalsIgnoreCase("preferences")) {
                    PreferencesWindowVox.show();
                } else if (command.equalsIgnoreCase("achievements")) {
                    Achievements.show();
                    this.newGameWindow.hide();
                } else if (command.equalsIgnoreCase("instructions")) {
                    VoxGUI.instructions();
                } else if (command.equalsIgnoreCase("updateCheck")) {
                    UpdateController.checkForUpdate(this);
                } else if (command.equalsIgnoreCase("newsletter")) {
                    Newsletter.show(null, "http://sillysoft.net/");
                } else if ("enterCode".equals(command)) {
                    EnterCodeWindow.show(this);
                } else {
                    SS.debug("Lux -> Unimplemented action command: " + command);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
        this.windowClosing(e);
    }

    public void windowClosing(WindowEvent e) {
        SS.debug("VoxGUI: windowClosing");
        this.saveSelections();
        if (this.windows.size() == 0) {
            this.quit();
        } else {
            this.printActiveWindowList();
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void showNewGameWindow() {
        if (this.newGameWindow.isVisible()) {
            this.newGameWindow.toFront();
        } else {
            this.newGameWindow.show();
            if (null == this.newGameWindow.getRootPane().getDefaultButton()) {
                this.newGameWindow.getRootPane().setDefaultButton(this.playButton);
            }
        }
    }

    public String stripStars(String input) {
        while (input.endsWith(" ") || input.endsWith(BLACK_STAR) || input.endsWith(WHITE_STAR) || input.endsWith(PLAYER_STAR)) {
            input = input.substring(0, input.length() - 1);
        }
        return input;
    }

    public String getSelectedMapName() {
        return this.stripStars(this.mapSelector.getSelectedString());
    }

    public String getSelectedPlayerName() {
        return this.stripStars(this.controlPlayer.getSelectedString());
    }

    public void fillMapSelector(String selection) {
        int j;
        this.fillingMapSelector = true;
        this.mapSelector.removeAllItems();
        Vector mapList = new Vector();
        PluginManager.buildMapListFromFolder(new File(DesktopTool.supportFolderPath() + "Maps"), "", mapList);
        for (j = 0; j < mapList.size(); ++j) {
            int w;
            String map;
            String mapEntry = map = (String)mapList.get(j);
            int won = Vox.getStatsPrefs().getInt("wonMap_" + map, 0);
            int wonAll = Vox.getStatsPrefs().getInt("wonAll_" + map, 0);
            if (won > 0 || wonAll > 0) {
                mapEntry = mapEntry + " ";
            }
            for (w = 0; w < wonAll; ++w) {
                mapEntry = mapEntry + BLACK_STAR;
            }
            for (w = 0; w < won - wonAll; ++w) {
                mapEntry = mapEntry + WHITE_STAR;
            }
            this.mapSelector.addItem(mapEntry);
        }
        this.mapSelector.addItem(" \u221e " + Translator.getString("MapEditor") + "...");
        this.mapSelector.addItem(" \u221e " + Translator.getString("Getmoremaps"));
        this.fillingMapSelector = false;
        if (selection != null) {
            if (selection.endsWith(".voxb")) {
                selection = selection.substring(0, selection.length() - 5);
            }
            this.mapSelector.setSelectedItem(selection);
            if (!selection.equals(this.mapSelector.getSelectedString())) {
                for (j = 0; j < this.mapSelector.getItemCount(); ++j) {
                    if (!this.mapSelector.getItemAt(j).toString().startsWith(selection)) continue;
                    this.mapSelector.setSelectedIndex(j);
                    return;
                }
            }
        }
    }

    public void loadInfoForSelectedMap() {
        System.out.println("Selected map -> " + this.getSelectedMapName());
        String mapXML = FileTool.fileToString(DesktopTool.supportFolderPath() + "Maps" + File.separator + this.getSelectedMapName() + ".voxb");
        ArrayList<String> playerList = new ArrayList<String>();
        String playerXML = XMLTool.extractContained("player", mapXML, 0);
        int h = 1;
        while (playerXML != null) {
            String ID = XMLTool.extractAttribute("id", playerXML);
            if (!"0".equals(ID)) {
                String playerName = XMLTool.extractAttribute("name", playerXML);
                int playerWonDifficulty = Vox.getStatsPrefs().getInt("wonPos_" + this.getSelectedMapName() + "__" + (h - 1), 0);
                if (playerWonDifficulty > 0) {
                    String playerItem = playerName + " ";
                    for (int w = 0; w < playerWonDifficulty; ++w) {
                        playerItem = playerItem + PLAYER_STAR;
                    }
                    playerList.add(playerItem);
                } else {
                    playerList.add(playerName);
                }
            }
            playerXML = StringTool.xmlSafeReverse(XMLTool.extractContained("player", mapXML, h));
            ++h;
        }
        this.controlPlayer.removeAllItems();
        playerList.add("-- " + Translator.getString("None") + " --");
        playerList.add("-- " + Translator.getString("Random") + " --");
        this.controlPlayer.addItemList(playerList);
        String selectedPlayer = Prefs.get("controlPlayer_" + this.getSelectedMapName(), "-- " + Translator.getString("Random") + " --");
        if (this.getSelectedMapName().startsWith("Tutorial")) {
            selectedPlayer = Prefs.get("controlPlayer_" + this.getSelectedMapName(), "Hero");
        }
        if (selectedPlayer != null) {
            this.controlPlayer.setSelectedItem(selectedPlayer);
            if (!selectedPlayer.equals(this.controlPlayer.getSelectedString())) {
                for (int j = 0; j < this.controlPlayer.getItemCount(); ++j) {
                    if (!this.controlPlayer.getItemAt(j).toString().startsWith(selectedPlayer)) continue;
                    this.controlPlayer.setSelectedIndex(j);
                }
            }
        }
        Dimension dim = this.controlPlayer.getPreferredSize();
        Dimension dim2 = this.difficulty.getPreferredSize();
        this.difficulty.setPreferredSize(dim);
        this.difficulty.setMinimumSize(dim);
    }

    public void saveSelections() {
        Prefs.put("mapSelector", this.getSelectedMapName());
        if (!"-- Random --".equals(this.getSelectedPlayerName()) || !"-- Random --".equals(Prefs.get("controlPlayer_" + this.getSelectedMapName(), "-- Random --"))) {
            Prefs.put("controlPlayer_" + this.getSelectedMapName(), this.getSelectedPlayerName());
        }
        Prefs.put("difficulty", this.difficulty.getSelectedString());
        Prefs.put("playerNames0", this.playerName.getText().trim());
        Prefs.sync();
    }

    public JMenu makeRadioMenu() {
        return null;
    }

    public JMenu makeMenu(String id) {
        return null;
    }

    public String shortName() {
        return "vox";
    }

    private void setPreviewImage() {
        try {
            String foo = this.getSelectedMapName();
            if (foo == null) {
                return;
            }
            String file = foo.toString();
            file = file.substring(file.lastIndexOf(47) + 1);
            file = file.replaceAll(" ", "%20");
            file = file.replaceAll(",", "");
            file = file.replaceAll(";", "");
            file = file.replaceAll(":", "");
            file = file.replaceAll("!", "");
            file = file.replaceAll("/+", "");
            file = file.replaceAll("&", "");
            RemoteImageFetcher.getImage("http://sillysoft.net/vox/plugins/images/" + file + "_thumb.png", 0, this);
        }
        catch (Exception ex) {
            System.out.println("setPreviewImage: " + ex);
            ex.printStackTrace();
        }
    }

    public void imageReady(int row, Object imageIcon) {
        this.pluginImage.setIcon((Icon)imageIcon);
        this.pluginImage.repaint();
    }

    public String getDefaultJoinName() {
        return this.playerName.getText();
    }

    public static void instructions() {
        BrowserLauncher.openURL("file://" + DesktopTool.bundleResourcesLocation() + "Castle_Vox_Instructions.html");
    }

    public void addMe(Object window) {
        if (!this.windows.contains(window)) {
            this.windows.add(window);
        }
    }

    public void killMe(Object dead) {
        this.windows.remove(dead);
        if (this.windows.size() == 0 && !quitting) {
            if (networkGameClosing) {
                networkGameClosing = false;
                VJoinGame.show();
            } else {
                this.showNewGameWindow();
            }
        }
    }

    public void printActiveWindowList() {
        System.out.println("Active window list:");
        for (int i = 0; i < this.windows.size(); ++i) {
            System.out.println(" -> " + this.windows.get(i));
        }
        System.out.println("End of list.");
    }

    public void addGame(VoxClient g) {
        if (!this.activeGames.contains(g)) {
            this.activeGames.add(g);
        }
    }

    public void killGame(VoxClient g) {
        this.activeGames.remove(g);
    }

    public void quit() {
        quitting = true;
        for (int i = this.activeGames.size() - 1; i > -1; --i) {
            ((VoxClient)this.activeGames.get(i)).windowClosing(null);
        }
        if (this.activeGames.size() == 0) {
            if (this.sharewareVersion) {
                // empty if block
            }
            if (MusicEngine.isMusicPlaying()) {
                MusicEngine.pause();
                Thread.yield();
                Thread.yield();
            }
            super.terminate();
        }
        quitting = false;
    }

    public void setRegistration() {
        SSLink link;
        this.regLabelPanel.removeAll();
        if (this.sharewareVersion) {
            this.registration.setText("Castle Vox 1.2 " + Translator.getString("freeversion") + " ");
            this.regLabelPanel.add(this.registration);
            link = new SSLink("Registration Window", Translator.getString("register"));
            link.setFont(this.regfont);
            this.regLabelPanel.add(link);
            JLabel cby = new JLabel("- created by ");
            cby.setFont(this.regfont);
            this.regLabelPanel.add(cby);
        } else {
            String regName = Prefs.get("regName", "");
            if ("".equals(regName.trim())) {
                regName = "you";
            }
            this.registration.setText("Castle Vox 1.2 - " + Translator.getString("Registeredto") + " " + regName + " - " + Translator.getString("createdby") + " ");
            this.regLabelPanel.add(this.registration);
        }
        link = new SSLink("http://sillysoft.net", "Sillysoft Games");
        link.setFont(this.regfont);
        this.regLabelPanel.add(link);
        this.regLabelPanel.revalidate();
    }

    static {
        networkGameClosing = false;
        quitting = false;
    }
}

