/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.lux.gui.TurnTimerManager;
import com.sillysoft.lux.gui.TurnTimerTask;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.BrowserLauncher;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.FolderLauncher;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Continent;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.RecruitPanel;
import com.sillysoft.vox.Stats;
import com.sillysoft.vox.StatsHistory;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.Visuals;
import com.sillysoft.vox.Vox;
import com.sillysoft.vox.VoxGUI;
import com.sillysoft.vox.VoxNetTalker;
import com.sillysoft.vox.VoxOptions;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.VoxWorldManager;
import com.sillysoft.vox.WidthBar;
import com.sillysoft.vox.command.BuildCommand;
import com.sillysoft.vox.command.Command;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.RegisterNag;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSChatArea;
import com.sillysoft.widgets.SSChatAreaParent;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSMenuItem;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SoundEffect;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;

public class VoxClient
extends VoxNetTalker
implements SSChatAreaParent,
VoxWorldManager,
CountriesManager,
TurnTimerManager,
WindowListener,
ActionListener,
Runnable {
    private String name;
    private String key;
    boolean showChat;
    public SSFrame window;
    private SSButton finishedButton;
    private SSButton infoButton;
    private SSButton bonusButton;
    private SSButton recruitButton;
    private SSButton gameOptionsButton;
    private SSButton restartButton;
    protected static boolean fullscreen = false;
    private boolean bonusMode;
    protected Visuals visuals;
    protected WidthBar widthBar;
    protected JPanel contentPanel;
    protected JPanel buttonPanel;
    protected JScrollPane scroller;
    protected JSplitPane splitPane;
    protected SSChatArea chatArea;
    private boolean chatlogLoaded = false;
    private static SoundEffect chatSound = new SoundEffect("chat.wav");
    private static SoundEffect joinSound = new SoundEffect("joinNetwork.wav");
    private static SoundEffect exitSound = new SoundEffect("exitNetwork.wav");
    protected static SoundEffect timerSound = new SoundEffect("timerCountdown.wav");
    private static SoundEffect gameWinSound = new SoundEffect("game_win.wav");
    private static SoundEffect gameLoseSound = new SoundEffect("game_lose.wav");
    private static SoundEffect castleConqueredSound = new SoundEffect("castle_conquered.wav");
    private static SoundEffect castleBuiltSound = new SoundEffect("castle_built.wav");
    private static SoundEffect roundOverSound1 = new SoundEffect("battle_begin_var1.wav");
    private static SoundEffect roundOverSound2 = new SoundEffect("battle_begin_var4.wav");
    private static SoundEffect roundOverSound3 = new SoundEffect("battle_begin_var5.wav");
    private static SoundEffect roundOverSound3modern = new SoundEffect("battle_begin_modern.wav");
    private static SoundEffect roundOverSound4 = new SoundEffect("battle_begin_var7.wav");
    private static SoundEffect roundOverFriendlySound = new SoundEffect("battle_begin_var8_marching.wav");
    private static SoundEffect battleOverSound = new SoundEffect("battle_over.wav");
    private static SoundEffect battleWonSound = new SoundEffect("territory_gained.wav");
    private static SoundEffect battleLostSound = new SoundEffect("territory_lost.wav");
    protected static SoundEffect clickSound = new SoundEffect("general_click.wav");
    protected static SoundEffect undoSound = new SoundEffect("undo.wav");
    protected static SoundEffect invalidSound = new SoundEffect("invalid.wav");
    protected static SoundEffect attackSound = new SoundEffect("order_attack.wav");
    protected static SoundEffect defendSound = new SoundEffect("order_defend.wav");
    public VoxOptions ops;
    public String playerInfoPointString;
    public boolean savedGame;
    private VoxWorld world;
    private String serverAddress;
    private int serverPort;
    private int playerID;
    private List continents;
    public Stats stats;
    public boolean guestOnly;
    private long turnEndsAt;
    private Timer turnTimer;
    private boolean killed = false;
    private boolean gameOver = false;
    private VoxServer localServer;
    private boolean endGameAfterSave = false;
    private int battleSoundIndexCount = 0;
    double currentZoom = 1.0;

    protected VoxClient(VoxServer server, String name, String key, boolean showChat) {
        this.localServer = server;
        this.serverAddress = null;
        this.serverPort = 0;
        this.name = name;
        this.key = key;
        this.showChat = showChat;
        this.savedGame = false;
        System.out.println("VoxClient -> connecting to local server " + server + ", " + name + ", " + key + ", " + showChat);
        this.initClient();
    }

    protected VoxClient(VoxServer server) {
        this.localServer = server;
        this.serverAddress = null;
        this.serverPort = 0;
        this.name = "<saved game player>";
        this.key = "saved game creator key";
        this.showChat = false;
        this.savedGame = true;
        System.out.println("VoxClient -> connecting to local server " + server + ", " + this.name + ", " + this.key + ", " + this.showChat);
        this.initClient();
    }

    protected VoxClient(String serverAddress, int serverPort, String name, String key, boolean showChat, boolean guestOnly) {
        this.serverAddress = serverAddress;
        this.serverPort = serverPort;
        this.name = name;
        this.key = key;
        this.showChat = showChat;
        this.guestOnly = guestOnly;
        this.savedGame = false;
        System.out.println("VoxClient -> connecting to " + serverAddress + ", " + serverPort + ", " + name + ", " + key + ", " + showChat);
        this.initClient();
    }

    private void initClient() {
        this.playerID = -1;
        this.window = new SSFrame("Castle Vox");
        this.window.setJMenuBar(this.makeJMenuBar(this.window));
        this.window.setLocationID("voxframe");
        this.window.addWindowListener(this);
        this.window.setDefaultCloseOperation(0);
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BorderLayout());
        this.visuals = new Visuals(this);
        this.visuals.setPreferredSize(new Dimension(600, 150));
        this.scroller = new JScrollPane(this.visuals);
        this.scroller.setBorder(null);
        this.scroller.getVerticalScrollBar().setUnitIncrement(16);
        this.scroller.getHorizontalScrollBar().setUnitIncrement(16);
        this.scroller.setOpaque(true);
        this.contentPanel.add((Component)this.scroller, "Center");
        this.buttonPanel = new JPanel(new FlowLayout(0));
        this.bonusButton = new SSButton(Translator.getString("Bonuses"));
        this.bonusButton.setFocusable(false);
        this.bonusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VoxClient.this.toggleBonusView();
            }
        });
        this.buttonPanel.add(this.bonusButton);
        this.recruitButton = new SSButton(Translator.getString("Recruit"));
        this.recruitButton.setFocusable(false);
        this.recruitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VoxClient.this.recruitButtonAction();
            }
        });
        if (this.controlsAnyone()) {
            this.buttonPanel.add(this.recruitButton);
        }
        this.finishedButton = new SSButton(Translator.getString("FinishedMoves"));
        this.finishedButton.setFocusable(false);
        this.finishedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VoxClient.this.finishedMoves();
            }
        });
        if (this.controlsAnyone()) {
            this.buttonPanel.add(this.finishedButton);
        }
        if (SS.isMacintosh) {
            Color trans = new Color(0.0f, 0.0f, 0.0f, 0.0f);
            this.finishedButton.setBackground(trans);
            this.bonusButton.setBackground(trans);
            this.recruitButton.setBackground(trans);
        }
        JPanel bottomRow = new JPanel(new BorderLayout());
        bottomRow.setBackground(Color.BLACK);
        this.buttonPanel.setBackground(Color.BLACK);
        this.widthBar = new WidthBar(420, 34, this);
        bottomRow.add((Component)this.widthBar, "West");
        bottomRow.add((Component)this.buttonPanel, "Center");
        bottomRow.setBackground(Color.BLACK);
        this.contentPanel.add((Component)bottomRow, "South");
        if (this.showChat) {
            this.contentPanel.setMinimumSize(new Dimension(300, 200));
            this.chatArea = new SSChatArea(this, "chat-name");
            this.chatArea.setMinimumSize(new Dimension(300, 100));
            this.splitPane = new JSplitPane(0, this.contentPanel, this.chatArea);
            this.splitPane.setOneTouchExpandable(true);
            this.splitPane.setContinuousLayout(true);
            this.splitPane.setBorder(null);
            this.splitPane.setOpaque(true);
            this.window.setContentPane(this.splitPane);
            this.chatArea.focusChatField();
        } else {
            this.window.setContentPane(this.contentPanel);
        }
        this.window.pack();
        this.window.show();
        VoxGUI.getInstance().addGame(this);
        this.connectToServer();
    }

    public void setMapInfo(int width, int height, String title, String theme, boolean opsChanged) {
        SS.debug("VoxClient.setMapInfo " + title + ", width=" + width + ", height=" + height + ", " + opsChanged, 1);
        if (opsChanged) {
            Dimension dim = new Dimension(width, height);
            this.visuals.setMinimumSize(dim);
            this.visuals.setPreferredSize(dim);
            if (height + 34 > SwingTool.getUsableDimension().height) {
                dim = new Dimension(width + SwingTool.SCROLLBAR_SIZE, height);
            }
            this.scroller.setPreferredSize(dim);
            this.visuals.setTheme(theme);
            this.visuals.setMapSize(width, height);
            int dividerLocation = -1;
            if (this.showChat) {
                int width_offset = 20;
                if (SS.isMacintosh) {
                    width_offset = 0;
                }
                int height_offset = 20;
                int oldHeight = this.chatArea.getSize().height;
                int CHATPANEL_HEIGHT = 166;
                CHATPANEL_HEIGHT = Math.max(CHATPANEL_HEIGHT, oldHeight);
                this.chatArea.setPreferredSize(new Dimension(width, CHATPANEL_HEIGHT));
                this.splitPane.setPreferredSize(new Dimension(width + width_offset, height + 34 + CHATPANEL_HEIGHT + height_offset));
                dividerLocation = height + 34;
                if (width < 730) {
                    dividerLocation += 34;
                }
                dividerLocation += 5;
            }
            this.window.pack();
            if (dividerLocation != -1) {
                this.splitPane.setDividerLocation(dividerLocation);
                this.chatArea.focusChatField();
            }
            this.window.setTitle(SS.isMacintosh ? "Castle Vox - " + title : title + " - Castle Vox");
            this.visuals.setContainsPlayerInfo(true);
            this.window.show();
            Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            Dimension screenDimension = screenRect.getSize();
            if ((double)(width + 20) > screenDimension.getWidth() && (double)(height + 20) > screenDimension.getHeight()) {
                this.window.setExtendedState(6);
                SS.debug("setMapInfo setExtendedState(Frame.MAXIMIZED_BOTH)", 1);
            }
        }
        MusicEngine.startTrackSequence(VoxClient.musicSequenceForMap(title));
    }

    public static int musicSequenceForMap(String map) {
        if (map == null || "".equals(map.trim())) {
            return 6;
        }
        if ((map = map.toLowerCase()).indexOf("revolution") != -1 || map.indexOf("alamo") != -1 || map.indexOf("civil war") != -1 || map.indexOf("alcatraz") != -1 || map.indexOf("napole") != -1 || map.indexOf("new orleans") != -1 || map.indexOf("1812") != -1) {
            return 7;
        }
        if (map.equals("england") || map.indexOf("hex") != -1 || map.indexOf("bushido") != -1 || map.indexOf("dragon") != -1 || map.indexOf("germaniae") != -1 || map.indexOf("rabbit") != -1 || map.indexOf("robin hood") != -1 || map.indexOf("tutorial") != -1 || map.indexOf("crusades") != -1 || map.indexOf("hundred years") != -1) {
            return 8;
        }
        if (map.indexOf("world war") != -1 || map.indexOf("ambush") != -1 || map.indexOf("cosmic") != -1 || map.indexOf("big league") != -1 || map.indexOf("the pole") != -1 || map.indexOf("vox world") != -1 || map.indexOf("wwii") != -1 || map.indexOf("ww2") != -1 || map.indexOf("iraq") != -1) {
            return 9;
        }
        if (map.indexOf("roman") != -1 || map.indexOf("rome") != -1 || map.indexOf("ancient") != -1 || map.indexOf("civilization") != -1 || map.indexOf("alexander") != -1 || map.indexOf("sparta") != -1) {
            return 10;
        }
        return 12;
    }

    public void doneBuying() {
        this.visuals.doneBuying();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        boolean gameJustStarting;
        if (this.ops == null || fullscreen) {
            this.terminate();
            return;
        }
        if (this.ops.allowNetworkPlayers) {
            if (!this.controlsAnyone() || this.gameOver || this.sock == null) {
                this.terminate();
                return;
            }
            int answer = 1;
            Object[] options = new Object[]{Translator.getString("IllBeBack"), Translator.getString("BotTakeover"), Translator.getString("Cancel")};
            answer = SSOptionPane.showOptionDialog(this.window, Translator.getString("endGameQuestionMulti") + "     ", Translator.getString("endGameTitleMulti"), options, Translator.getString("IllBeBack"));
            if (answer == 0) {
                this.terminate();
                return;
            }
            if (answer == 1) {
                String takeoverBot = "Holdem";
                String command = "exitsetAI: " + this.playerID + " " + takeoverBot;
                this.encodeln(command);
                SS.debug("Leaving client " + this.name() + " says to let a bot takeover his player...");
                this.terminate();
                return;
            }
            return;
        }
        boolean bl = gameJustStarting = this.world == null || this.world.roundCount == 1 && this.world.getCommands().size() == 0;
        if (gameJustStarting || this.gameOver) {
            this.terminate();
            return;
        }
        int answer = 1;
        Object[] options = new Object[]{Translator.getString("ExitGame"), Translator.getString("SaveGame"), Translator.getString("Cancel")};
        answer = SSOptionPane.showOptionDialog(this.window, Translator.getString("endGameQuestion") + "     ", Translator.getString("endGameTitle"), options, Translator.getString("ExitGame"));
        if (answer == 0) {
            this.terminate();
            return;
        }
        if (answer == 1) {
            this.endGameAfterSave = true;
            this.saveGame();
            return;
        }
        if (answer == 2) {
            return;
        }
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void kill() {
        if (this.visuals.loadText != null) {
            this.visuals.setLoadText("Error. Game Aborted.");
        }
    }

    public void terminate() {
        if (fullscreen) {
            this.goFullscreen();
        }
        if (this.killed) {
            return;
        }
        this.killed = true;
        VoxGUI.networkGameClosing = this.ops != null && this.ops.allowNetworkPlayers;
        this.closeSocket();
        this.serverAddress = null;
        if (this.turnTimer != null) {
            this.turnTimer.cancel();
            this.turnTimer = null;
        }
        if (roundOverFriendlySound != null) {
            roundOverFriendlySound.stopLooping();
        }
        if (this.chatArea != null) {
            this.chatArea.kill();
        }
        this.chatArea = null;
        if (this.window != null) {
            SwingTool.destroyMenu(this.window.getJMenuBar());
            this.window.setJMenuBar(null);
            this.window.setMenuBar(null);
            this.window.setContentPane(new JPanel());
            this.window.dispose();
            this.window = null;
        }
        if (this.visuals != null) {
            this.visuals.kill();
        }
        this.visuals = null;
        if (this.world != null) {
            this.world.killed = true;
        }
        this.world = null;
        VoxGUI.getInstance().killGame(this);
    }

    protected void repaint() {
        this.visuals.repaint();
    }

    public void refreshBuyPanel(Object foo) {
        this.visuals.updateMoney();
    }

    public void showOwnedCommands(List fullCommandList) {
        this.world.addCommands(fullCommandList);
        this.updateRecruitButton();
        if (this.world.getMoney(this.playerID) < RecruitPanel.LEAST_COST) {
            this.doneBuying();
        } else if (Prefs.getBoolean("showRecruits", false)) {
            this.visuals.buyingRound(null);
        }
    }

    public void showAllCommands(List fullCommandList) {
        this.doneBuying();
        this.visuals.setActive(false);
        this.visuals.endOfRound();
        this.widthBar.showTimer(false);
        this.recruitButton.setEnabled(false);
        this.finishedButton.setEnabled(false);
        if (this.controlsAnyone()) {
            this.world.undoAllCommands(this.getPlayer(this.playerID));
        }
        this.world.addCommands(fullCommandList);
        this.world.flashBattles();
        this.playBattleSounds();
    }

    protected boolean modernMap() {
        int musicID = VoxClient.musicSequenceForMap(this.ops.mapTitle);
        return musicID == 7 || musicID == 9;
    }

    private void playBattleSounds() {
        if (this.battleSoundIndexCount == 0) {
            roundOverSound1.play();
        }
        if (this.battleSoundIndexCount == 1) {
            roundOverSound2.play();
        }
        if (this.battleSoundIndexCount == 2) {
            if (this.modernMap()) {
                roundOverSound3modern.play();
            } else {
                roundOverSound3.play();
            }
        }
        if (this.battleSoundIndexCount == 3) {
            roundOverSound4.play();
        }
        this.battleSoundIndexCount = (this.battleSoundIndexCount + 1) % 4;
        if (Prefs.getInt("battleDelay", 757) > 18) {
            new Thread("delayed battle sounds"){

                public void run() {
                    try {
                        Thread.sleep(3000L);
                        if (VoxClient.this.world.flashingBattlesCount() > 5 && !((VoxClient)VoxClient.this).world.killed) {
                            VoxClient.this.playBattleSounds();
                        } else if (VoxClient.this.world.getCommands().size() > 0 && !VoxClient.this.killed) {
                            SS.debug("roundOverFriendlySound.play(). commands=" + VoxClient.this.world.getCommands().size() + ", flashingBattles=" + VoxClient.this.world.flashingBattlesCount());
                            roundOverFriendlySound.startLooping();
                        }
                    }
                    catch (Exception e) {
                        SS.debug("Delayed battle sounds: " + e);
                    }
                }
            }.start();
        }
    }

    public JMenuBar makeJMenuBar(JFrame forWindow) {
        JMenuItem showContinentsMenuItem;
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(VoxGUI.getInstance().makeFileMenu(forWindow, true, true));
        menuBar.add(VoxGUI.getInstance().makeEditMenu());
        JMenu menu = new JMenu(Translator.getString("Game"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(71);
        }
        JMenuItem menuItem = new JMenuItem(Translator.getString("Undo"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("undoMenu");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem(Translator.getString("UndoAll"));
        menuItem.setActionCommand("undoAllMenu");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = showContinentsMenuItem = new JMenuItem(Translator.getString("ShowBonuses"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(66, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("showBonuses");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem(Translator.getString("RecruitUnits"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("recruit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem(Translator.getString("FinishedMoves"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("finishedMoves");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("SaveGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.setActionCommand("saveGame");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Screenshot"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("screenshot");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new JMenuItem(Translator.getString("Surrender"));
        menuItem.setActionCommand("surrender");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new JMenuItem(Translator.getString("RestartGame"));
        menuItem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8));
        menuItem.setActionCommand("replay");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        if (forWindow == null) {
            menu.addSeparator();
        }
        menuBar.add(menu);
        menu = new JMenu(Translator.getString("Board"));
        if (!SS.isMacintosh) {
            menu.setMnemonic(77);
        }
        menuItem = new SSMenuItem(Translator.getString("ResizeMapLarger"));
        menuItem.setActionCommand("resizeBigger");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(61, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("ResizeMapSmaller"));
        menuItem.setActionCommand("resizeSmaller");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(45, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Tooriginalsize"));
        menuItem.setActionCommand("resizeMapToOriginal");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(48, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Tofitscreen"));
        menuItem.setActionCommand("resizeMapToFit");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(57, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("Fullscreen"));
        menuItem.setActionCommand("resizeFullscreen");
        menuItem.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu.addSeparator();
        menuItem = new SSMenuItem(Translator.getString("GotoSavedBoards"));
        menuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FolderLauncher.openPath(DesktopTool.supportFolderPath() + "Maps");
            }
        });
        menu.add(menuItem);
        menuItem = new SSMenuItem(Translator.getString("MakeYourOwnMap"));
        menuItem.setActionCommand("showMapNotes");
        menuItem.addActionListener(VoxGUI.getInstance());
        menu.add(menuItem);
        menuBar.add(menu);
        menuBar.add(VoxGUI.getInstance().makeOnlineMenu());
        menuBar.add(VoxGUI.getInstance().makeHelpMenu());
        return menuBar;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            String command = event.getActionCommand();
            if ("playerInfoToggle".equals(command)) {
                this.visuals.toggleContainsPlayerInfo();
            } else if ("showBonuses".equals(command)) {
                this.toggleBonusView();
            } else if ("finishedMoves".equals(command)) {
                this.finishedMoves();
            } else if ("recruit".equals(command)) {
                this.recruitButtonAction();
            } else if ("replay".equals(command)) {
                this.visuals.restart();
                this.encodeln("CHAT: /start");
            } else if ("surrender".equals(command)) {
                int answer = 1;
                Object[] options = new Object[]{Translator.getString("Surrender"), Translator.getString("FightOn")};
                answer = SSOptionPane.showOptionDialog(this.window, Translator.getString("surrenderquestion"), "", options, "");
                if (answer == 0) {
                    this.encodeln("CHAT: /surrender");
                }
            } else if ("screenshot".equals(command)) {
                String dir = DesktopTool.supportFolderPath() + "Screenshots" + File.separator;
                File dirFile = new File(dir);
                dirFile.mkdirs();
                String filename = dir + this.ops.mapTitle + " round " + this.world.roundCount;
                if (new File(filename + ".png").exists()) {
                    int i = 1;
                    while (new File(filename + "." + i + ".png").exists()) {
                        ++i;
                    }
                    filename = filename + "." + i;
                }
                if (this.visuals.hideBonusLabels) {
                    GraphicsTool.saveComponentAsMiniPNG(this.visuals, filename + "_nolab", this.visuals.displayWidth, this.visuals.displayHeight);
                } else {
                    GraphicsTool.saveComponentAsJPEG(this.visuals, filename, Prefs.getBoolean("makeScreenshotThumbnail", false), this.visuals.displayWidth, this.visuals.displayHeight, SSApp.isVox);
                    GraphicsTool.saveComponentAsPNG(this.visuals, filename, Prefs.getBoolean("makeScreenshotThumbnail", false), this.visuals.displayWidth, this.visuals.displayHeight);
                }
                this.showMessage("A screenshot has been saved in: \n" + dir);
            } else if ("saveGame".equals(command)) {
                this.saveGame();
            } else if ("undoMenu".equals(command)) {
                Command com = this.world.undoCommand();
                if (com == null) {
                    SS.beep();
                    return;
                }
                undoSound.play();
                if (com instanceof BuildCommand) {
                    this.visuals.updateMoney();
                }
                this.visuals.repaint();
                this.commandUndone();
            } else if (!"redoMenu".equals(command)) {
                if ("undoAllMenu".equals(command)) {
                    if (this.world.getCommands().size() == 0) {
                        SS.beep();
                        return;
                    }
                    undoSound.play();
                    this.world.undoAllCommands(this.getPlayer(this.playerID));
                    this.visuals.updateMoney();
                    this.visuals.repaint();
                    this.commandUndone();
                } else if ("resizeBigger".equals(command)) {
                    this.resizeTo(this.currentZoom * 1.05);
                } else if ("resizeSmaller".equals(command)) {
                    this.resizeTo(this.currentZoom * 0.95);
                } else if ("resizeMapToOriginal".equals(command)) {
                    this.resizeTo(1.0);
                } else if ("resizeMapToFit".equals(command)) {
                    this.resizeToFit();
                } else if ("resizeFullscreen".equals(command)) {
                    this.goFullscreen();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toggleBonusView() {
        this.bonusMode = !this.bonusMode;
        this.visuals.toggleBonusView();
    }

    protected void goFullscreen() {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0];
        if (!fullscreen) {
            this.window.removeWindowListener(this);
            SSFrame newWindow = new SSFrame(this.window.getTitle());
            newWindow.setResizable(false);
            newWindow.setUndecorated(true);
            newWindow.setContentPane(this.window.getContentPane());
            newWindow.setJMenuBar(this.window.getJMenuBar());
            this.window.hide();
            newWindow.addWindowListener(this);
            device.setFullScreenWindow(newWindow);
            this.window = newWindow;
            this.resizeToFit();
        } else {
            this.window.removeWindowListener(this);
            device.setFullScreenWindow(null);
            this.window.hide();
            SSFrame newWindow = new SSFrame(this.window.getTitle());
            newWindow.setContentPane(this.window.getContentPane());
            newWindow.setJMenuBar(this.makeJMenuBar(newWindow));
            newWindow.setLocationID("voxframe");
            newWindow.addWindowListener(this);
            this.window = newWindow;
            this.window.show();
            this.resizeTo(1.0);
        }
        fullscreen = !fullscreen;
    }

    protected void setupPlayers() {
        Color[] colors = new Color[this.getNumberOfPlayers()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = this.getPlayer(i).getColor();
        }
        this.widthBar.setColors(colors);
    }

    public void orderExplosion(int playerID, int country) {
        this.orderExplosion(playerID, country, false);
    }

    public void orderExplosion(int playerID, int country, boolean nuke) {
        this.visuals.orderExplosion(country, nuke);
    }

    public void dealWithCommand(String command) {
        try {
            if (command.startsWith("/set ")) {
                String[] params = StringTool.tokenize(command, " ");
                if (params == null || params.length < 2) {
                    this.printMessage("Improper usage. Example: /set makeScreenshotThumbnail true");
                    return;
                }
                boolean newState = params.length < 3 ? true : new Boolean(params[2]);
                try {
                    int intValue = Integer.parseInt(params[2]);
                    this.printMessage("Setting local switch: " + params[1] + " to " + intValue);
                    SS.debug("Setting switch: " + params[1] + " to " + intValue);
                    Prefs.putInt(params[1], intValue);
                    return;
                }
                catch (Exception e) {
                    this.printMessage("Setting local switch: " + params[1] + " to " + newState);
                    SS.debug("Setting switch: " + params[1] + " to " + newState);
                    Prefs.putBoolean(params[1], newState);
                }
            } else if (command.equalsIgnoreCase("/end")) {
                this.finishedMoves();
            } else if (command.equalsIgnoreCase("/help")) {
                VoxGUI.instructions();
            } else if (command.equals("/i")) {
                this.printMessage("Enter a player name to lookup online. /i hawk");
            } else if (command.trim().equals("/")) {
                this.getCompletionFor(command);
                chatSound.play();
            } else if (command.startsWith("/i ")) {
                String input = command.substring(command.indexOf(" ") + 1);
                BrowserLauncher.openURL("http://sillysoft.net/vox/rankings/user/" + URLEncoder.encode(input, "UTF-8"));
            } else if (command.equalsIgnoreCase("/printunicode")) {
                this.println("Unicode test:");
                this.printUnicodeTest();
            } else {
                this.encodeln("CHAT: " + command);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public JButton getDefaultButton() {
        return this.window.getRootPane().getDefaultButton();
    }

    public JMenuBar getJMenuBarForChatArea(JFrame window) {
        return null;
    }

    public void chatAreaWindowClosing(WindowEvent e) {
    }

    public String getCompletionFor(String commandStart) {
        if ("".equals(commandStart)) {
            return "";
        }
        if (commandStart.startsWith("`")) {
            return "`" + this.getCompletionFor(commandStart.substring(1));
        }
        int spacePosition = commandStart.indexOf(" ");
        String nameSegment = commandStart.substring(spacePosition + 1);
        String nameSegmentLower = nameSegment.toLowerCase();
        ArrayList<String> possibleNameCompletions = new ArrayList<String>();
        if (commandStart.startsWith("/map ")) {
            Vector mapList = PluginManager.getInstance().getMapList();
            for (int j = 0; j < mapList.size(); ++j) {
                String map = (String)mapList.get(j);
                if (!map.toLowerCase().startsWith(nameSegmentLower)) continue;
                possibleNameCompletions.add(map);
            }
        } else if (commandStart.startsWith("/play ")) {
            for (int j = 0; j < this.ops.players.size(); ++j) {
                Player p = (Player)this.ops.players.get(j);
                if (!p.getName().toLowerCase().startsWith(nameSegmentLower)) continue;
                possibleNameCompletions.add(p.getName());
            }
        } else if (commandStart.startsWith("/")) {
            if ("/debug".startsWith(commandStart)) {
                possibleNameCompletions.add("/debug");
            }
            if ("/desc".startsWith(commandStart)) {
                possibleNameCompletions.add("/desc");
            }
            if ("/end".startsWith(commandStart)) {
                possibleNameCompletions.add("/end");
            }
            if ("/guest".startsWith(commandStart)) {
                possibleNameCompletions.add("/guest");
            }
            if ("/help".startsWith(commandStart)) {
                possibleNameCompletions.add("/help");
            }
            if ("/i".startsWith(commandStart)) {
                possibleNameCompletions.add("/i");
            }
            if ("/play".startsWith(commandStart)) {
                possibleNameCompletions.add("/play");
            }
            if ("/map ".startsWith(commandStart)) {
                possibleNameCompletions.add("/map ");
            }
            if ("/me".startsWith(commandStart)) {
                possibleNameCompletions.add("/me");
            }
            if ("/start".startsWith(commandStart)) {
                possibleNameCompletions.add("/start");
            }
            if ("/surrender".startsWith(commandStart)) {
                possibleNameCompletions.add("/surrender");
            }
            if ("/t".startsWith(commandStart)) {
                possibleNameCompletions.add("/t");
            }
            if ("/users".startsWith(commandStart)) {
                possibleNameCompletions.add("/users");
            }
            if ("/waiting".startsWith(commandStart)) {
                possibleNameCompletions.add("/waiting");
            }
        }
        for (int j = 0; j < this.ops.players.size(); ++j) {
            Player p = (Player)this.ops.players.get(j);
            if (p.getName().toLowerCase().startsWith(nameSegmentLower)) {
                possibleNameCompletions.add(p.getName());
            }
            if (p.controlledBy == null || !p.controlledBy.toLowerCase().startsWith(nameSegmentLower)) continue;
            possibleNameCompletions.add(p.controlledBy);
        }
        if (possibleNameCompletions.size() == 0) {
            int lastSpacePosition = commandStart.lastIndexOf(" ");
            if (lastSpacePosition == spacePosition) {
                this.printMessage(Translator.getString("Nocompletions") + " " + nameSegment);
                return commandStart;
            }
            nameSegment = commandStart.substring(lastSpacePosition + 1);
            return commandStart.substring(0, lastSpacePosition + 1) + this.getCompletionFor(nameSegment);
        }
        if (possibleNameCompletions.size() == 1) {
            return commandStart.substring(0, spacePosition + 1) + (String)possibleNameCompletions.get(0);
        }
        StringBuffer printout = new StringBuffer(Translator.getString("Possiblecompletions") + " ");
        for (int i = 0; i < possibleNameCompletions.size(); ++i) {
            printout.append(possibleNameCompletions.get(i));
            if (i + 1 == possibleNameCompletions.size()) continue;
            printout.append(", ");
        }
        this.printMessage(printout.toString());
        return commandStart.substring(0, spacePosition + 1) + StringTool.getCommonStart(possibleNameCompletions);
    }

    public void escapeKeyPressed() {
        SS.debug("Client.escapePressed", 1);
        this.visuals.escapeKeyPressed();
    }

    public void cacheModKeys(KeyEvent e) {
        this.visuals.cacheModKeys(e);
    }

    public Object getControl() {
        return this;
    }

    public void setPlacingKey(int placingKey) {
        this.visuals.setPlacingKey(placingKey);
    }

    public boolean usedPlacedDividerKey() {
        return this.visuals.usedPlacedDividerKey();
    }

    public boolean usedZeroAttack() {
        return this.visuals.usedZeroAttack();
    }

    public void takeChat(String chat) {
        if (!this.showChat) {
            return;
        }
        if (chat.startsWith("\u2731 tra: 3")) {
            chat = "\u2731" + Translator.translateTokens(chat.substring(8));
        }
        if (chat.startsWith("\u2731") && chat.indexOf(" has joined in round ") != -1) {
            joinSound.play();
        } else if (chat.startsWith("\u2731") && chat.indexOf(" has exited ") != -1) {
            exitSound.play();
        } else if (this.chatlogLoaded) {
            chatSound.play();
        }
        if (this.ops != null && this.ops.players != null) {
            for (int i = 0; i < this.ops.players.size(); ++i) {
                if (!chat.startsWith(this.getPlayer(i).getName() + " ") && !chat.startsWith(this.getPlayer(i).getBrain() + " AI " + this.getPlayer(i).getName()) && !chat.startsWith(this.getPlayer((int)i).controlledBy + ":") && !chat.startsWith("    " + this.getPlayer((int)i).controlledBy + " ")) continue;
                this.println(chat, this.getPlayer(i).getColor());
                return;
            }
        }
        this.println(chat);
    }

    public void takeTeamChat(String chat) {
        chatSound.play();
        for (int i = 0; i < this.ops.players.size(); ++i) {
            if (!chat.startsWith(this.getPlayer(i).getName() + ": ") && !chat.startsWith(this.getPlayer(i).getBrain() + " AI " + this.getPlayer(i).getName()) && !chat.startsWith(this.getPlayer((int)i).controlledBy + ": ") && !chat.startsWith("    " + this.getPlayer((int)i).controlledBy + " ")) continue;
            this.println(chat, this.getPlayer(i).getColor(), SSChatArea.singStyle);
            return;
        }
        this.println(chat, null, SSChatArea.singStyle);
    }

    public void takeEmote(String chat) {
        chatSound.play();
        this.println("\u221e " + chat + " \u221e", null, SSChatArea.emoteStyle);
    }

    public void showNotice(String text, Point p, long length) {
        this.visuals.showNotice(text, p, length);
    }

    public int getGuiOwner() {
        return this.playerID;
    }

    public int getNumberOfPlayers() {
        return this.ops.players.size();
    }

    public Player getPlayer(int playerID) {
        if (playerID < 0) {
            return null;
        }
        return (Player)this.ops.players.get(playerID);
    }

    public VoxWorld getGuiWorld() {
        return this.world;
    }

    protected List getCommandsToDraw() {
        return this.world.getCommands();
    }

    public void finishedMoves() {
        if (!this.controlsAnyone() || this.gameOver) {
            this.finishedButton.setEnabled(false);
            return;
        }
        if (!(fullscreen || this.world.hasBuildCommands() || this.world.getPlayerMoney(this.playerID) < RecruitPanel.LEAST_COST || this.visuals.getCastleCountry() == null && this.world.getPlayerMoney(this.playerID) < 80)) {
            int answer = 1;
            Object[] options = new Object[]{Translator.getString("RecruitUnits"), Translator.getString("FinishedMoves")};
            answer = SSOptionPane.showOptionDialog(this.window, Translator.getString("Youhave") + " " + this.world.getPlayerMoney(this.playerID) + " " + Translator.getString("gold") + ". " + Translator.getString("Wouldyouliketorecruitunits"), "", options, Translator.getString("RecruitUnits"));
            if (answer == -1) {
                // empty if block
            }
            if (answer == 0) {
                this.visuals.buyingRound(null);
                return;
            }
        }
        this.finishedButton.setEnabled(false);
        this.finishedMoves(this.playerID);
    }

    public void finishedMoves(int ID) {
        this.encodeln("finishedMoves: " + this.playerID);
    }

    protected void loadMap() {
    }

    public boolean isHuman(int ID) {
        return ID == this.playerID;
    }

    public void setGameRound(int count) {
        this.world.roundCount = count;
    }

    public void setVoxOptions(VoxOptions ops) {
        boolean opsChanged = this.ops == null || this.ops.width != ops.width || this.ops.height != ops.height || !this.ops.mapTitle.equals(ops.mapTitle) || !this.ops.mapTheme.equals(ops.mapTheme);
        this.ops = ops;
        this.playerInfoPointString = ops.playerInfoPointString;
        this.setMapInfo(ops.width, ops.height, ops.mapTitle, ops.mapTheme, opsChanged);
        this.setupPlayers();
        if (ops.useTurnTimer && this.turnTimer == null) {
            this.turnTimer = new Timer();
            this.turnTimer.schedule((TimerTask)new TurnTimerTask(this), 1000L, 1000L);
        }
        this.widthBar.recacheWidth();
        this.gameOver = false;
    }

    public void setWorldData(List countries) {
        block7: {
            block6: {
                block8: {
                    for (int i = 0; i < countries.size(); ++i) {
                        Country c = (Country)countries.get(i);
                        c.resolveAdjoiningList(countries);
                    }
                    this.world = new VoxWorld(this, this.playerID);
                    this.world.setPlayers(this.ops.players);
                    this.world.setCountries(countries);
                    this.world.setContinents(this.continents);
                    if (this.controlsAnyone()) {
                        this.world.setupBot(this.getPlayer(this.playerID));
                    }
                    this.visuals.setEngine(this.world);
                    this.visuals.setCountries(countries);
                    this.visuals.setActive(true);
                    this.stats = new Stats(this, this.getNumberOfPlayers());
                    if (this.currentZoom != 1.0) {
                        this.resizeTo(this.currentZoom);
                    }
                    int CHATPANEL_HEIGHT = 166;
                    Dimension screenDimension = SwingTool.getUsableDimension();
                    if (Prefs.getBoolean("autoGrow", false) && screenDimension.getWidth() > (double)this.ops.width && screenDimension.getHeight() > (double)this.ops.height) break block6;
                    if (!Prefs.getBoolean("autoShrink", true)) break block7;
                    if (screenDimension.getWidth() < (double)this.ops.width) break block8;
                    double d = screenDimension.getHeight();
                    int n = this.ops.height + 34;
                    int n2 = this.showChat ? CHATPANEL_HEIGHT : 0;
                    if (!(d < (double)(n + n2))) break block7;
                }
                if (this.ops.height >= 2001) break block7;
            }
            this.resizeToFit();
        }
    }

    public void startNewRound(long turnTimeLeft) {
        battleOverSound.play();
        roundOverFriendlySound.stopLooping();
        long currentTime = new Date().getTime();
        this.turnEndsAt = currentTime + turnTimeLeft;
        this.world.clearCommands();
        this.world.setUnitOriginalCountries();
        ++this.world.roundCount;
        this.chatlogLoaded = true;
        if (this.controlsAnyone()) {
            this.recruitButton.setEnabled(true);
            this.finishedButton.setEnabled(true);
        }
        this.visuals.endOfRound();
        this.visuals.setActive(true);
        this.stats = new Stats(this, this.getNumberOfPlayers());
        this.widthBar.showTimer(true);
        this.widthBar.calculateWidths();
        this.widthBar.repaintColors();
    }

    public void updateRecruitButton() {
        if (this.playerID < 0) {
            this.recruitButton.setText(Translator.getString("Recruit"));
        } else {
            this.recruitButton.setText(Translator.getString("Recruit") + " (" + this.world.getMoney(this.playerID) + ")");
        }
    }

    public void setMoney(int ID, int money) {
        this.world.setMoney(this.getPlayer(ID), money);
    }

    public void doneMoneys() {
        this.updateRecruitButton();
        if (this.controlsAnyone() && this.stats.getArmies(this.playerID) > 0 && (this.world.getCastleCountriesOwnedBy(this.playerID).size() > 0 || this.world.getMoney(this.playerID) >= 80 && this.stats.getArmies(this.playerID) > 4) && Prefs.getBoolean("showRecruits", false) && this.world.getMoney(this.playerID) >= RecruitPanel.LEAST_COST) {
            this.visuals.buyingRound(null);
        }
    }

    public List getCountries() {
        return this.world.countries;
    }

    public String name() {
        return this.name;
    }

    public String ip() {
        return "IP";
    }

    public void setPlayerID(int ID) {
        this.playerID = ID;
        this.visuals.setPlayerID(ID);
        if (this.controlsAnyone()) {
            this.printMessage(Translator.getString("takeOver") + " " + this.getPlayer(ID).getName() + " on team " + this.getPlayer(ID).getTeam());
            this.updateRecruitButton();
            this.recruitButton.setEnabled(true);
            this.finishedButton.setEnabled(true);
            this.buttonPanel.add(this.recruitButton);
            this.buttonPanel.add(this.finishedButton);
            this.buttonPanel.revalidate();
            this.buttonPanel.repaint();
            if (Prefs.getBoolean("showRecruits", false) && this.world.getMoney(this.playerID) >= RecruitPanel.LEAST_COST) {
                this.visuals.buyingRound(null);
            }
            new Thread("Delayed-team-notices"){

                public void run() {
                    Team t = VoxClient.this.getPlayer(VoxClient.this.playerID).getTeam();
                    if (!Prefs.getBoolean("showRecruits", false) || VoxClient.this.world.getMoney(VoxClient.this.playerID) < RecruitPanel.LEAST_COST) {
                        try {
                            Thread.sleep(400L);
                            VoxClient.this.showNotice(Translator.getString("Youcontrol") + " " + VoxClient.this.getPlayer(VoxClient.this.playerID).name(), VoxClient.this.visuals.getLargestCountry(VoxClient.this.playerID).getCenter(), 10000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    int initialDelay = 1800;
                    int smallDelay = 600;
                    for (int i = 0; i < VoxClient.this.ops.players.size(); ++i) {
                        if (i == VoxClient.this.playerID || !VoxClient.this.getPlayer(i).getTeam().equals(t)) continue;
                        try {
                            Thread.sleep(initialDelay + smallDelay);
                            initialDelay = 0;
                            VoxClient.this.showNotice(VoxClient.this.getPlayer(i).name() + " " + Translator.getString("isonyourteam"), VoxClient.this.visuals.getLargestCountry(i).getCenter(), 8000L);
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }.start();
        }
    }

    public void gameOver(StatsHistory statsHistory) {
        this.world.stopFlashing();
        this.visuals.gameOver(statsHistory);
        this.widthBar.showTimer(false);
        this.buttonPanel.remove(this.recruitButton);
        this.buttonPanel.remove(this.finishedButton);
        this.buttonPanel.revalidate();
        this.buttonPanel.repaint();
        this.gameOver = true;
        MusicEngine.startTrackSequence(11);
        if (this.gameOptionsButton == null) {
            this.gameOptionsButton = new SSButton(Translator.getString("GameOptions"));
            this.gameOptionsButton.setFocusable(false);
            this.gameOptionsButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VoxClient.this.terminate();
                    VoxGUI.getInstance().showNewGameWindow();
                }
            });
            this.restartButton = new SSButton(Translator.getString("PlayAgain"));
            this.restartButton.setFocusable(false);
            this.restartButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VoxClient.this.buttonPanel.remove(VoxClient.this.gameOptionsButton);
                    VoxClient.this.buttonPanel.remove(VoxClient.this.restartButton);
                    VoxClient.this.buttonPanel.repaint();
                    VoxClient.this.dealWithCommand("/start");
                }
            });
        }
        if (!this.showChat) {
            this.buttonPanel.add(this.gameOptionsButton);
            this.buttonPanel.add(this.restartButton);
            this.window.getRootPane().setDefaultButton(this.restartButton);
            this.buttonPanel.revalidate();
            this.buttonPanel.repaint();
        }
        if (this.playerID > -1 && this.getPlayer(this.playerID).getTeam().getName().equalsIgnoreCase(statsHistory.winningTeamName)) {
            gameWinSound.play();
            SS.debug("Client was part of a winning team! Team: " + this.getPlayer(this.playerID).getTeam().getName() + ", Player: " + this.getPlayer(this.playerID).getName() + ", Map: " + this.ops.mapTitle + ", Difficulty: " + this.ops.difficulty, 1);
            Preferences statsPrefs = Vox.getStatsPrefs();
            if (this.world.roundCount < statsPrefs.getInt("fastestWin", 1000000)) {
                statsPrefs.putInt("fastestWin", this.world.roundCount);
                statsPrefs.put("fastestWinDetails", this.ops.mapTitle + " " + Translator.getString("as") + " " + this.getPlayer(this.playerID).getName());
            }
            if (this.world.roundCount > statsPrefs.getInt("slowestWin", 0)) {
                statsPrefs.putInt("slowestWin", this.world.roundCount);
                statsPrefs.put("slowestWinDetails", this.ops.mapTitle + " " + Translator.getString("as") + " " + this.getPlayer(this.playerID).getName());
            }
            statsPrefs.putInt("gamesWon", statsPrefs.getInt("gamesWon", 0) + 1);
            if (statsPrefs.getInt("wonMap_" + this.ops.mapTitle, 0) < this.getDifficultyID(this.ops.difficulty)) {
                statsPrefs.putInt("wonMap_" + this.ops.mapTitle, this.getDifficultyID(this.ops.difficulty));
            }
            SS.debug("wonPos_" + this.ops.mapTitle + "__" + this.playerID);
            SS.debug(statsPrefs.getInt("wonPos_" + this.ops.mapTitle + "__" + this.playerID, 0));
            SS.debug(this.getDifficultyID(this.ops.difficulty));
            if (statsPrefs.getInt("wonPos_" + this.ops.mapTitle + "__" + this.playerID, 0) < this.getDifficultyID(this.ops.difficulty)) {
                statsPrefs.putInt("wonPos_" + this.ops.mapTitle + "__" + this.playerID, this.getDifficultyID(this.ops.difficulty));
            }
            try {
                String mapXML = FileTool.fileToString(DesktopTool.supportFolderPath() + "Maps" + File.separator + this.ops.mapTitle + ".voxb");
                int playerCount = 0;
                int playerWonCount = 0;
                int playerWonMaxDifficulty = 5;
                String playerXML = XMLTool.extractContained("player", mapXML, 0);
                int h = 1;
                while (playerXML != null) {
                    if (!"0".equals(XMLTool.extractAttribute("id", playerXML))) {
                        ++playerCount;
                        int wonAsPlayer = statsPrefs.getInt("wonPos_" + this.ops.mapTitle + "__" + (h - 1), 0);
                        if (wonAsPlayer > 0) {
                            ++playerWonCount;
                            playerWonMaxDifficulty = Math.min(playerWonMaxDifficulty, wonAsPlayer);
                        }
                    }
                    playerXML = XMLTool.extractContained("player", mapXML, h);
                    ++h;
                }
                if (playerWonCount == playerCount) {
                    statsPrefs.putInt("wonAll_" + this.ops.mapTitle, playerWonMaxDifficulty);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            VoxGUI.getInstance().fillMapSelector(VoxGUI.getInstance().getSelectedMapName());
            VoxGUI.getInstance().loadInfoForSelectedMap();
            if (VoxGUI.getInstance().isDemo() && statsPrefs.getInt("gamesWon", 1) % 20 == 0) {
                new Thread("i-want-you-delayed"){

                    public void run() {
                        try {
                            Thread.sleep(5000L);
                            new RegisterNag("Register9.jpg", "SupportTheTroops", true, false);
                            battleOverSound.play();
                        }
                        catch (Exception e) {
                            SS.debug("Delayed battle sounds: " + e);
                        }
                    }
                }.start();
            }
        } else if (this.playerID > 0) {
            gameLoseSound.play();
        } else {
            gameWinSound.play();
        }
    }

    public int getTurnSecondsLeft() {
        if (!this.ops.useTurnTimer) {
            return 1000;
        }
        long currentTime = new Date().getTime();
        int turnSecondsLeft = (int)((double)(this.turnEndsAt - currentTime - 100L) / 1000.0);
        return turnSecondsLeft;
    }

    public void turnTimerTick() {
        int s = this.getTurnSecondsLeft();
        if (this.ops.useTurnTimer && this.widthBar.showTimer && (s == 1 || s == 2 || s == 3 || s == 9 || s == 10 || s == 30)) {
            timerSound.play();
        }
        if (this.widthBar != null) {
            this.widthBar.repaint(0L, 0, 0, 50, 32);
        }
    }

    public List getContinents() {
        return this.world.continents;
    }

    public Continent getContinent(int ID) {
        return this.world.getContinent(ID);
    }

    public int getContinentSize(Continent cont) {
        int ID = cont.getID();
        int size = 0;
        for (int i = 0; i < this.world.countries.size(); ++i) {
            Country c = (Country)this.world.countries.get(i);
            if (c.getContinentID() != ID) continue;
            ++size;
        }
        return size;
    }

    public Color getContinentColor(int ID) {
        if (this.world.continents == null) {
            return Color.BLACK;
        }
        for (int i = 0; i < this.world.continents.size(); ++i) {
            Continent c = (Continent)this.world.continents.get(i);
            if (c.getID() != ID) continue;
            return c.getColor();
        }
        return Color.BLACK;
    }

    public int getNumberOfContinents() {
        return this.world.continents.size();
    }

    public void commandAdded() {
        this.encodeln("sendHumanMoves: " + this.playerID + " " + XMLTool.getListXML(this.world.getCommands(), "vcommand"));
    }

    public void commandUndone() {
        this.encodeln("sendHumanMoves: " + this.playerID + " " + XMLTool.getListXML(this.world.getCommands(), "vcommand"));
    }

    public Player getLargestPlayer() {
        return this.getPlayer(this.stats.getLargestPlayer());
    }

    private void connectToServer() {
        new Thread((Runnable)this, "VoxClient-networking").start();
    }

    public void run() {
        String hostAddress = this.serverAddress;
        int hostPort = this.serverPort;
        try {
            if (this.localServer != null) {
                this.printMessage(Translator.getString("Connectinglocal") + " on port " + this.localServer.socketPort);
                this.localServer.acceptLocalClient(this);
            } else {
                this.printMessage(Translator.getString("Connecting") + " " + hostAddress + " " + Translator.getString("port") + " " + hostPort + "...");
                InetAddress host = InetAddress.getByName(hostAddress);
                Socket outgoing = new Socket(host, hostPort);
                outgoing.setKeepAlive(true);
                this.setSocket(outgoing);
            }
            this.encodeln("VOXCONNECT-0.9:" + this.name());
            String input = this.readLine();
            if (input != null && input.startsWith("VOXCONNECT-")) {
                float remoteVersion = Float.parseFloat(input.substring(11, input.indexOf(":")));
                if (!(remoteVersion < 0.9f) && remoteVersion != 0.9f) {
                    SS.debug("Lux -> Warning: server is using a different networkVersion. They have " + remoteVersion + " and we have " + 0.9f);
                }
            } else {
                SS.debug("VoxClient bad negotiation: Aborting connection");
                this.printMessage("VoxClient bad negotiation: Aborting connection");
                this.sock.close();
                return;
            }
            this.encodeln("userKey: " + this.key);
            if (this.guestOnly) {
                this.encodeln("guestOnly: true");
            }
            this.encodeln("remote-version: 1.2");
            this.encodeln("");
            boolean connected = true;
            while (!this.killed && connected) {
                input = this.readLine();
                if (input == null) {
                    if (this.localServer == null) {
                        connected = false;
                        continue;
                    }
                    SS.debug("LocalClient got a null readLine(), will continue listening", 10);
                    Thread.yield();
                    Thread.sleep(200L);
                    Thread.yield();
                    continue;
                }
                try {
                    this.decode(input);
                }
                catch (Throwable t) {
                    SS.debug("decode failed with input of (" + input + "): " + t);
                    t.printStackTrace();
                }
            }
            this.sock = null;
            this.serverAddress = null;
            SS.debug("VoxClient Thread Finished");
            if (this.visuals != null) {
                this.visuals.lostServer();
            }
        }
        catch (ConnectException e) {
            this.printMessage(Translator.getString("Connectionrefused"));
            this.visuals.setLoadText(Translator.getString("Connectionrefused"));
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            this.printMessage(Translator.getString("Unknownhost") + ": " + hostAddress);
            this.visuals.setLoadText(Translator.getString("Unknownhost") + ": " + hostAddress);
            e.printStackTrace();
        }
        catch (Throwable e) {
            this.printMessage(Translator.getString("Error") + ": " + e);
            if (this.visuals != null) {
                this.visuals.setLoadText(Translator.getString("Error") + ": " + e);
            }
            e.printStackTrace();
        }
    }

    private void decode(String command) {
        String[] params = StringTool.tokenize(command, " ");
        if (params.length == 0) {
            return;
        }
        if (params[0].equals("CHAT:")) {
            this.takeChat(command.substring(6));
        } else if (params[0].equals("CHATCOLOR:")) {
            String text = command.substring(params[0].length() + params[1].length() + 2);
            this.takeTeamChat(text);
        } else if (params[0].equals("EMOTE:")) {
            String text = command.substring(params[0].length() + 1);
            this.takeEmote(text);
        } else if (params[0].equals("voxOptions:")) {
            String XML = command.substring(params[0].length() + 1);
            this.setVoxOptions(new VoxOptions(XML));
        } else if (params[0].equals("setGameRound:")) {
            this.setGameRound(Integer.parseInt(params[1]));
        } else if (params[0].equals("countries:")) {
            String XML = command.substring(params[0].length() + 1);
            ArrayList<Country> list = new ArrayList<Country>();
            String item = XMLTool.extract("vcountry", XML);
            int h = 1;
            while (item != null) {
                Country object = new Country(item, this);
                list.add(object);
                item = XMLTool.extract("vcountry", XML, h);
                ++h;
            }
            this.setWorldData(list);
        } else if (params[0].equals("startNewRound:")) {
            this.startNewRound(Long.parseLong(params[1]));
        } else if (params[0].equals("updateCountry:")) {
            boolean conquered;
            int ID = Integer.parseInt(params[1]);
            Country c = (Country)this.getCountries().get(ID);
            UnitStackGroup units = new UnitStackGroup(command.substring(params[0].length() + params[1].length() + params[2].length() + 3), this);
            c.setNewUnits(units);
            boolean bl = conquered = units.size() > 0 && !units.getDominantOwner().getTeam().equals(c.getTeam());
            if (conquered) {
                c.setOwner(units.getDominantOwner());
            }
            c.setFlashing(false);
            if (params[2].equals("true")) {
                if (conquered) {
                    this.showNotice(c.getName() + " conquered by " + c.getOwner().getName() + "!", c.getCenter(), 8000L);
                    castleConqueredSound.play();
                } else {
                    this.showNotice(units.getCastle().getOwner().getName() + " built a Castle in " + c.getName() + "!", c.getCenter(), 8000L);
                    castleBuiltSound.play();
                }
            } else if (conquered) {
                // empty if block
            }
            this.visuals.repaint(this.world.clearCommands(c));
            this.visuals.repaint(c.getBounds());
        } else if (params[0].equals("setExtraLines:")) {
            String XML = command.substring(params[0].length() + 1);
            ArrayList<ExtraLine> list = new ArrayList<ExtraLine>();
            String item = XMLTool.extract("elines", XML);
            int h = 1;
            while (item != null) {
                ExtraLine object = new ExtraLine(item);
                list.add(object);
                item = XMLTool.extract("elines", XML, h);
                ++h;
            }
            this.visuals.setExtraLines(list);
        } else if (params[0].equals("setContinents:")) {
            String XML = command.substring(params[0].length() + 1);
            ArrayList<Continent> list = new ArrayList<Continent>();
            String item = XMLTool.extract("vcont", XML);
            int h = 1;
            while (item != null) {
                Continent object = new Continent(item);
                list.add(object);
                item = XMLTool.extract("vcont", XML, h);
                ++h;
            }
            this.continents = list;
            if (this.world != null) {
                this.world.setContinents(list);
            }
        } else if (params[0].equals("setMoney:")) {
            this.setMoney(Integer.parseInt(params[1]), Integer.parseInt(params[2]));
        } else if (params[0].equals("doneMoneys:")) {
            this.doneMoneys();
        } else if (params[0].equals("doneJoining:")) {
            if (this.chatArea != null) {
                SwingUtilities.invokeLater(this.chatArea.scrollDownRunnable);
            }
        } else if (params[0].equals("setPlayerID:")) {
            this.setPlayerID(Integer.parseInt(params[1]));
        } else if (params[0].equals("gameOver:")) {
            String XML = command.substring(params[0].length() + 1);
            StatsHistory statsHistory = new StatsHistory(XML);
            this.gameOver(statsHistory);
        } else if (params[0].equals("saveGame:")) {
            String XML = command.substring(params[0].length() + 1);
            StatsHistory statsHistory = new StatsHistory(XML);
            this.saveGame(statsHistory);
        } else if (params[0].equals("showCommands:")) {
            String XML = command.substring(params[0].length() + 1);
            ArrayList<Command> list = new ArrayList<Command>();
            String item = XMLTool.extract("vcommand", XML);
            int h = 1;
            while (item != null) {
                Command object = Command.fromXML(item, this);
                list.add(object);
                item = XMLTool.extract("vcommand", XML, h);
                ++h;
            }
            this.showAllCommands(list);
        } else if (params[0].equals("showOwnedCommands:")) {
            String XML = command.substring(params[0].length() + 1);
            ArrayList<Command> list = new ArrayList<Command>();
            String item = XMLTool.extract("vcommand", XML);
            int h = 1;
            while (item != null) {
                Command object = Command.fromXML(item, this);
                list.add(object);
                item = XMLTool.extract("vcommand", XML, h);
                ++h;
            }
            this.showOwnedCommands(list);
        } else if (params[0].equals("setControlling:")) {
            String newName = "null".equals(params[2]) ? null : command.substring(params[0].length() + params[1].length() + 2);
            this.getPlayer((int)Integer.parseInt((String)params[1])).controlledBy = newName;
        } else if (params[0].equals("setAI:")) {
            int switchID = Integer.parseInt(params[1]);
            if (switchID == this.playerID) {
                this.playerID = -1;
            }
            this.getPlayer(switchID).setAgentType(params[2]);
            this.visuals.infoPanel.fireTableDataChanged();
        } else if (params[0].equals("notwaiting:")) {
            this.finishedButton.setEnabled(false);
        } else if (params[0].equals("addGameStartedCount:")) {
            Vox.getStatsPrefs().putInt("gamesPlayed", Vox.getStatsPrefs().getInt("gamesPlayed", 0) + 1);
        } else if (params[0].equals("KILL:")) {
            SS.debug("client recieved a KILL: message", 1);
            this.kill();
        } else {
            SS.debug("VoxC -> Unknown network command: " + command);
        }
    }

    public void printMessage(String text) {
        if (this.chatArea != null) {
            this.chatArea.println("\u2731 " + text + " \u2731");
        }
    }

    public void println(String text) {
        if (this.chatArea != null) {
            this.chatArea.println(text);
        }
    }

    public void println(String text, Color color) {
        if (this.chatArea != null) {
            this.chatArea.println(text, color);
        }
    }

    public void println(String text, Color color, SimpleAttributeSet style) {
        if (this.chatArea != null) {
            this.chatArea.println(text, color, style);
        }
    }

    public boolean controlsAnyone() {
        return this.playerID > -1 && this.stats.getArmies(this.playerID) > 0;
    }

    public boolean controlsID(int ID) {
        return this.playerID == ID;
    }

    public void updateCountry(Country c, boolean castleConquered) {
    }

    public void updateCountry(Country c, boolean castleConquered, boolean castleBuilt) {
    }

    public boolean isAlive() {
        return true;
    }

    private void resizeTo(double zoom) {
        try {
            boolean needsVerticalScrollbar;
            XMLSerializable c;
            int i;
            this.currentZoom = zoom;
            this.visuals.setLoadText("resizing map");
            List countries = this.world.getCountries();
            for (i = 0; i < countries.size(); ++i) {
                c = (Country)countries.get(i);
                ((Country)c).resize(this.currentZoom);
            }
            for (i = 0; i < this.world.continents.size(); ++i) {
                c = (Continent)this.world.continents.get(i);
                ((Continent)c).resize(this.currentZoom);
            }
            List commands = this.world.getCommands();
            for (int j = 0; j < commands.size(); ++j) {
                Command com = (Command)commands.get(j);
                com.resetArrow(this.world);
            }
            this.visuals.resizeExtraLines(this.currentZoom);
            int mapWidth = (int)Math.floor((double)this.ops.width * this.currentZoom);
            int mapHeight = (int)Math.floor((double)this.ops.height * this.currentZoom);
            this.scroller.setPreferredSize(new Dimension(mapWidth, mapHeight));
            this.visuals.setMinimumSize(new Dimension(mapWidth, mapHeight));
            this.visuals.setPreferredSize(new Dimension(mapWidth, mapHeight));
            this.visuals.setMapSize(mapWidth, mapHeight);
            SS.debug("visuals.setMapSize(" + mapWidth + ", " + mapHeight + ");", 1);
            Point originalPI = GraphicsTool.pointFromString(this.ops.playerInfoPointString);
            if (originalPI != null) {
                originalPI.setLocation((double)originalPI.x * this.currentZoom, (double)originalPI.y * this.currentZoom);
                this.playerInfoPointString = GraphicsTool.stringFromPoint(originalPI);
            }
            this.visuals.setContainsPlayerInfo(true);
            this.visuals.loadTheme(this.ops.mapTheme);
            this.visuals.setLoadText(null);
            int newWidth = (int)Math.ceil((double)this.ops.width * this.currentZoom);
            int newHeight = (int)Math.ceil((double)this.ops.height * this.currentZoom);
            int CHATPANEL_HEIGHT = 95;
            newWidth += SwingTool.WINDOW_HORIZONTAL_PADDING;
            if (this.showChat) {
                newHeight += CHATPANEL_HEIGHT;
            }
            Dimension screenDimension = SwingTool.getUsableDimension();
            newHeight += this.ops.width < 730 ? 68 : 34;
            boolean bl = needsVerticalScrollbar = (double)(newHeight += SwingTool.WINDOW_VERTICAL_PADDING) > screenDimension.getHeight();
            if (needsVerticalScrollbar) {
                newWidth += SwingTool.SCROLLBAR_SIZE;
                SS.debug("boosting width to compensate for vertical scroller: ", 1);
            }
            newWidth = (int)Math.min(screenDimension.getWidth(), (double)newWidth);
            newHeight = (int)Math.min(screenDimension.getHeight() + (double)(SS.isMacintosh ? 0 : 8), (double)newHeight);
            SS.debug("resize map final dimensions: (" + mapWidth + "," + mapHeight + ")", 1);
            SS.debug("resize map final window size: (" + newWidth + "," + newHeight + ")", 1);
            if (this.showChat) {
                int oldChatHeight = this.chatArea.getSize().height;
                int newChatHeight = 95;
                this.splitPane.setPreferredSize(new Dimension(mapWidth, newHeight + newChatHeight));
            }
            this.window.pack();
            if ((double)(newHeight + 20) > screenDimension.getHeight() && (double)(newWidth + 140) > screenDimension.getWidth()) {
                this.window.setExtendedState(6);
                SS.debug("resize setExtendedState(Frame.MAXIMIZED_BOTH)", 1);
            }
            if (this.showChat) {
                int divide = Math.min(mapHeight + 34 + 5, (int)screenDimension.getHeight() - 100);
                SS.debug("setSplitDivider: " + divide, 1);
                this.splitPane.setDividerLocation(divide);
            }
        }
        catch (Exception e) {
            this.showMessage(Translator.getString("Error") + ": " + e);
            e.printStackTrace();
        }
    }

    public void resizeToFit() {
        this.resizeToFitInner();
        if (SS.isMacintosh && !this.showChat) {
            SS.debug("Mac OS X doing a second resizeToFitInner()...", 0);
            this.resizeToFitInner();
        }
    }

    public void resizeToFitInner() {
        Rectangle screenRect = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        Dimension screenDimension = screenRect.getSize();
        SS.debug("fitIntoHeight = " + screenDimension.getHeight() + " - " + SwingTool.WINDOW_VERTICAL_PADDING + " - " + (this.ops.width < 730 ? 68 : 34) + " - " + (this.showChat && !Prefs.getBoolean("seperateChatWindow", false) ? 166 : 0), 0);
        double percent = GraphicsTool.getResizePercentToFitInsideDimension(this.ops.width, this.ops.height, screenDimension.getWidth() - (double)SwingTool.WINDOW_HORIZONTAL_PADDING, screenDimension.getHeight() - (double)SwingTool.WINDOW_VERTICAL_PADDING - (double)(this.ops.width < 730 ? 68 : 34) - (double)(this.showChat && !Prefs.getBoolean("seperateChatWindow", false) ? 166 : 0));
        SS.debug("fitIntoPercent = " + percent, 0);
        this.resizeTo(percent);
        this.window.setLocation(0, 0);
    }

    public boolean saveGame() {
        if (this.world.roundCount < 1) {
            this.showMessage("You cannot save a game before round 1.");
            return false;
        }
        if (!this.visuals.active) {
            this.showMessage("You can only save a game during the planning phase.");
            return false;
        }
        this.dealWithCommand("/saveGame");
        return true;
    }

    public void saveGame(StatsHistory statsHistory) {
        String filename = this.ops.mapTitle + " round " + this.world.roundCount;
        if (!fullscreen) {
            filename = SSOptionPane.showInputDialog(this.window, Translator.getString("SaveBoardAs") + ":", filename);
        }
        SS.debug("SaveGame: " + filename, 1);
        if (filename == null) {
            return;
        }
        this.saveGame(statsHistory, filename);
        this.showMessage(Translator.getString("SavedGameFinished"));
        if (this.endGameAfterSave) {
            this.terminate();
        }
    }

    public void saveGame(StatsHistory statsHistory, String filename) {
        int i;
        StringBuffer result = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<voxsave>\n");
        result.append("<title>" + this.ops.mapTitle + "</title> \n");
        result.append("<width>" + this.visuals.displayWidth + "</width> \n");
        result.append("<height>" + this.visuals.displayHeight + "</height> \n");
        result.append("<theme>" + this.ops.mapTheme + "</theme> \n");
        result.append("<playerInfoLocation>" + this.playerInfoPointString + "</playerInfoLocation> \n\n");
        result.append("<gameRound>");
        result.append(this.world.roundCount);
        result.append("</gameRound>\n");
        result.append("<difficulty>");
        result.append(this.ops.difficulty);
        result.append("</difficulty>\n");
        result.append("<countryBorderWidth>");
        result.append(this.ops.borderWidth);
        result.append("</countryBorderWidth>\n");
        boolean[] outputPlayer = new boolean[this.ops.players.size()];
        for (i = 0; i < this.ops.players.size(); ++i) {
            outputPlayer[i] = false;
        }
        for (i = 0; i < this.ops.players.size(); ++i) {
            if (outputPlayer[i]) continue;
            Player p = this.getPlayer(i);
            Team t = p.getTeam();
            result.append("<team name=\"" + StringTool.xmlSafe(t.getName()) + "\" symbol=\"" + t.getSymbol() + "\"> \n");
            for (int j = 0; j < this.ops.players.size(); ++j) {
                Player jp = this.getPlayer(j);
                if (outputPlayer[j] || !jp.getTeam().equals(p.getTeam())) continue;
                result.append("\t<player id=\"" + j + "\" name=\"" + StringTool.xmlSafe(jp.getName()) + "\" agent=\"" + jp.getAgentType() + "\" " + (jp.isHuman() ? "controlledBy=\"" + jp.controlledBy + "\" " : " "));
                result.append("money=\"" + this.world.getPlayerMoney(j) + "\" color=\"" + GraphicsTool.stringFromColor(jp.getColor()) + "\" /> \n");
                outputPlayer[j] = true;
            }
            result.append("</team>\n");
        }
        result.append("\n\n");
        result.append(XMLTool.getListXML(this.world.getCommands(), "vcommand"));
        result.append("\n\n");
        List currentCommands = this.world.getCommands();
        ArrayList cloneCommands = new ArrayList();
        for (int j = 0; j < currentCommands.size(); ++j) {
            cloneCommands.add(currentCommands.get(j));
        }
        this.world.undoAllCommands(this.getPlayer(this.playerID));
        for (int cont = 0; cont < this.continents.size(); ++cont) {
            Continent c = (Continent)this.continents.get(cont);
            result.append("<continent>\n");
            result.append("\t<continentname>" + StringTool.xmlSafe(c.getName()) + "</continentname> \n");
            result.append("\t<bonus>" + c.getBonus() + "</bonus> \n");
            result.append("\t<labellocation>" + GraphicsTool.stringFromPoint(c.getLabelLocation()) + "</labellocation> \n");
            result.append("\t<color>" + GraphicsTool.stringFromColor(c.getColor()) + "</color> \n");
            for (int cc = 0; cc < this.world.countries.size(); ++cc) {
                Country spot = (Country)this.world.countries.get(cc);
                if (spot.getContinentID() != c.getID()) continue;
                result.append("\t<country> \n");
                result.append("\t\t<id>" + spot.getID() + "</id> \n");
                result.append("\t\t<name>" + StringTool.xmlSafe(spot.getName()) + "</name> \n");
                result.append("\t\t<initialOwner>" + spot.getOwner().getID() + "</initialOwner> \n");
                result.append("\t\t<income>" + spot.getBonus() + "</income> \n");
                result.append(spot.getUnitXML());
                result.append("\t\t<adjoining>" + spot.getAdjoiningListString() + "</adjoining> \n");
                result.append("\t\t<armylocation>" + GraphicsTool.stringFromPoint(spot.getLabelLocation()) + "</armylocation> \n");
                result.append("\t\t<voxPoints>" + spot.getVoxPointsString() + "</voxPoints> \n");
                result.append("\t\t<polygon>" + GraphicsTool.stringFromGeneralPath(spot.getShape(), this.visuals.displayHeight) + "</polygon> \n");
                result.append("\t</country> \n");
            }
            result.append("</continent> \n\n");
        }
        this.world.addCommands(cloneCommands);
        this.updateRecruitButton();
        result.append("<SH>" + statsHistory.toStringXML() + "</SH>\n\n");
        List lines = this.visuals.lines;
        if (lines != null) {
            for (int h = 0; h < lines.size(); ++h) {
                ExtraLine l = (ExtraLine)lines.get(h);
                result.append(l.getXML(this.visuals.displayHeight));
                result.append("\n");
            }
        }
        if (this.visuals.aboveLines != null) {
            lines = this.visuals.aboveLines;
            for (int h = 0; h < lines.size(); ++h) {
                ExtraLine l = (ExtraLine)lines.get(h);
                result.append(l.getXML(this.visuals.displayHeight));
                result.append("\n");
            }
        }
        result.append("\n</voxsave>\n");
        if (!filename.endsWith(".vox")) {
            filename = filename + ".vox";
        }
        new File(DesktopTool.savedGameDir()).mkdirs();
        File file = new File(DesktopTool.savedGameDir() + filename);
        SS.debug("Saving game to " + DesktopTool.savedGameDir() + filename);
        if (file.exists()) {
            file.delete();
        }
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
            out.print(result);
            out.close();
        }
        catch (Throwable e) {
            System.out.println("Vox -> error in saveGame().");
            e.printStackTrace();
        }
    }

    public Stats getStats() {
        return this.stats;
    }

    public VoxOptions getOps() {
        return this.ops;
    }

    private void printUnicodeTest() {
        boolean i = false;
        char[] hexchars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        int digit1 = 2;
        for (int digit2 = 2; digit2 < 12; ++digit2) {
            for (int digit3 = 0; digit3 < 16; ++digit3) {
                System.out.print("println(\"");
                for (int digit4 = 0; digit4 < 16; ++digit4) {
                    System.out.print("" + hexchars[digit1] + hexchars[digit2] + hexchars[digit3] + hexchars[digit4] + ":\\u" + hexchars[digit1] + hexchars[digit2] + hexchars[digit3] + hexchars[digit4] + "    ");
                }
                System.out.println("\");");
            }
        }
        this.println("2200:\u2200    2201:\u2201    2202:\u2202    2203:\u2203    2204:\u2204    2205:\u2205    2206:\u2206    2207:\u2207    2208:\u2208    2209:\u2209    220A:\u220a    220B:\u220b    220C:\u220c    220D:\u220d    220E:\u220e    220F:\u220f    ");
        this.println("2210:\u2210    2211:\u2211    2212:\u2212    2213:\u2213    2214:\u2214    2215:\u2215    2216:\u2216    2217:\u2217    2218:\u2218    2219:\u2219    221A:\u221a    221B:\u221b    221C:\u221c    221D:\u221d    221E:\u221e    221F:\u221f    ");
        this.println("2220:\u2220    2221:\u2221    2222:\u2222    2223:\u2223    2224:\u2224    2225:\u2225    2226:\u2226    2227:\u2227    2228:\u2228    2229:\u2229    222A:\u222a    222B:\u222b    222C:\u222c    222D:\u222d    222E:\u222e    222F:\u222f    ");
        this.println("2230:\u2230    2231:\u2231    2232:\u2232    2233:\u2233    2234:\u2234    2235:\u2235    2236:\u2236    2237:\u2237    2238:\u2238    2239:\u2239    223A:\u223a    223B:\u223b    223C:\u223c    223D:\u223d    223E:\u223e    223F:\u223f    ");
        this.println("2240:\u2240    2241:\u2241    2242:\u2242    2243:\u2243    2244:\u2244    2245:\u2245    2246:\u2246    2247:\u2247    2248:\u2248    2249:\u2249    224A:\u224a    224B:\u224b    224C:\u224c    224D:\u224d    224E:\u224e    224F:\u224f    ");
        this.println("2250:\u2250    2251:\u2251    2252:\u2252    2253:\u2253    2254:\u2254    2255:\u2255    2256:\u2256    2257:\u2257    2258:\u2258    2259:\u2259    225A:\u225a    225B:\u225b    225C:\u225c    225D:\u225d    225E:\u225e    225F:\u225f    ");
        this.println("2260:\u2260    2261:\u2261    2262:\u2262    2263:\u2263    2264:\u2264    2265:\u2265    2266:\u2266    2267:\u2267    2268:\u2268    2269:\u2269    226A:\u226a    226B:\u226b    226C:\u226c    226D:\u226d    226E:\u226e    226F:\u226f    ");
        this.println("2270:\u2270    2271:\u2271    2272:\u2272    2273:\u2273    2274:\u2274    2275:\u2275    2276:\u2276    2277:\u2277    2278:\u2278    2279:\u2279    227A:\u227a    227B:\u227b    227C:\u227c    227D:\u227d    227E:\u227e    227F:\u227f    ");
        this.println("2280:\u2280    2281:\u2281    2282:\u2282    2283:\u2283    2284:\u2284    2285:\u2285    2286:\u2286    2287:\u2287    2288:\u2288    2289:\u2289    228A:\u228a    228B:\u228b    228C:\u228c    228D:\u228d    228E:\u228e    228F:\u228f    ");
        this.println("2290:\u2290    2291:\u2291    2292:\u2292    2293:\u2293    2294:\u2294    2295:\u2295    2296:\u2296    2297:\u2297    2298:\u2298    2299:\u2299    229A:\u229a    229B:\u229b    229C:\u229c    229D:\u229d    229E:\u229e    229F:\u229f    ");
        this.println("22A0:\u22a0    22A1:\u22a1    22A2:\u22a2    22A3:\u22a3    22A4:\u22a4    22A5:\u22a5    22A6:\u22a6    22A7:\u22a7    22A8:\u22a8    22A9:\u22a9    22AA:\u22aa    22AB:\u22ab    22AC:\u22ac    22AD:\u22ad    22AE:\u22ae    22AF:\u22af    ");
        this.println("22B0:\u22b0    22B1:\u22b1    22B2:\u22b2    22B3:\u22b3    22B4:\u22b4    22B5:\u22b5    22B6:\u22b6    22B7:\u22b7    22B8:\u22b8    22B9:\u22b9    22BA:\u22ba    22BB:\u22bb    22BC:\u22bc    22BD:\u22bd    22BE:\u22be    22BF:\u22bf    ");
        this.println("22C0:\u22c0    22C1:\u22c1    22C2:\u22c2    22C3:\u22c3    22C4:\u22c4    22C5:\u22c5    22C6:\u22c6    22C7:\u22c7    22C8:\u22c8    22C9:\u22c9    22CA:\u22ca    22CB:\u22cb    22CC:\u22cc    22CD:\u22cd    22CE:\u22ce    22CF:\u22cf    ");
        this.println("22D0:\u22d0    22D1:\u22d1    22D2:\u22d2    22D3:\u22d3    22D4:\u22d4    22D5:\u22d5    22D6:\u22d6    22D7:\u22d7    22D8:\u22d8    22D9:\u22d9    22DA:\u22da    22DB:\u22db    22DC:\u22dc    22DD:\u22dd    22DE:\u22de    22DF:\u22df    ");
        this.println("22E0:\u22e0    22E1:\u22e1    22E2:\u22e2    22E3:\u22e3    22E4:\u22e4    22E5:\u22e5    22E6:\u22e6    22E7:\u22e7    22E8:\u22e8    22E9:\u22e9    22EA:\u22ea    22EB:\u22eb    22EC:\u22ec    22ED:\u22ed    22EE:\u22ee    22EF:\u22ef    ");
        this.println("22F0:\u22f0    22F1:\u22f1    22F2:\u22f2    22F3:\u22f3    22F4:\u22f4    22F5:\u22f5    22F6:\u22f6    22F7:\u22f7    22F8:\u22f8    22F9:\u22f9    22FA:\u22fa    22FB:\u22fb    22FC:\u22fc    22FD:\u22fd    22FE:\u22fe    22FF:\u22ff    ");
        this.println("2300:\u2300    2301:\u2301    2302:\u2302    2303:\u2303    2304:\u2304    2305:\u2305    2306:\u2306    2307:\u2307    2308:\u2308    2309:\u2309    230A:\u230a    230B:\u230b    230C:\u230c    230D:\u230d    230E:\u230e    230F:\u230f    ");
        this.println("2310:\u2310    2311:\u2311    2312:\u2312    2313:\u2313    2314:\u2314    2315:\u2315    2316:\u2316    2317:\u2317    2318:\u2318    2319:\u2319    231A:\u231a    231B:\u231b    231C:\u231c    231D:\u231d    231E:\u231e    231F:\u231f    ");
        this.println("2320:\u2320    2321:\u2321    2322:\u2322    2323:\u2323    2324:\u2324    2325:\u2325    2326:\u2326    2327:\u2327    2328:\u2328    2329:\u2329    232A:\u232a    232B:\u232b    232C:\u232c    232D:\u232d    232E:\u232e    232F:\u232f    ");
        this.println("2330:\u2330    2331:\u2331    2332:\u2332    2333:\u2333    2334:\u2334    2335:\u2335    2336:\u2336    2337:\u2337    2338:\u2338    2339:\u2339    233A:\u233a    233B:\u233b    233C:\u233c    233D:\u233d    233E:\u233e    233F:\u233f    ");
        this.println("2340:\u2340    2341:\u2341    2342:\u2342    2343:\u2343    2344:\u2344    2345:\u2345    2346:\u2346    2347:\u2347    2348:\u2348    2349:\u2349    234A:\u234a    234B:\u234b    234C:\u234c    234D:\u234d    234E:\u234e    234F:\u234f    ");
        this.println("2350:\u2350    2351:\u2351    2352:\u2352    2353:\u2353    2354:\u2354    2355:\u2355    2356:\u2356    2357:\u2357    2358:\u2358    2359:\u2359    235A:\u235a    235B:\u235b    235C:\u235c    235D:\u235d    235E:\u235e    235F:\u235f    ");
        this.println("2360:\u2360    2361:\u2361    2362:\u2362    2363:\u2363    2364:\u2364    2365:\u2365    2366:\u2366    2367:\u2367    2368:\u2368    2369:\u2369    236A:\u236a    236B:\u236b    236C:\u236c    236D:\u236d    236E:\u236e    236F:\u236f    ");
        this.println("2370:\u2370    2371:\u2371    2372:\u2372    2373:\u2373    2374:\u2374    2375:\u2375    2376:\u2376    2377:\u2377    2378:\u2378    2379:\u2379    237A:\u237a    237B:\u237b    237C:\u237c    237D:\u237d    237E:\u237e    237F:\u237f    ");
        this.println("2380:\u2380    2381:\u2381    2382:\u2382    2383:\u2383    2384:\u2384    2385:\u2385    2386:\u2386    2387:\u2387    2388:\u2388    2389:\u2389    238A:\u238a    238B:\u238b    238C:\u238c    238D:\u238d    238E:\u238e    238F:\u238f    ");
        this.println("2390:\u2390    2391:\u2391    2392:\u2392    2393:\u2393    2394:\u2394    2395:\u2395    2396:\u2396    2397:\u2397    2398:\u2398    2399:\u2399    239A:\u239a    239B:\u239b    239C:\u239c    239D:\u239d    239E:\u239e    239F:\u239f    ");
        this.println("23A0:\u23a0    23A1:\u23a1    23A2:\u23a2    23A3:\u23a3    23A4:\u23a4    23A5:\u23a5    23A6:\u23a6    23A7:\u23a7    23A8:\u23a8    23A9:\u23a9    23AA:\u23aa    23AB:\u23ab    23AC:\u23ac    23AD:\u23ad    23AE:\u23ae    23AF:\u23af    ");
        this.println("23B0:\u23b0    23B1:\u23b1    23B2:\u23b2    23B3:\u23b3    23B4:\u23b4    23B5:\u23b5    23B6:\u23b6    23B7:\u23b7    23B8:\u23b8    23B9:\u23b9    23BA:\u23ba    23BB:\u23bb    23BC:\u23bc    23BD:\u23bd    23BE:\u23be    23BF:\u23bf    ");
        this.println("23C0:\u23c0    23C1:\u23c1    23C2:\u23c2    23C3:\u23c3    23C4:\u23c4    23C5:\u23c5    23C6:\u23c6    23C7:\u23c7    23C8:\u23c8    23C9:\u23c9    23CA:\u23ca    23CB:\u23cb    23CC:\u23cc    23CD:\u23cd    23CE:\u23ce    23CF:\u23cf    ");
        this.println("23D0:\u23d0    23D1:\u23d1    23D2:\u23d2    23D3:\u23d3    23D4:\u23d4    23D5:\u23d5    23D6:\u23d6    23D7:\u23d7    23D8:\u23d8    23D9:\u23d9    23DA:\u23da    23DB:\u23db    23DC:\u23dc    23DD:\u23dd    23DE:\u23de    23DF:\u23df    ");
        this.println("23E0:\u23e0    23E1:\u23e1    23E2:\u23e2    23E3:\u23e3    23E4:\u23e4    23E5:\u23e5    23E6:\u23e6    23E7:\u23e7    23E8:\u23e8    23E9:\u23e9    23EA:\u23ea    23EB:\u23eb    23EC:\u23ec    23ED:\u23ed    23EE:\u23ee    23EF:\u23ef    ");
        this.println("23F0:\u23f0    23F1:\u23f1    23F2:\u23f2    23F3:\u23f3    23F4:\u23f4    23F5:\u23f5    23F6:\u23f6    23F7:\u23f7    23F8:\u23f8    23F9:\u23f9    23FA:\u23fa    23FB:\u23fb    23FC:\u23fc    23FD:\u23fd    23FE:\u23fe    23FF:\u23ff    ");
        this.println("2400:\u2400    2401:\u2401    2402:\u2402    2403:\u2403    2404:\u2404    2405:\u2405    2406:\u2406    2407:\u2407    2408:\u2408    2409:\u2409    240A:\u240a    240B:\u240b    240C:\u240c    240D:\u240d    240E:\u240e    240F:\u240f    ");
        this.println("2410:\u2410    2411:\u2411    2412:\u2412    2413:\u2413    2414:\u2414    2415:\u2415    2416:\u2416    2417:\u2417    2418:\u2418    2419:\u2419    241A:\u241a    241B:\u241b    241C:\u241c    241D:\u241d    241E:\u241e    241F:\u241f    ");
        this.println("2420:\u2420    2421:\u2421    2422:\u2422    2423:\u2423    2424:\u2424    2425:\u2425    2426:\u2426    2427:\u2427    2428:\u2428    2429:\u2429    242A:\u242a    242B:\u242b    242C:\u242c    242D:\u242d    242E:\u242e    242F:\u242f    ");
        this.println("2430:\u2430    2431:\u2431    2432:\u2432    2433:\u2433    2434:\u2434    2435:\u2435    2436:\u2436    2437:\u2437    2438:\u2438    2439:\u2439    243A:\u243a    243B:\u243b    243C:\u243c    243D:\u243d    243E:\u243e    243F:\u243f    ");
        this.println("2440:\u2440    2441:\u2441    2442:\u2442    2443:\u2443    2444:\u2444    2445:\u2445    2446:\u2446    2447:\u2447    2448:\u2448    2449:\u2449    244A:\u244a    244B:\u244b    244C:\u244c    244D:\u244d    244E:\u244e    244F:\u244f    ");
        this.println("2450:\u2450    2451:\u2451    2452:\u2452    2453:\u2453    2454:\u2454    2455:\u2455    2456:\u2456    2457:\u2457    2458:\u2458    2459:\u2459    245A:\u245a    245B:\u245b    245C:\u245c    245D:\u245d    245E:\u245e    245F:\u245f    ");
        this.println("2460:\u2460    2461:\u2461    2462:\u2462    2463:\u2463    2464:\u2464    2465:\u2465    2466:\u2466    2467:\u2467    2468:\u2468    2469:\u2469    246A:\u246a    246B:\u246b    246C:\u246c    246D:\u246d    246E:\u246e    246F:\u246f    ");
        this.println("2470:\u2470    2471:\u2471    2472:\u2472    2473:\u2473    2474:\u2474    2475:\u2475    2476:\u2476    2477:\u2477    2478:\u2478    2479:\u2479    247A:\u247a    247B:\u247b    247C:\u247c    247D:\u247d    247E:\u247e    247F:\u247f    ");
        this.println("2480:\u2480    2481:\u2481    2482:\u2482    2483:\u2483    2484:\u2484    2485:\u2485    2486:\u2486    2487:\u2487    2488:\u2488    2489:\u2489    248A:\u248a    248B:\u248b    248C:\u248c    248D:\u248d    248E:\u248e    248F:\u248f    ");
        this.println("2490:\u2490    2491:\u2491    2492:\u2492    2493:\u2493    2494:\u2494    2495:\u2495    2496:\u2496    2497:\u2497    2498:\u2498    2499:\u2499    249A:\u249a    249B:\u249b    249C:\u249c    249D:\u249d    249E:\u249e    249F:\u249f    ");
        this.println("24A0:\u24a0    24A1:\u24a1    24A2:\u24a2    24A3:\u24a3    24A4:\u24a4    24A5:\u24a5    24A6:\u24a6    24A7:\u24a7    24A8:\u24a8    24A9:\u24a9    24AA:\u24aa    24AB:\u24ab    24AC:\u24ac    24AD:\u24ad    24AE:\u24ae    24AF:\u24af    ");
        this.println("24B0:\u24b0    24B1:\u24b1    24B2:\u24b2    24B3:\u24b3    24B4:\u24b4    24B5:\u24b5    24B6:\u24b6    24B7:\u24b7    24B8:\u24b8    24B9:\u24b9    24BA:\u24ba    24BB:\u24bb    24BC:\u24bc    24BD:\u24bd    24BE:\u24be    24BF:\u24bf    ");
        this.println("24C0:\u24c0    24C1:\u24c1    24C2:\u24c2    24C3:\u24c3    24C4:\u24c4    24C5:\u24c5    24C6:\u24c6    24C7:\u24c7    24C8:\u24c8    24C9:\u24c9    24CA:\u24ca    24CB:\u24cb    24CC:\u24cc    24CD:\u24cd    24CE:\u24ce    24CF:\u24cf    ");
        this.println("24D0:\u24d0    24D1:\u24d1    24D2:\u24d2    24D3:\u24d3    24D4:\u24d4    24D5:\u24d5    24D6:\u24d6    24D7:\u24d7    24D8:\u24d8    24D9:\u24d9    24DA:\u24da    24DB:\u24db    24DC:\u24dc    24DD:\u24dd    24DE:\u24de    24DF:\u24df    ");
        this.println("24E0:\u24e0    24E1:\u24e1    24E2:\u24e2    24E3:\u24e3    24E4:\u24e4    24E5:\u24e5    24E6:\u24e6    24E7:\u24e7    24E8:\u24e8    24E9:\u24e9    24EA:\u24ea    24EB:\u24eb    24EC:\u24ec    24ED:\u24ed    24EE:\u24ee    24EF:\u24ef    ");
        this.println("24F0:\u24f0    24F1:\u24f1    24F2:\u24f2    24F3:\u24f3    24F4:\u24f4    24F5:\u24f5    24F6:\u24f6    24F7:\u24f7    24F8:\u24f8    24F9:\u24f9    24FA:\u24fa    24FB:\u24fb    24FC:\u24fc    24FD:\u24fd    24FE:\u24fe    24FF:\u24ff    ");
        this.println("2500:\u2500    2501:\u2501    2502:\u2502    2503:\u2503    2504:\u2504    2505:\u2505    2506:\u2506    2507:\u2507    2508:\u2508    2509:\u2509    250A:\u250a    250B:\u250b    250C:\u250c    250D:\u250d    250E:\u250e    250F:\u250f    ");
        this.println("2510:\u2510    2511:\u2511    2512:\u2512    2513:\u2513    2514:\u2514    2515:\u2515    2516:\u2516    2517:\u2517    2518:\u2518    2519:\u2519    251A:\u251a    251B:\u251b    251C:\u251c    251D:\u251d    251E:\u251e    251F:\u251f    ");
        this.println("2520:\u2520    2521:\u2521    2522:\u2522    2523:\u2523    2524:\u2524    2525:\u2525    2526:\u2526    2527:\u2527    2528:\u2528    2529:\u2529    252A:\u252a    252B:\u252b    252C:\u252c    252D:\u252d    252E:\u252e    252F:\u252f    ");
        this.println("2530:\u2530    2531:\u2531    2532:\u2532    2533:\u2533    2534:\u2534    2535:\u2535    2536:\u2536    2537:\u2537    2538:\u2538    2539:\u2539    253A:\u253a    253B:\u253b    253C:\u253c    253D:\u253d    253E:\u253e    253F:\u253f    ");
        this.println("2540:\u2540    2541:\u2541    2542:\u2542    2543:\u2543    2544:\u2544    2545:\u2545    2546:\u2546    2547:\u2547    2548:\u2548    2549:\u2549    254A:\u254a    254B:\u254b    254C:\u254c    254D:\u254d    254E:\u254e    254F:\u254f    ");
        this.println("2550:\u2550    2551:\u2551    2552:\u2552    2553:\u2553    2554:\u2554    2555:\u2555    2556:\u2556    2557:\u2557    2558:\u2558    2559:\u2559    255A:\u255a    255B:\u255b    255C:\u255c    255D:\u255d    255E:\u255e    255F:\u255f    ");
        this.println("2560:\u2560    2561:\u2561    2562:\u2562    2563:\u2563    2564:\u2564    2565:\u2565    2566:\u2566    2567:\u2567    2568:\u2568    2569:\u2569    256A:\u256a    256B:\u256b    256C:\u256c    256D:\u256d    256E:\u256e    256F:\u256f    ");
        this.println("2570:\u2570    2571:\u2571    2572:\u2572    2573:\u2573    2574:\u2574    2575:\u2575    2576:\u2576    2577:\u2577    2578:\u2578    2579:\u2579    257A:\u257a    257B:\u257b    257C:\u257c    257D:\u257d    257E:\u257e    257F:\u257f    ");
        this.println("2580:\u2580    2581:\u2581    2582:\u2582    2583:\u2583    2584:\u2584    2585:\u2585    2586:\u2586    2587:\u2587    2588:\u2588    2589:\u2589    258A:\u258a    258B:\u258b    258C:\u258c    258D:\u258d    258E:\u258e    258F:\u258f    ");
        this.println("2590:\u2590    2591:\u2591    2592:\u2592    2593:\u2593    2594:\u2594    2595:\u2595    2596:\u2596    2597:\u2597    2598:\u2598    2599:\u2599    259A:\u259a    259B:\u259b    259C:\u259c    259D:\u259d    259E:\u259e    259F:\u259f    ");
        this.println("25A0:\u25a0    25A1:\u25a1    25A2:\u25a2    25A3:\u25a3    25A4:\u25a4    25A5:\u25a5    25A6:\u25a6    25A7:\u25a7    25A8:\u25a8    25A9:\u25a9    25AA:\u25aa    25AB:\u25ab    25AC:\u25ac    25AD:\u25ad    25AE:\u25ae    25AF:\u25af    ");
        this.println("25B0:\u25b0    25B1:\u25b1    25B2:\u25b2    25B3:\u25b3    25B4:\u25b4    25B5:\u25b5    25B6:\u25b6    25B7:\u25b7    25B8:\u25b8    25B9:\u25b9    25BA:\u25ba    25BB:\u25bb    25BC:\u25bc    25BD:\u25bd    25BE:\u25be    25BF:\u25bf    ");
        this.println("25C0:\u25c0    25C1:\u25c1    25C2:\u25c2    25C3:\u25c3    25C4:\u25c4    25C5:\u25c5    25C6:\u25c6    25C7:\u25c7    25C8:\u25c8    25C9:\u25c9    25CA:\u25ca    25CB:\u25cb    25CC:\u25cc    25CD:\u25cd    25CE:\u25ce    25CF:\u25cf    ");
        this.println("25D0:\u25d0    25D1:\u25d1    25D2:\u25d2    25D3:\u25d3    25D4:\u25d4    25D5:\u25d5    25D6:\u25d6    25D7:\u25d7    25D8:\u25d8    25D9:\u25d9    25DA:\u25da    25DB:\u25db    25DC:\u25dc    25DD:\u25dd    25DE:\u25de    25DF:\u25df    ");
        this.println("25E0:\u25e0    25E1:\u25e1    25E2:\u25e2    25E3:\u25e3    25E4:\u25e4    25E5:\u25e5    25E6:\u25e6    25E7:\u25e7    25E8:\u25e8    25E9:\u25e9    25EA:\u25ea    25EB:\u25eb    25EC:\u25ec    25ED:\u25ed    25EE:\u25ee    25EF:\u25ef    ");
        this.println("25F0:\u25f0    25F1:\u25f1    25F2:\u25f2    25F3:\u25f3    25F4:\u25f4    25F5:\u25f5    25F6:\u25f6    25F7:\u25f7    25F8:\u25f8    25F9:\u25f9    25FA:\u25fa    25FB:\u25fb    25FC:\u25fc    25FD:\u25fd    25FE:\u25fe    25FF:\u25ff    ");
        this.println("2600:\u2600    2601:\u2601    2602:\u2602    2603:\u2603    2604:\u2604    2605:\u2605    2606:\u2606    2607:\u2607    2608:\u2608    2609:\u2609    260A:\u260a    260B:\u260b    260C:\u260c    260D:\u260d    260E:\u260e    260F:\u260f    ");
        this.println("2610:\u2610    2611:\u2611    2612:\u2612    2613:\u2613    2614:\u2614    2615:\u2615    2616:\u2616    2617:\u2617    2618:\u2618    2619:\u2619    261A:\u261a    261B:\u261b    261C:\u261c    261D:\u261d    261E:\u261e    261F:\u261f    ");
        this.println("2620:\u2620    2621:\u2621    2622:\u2622    2623:\u2623    2624:\u2624    2625:\u2625    2626:\u2626    2627:\u2627    2628:\u2628    2629:\u2629    262A:\u262a    262B:\u262b    262C:\u262c    262D:\u262d    262E:\u262e    262F:\u262f    ");
        this.println("2630:\u2630    2631:\u2631    2632:\u2632    2633:\u2633    2634:\u2634    2635:\u2635    2636:\u2636    2637:\u2637    2638:\u2638    2639:\u2639    263A:\u263a    263B:\u263b    263C:\u263c    263D:\u263d    263E:\u263e    263F:\u263f    ");
        this.println("2640:\u2640    2641:\u2641    2642:\u2642    2643:\u2643    2644:\u2644    2645:\u2645    2646:\u2646    2647:\u2647    2648:\u2648    2649:\u2649    264A:\u264a    264B:\u264b    264C:\u264c    264D:\u264d    264E:\u264e    264F:\u264f    ");
        this.println("2650:\u2650    2651:\u2651    2652:\u2652    2653:\u2653    2654:\u2654    2655:\u2655    2656:\u2656    2657:\u2657    2658:\u2658    2659:\u2659    265A:\u265a    265B:\u265b    265C:\u265c    265D:\u265d    265E:\u265e    265F:\u265f    ");
        this.println("2660:\u2660    2661:\u2661    2662:\u2662    2663:\u2663    2664:\u2664    2665:\u2665    2666:\u2666    2667:\u2667    2668:\u2668    2669:\u2669    266A:\u266a    266B:\u266b    266C:\u266c    266D:\u266d    266E:\u266e    266F:\u266f    ");
        this.println("2670:\u2670    2671:\u2671    2672:\u2672    2673:\u2673    2674:\u2674    2675:\u2675    2676:\u2676    2677:\u2677    2678:\u2678    2679:\u2679    267A:\u267a    267B:\u267b    267C:\u267c    267D:\u267d    267E:\u267e    267F:\u267f    ");
        this.println("2680:\u2680    2681:\u2681    2682:\u2682    2683:\u2683    2684:\u2684    2685:\u2685    2686:\u2686    2687:\u2687    2688:\u2688    2689:\u2689    268A:\u268a    268B:\u268b    268C:\u268c    268D:\u268d    268E:\u268e    268F:\u268f    ");
        this.println("2690:\u2690    2691:\u2691    2692:\u2692    2693:\u2693    2694:\u2694    2695:\u2695    2696:\u2696    2697:\u2697    2698:\u2698    2699:\u2699    269A:\u269a    269B:\u269b    269C:\u269c    269D:\u269d    269E:\u269e    269F:\u269f    ");
        this.println("26A0:\u26a0    26A1:\u26a1    26A2:\u26a2    26A3:\u26a3    26A4:\u26a4    26A5:\u26a5    26A6:\u26a6    26A7:\u26a7    26A8:\u26a8    26A9:\u26a9    26AA:\u26aa    26AB:\u26ab    26AC:\u26ac    26AD:\u26ad    26AE:\u26ae    26AF:\u26af    ");
        this.println("26B0:\u26b0    26B1:\u26b1    26B2:\u26b2    26B3:\u26b3    26B4:\u26b4    26B5:\u26b5    26B6:\u26b6    26B7:\u26b7    26B8:\u26b8    26B9:\u26b9    26BA:\u26ba    26BB:\u26bb    26BC:\u26bc    26BD:\u26bd    26BE:\u26be    26BF:\u26bf    ");
        this.println("26C0:\u26c0    26C1:\u26c1    26C2:\u26c2    26C3:\u26c3    26C4:\u26c4    26C5:\u26c5    26C6:\u26c6    26C7:\u26c7    26C8:\u26c8    26C9:\u26c9    26CA:\u26ca    26CB:\u26cb    26CC:\u26cc    26CD:\u26cd    26CE:\u26ce    26CF:\u26cf    ");
        this.println("26D0:\u26d0    26D1:\u26d1    26D2:\u26d2    26D3:\u26d3    26D4:\u26d4    26D5:\u26d5    26D6:\u26d6    26D7:\u26d7    26D8:\u26d8    26D9:\u26d9    26DA:\u26da    26DB:\u26db    26DC:\u26dc    26DD:\u26dd    26DE:\u26de    26DF:\u26df    ");
        this.println("26E0:\u26e0    26E1:\u26e1    26E2:\u26e2    26E3:\u26e3    26E4:\u26e4    26E5:\u26e5    26E6:\u26e6    26E7:\u26e7    26E8:\u26e8    26E9:\u26e9    26EA:\u26ea    26EB:\u26eb    26EC:\u26ec    26ED:\u26ed    26EE:\u26ee    26EF:\u26ef    ");
        this.println("26F0:\u26f0    26F1:\u26f1    26F2:\u26f2    26F3:\u26f3    26F4:\u26f4    26F5:\u26f5    26F6:\u26f6    26F7:\u26f7    26F8:\u26f8    26F9:\u26f9    26FA:\u26fa    26FB:\u26fb    26FC:\u26fc    26FD:\u26fd    26FE:\u26fe    26FF:\u26ff    ");
        this.println("2700:\u2700    2701:\u2701    2702:\u2702    2703:\u2703    2704:\u2704    2705:\u2705    2706:\u2706    2707:\u2707    2708:\u2708    2709:\u2709    270A:\u270a    270B:\u270b    270C:\u270c    270D:\u270d    270E:\u270e    270F:\u270f    ");
        this.println("2710:\u2710    2711:\u2711    2712:\u2712    2713:\u2713    2714:\u2714    2715:\u2715    2716:\u2716    2717:\u2717    2718:\u2718    2719:\u2719    271A:\u271a    271B:\u271b    271C:\u271c    271D:\u271d    271E:\u271e    271F:\u271f    ");
        this.println("2720:\u2720    2721:\u2721    2722:\u2722    2723:\u2723    2724:\u2724    2725:\u2725    2726:\u2726    2727:\u2727    2728:\u2728    2729:\u2729    272A:\u272a    272B:\u272b    272C:\u272c    272D:\u272d    272E:\u272e    272F:\u272f    ");
        this.println("2730:\u2730    2731:\u2731    2732:\u2732    2733:\u2733    2734:\u2734    2735:\u2735    2736:\u2736    2737:\u2737    2738:\u2738    2739:\u2739    273A:\u273a    273B:\u273b    273C:\u273c    273D:\u273d    273E:\u273e    273F:\u273f    ");
        this.println("2740:\u2740    2741:\u2741    2742:\u2742    2743:\u2743    2744:\u2744    2745:\u2745    2746:\u2746    2747:\u2747    2748:\u2748    2749:\u2749    274A:\u274a    274B:\u274b    274C:\u274c    274D:\u274d    274E:\u274e    274F:\u274f    ");
        this.println("2750:\u2750    2751:\u2751    2752:\u2752    2753:\u2753    2754:\u2754    2755:\u2755    2756:\u2756    2757:\u2757    2758:\u2758    2759:\u2759    275A:\u275a    275B:\u275b    275C:\u275c    275D:\u275d    275E:\u275e    275F:\u275f    ");
        this.println("2760:\u2760    2761:\u2761    2762:\u2762    2763:\u2763    2764:\u2764    2765:\u2765    2766:\u2766    2767:\u2767    2768:\u2768    2769:\u2769    276A:\u276a    276B:\u276b    276C:\u276c    276D:\u276d    276E:\u276e    276F:\u276f    ");
        this.println("2770:\u2770    2771:\u2771    2772:\u2772    2773:\u2773    2774:\u2774    2775:\u2775    2776:\u2776    2777:\u2777    2778:\u2778    2779:\u2779    277A:\u277a    277B:\u277b    277C:\u277c    277D:\u277d    277E:\u277e    277F:\u277f    ");
        this.println("2780:\u2780    2781:\u2781    2782:\u2782    2783:\u2783    2784:\u2784    2785:\u2785    2786:\u2786    2787:\u2787    2788:\u2788    2789:\u2789    278A:\u278a    278B:\u278b    278C:\u278c    278D:\u278d    278E:\u278e    278F:\u278f    ");
        this.println("2790:\u2790    2791:\u2791    2792:\u2792    2793:\u2793    2794:\u2794    2795:\u2795    2796:\u2796    2797:\u2797    2798:\u2798    2799:\u2799    279A:\u279a    279B:\u279b    279C:\u279c    279D:\u279d    279E:\u279e    279F:\u279f    ");
        this.println("27A0:\u27a0    27A1:\u27a1    27A2:\u27a2    27A3:\u27a3    27A4:\u27a4    27A5:\u27a5    27A6:\u27a6    27A7:\u27a7    27A8:\u27a8    27A9:\u27a9    27AA:\u27aa    27AB:\u27ab    27AC:\u27ac    27AD:\u27ad    27AE:\u27ae    27AF:\u27af    ");
        this.println("27B0:\u27b0    27B1:\u27b1    27B2:\u27b2    27B3:\u27b3    27B4:\u27b4    27B5:\u27b5    27B6:\u27b6    27B7:\u27b7    27B8:\u27b8    27B9:\u27b9    27BA:\u27ba    27BB:\u27bb    27BC:\u27bc    27BD:\u27bd    27BE:\u27be    27BF:\u27bf    ");
        this.println("27C0:\u27c0    27C1:\u27c1    27C2:\u27c2    27C3:\u27c3    27C4:\u27c4    27C5:\u27c5    27C6:\u27c6    27C7:\u27c7    27C8:\u27c8    27C9:\u27c9    27CA:\u27ca    27CB:\u27cb    27CC:\u27cc    27CD:\u27cd    27CE:\u27ce    27CF:\u27cf    ");
        this.println("27D0:\u27d0    27D1:\u27d1    27D2:\u27d2    27D3:\u27d3    27D4:\u27d4    27D5:\u27d5    27D6:\u27d6    27D7:\u27d7    27D8:\u27d8    27D9:\u27d9    27DA:\u27da    27DB:\u27db    27DC:\u27dc    27DD:\u27dd    27DE:\u27de    27DF:\u27df    ");
        this.println("27E0:\u27e0    27E1:\u27e1    27E2:\u27e2    27E3:\u27e3    27E4:\u27e4    27E5:\u27e5    27E6:\u27e6    27E7:\u27e7    27E8:\u27e8    27E9:\u27e9    27EA:\u27ea    27EB:\u27eb    27EC:\u27ec    27ED:\u27ed    27EE:\u27ee    27EF:\u27ef    ");
        this.println("27F0:\u27f0    27F1:\u27f1    27F2:\u27f2    27F3:\u27f3    27F4:\u27f4    27F5:\u27f5    27F6:\u27f6    27F7:\u27f7    27F8:\u27f8    27F9:\u27f9    27FA:\u27fa    27FB:\u27fb    27FC:\u27fc    27FD:\u27fd    27FE:\u27fe    27FF:\u27ff    ");
        this.println("2800:\u2800    2801:\u2801    2802:\u2802    2803:\u2803    2804:\u2804    2805:\u2805    2806:\u2806    2807:\u2807    2808:\u2808    2809:\u2809    280A:\u280a    280B:\u280b    280C:\u280c    280D:\u280d    280E:\u280e    280F:\u280f    ");
        this.println("2810:\u2810    2811:\u2811    2812:\u2812    2813:\u2813    2814:\u2814    2815:\u2815    2816:\u2816    2817:\u2817    2818:\u2818    2819:\u2819    281A:\u281a    281B:\u281b    281C:\u281c    281D:\u281d    281E:\u281e    281F:\u281f    ");
        this.println("2820:\u2820    2821:\u2821    2822:\u2822    2823:\u2823    2824:\u2824    2825:\u2825    2826:\u2826    2827:\u2827    2828:\u2828    2829:\u2829    282A:\u282a    282B:\u282b    282C:\u282c    282D:\u282d    282E:\u282e    282F:\u282f    ");
        this.println("2830:\u2830    2831:\u2831    2832:\u2832    2833:\u2833    2834:\u2834    2835:\u2835    2836:\u2836    2837:\u2837    2838:\u2838    2839:\u2839    283A:\u283a    283B:\u283b    283C:\u283c    283D:\u283d    283E:\u283e    283F:\u283f    ");
        this.println("2840:\u2840    2841:\u2841    2842:\u2842    2843:\u2843    2844:\u2844    2845:\u2845    2846:\u2846    2847:\u2847    2848:\u2848    2849:\u2849    284A:\u284a    284B:\u284b    284C:\u284c    284D:\u284d    284E:\u284e    284F:\u284f    ");
        this.println("2850:\u2850    2851:\u2851    2852:\u2852    2853:\u2853    2854:\u2854    2855:\u2855    2856:\u2856    2857:\u2857    2858:\u2858    2859:\u2859    285A:\u285a    285B:\u285b    285C:\u285c    285D:\u285d    285E:\u285e    285F:\u285f    ");
        this.println("2860:\u2860    2861:\u2861    2862:\u2862    2863:\u2863    2864:\u2864    2865:\u2865    2866:\u2866    2867:\u2867    2868:\u2868    2869:\u2869    286A:\u286a    286B:\u286b    286C:\u286c    286D:\u286d    286E:\u286e    286F:\u286f    ");
        this.println("2870:\u2870    2871:\u2871    2872:\u2872    2873:\u2873    2874:\u2874    2875:\u2875    2876:\u2876    2877:\u2877    2878:\u2878    2879:\u2879    287A:\u287a    287B:\u287b    287C:\u287c    287D:\u287d    287E:\u287e    287F:\u287f    ");
        this.println("2880:\u2880    2881:\u2881    2882:\u2882    2883:\u2883    2884:\u2884    2885:\u2885    2886:\u2886    2887:\u2887    2888:\u2888    2889:\u2889    288A:\u288a    288B:\u288b    288C:\u288c    288D:\u288d    288E:\u288e    288F:\u288f    ");
        this.println("2890:\u2890    2891:\u2891    2892:\u2892    2893:\u2893    2894:\u2894    2895:\u2895    2896:\u2896    2897:\u2897    2898:\u2898    2899:\u2899    289A:\u289a    289B:\u289b    289C:\u289c    289D:\u289d    289E:\u289e    289F:\u289f    ");
        this.println("28A0:\u28a0    28A1:\u28a1    28A2:\u28a2    28A3:\u28a3    28A4:\u28a4    28A5:\u28a5    28A6:\u28a6    28A7:\u28a7    28A8:\u28a8    28A9:\u28a9    28AA:\u28aa    28AB:\u28ab    28AC:\u28ac    28AD:\u28ad    28AE:\u28ae    28AF:\u28af    ");
        this.println("28B0:\u28b0    28B1:\u28b1    28B2:\u28b2    28B3:\u28b3    28B4:\u28b4    28B5:\u28b5    28B6:\u28b6    28B7:\u28b7    28B8:\u28b8    28B9:\u28b9    28BA:\u28ba    28BB:\u28bb    28BC:\u28bc    28BD:\u28bd    28BE:\u28be    28BF:\u28bf    ");
        this.println("28C0:\u28c0    28C1:\u28c1    28C2:\u28c2    28C3:\u28c3    28C4:\u28c4    28C5:\u28c5    28C6:\u28c6    28C7:\u28c7    28C8:\u28c8    28C9:\u28c9    28CA:\u28ca    28CB:\u28cb    28CC:\u28cc    28CD:\u28cd    28CE:\u28ce    28CF:\u28cf    ");
        this.println("28D0:\u28d0    28D1:\u28d1    28D2:\u28d2    28D3:\u28d3    28D4:\u28d4    28D5:\u28d5    28D6:\u28d6    28D7:\u28d7    28D8:\u28d8    28D9:\u28d9    28DA:\u28da    28DB:\u28db    28DC:\u28dc    28DD:\u28dd    28DE:\u28de    28DF:\u28df    ");
        this.println("28E0:\u28e0    28E1:\u28e1    28E2:\u28e2    28E3:\u28e3    28E4:\u28e4    28E5:\u28e5    28E6:\u28e6    28E7:\u28e7    28E8:\u28e8    28E9:\u28e9    28EA:\u28ea    28EB:\u28eb    28EC:\u28ec    28ED:\u28ed    28EE:\u28ee    28EF:\u28ef    ");
        this.println("28F0:\u28f0    28F1:\u28f1    28F2:\u28f2    28F3:\u28f3    28F4:\u28f4    28F5:\u28f5    28F6:\u28f6    28F7:\u28f7    28F8:\u28f8    28F9:\u28f9    28FA:\u28fa    28FB:\u28fb    28FC:\u28fc    28FD:\u28fd    28FE:\u28fe    28FF:\u28ff    ");
        this.println("2900:\u2900    2901:\u2901    2902:\u2902    2903:\u2903    2904:\u2904    2905:\u2905    2906:\u2906    2907:\u2907    2908:\u2908    2909:\u2909    290A:\u290a    290B:\u290b    290C:\u290c    290D:\u290d    290E:\u290e    290F:\u290f    ");
        this.println("2910:\u2910    2911:\u2911    2912:\u2912    2913:\u2913    2914:\u2914    2915:\u2915    2916:\u2916    2917:\u2917    2918:\u2918    2919:\u2919    291A:\u291a    291B:\u291b    291C:\u291c    291D:\u291d    291E:\u291e    291F:\u291f    ");
        this.println("2920:\u2920    2921:\u2921    2922:\u2922    2923:\u2923    2924:\u2924    2925:\u2925    2926:\u2926    2927:\u2927    2928:\u2928    2929:\u2929    292A:\u292a    292B:\u292b    292C:\u292c    292D:\u292d    292E:\u292e    292F:\u292f    ");
        this.println("2930:\u2930    2931:\u2931    2932:\u2932    2933:\u2933    2934:\u2934    2935:\u2935    2936:\u2936    2937:\u2937    2938:\u2938    2939:\u2939    293A:\u293a    293B:\u293b    293C:\u293c    293D:\u293d    293E:\u293e    293F:\u293f    ");
        this.println("2940:\u2940    2941:\u2941    2942:\u2942    2943:\u2943    2944:\u2944    2945:\u2945    2946:\u2946    2947:\u2947    2948:\u2948    2949:\u2949    294A:\u294a    294B:\u294b    294C:\u294c    294D:\u294d    294E:\u294e    294F:\u294f    ");
        this.println("2950:\u2950    2951:\u2951    2952:\u2952    2953:\u2953    2954:\u2954    2955:\u2955    2956:\u2956    2957:\u2957    2958:\u2958    2959:\u2959    295A:\u295a    295B:\u295b    295C:\u295c    295D:\u295d    295E:\u295e    295F:\u295f    ");
        this.println("2960:\u2960    2961:\u2961    2962:\u2962    2963:\u2963    2964:\u2964    2965:\u2965    2966:\u2966    2967:\u2967    2968:\u2968    2969:\u2969    296A:\u296a    296B:\u296b    296C:\u296c    296D:\u296d    296E:\u296e    296F:\u296f    ");
        this.println("2970:\u2970    2971:\u2971    2972:\u2972    2973:\u2973    2974:\u2974    2975:\u2975    2976:\u2976    2977:\u2977    2978:\u2978    2979:\u2979    297A:\u297a    297B:\u297b    297C:\u297c    297D:\u297d    297E:\u297e    297F:\u297f    ");
        this.println("2980:\u2980    2981:\u2981    2982:\u2982    2983:\u2983    2984:\u2984    2985:\u2985    2986:\u2986    2987:\u2987    2988:\u2988    2989:\u2989    298A:\u298a    298B:\u298b    298C:\u298c    298D:\u298d    298E:\u298e    298F:\u298f    ");
        this.println("2990:\u2990    2991:\u2991    2992:\u2992    2993:\u2993    2994:\u2994    2995:\u2995    2996:\u2996    2997:\u2997    2998:\u2998    2999:\u2999    299A:\u299a    299B:\u299b    299C:\u299c    299D:\u299d    299E:\u299e    299F:\u299f    ");
        this.println("29A0:\u29a0    29A1:\u29a1    29A2:\u29a2    29A3:\u29a3    29A4:\u29a4    29A5:\u29a5    29A6:\u29a6    29A7:\u29a7    29A8:\u29a8    29A9:\u29a9    29AA:\u29aa    29AB:\u29ab    29AC:\u29ac    29AD:\u29ad    29AE:\u29ae    29AF:\u29af    ");
        this.println("29B0:\u29b0    29B1:\u29b1    29B2:\u29b2    29B3:\u29b3    29B4:\u29b4    29B5:\u29b5    29B6:\u29b6    29B7:\u29b7    29B8:\u29b8    29B9:\u29b9    29BA:\u29ba    29BB:\u29bb    29BC:\u29bc    29BD:\u29bd    29BE:\u29be    29BF:\u29bf    ");
        this.println("29C0:\u29c0    29C1:\u29c1    29C2:\u29c2    29C3:\u29c3    29C4:\u29c4    29C5:\u29c5    29C6:\u29c6    29C7:\u29c7    29C8:\u29c8    29C9:\u29c9    29CA:\u29ca    29CB:\u29cb    29CC:\u29cc    29CD:\u29cd    29CE:\u29ce    29CF:\u29cf    ");
        this.println("29D0:\u29d0    29D1:\u29d1    29D2:\u29d2    29D3:\u29d3    29D4:\u29d4    29D5:\u29d5    29D6:\u29d6    29D7:\u29d7    29D8:\u29d8    29D9:\u29d9    29DA:\u29da    29DB:\u29db    29DC:\u29dc    29DD:\u29dd    29DE:\u29de    29DF:\u29df    ");
        this.println("29E0:\u29e0    29E1:\u29e1    29E2:\u29e2    29E3:\u29e3    29E4:\u29e4    29E5:\u29e5    29E6:\u29e6    29E7:\u29e7    29E8:\u29e8    29E9:\u29e9    29EA:\u29ea    29EB:\u29eb    29EC:\u29ec    29ED:\u29ed    29EE:\u29ee    29EF:\u29ef    ");
        this.println("29F0:\u29f0    29F1:\u29f1    29F2:\u29f2    29F3:\u29f3    29F4:\u29f4    29F5:\u29f5    29F6:\u29f6    29F7:\u29f7    29F8:\u29f8    29F9:\u29f9    29FA:\u29fa    29FB:\u29fb    29FC:\u29fc    29FD:\u29fd    29FE:\u29fe    29FF:\u29ff    ");
        this.println("2A00:\u2a00    2A01:\u2a01    2A02:\u2a02    2A03:\u2a03    2A04:\u2a04    2A05:\u2a05    2A06:\u2a06    2A07:\u2a07    2A08:\u2a08    2A09:\u2a09    2A0A:\u2a0a    2A0B:\u2a0b    2A0C:\u2a0c    2A0D:\u2a0d    2A0E:\u2a0e    2A0F:\u2a0f    ");
        this.println("2A10:\u2a10    2A11:\u2a11    2A12:\u2a12    2A13:\u2a13    2A14:\u2a14    2A15:\u2a15    2A16:\u2a16    2A17:\u2a17    2A18:\u2a18    2A19:\u2a19    2A1A:\u2a1a    2A1B:\u2a1b    2A1C:\u2a1c    2A1D:\u2a1d    2A1E:\u2a1e    2A1F:\u2a1f    ");
        this.println("2A20:\u2a20    2A21:\u2a21    2A22:\u2a22    2A23:\u2a23    2A24:\u2a24    2A25:\u2a25    2A26:\u2a26    2A27:\u2a27    2A28:\u2a28    2A29:\u2a29    2A2A:\u2a2a    2A2B:\u2a2b    2A2C:\u2a2c    2A2D:\u2a2d    2A2E:\u2a2e    2A2F:\u2a2f    ");
        this.println("2A30:\u2a30    2A31:\u2a31    2A32:\u2a32    2A33:\u2a33    2A34:\u2a34    2A35:\u2a35    2A36:\u2a36    2A37:\u2a37    2A38:\u2a38    2A39:\u2a39    2A3A:\u2a3a    2A3B:\u2a3b    2A3C:\u2a3c    2A3D:\u2a3d    2A3E:\u2a3e    2A3F:\u2a3f    ");
        this.println("2A40:\u2a40    2A41:\u2a41    2A42:\u2a42    2A43:\u2a43    2A44:\u2a44    2A45:\u2a45    2A46:\u2a46    2A47:\u2a47    2A48:\u2a48    2A49:\u2a49    2A4A:\u2a4a    2A4B:\u2a4b    2A4C:\u2a4c    2A4D:\u2a4d    2A4E:\u2a4e    2A4F:\u2a4f    ");
        this.println("2A50:\u2a50    2A51:\u2a51    2A52:\u2a52    2A53:\u2a53    2A54:\u2a54    2A55:\u2a55    2A56:\u2a56    2A57:\u2a57    2A58:\u2a58    2A59:\u2a59    2A5A:\u2a5a    2A5B:\u2a5b    2A5C:\u2a5c    2A5D:\u2a5d    2A5E:\u2a5e    2A5F:\u2a5f    ");
        this.println("2A60:\u2a60    2A61:\u2a61    2A62:\u2a62    2A63:\u2a63    2A64:\u2a64    2A65:\u2a65    2A66:\u2a66    2A67:\u2a67    2A68:\u2a68    2A69:\u2a69    2A6A:\u2a6a    2A6B:\u2a6b    2A6C:\u2a6c    2A6D:\u2a6d    2A6E:\u2a6e    2A6F:\u2a6f    ");
        this.println("2A70:\u2a70    2A71:\u2a71    2A72:\u2a72    2A73:\u2a73    2A74:\u2a74    2A75:\u2a75    2A76:\u2a76    2A77:\u2a77    2A78:\u2a78    2A79:\u2a79    2A7A:\u2a7a    2A7B:\u2a7b    2A7C:\u2a7c    2A7D:\u2a7d    2A7E:\u2a7e    2A7F:\u2a7f    ");
        this.println("2A80:\u2a80    2A81:\u2a81    2A82:\u2a82    2A83:\u2a83    2A84:\u2a84    2A85:\u2a85    2A86:\u2a86    2A87:\u2a87    2A88:\u2a88    2A89:\u2a89    2A8A:\u2a8a    2A8B:\u2a8b    2A8C:\u2a8c    2A8D:\u2a8d    2A8E:\u2a8e    2A8F:\u2a8f    ");
        this.println("2A90:\u2a90    2A91:\u2a91    2A92:\u2a92    2A93:\u2a93    2A94:\u2a94    2A95:\u2a95    2A96:\u2a96    2A97:\u2a97    2A98:\u2a98    2A99:\u2a99    2A9A:\u2a9a    2A9B:\u2a9b    2A9C:\u2a9c    2A9D:\u2a9d    2A9E:\u2a9e    2A9F:\u2a9f    ");
        this.println("2AA0:\u2aa0    2AA1:\u2aa1    2AA2:\u2aa2    2AA3:\u2aa3    2AA4:\u2aa4    2AA5:\u2aa5    2AA6:\u2aa6    2AA7:\u2aa7    2AA8:\u2aa8    2AA9:\u2aa9    2AAA:\u2aaa    2AAB:\u2aab    2AAC:\u2aac    2AAD:\u2aad    2AAE:\u2aae    2AAF:\u2aaf    ");
        this.println("2AB0:\u2ab0    2AB1:\u2ab1    2AB2:\u2ab2    2AB3:\u2ab3    2AB4:\u2ab4    2AB5:\u2ab5    2AB6:\u2ab6    2AB7:\u2ab7    2AB8:\u2ab8    2AB9:\u2ab9    2ABA:\u2aba    2ABB:\u2abb    2ABC:\u2abc    2ABD:\u2abd    2ABE:\u2abe    2ABF:\u2abf    ");
        this.println("2AC0:\u2ac0    2AC1:\u2ac1    2AC2:\u2ac2    2AC3:\u2ac3    2AC4:\u2ac4    2AC5:\u2ac5    2AC6:\u2ac6    2AC7:\u2ac7    2AC8:\u2ac8    2AC9:\u2ac9    2ACA:\u2aca    2ACB:\u2acb    2ACC:\u2acc    2ACD:\u2acd    2ACE:\u2ace    2ACF:\u2acf    ");
        this.println("2AD0:\u2ad0    2AD1:\u2ad1    2AD2:\u2ad2    2AD3:\u2ad3    2AD4:\u2ad4    2AD5:\u2ad5    2AD6:\u2ad6    2AD7:\u2ad7    2AD8:\u2ad8    2AD9:\u2ad9    2ADA:\u2ada    2ADB:\u2adb    2ADC:\u2adc    2ADD:\u2add    2ADE:\u2ade    2ADF:\u2adf    ");
        this.println("2AE0:\u2ae0    2AE1:\u2ae1    2AE2:\u2ae2    2AE3:\u2ae3    2AE4:\u2ae4    2AE5:\u2ae5    2AE6:\u2ae6    2AE7:\u2ae7    2AE8:\u2ae8    2AE9:\u2ae9    2AEA:\u2aea    2AEB:\u2aeb    2AEC:\u2aec    2AED:\u2aed    2AEE:\u2aee    2AEF:\u2aef    ");
        this.println("2AF0:\u2af0    2AF1:\u2af1    2AF2:\u2af2    2AF3:\u2af3    2AF4:\u2af4    2AF5:\u2af5    2AF6:\u2af6    2AF7:\u2af7    2AF8:\u2af8    2AF9:\u2af9    2AFA:\u2afa    2AFB:\u2afb    2AFC:\u2afc    2AFD:\u2afd    2AFE:\u2afe    2AFF:\u2aff    ");
        this.println("2B00:\u2b00    2B01:\u2b01    2B02:\u2b02    2B03:\u2b03    2B04:\u2b04    2B05:\u2b05    2B06:\u2b06    2B07:\u2b07    2B08:\u2b08    2B09:\u2b09    2B0A:\u2b0a    2B0B:\u2b0b    2B0C:\u2b0c    2B0D:\u2b0d    2B0E:\u2b0e    2B0F:\u2b0f    ");
        this.println("2B10:\u2b10    2B11:\u2b11    2B12:\u2b12    2B13:\u2b13    2B14:\u2b14    2B15:\u2b15    2B16:\u2b16    2B17:\u2b17    2B18:\u2b18    2B19:\u2b19    2B1A:\u2b1a    2B1B:\u2b1b    2B1C:\u2b1c    2B1D:\u2b1d    2B1E:\u2b1e    2B1F:\u2b1f    ");
        this.println("2B20:\u2b20    2B21:\u2b21    2B22:\u2b22    2B23:\u2b23    2B24:\u2b24    2B25:\u2b25    2B26:\u2b26    2B27:\u2b27    2B28:\u2b28    2B29:\u2b29    2B2A:\u2b2a    2B2B:\u2b2b    2B2C:\u2b2c    2B2D:\u2b2d    2B2E:\u2b2e    2B2F:\u2b2f    ");
        this.println("2B30:\u2b30    2B31:\u2b31    2B32:\u2b32    2B33:\u2b33    2B34:\u2b34    2B35:\u2b35    2B36:\u2b36    2B37:\u2b37    2B38:\u2b38    2B39:\u2b39    2B3A:\u2b3a    2B3B:\u2b3b    2B3C:\u2b3c    2B3D:\u2b3d    2B3E:\u2b3e    2B3F:\u2b3f    ");
        this.println("2B40:\u2b40    2B41:\u2b41    2B42:\u2b42    2B43:\u2b43    2B44:\u2b44    2B45:\u2b45    2B46:\u2b46    2B47:\u2b47    2B48:\u2b48    2B49:\u2b49    2B4A:\u2b4a    2B4B:\u2b4b    2B4C:\u2b4c    2B4D:\u2b4d    2B4E:\u2b4e    2B4F:\u2b4f    ");
        this.println("2B50:\u2b50    2B51:\u2b51    2B52:\u2b52    2B53:\u2b53    2B54:\u2b54    2B55:\u2b55    2B56:\u2b56    2B57:\u2b57    2B58:\u2b58    2B59:\u2b59    2B5A:\u2b5a    2B5B:\u2b5b    2B5C:\u2b5c    2B5D:\u2b5d    2B5E:\u2b5e    2B5F:\u2b5f    ");
        this.println("2B60:\u2b60    2B61:\u2b61    2B62:\u2b62    2B63:\u2b63    2B64:\u2b64    2B65:\u2b65    2B66:\u2b66    2B67:\u2b67    2B68:\u2b68    2B69:\u2b69    2B6A:\u2b6a    2B6B:\u2b6b    2B6C:\u2b6c    2B6D:\u2b6d    2B6E:\u2b6e    2B6F:\u2b6f    ");
        this.println("2B70:\u2b70    2B71:\u2b71    2B72:\u2b72    2B73:\u2b73    2B74:\u2b74    2B75:\u2b75    2B76:\u2b76    2B77:\u2b77    2B78:\u2b78    2B79:\u2b79    2B7A:\u2b7a    2B7B:\u2b7b    2B7C:\u2b7c    2B7D:\u2b7d    2B7E:\u2b7e    2B7F:\u2b7f    ");
        this.println("2B80:\u2b80    2B81:\u2b81    2B82:\u2b82    2B83:\u2b83    2B84:\u2b84    2B85:\u2b85    2B86:\u2b86    2B87:\u2b87    2B88:\u2b88    2B89:\u2b89    2B8A:\u2b8a    2B8B:\u2b8b    2B8C:\u2b8c    2B8D:\u2b8d    2B8E:\u2b8e    2B8F:\u2b8f    ");
        this.println("2B90:\u2b90    2B91:\u2b91    2B92:\u2b92    2B93:\u2b93    2B94:\u2b94    2B95:\u2b95    2B96:\u2b96    2B97:\u2b97    2B98:\u2b98    2B99:\u2b99    2B9A:\u2b9a    2B9B:\u2b9b    2B9C:\u2b9c    2B9D:\u2b9d    2B9E:\u2b9e    2B9F:\u2b9f    ");
        this.println("2BA0:\u2ba0    2BA1:\u2ba1    2BA2:\u2ba2    2BA3:\u2ba3    2BA4:\u2ba4    2BA5:\u2ba5    2BA6:\u2ba6    2BA7:\u2ba7    2BA8:\u2ba8    2BA9:\u2ba9    2BAA:\u2baa    2BAB:\u2bab    2BAC:\u2bac    2BAD:\u2bad    2BAE:\u2bae    2BAF:\u2baf    ");
        this.println("2BB0:\u2bb0    2BB1:\u2bb1    2BB2:\u2bb2    2BB3:\u2bb3    2BB4:\u2bb4    2BB5:\u2bb5    2BB6:\u2bb6    2BB7:\u2bb7    2BB8:\u2bb8    2BB9:\u2bb9    2BBA:\u2bba    2BBB:\u2bbb    2BBC:\u2bbc    2BBD:\u2bbd    2BBE:\u2bbe    2BBF:\u2bbf    ");
        this.println("2BC0:\u2bc0    2BC1:\u2bc1    2BC2:\u2bc2    2BC3:\u2bc3    2BC4:\u2bc4    2BC5:\u2bc5    2BC6:\u2bc6    2BC7:\u2bc7    2BC8:\u2bc8    2BC9:\u2bc9    2BCA:\u2bca    2BCB:\u2bcb    2BCC:\u2bcc    2BCD:\u2bcd    2BCE:\u2bce    2BCF:\u2bcf    ");
        this.println("2BD0:\u2bd0    2BD1:\u2bd1    2BD2:\u2bd2    2BD3:\u2bd3    2BD4:\u2bd4    2BD5:\u2bd5    2BD6:\u2bd6    2BD7:\u2bd7    2BD8:\u2bd8    2BD9:\u2bd9    2BDA:\u2bda    2BDB:\u2bdb    2BDC:\u2bdc    2BDD:\u2bdd    2BDE:\u2bde    2BDF:\u2bdf    ");
        this.println("2BE0:\u2be0    2BE1:\u2be1    2BE2:\u2be2    2BE3:\u2be3    2BE4:\u2be4    2BE5:\u2be5    2BE6:\u2be6    2BE7:\u2be7    2BE8:\u2be8    2BE9:\u2be9    2BEA:\u2bea    2BEB:\u2beb    2BEC:\u2bec    2BED:\u2bed    2BEE:\u2bee    2BEF:\u2bef    ");
        this.println("2BF0:\u2bf0    2BF1:\u2bf1    2BF2:\u2bf2    2BF3:\u2bf3    2BF4:\u2bf4    2BF5:\u2bf5    2BF6:\u2bf6    2BF7:\u2bf7    2BF8:\u2bf8    2BF9:\u2bf9    2BFA:\u2bfa    2BFB:\u2bfb    2BFC:\u2bfc    2BFD:\u2bfd    2BFE:\u2bfe    2BFF:\u2bff    ");
    }

    public VoxWorld getWorld() {
        return this.world;
    }

    private int getDifficultyID(String d) {
        int j;
        if (d.equals("-- Easy --") || d.equals("-- " + Translator.getString("Easy") + " --")) {
            return 1;
        }
        if (d.equals("-- Medium --") || d.equals("-- " + Translator.getString("Medium") + " --")) {
            return 2;
        }
        if (d.equals("-- Hard --") || d.equals("-- " + Translator.getString("Hard") + " --")) {
            return 3;
        }
        String[] bots = Vox.getBotsEasy();
        for (j = 0; j < bots.length; ++j) {
            if (!bots[j].equals(d)) continue;
            return 1;
        }
        bots = Vox.getBotsMedium();
        for (j = 0; j < bots.length; ++j) {
            if (!bots[j].equals(d)) continue;
            return 2;
        }
        bots = Vox.getBotsHard();
        for (j = 0; j < bots.length; ++j) {
            if (!bots[j].equals(d)) continue;
            return 3;
        }
        SS.debug("Couldn't match difficulty to ID: " + d);
        return 1;
    }

    public void recruitButtonAction() {
        if (this.controlsAnyone()) {
            if (this.visuals.getCastleCountry() == null && this.world.getPlayerMoney(this.playerID) < 80) {
                invalidSound.play();
                this.showNotice("You must conquer a Castle, or save up to build one", new Point(600, this.ops.height + 40), 5000L);
            } else {
                this.visuals.toggleRecruitPanel();
            }
        }
    }

    public void AIChat(int playerID, String chat) {
    }

    public void showMessage(String message) {
        if (!fullscreen) {
            SSOptionPane.showMessageDialog(this.window, message, null, 1);
        } else {
            this.showNotice(message, new Point(this.visuals.displayWidth / 2, 100), 5000L);
        }
    }
}

