/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.jidesoft.utils.Lm;
import com.sillysoft.lux.gui.EnterCodeWindow;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.DirectoryTool;
import com.sillysoft.tools.FileTool;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.LogFile;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.URLTool;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.VoxGUI;
import com.sillysoft.vox.VoxServer;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.UIManager;

public class Vox {
    public static final String releaseDate = "February 25th, 2011";
    public static final float voxVersion = 1.2f;
    public static final float networkVersion = 0.9f;
    public static boolean superfast = false;
    public static boolean headless = false;
    public static int timeParam;
    public static String mapParam;
    public static String nameParam;
    public static String descParam;
    public static String localServerAddress;
    public static int localServerPort;
    public boolean sharewareVersion;
    protected static Vox sharedVox;
    protected Vector allAgents;
    protected Vector easyAgents;
    protected Vector mediumAgents;
    protected Vector hardAgents;
    protected Vector moreAgents;
    private static Preferences statsPrefs;

    public static void main(String[] args) {
        System.setProperty("apple.awt.showGrowBox", "false");
        Prefs.setPackageClassAndNode(Vox.class, "Preferences");
        URLTool.setUserAgent("Castle Vox v 1.2 (" + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ")");
        DesktopTool.initDesktopTool("Vox", "vox.icns", headless);
        GraphicsTool.initGraphicsTool(DesktopTool.supportFolderPath(), DesktopTool.modernResourcesLocation());
        LogFile.copySystemOutputToFile(DesktopTool.supportFolderPath() + "log.txt");
        SSApp.setup("Castle Vox", "Vox");
        System.out.println("Castle Vox version 1.2 starting under user " + System.getProperty("user.name"));
        System.out.println("  -> OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        System.out.println("  -> VM: " + System.getProperty("java.version") + " / " + System.getProperty("java.class.version"));
        System.out.println("  -> support: " + DesktopTool.supportFolderPath());
        System.out.println("  -> bundle: " + DesktopTool.bundleResourcesLocation());
        System.out.println("  -> modern: " + DesktopTool.modernResourcesLocation());
        new File(DesktopTool.supportFolderPath() + "Agents").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Maps").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Mods").mkdirs();
        new File(DesktopTool.supportFolderPath() + "Themes").mkdirs();
        Translator.loadBundle("VoxBundle");
        if (SS.isMacintosh) {
            Vox.copyInitialSupportFiles();
        }
        for (int i = 0; i < args.length; ++i) {
            int equalPos;
            if ("-headless".equals(args[i])) {
                headless = true;
                System.out.println(" ---- HEADLESS MODE: ");
                System.out.println(" ---- Vox is starting up in headless server mode. No GUI elements will appear.");
                continue;
            }
            if (args[i].startsWith("-time")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 3) {
                    System.out.println("Improper time given. Examples: -time=45 -time=5m -time=24h -time=0 (for no limit)");
                    continue;
                }
                if (args[i].endsWith("h")) {
                    float hours = -1.0f;
                    int seconds = -1;
                    try {
                        hours = Float.parseFloat(args[i].substring(equalPos + 1, args[i].length() - 1));
                    }
                    catch (Exception e) {
                        System.out.println("Improper time given. Examples: -time=45 -time=5m -time=24h -time=0 (for no limit)");
                    }
                    if (hours == 0.0f) {
                        Prefs.putBoolean("turnTimer", false);
                    } else {
                        seconds = (int)(hours * 3600.0f);
                        seconds = Math.max(seconds, 15);
                        Prefs.putInt("turnTimerSeconds", seconds);
                        Prefs.putBoolean("turnTimer", true);
                    }
                    timeParam = seconds;
                    continue;
                }
                if (args[i].endsWith("m")) {
                    float minutes = -1.0f;
                    int seconds = -1;
                    try {
                        minutes = Float.parseFloat(args[i].substring(equalPos + 1, args[i].length() - 1));
                    }
                    catch (Exception e) {
                        System.out.println("Improper time given. Examples: -time=45 -time=5m -time=24h -time=0 (for no limit)");
                    }
                    if (minutes == 0.0f) {
                        Prefs.putBoolean("turnTimer", false);
                    } else {
                        seconds = (int)(minutes * 60.0f);
                        seconds = Math.max(seconds, 15);
                        Prefs.putInt("turnTimerSeconds", seconds);
                        Prefs.putBoolean("turnTimer", true);
                    }
                    timeParam = seconds;
                    continue;
                }
                int seconds = -1;
                try {
                    seconds = Integer.parseInt(args[i].substring(equalPos + 1));
                }
                catch (Exception e) {
                    System.out.println("Improper time given. Examples: -time=45 -time=5m -time=24h -time=0 (for no limit)");
                }
                if (seconds == 0) {
                    Prefs.putBoolean("turnTimer", false);
                } else {
                    seconds = Math.max(seconds, 15);
                    Prefs.putInt("turnTimerSeconds", seconds);
                    Prefs.putBoolean("turnTimer", true);
                }
                timeParam = seconds;
                continue;
            }
            if (args[i].startsWith("-map=")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper map given. Examples: -map=Classic -map=AlphaHex");
                    continue;
                }
                String desiredMap = args[i].substring(equalPos + 1);
                System.out.println("Desired map = " + desiredMap);
                ArrayList mapList = new ArrayList();
                PluginManager.buildMapListFromFolder(new File(DesktopTool.supportFolderPath() + "Maps"), "", mapList);
                for (int j = 0; j < mapList.size() && desiredMap != null; ++j) {
                    String map = (String)mapList.get(j);
                    if (!StringTool.stripSpaces(map).equals(desiredMap)) continue;
                    mapParam = map;
                    Prefs.put("mapSelector", map);
                    System.out.println("Set the map to be " + map);
                    desiredMap = null;
                }
                if (desiredMap == null) continue;
                System.out.println("Map not found. You must strip all spaces from the name. Examples: -map=ClassicRisk -map=ToThePowerOfHex");
                continue;
            }
            if (args[i].startsWith("-public")) {
                if (args[i].endsWith("true")) {
                    Prefs.putBoolean("internetPublic", true);
                    continue;
                }
                Prefs.putBoolean("internetPublic", false);
                continue;
            }
            if (args[i].startsWith("-name")) {
                String name;
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper name given. Examples: -name=dustin -name=Dustin_Headless_Host");
                    continue;
                }
                nameParam = name = StringTool.underscoreToSpace(args[i].substring(equalPos + 1));
                continue;
            }
            if (args[i].startsWith("-desc")) {
                equalPos = args[i].indexOf(61);
                if (equalPos < 2) {
                    System.out.println("Improper description given. Examples: -desc=Come_play_with_me! -name=Restart_for_humans._Bots_first.");
                    continue;
                }
                descParam = StringTool.underscoreToSpace(args[i].substring(equalPos + 1));
                Prefs.put("lastDescription", StringTool.underscoreToSpace(args[i].substring(equalPos + 1)));
                continue;
            }
            System.out.println("Vox unknown argument = " + args[i]);
        }
        if (headless) {
            VoxServer server = new VoxServer(mapParam, "", "-- " + Translator.getString("Random") + " --", true, ++localServerPort, nameParam);
            server.listenOnTerminal();
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            SSFrame.setDefaultIcon("logo32.gif");
            sharedVox = new VoxGUI();
            try {
                Lm.verifyLicense((String)"Sillysoft Games", (String)"Castle Vox", (String)"BKRtfMgQS6kdJovi8:57RK2J.W:KKiK");
            }
            catch (Throwable t) {
                SS.debug("JIDE Charts failed to load error !");
            }
        }
    }

    private static void copyInitialSupportFiles() {
        if (!Prefs.getBoolean("savedBoardCopied1.2", false)) {
            Prefs.putBoolean("savedBoardCopied1.2", true);
            try {
                String savedBoardDir = DesktopTool.supportFolderPath() + "Maps";
                File bundleBoardDir = new File(DesktopTool.modernResourcesLocation() + "Maps");
                File[] theBoards = bundleBoardDir.listFiles();
                for (int i = 0; i < theBoards.length; ++i) {
                    if (new File(savedBoardDir + File.separator + theBoards[i].getName()).exists()) {
                        new File(savedBoardDir + File.separator + theBoards[i].getName()).delete();
                    }
                    FileTool.copyFile(theBoards[i].getPath(), savedBoardDir + File.separator + theBoards[i].getName());
                }
            }
            catch (Throwable t) {
                SS.debug("Lux -> error copying over initial boards: " + t);
            }
            try {
                FileTool.copyFolder(DesktopTool.modernResourcesLocation() + "Themes", DesktopTool.supportFolderPath() + "Themes");
                FileTool.copyFolder(DesktopTool.modernResourcesLocation() + "Cache" + File.separator + "Images", DesktopTool.supportFolderPath() + "Cache" + File.separator + "Images");
            }
            catch (Throwable t) {
                SS.debug("Lux -> error copying over initial themes: " + t);
                t.printStackTrace();
            }
        }
    }

    public boolean isDemo() {
        return this.sharewareVersion;
    }

    public int getSharewareCount() {
        return Vox.getStatsPrefs().getInt("gamesPlayed", 0);
    }

    public void fillMapSelector(String selectedMap) {
    }

    public void registerCodeOnline(final String name, final String code) {
        if (code == null || code.equals("")) {
            this.registerCodeResult(false, name, code);
            return;
        }
        new Thread("Register-code-thread"){

            public void run() {
                try {
                    EnterCodeWindow.instance.setSpinner(true);
                    String request = "http://sillysoft.net/vox/codeCheck.php?code=" + code;
                    String contents = URLTool.getURL(request);
                    String result = XMLTool.extract("result", contents);
                    Vox.this.registerCodeResult("pass".equals(result), name, code);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Vox.this.registerCodeResult(false, name, code);
                }
            }
        }.start();
    }

    private void registerCodeResult(boolean result, String name, String code) {
        EnterCodeWindow.show(VoxGUI.getInstance());
        EnterCodeWindow.instance.setSpinner(false);
        if (result) {
            SSOptionPane.showMessageDialog(EnterCodeWindow.instance.theFrame, Translator.getString("ValidationSuccessMessage"), Translator.getString("ValidationSuccess"), 1);
            EnterCodeWindow.hide();
            this.sharewareVersion = false;
            Prefs.put("regCode", code);
            Prefs.put("regName", name);
            Prefs.sync();
            VoxGUI.getInstance().setRegistration();
            try {
                SS.debug("REGISTER: clearing out the plugin cache");
                PluginManager.deleteCache();
            }
            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        SSOptionPane.showMessageDialog(EnterCodeWindow.instance.theFrame, Translator.getString("ValidationErrorMessage"), Translator.getString("ValidationError"), 0);
    }

    public boolean registerCode(String name, String code) {
        if ("".equals(name.trim())) {
            name = "you";
        }
        name = name.trim();
        code = code.trim();
        this.registerCodeOnline(name, code);
        return true;
    }

    public void terminate() {
        SS.debug("Vox is now exiting. Thanks for playing.");
        Prefs.sync();
        System.exit(0);
    }

    public static Object[] getBots() {
        String[] possibleAgents = DirectoryTool.listFilesWithSuffix(DesktopTool.supportFolderPath() + "Agents", ".class");
        if (possibleAgents.length > 0) {
            String[] builtin = Vox.getBuiltinBots();
            Object[] toreturn = new Object[builtin.length + possibleAgents.length];
            System.arraycopy(builtin, 0, toreturn, 0, builtin.length);
            System.arraycopy(possibleAgents, 0, toreturn, builtin.length, possibleAgents.length);
            return toreturn;
        }
        return Vox.getBuiltinBots();
    }

    public static String[] getBuiltinBots() {
        return new String[]{"Angry", "Bubbles", "Quirky", "Earl", "Grabby", "Holdem", "Hawk", "Kodos", "Polymath"};
    }

    public static String[] getBotsEasy() {
        return new String[]{"Angry", "Bubbles", "Quirky"};
    }

    public static String[] getBotsMedium() {
        return new String[]{"Earl", "Grabby", "Holdem"};
    }

    public static String[] getBotsHard() {
        return new String[]{"Hawk", "Kodos", "Polymath"};
    }

    public static Preferences getStatsPrefs() {
        if (statsPrefs == null) {
            statsPrefs = Preferences.userNodeForPackage(Vox.class).node("Stats");
        }
        return statsPrefs;
    }

    static {
        localServerPort = 3318;
    }
}

