/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.lux.gui.Tickable;
import com.sillysoft.lux.gui.Ticker;
import com.sillysoft.lux.plugin.PluginManager;
import com.sillysoft.tools.DesktopTool;
import com.sillysoft.tools.EventThread;
import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.AnimationLoaderVox;
import com.sillysoft.vox.Continent;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.PlayerInfoController;
import com.sillysoft.vox.RecruitPanel;
import com.sillysoft.vox.StatsHistory;
import com.sillysoft.vox.StatsHistoryChart;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxWorld;
import com.sillysoft.vox.command.BuildCommand;
import com.sillysoft.vox.command.Command;
import com.sillysoft.widgets.MultiLineToolTip;
import com.sillysoft.widgets.VisualsNotice;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class Visuals
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
Tickable {
    private BufferedImage mapBackground;
    private Image background;
    private Image foreground;
    private Image overground;
    private boolean customForeground;
    private int scrollingState = 0;
    private static Image[][] explosionFramesArrays;
    private static int[] animationFrameNumber;
    private static Dimension[] animationFrameSize;
    private Point[] animationPoint;
    private int[] animationFrameCount;
    private int[] animationNumber;
    private Object dirtyRectLock = new Object();
    private Rectangle dirtyRect = null;
    private boolean drawInfoPanel;
    protected PlayerInfoController infoPanel;
    private JComponent infoPanelView;
    private Color linesColor;
    private String gameOverText;
    public int displayWidth;
    public int displayHeight;
    private Color[] contColors;
    private Color contBorderColor;
    private Rectangle[] contBounds;
    private String[] contName;
    private Point[] contLabelLocation;
    protected List lines;
    protected List aboveLines;
    protected String loadText = "loading";
    protected String currentTheme;
    private String desiredTheme;
    private boolean bonusMode;
    protected boolean hideBonusLabels = false;
    protected boolean showBonusLabels = false;
    protected boolean hideArmies = false;
    private static List viewList;
    private List notices;
    protected boolean buyPanelIsVisable = false;
    RecruitPanel buyPanel;
    protected static final Cursor cursorEmpty;
    protected static final Cursor cursorSelect;
    protected static final Cursor cursorOverUnit;
    static Font arial24;
    static Font arial32;
    static Font loadingFont;
    static Font sansSerif12;
    static Font sansSerifBold12;
    private StatsHistoryChart chart;
    private VoxWorld world;
    private List countries;
    private UnitStack activeUnitStack;
    private Country activeUnitStackCountry;
    private boolean shiftPressed = false;
    private boolean altPressed = false;
    private boolean controlPressed = false;
    private boolean metaPressed = false;
    private boolean undoTriggerPressed = false;
    private boolean almostAllTrigger = false;
    VoxClient control;
    private Point lastMousePressedAt;
    private Point lastMouseMovedAt;
    private Random rand = new Random();
    Country lastCountryClicked = null;
    int sameCountryClickCount = 0;
    UnitStack excitedUnits;
    Country countryUnderMouse;
    StringBuffer keyPressedBuffer = new StringBuffer();
    private int placingKey = 0;
    private int divisionTotalOriginal = 0;
    private int usedPlacedDividerKeyCount = 0;
    private boolean usedPlacedDividerKey = false;
    private boolean usedZeroAttack = false;
    private UnitStackGroup placingUnits;
    private boolean activeStackIsBought = false;
    protected boolean active = false;
    float flashCountryAlpha;
    boolean flashCountryAlphaDescending;

    public Visuals(VoxClient control) {
        this.control = control;
        this.setLayout(null);
        this.countries = new Vector();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setBackground(Color.WHITE);
        this.init();
    }

    public void init() {
        this.setLoadText("loading game resources");
        if (animationFrameNumber == null) {
            AnimationLoaderVox.blockTillLoaded();
            animationFrameNumber = AnimationLoaderVox.getFrameCounts();
            animationFrameSize = AnimationLoaderVox.getFrameDimensions();
            explosionFramesArrays = AnimationLoaderVox.getFrameImages();
            AnimationLoaderVox.tidy();
            this.setLoadText("loading resources");
        }
        viewList.add(this);
    }

    void setEngine(VoxWorld world) {
        this.world = world;
        world.visualWorld = true;
        this.countries = world.getCountries();
        this.gameOverText = null;
        if (this.chart != null) {
            this.remove(this.chart);
            this.chart = null;
        }
        this.repaint();
        this.setToolTipText("tooltip");
        ToolTipManager.sharedInstance().setInitialDelay(200);
    }

    void setTheme(String theme) {
        if (!theme.equals(this.desiredTheme) && this.desiredTheme != null) {
            this.mapBackground = null;
            this.background = null;
            this.foreground = null;
            this.overground = null;
        }
        this.desiredTheme = theme;
    }

    void setMapSize(int width, int height) {
        this.displayWidth = width;
        this.displayHeight = height;
    }

    void setCountries(List newCountryList) {
        this.countries = newCountryList;
        if (!this.desiredTheme.equals(this.currentTheme)) {
            this.loadTheme(this.desiredTheme);
        }
        this.setLoadText(null);
    }

    public void paintComponent(Graphics g1) {
        try {
            Country c;
            int i;
            Country c2;
            int i2;
            boolean drawLandingNotice = false;
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setColor(Color.BLACK);
            g.fill(g.getClipBounds());
            if (this.loadText != null) {
                try {
                    g.setColor(new Color(100, 116, 235));
                    g.setFont(loadingFont);
                    g.drawString(this.loadText, this.getWidth() / 3, Math.min(this.getHeight() / 2, 400));
                    return;
                }
                catch (Exception e) {
                    System.out.println("Vox -> quick change of loadText caught");
                }
            }
            g.drawImage(this.mapBackground, 0, 0, this.displayWidth, this.displayHeight, null);
            boolean[] redrawMemory = new boolean[this.countries.size()];
            for (i2 = 0; i2 < this.countries.size(); ++i2) {
                c2 = (Country)this.countries.get(i2);
                redrawMemory[i2] = g.hitClip(c2.getBounds().x - 50, c2.getBounds().y - 50, c2.getBounds().width + 100, c2.getBounds().height + 100);
            }
            for (i2 = 0; i2 < this.countries.size(); ++i2) {
                if (!redrawMemory[i2]) continue;
                c2 = (Country)this.countries.get(i2);
                if (this.bonusMode) {
                    g.setColor(GraphicsTool.transparent(this.control.getContinent(c2.getContinentID()).getColor(), 0.71f));
                } else {
                    g.setColor(GraphicsTool.transparent(c2.getOwner().getColor(), 0.71f));
                }
                g.fill(c2.getShape());
                if (!c2.flashing) continue;
                g.setColor(GraphicsTool.transparent(Color.RED, 0.75f * this.flashCountryAlpha));
                g.fill(c2.getShape());
            }
            GraphicsTool.drawLines(g, this.aboveLines, this.linesColor);
            if (this.showBonusLabels && !this.hideBonusLabels) {
                for (i2 = 0; i2 < this.countries.size(); ++i2) {
                    if (!redrawMemory[i2]) continue;
                    c2 = (Country)this.countries.get(i2);
                    this.drawCountryBonusLabels(g, c2, 0.2f);
                }
                g.setFont(sansSerifBold12);
            }
            this.drawOverground(g);
            Font baseFont = g.getFont();
            for (i = 0; i < this.countries.size(); ++i) {
                if (!redrawMemory[i]) continue;
                c = (Country)this.countries.get(i);
                c.drawCastles(g, this.currentTheme);
            }
            if (!this.bonusMode) {
                this.drawCommands(g);
            }
            g.setColor(Color.BLACK);
            g.setFont(sansSerifBold12);
            for (i = 0; i < this.countries.size(); ++i) {
                if (!redrawMemory[i]) continue;
                c = (Country)this.countries.get(i);
                if (this.gameOverText != null) continue;
                if (this.bonusMode) {
                    if (this.hideBonusLabels) continue;
                    this.drawCountryBonusLabels(g, c, 0.6f);
                    continue;
                }
                if (this.hideArmies) continue;
                if (this.activeUnitStackCountry != null && this.activeUnitStackCountry.equals(this.countries.get(i))) {
                    c.drawMovingUnitsExcept(g, this.activeUnitStack, this.currentTheme);
                    continue;
                }
                c.drawMovingUnits(g, this.currentTheme);
            }
            if (this.gameOverText == null && !this.bonusMode && !this.hideArmies) {
                for (i = 0; i < this.countries.size(); ++i) {
                    if (!redrawMemory[i]) continue;
                    c = (Country)this.countries.get(i);
                    if (this.activeUnitStackCountry != null && this.activeUnitStackCountry.equals(this.countries.get(i))) {
                        c.drawUnitBubblesExcept(g, this.activeUnitStack, this.currentTheme);
                        continue;
                    }
                    c.drawUnitBubbles(g, this.currentTheme);
                }
            }
            if (this.gameOverText != null) {
                this.drawNotices(g);
                g.setColor(GraphicsTool.transparent(Color.DARK_GRAY, 0.35f));
                g.fill(g.getClipBounds());
                if (SS.isMacintosh) {
                    g.setFont(arial32);
                } else {
                    g.setFont(GraphicsTool.getDejaFontSized(32));
                }
                Color borderColor = this.control.getLargestPlayer().getColor();
                int centerY = 200;
                if (this.gameOverText.length() > 150) {
                    centerY = 300;
                }
                GraphicsTool.drawBoxedString(g, this.gameOverText, this.displayWidth / 2, centerY, 20, borderColor, 4);
                this.drawExplosions(g);
                return;
            }
            if (this.bonusMode && !this.hideBonusLabels) {
                this.drawContinentBonusLabels(g);
            }
            this.drawNotices(g);
            if (this.activeUnitStack != null && this.lastMouseMovedAt != null && !this.undoTriggerPressed && !this.bonusMode) {
                if (this.countryUnderMouse != null) {
                    Point arrowStartPoint = this.activeUnitStack.getDrawPoint();
                    Point arrowEndPoint = this.countryUnderMouse.getCenter();
                    boolean drawArrow = true;
                    if (this.countryUnderMouse.equals(this.activeUnitStackCountry)) {
                        drawArrow = false;
                    }
                    if (this.activeStackIsBought) {
                        drawArrow = false;
                    }
                    if (drawArrow) {
                        if (this.activeStackIsBought) {
                            if (this.countryUnderMouse.canBuildUnits(this.activeUnitStack)) {
                                g.setColor(Color.BLACK);
                            } else {
                                g.setColor(Color.GRAY);
                            }
                        } else if (this.world.unitCanReach(this.activeUnitStack, this.activeUnitStackCountry, this.countryUnderMouse)) {
                            if (this.activeUnitStack.getTeam().equals(this.countryUnderMouse.getTeam())) {
                                g.setColor(new Color(12, 86, 2));
                            } else {
                                g.setColor(new Color(215, 0, 47));
                            }
                        } else {
                            g.setColor(Color.GRAY);
                        }
                        GraphicsTool.drawThickArrow(g, arrowStartPoint.x + this.activeUnitStack.getWidth() / 2, arrowStartPoint.y + this.activeUnitStack.getHeight() / 2, arrowEndPoint.x, arrowEndPoint.y);
                    }
                }
                this.activeUnitStack.drawCenteredAtWithBubble(g, this.lastMouseMovedAt, this.currentTheme);
                String unitModString = null;
                if (this.undoTriggerPressed) {
                    g.setColor(Color.BLACK);
                    g.drawString("UNDO", this.lastMouseMovedAt.x - this.activeUnitStack.getWidth() / 2, this.lastMouseMovedAt.y - (this.activeUnitStack.getHeight() / 2 + 3));
                } else if (drawLandingNotice) {
                    g.setColor(Color.BLACK);
                    g.drawString("landing", this.lastMouseMovedAt.x - this.activeUnitStack.getWidth() / 2, this.lastMouseMovedAt.y - (this.activeUnitStack.getHeight() / 2 + 3));
                } else if (this.shiftPressed) {
                    g.setColor(Color.RED);
                    unitModString = "x" + this.activeUnitStack.getCount();
                } else if (this.altPressed && (this.controlPressed || this.metaPressed)) {
                    g.setColor(Color.RED);
                    unitModString = "x" + Math.min(50, this.activeUnitStack.getCount());
                } else if (this.altPressed) {
                    g.setColor(Color.RED);
                    unitModString = "x" + Math.min(10, this.activeUnitStack.getCount());
                } else if (this.controlPressed || this.metaPressed) {
                    g.setColor(Color.RED);
                    unitModString = "x" + Math.min(5, this.activeUnitStack.getCount());
                } else if (this.almostAllTrigger) {
                    g.setColor(Color.RED);
                    unitModString = "x" + Math.max(0, this.activeUnitStack.getCount() - 1);
                } else if (this.placingKey > 0) {
                    g.setColor(Color.RED);
                    int toPlace = Math.min(Math.round((float)this.divisionTotalOriginal / (float)this.placingKey), this.activeUnitStack.getCount());
                    if (this.usedPlacedDividerKeyCount + 1 >= this.placingKey && this.activeUnitStack.getCount() - toPlace < this.placingKey) {
                        toPlace = this.activeUnitStack.getCount();
                    }
                    unitModString = "x" + toPlace;
                }
                if (unitModString != null) {
                    g.drawString(unitModString, this.lastMouseMovedAt.x + 20, this.lastMouseMovedAt.y + 14);
                }
            } else if (this.undoTriggerPressed) {
                g.setColor(Color.BLACK);
                g.drawString("UNDO", this.lastMouseMovedAt.x - 10, this.lastMouseMovedAt.y - 8);
            }
            this.drawExplosions(g);
        }
        catch (Throwable t) {
            System.out.println("Visuals.paint caught an exception: " + t);
        }
    }

    private void drawCountryBonusLabels(Graphics2D g, Country c, float standOut) {
        if (c.getBonus() != 0) {
            g.setFont(GraphicsTool.getSymbolFontForBonus(g, Math.abs(c.getBonus())));
            Color contrastingBase = GraphicsTool.getContrastingBase(c.getOwner().getColor());
            Color contrastingBaseOpposite = contrastingBase == Color.BLACK ? Color.WHITE : Color.BLACK;
            int x = c.getCenter().x;
            int y = c.getCenter().y;
            if (c.getLabelLocation() != null) {
                x = c.getLabelLocation().x;
                y = this.displayHeight - c.getLabelLocation().y;
            }
            GraphicsTool.drawBoxedString(g, c.getBonus() + " " + c.getTeam().getSymbol(), x, y, 4, 2, GraphicsTool.transparent(contrastingBaseOpposite, standOut), c.getOwner().getColor(), 2, contrastingBase);
        }
    }

    private void drawContinentBonusLabels(Graphics2D g) {
        if (SS.isWindows) {
            g.setFont(GraphicsTool.getSymbolFontForBonus(g, 6));
        } else {
            g.setFont(arial24);
        }
        for (int c = 0; c < this.control.getNumberOfContinents(); ++c) {
            Color contrastingBase;
            Continent cont = this.control.getContinent(c);
            if (cont.getBonus() == 0) continue;
            String contTitle = cont.getName() + (cont.getName().endsWith("!") ? " " : ": ") + cont.getBonus();
            Team ownerTeam = cont.getTeamOwner(this.countries);
            if (ownerTeam != null) {
                contTitle = contTitle + " " + ownerTeam.getSymbol();
            }
            Color contrastingBaseOpposite = (contrastingBase = GraphicsTool.getContrastingBase(cont.getColor())) == Color.BLACK ? Color.WHITE : Color.BLACK;
            int y = this.displayHeight - cont.getLabelLocation().y;
            GraphicsTool.drawBoxedString(g, contTitle, cont.getLabelLocation().x, y, 10, 2, GraphicsTool.transparent(contrastingBaseOpposite, 0.6f), cont.getColor(), 2, contrastingBase);
        }
        g.setFont(sansSerifBold12);
    }

    private void drawCommands(Graphics2D g) {
        if (this.control != null) {
            Command c;
            int i;
            List commands = this.control.getCommandsToDraw();
            g.setStroke(new BasicStroke(1.0f, 1, 1));
            for (i = 0; i < commands.size(); ++i) {
                c = (Command)commands.get(i);
                c.drawArrow(g, this.world, this.currentTheme, this.active);
            }
            for (i = 0; i < commands.size(); ++i) {
                c = (Command)commands.get(i);
                c.drawUnits(g, this.world, this.currentTheme);
            }
        }
    }

    public void mousePressed(MouseEvent e) {
        if (!this.active) {
            return;
        }
        this.lastMousePressedAt = e.getPoint();
        if (this.bonusMode) {
            this.control.toggleBonusView();
        }
        if (this.undoTriggerPressed || this.activeUnitStack == null && (e.isPopupTrigger() || e.getButton() == 3)) {
            if (this.world != null) {
                List commands = this.control.getCommandsToDraw();
                for (int i = 0; i < commands.size(); ++i) {
                    Command com = (Command)commands.get(i);
                    if (!com.containsPoint(this.lastMousePressedAt)) continue;
                    this.world.undoCommand(com);
                    VoxClient.undoSound.play();
                    if (com instanceof BuildCommand) {
                        this.updateMoney();
                    }
                    this.repaint();
                    this.control.commandUndone();
                    return;
                }
            }
            return;
        }
        Country c = this.getCountryAtPoint(this.lastMousePressedAt);
        if (c == null) {
            c = this.getCountryAtPoint(this.lastMousePressedAt, true);
        }
        if (c != null) {
            boolean moreLeft;
            if (this.activeUnitStack == null) {
                this.lastMouseMovedAt = this.lastMousePressedAt;
                this.selectExcitedUnits();
                this.sameCountryClickCount = 0;
            } else if (this.activeStackIsBought) {
                moreLeft = this.world.placeUnits(this.activeUnitStack, c, this.getNumberOfUnits(this.activeUnitStack.getCount(), e));
                VoxClient.clickSound.play();
                if (!moreLeft) {
                    this.clearActiveUnitStack();
                }
                this.updateMoney();
                this.control.commandAdded();
            } else if (this.activeUnitStackCountry.equals(c) && !this.world.airAttackInProgress()) {
                this.switchSelectedUnit(c, this.lastMousePressedAt);
            } else {
                moreLeft = this.world.moveUnit(this.activeUnitStack, this.activeUnitStackCountry, c, this.getNumberOfUnits(this.activeUnitStack.getCount(), e));
                if (!moreLeft || this.almostAllTrigger) {
                    this.clearActiveUnitStack();
                }
                this.control.commandAdded();
            }
        } else {
            this.lastMouseMovedAt = this.lastMousePressedAt;
            this.selectExcitedUnits();
            this.sameCountryClickCount = 0;
        }
        if (this.lastCountryClicked == c) {
            ++this.sameCountryClickCount;
            if (this.sameCountryClickCount > 12 || this.sameCountryClickCount > 3 && this.control.ops.mapTitle.startsWith("Tutorial")) {
                Point p = c.getCenter();
                if (this.control.ops.mapTitle.startsWith("Tutorial")) {
                    if (this.control.controlsID(1)) {
                        p = new Point(340, 160);
                    } else if (this.control.controlsID(2)) {
                        p = new Point(p.x - 30, p.y + 4);
                    } else if (this.control.controlsID(3)) {
                        p = new Point(p.x + 38, p.y + 20);
                    }
                }
                this.showNotice("TIP: " + (SS.isMacintosh ? "Right-click or shift-click" : "Right-click") + " to order all units at once", p);
            } else if (this.sameCountryClickCount > 7) {
                this.showNotice("TIP: Control-click to order 5 units at a time", c.getCenter());
            }
        } else {
            this.sameCountryClickCount = 1;
        }
        this.repaint();
        this.lastCountryClicked = c;
    }

    public int getNumberOfUnits(int totalUnits, MouseEvent e) {
        boolean shift = e.isShiftDown() || e.getButton() == 2 || e.getButton() == 3;
        boolean control = e.isControlDown();
        boolean alt = e.isAltDown();
        boolean meta = e.isMetaDown();
        if (this.placingKey > 0 && this.divisionTotalOriginal > 0) {
            this.usedPlacedDividerKey = true;
            ++this.usedPlacedDividerKeyCount;
            int selectedArmies = Math.min(Math.round((float)this.divisionTotalOriginal / (float)this.placingKey), totalUnits);
            if (this.usedPlacedDividerKeyCount >= this.placingKey && totalUnits - selectedArmies < this.placingKey) {
                selectedArmies = totalUnits;
            }
            return selectedArmies;
        }
        this.usedPlacedDividerKey = false;
        this.usedPlacedDividerKeyCount = 0;
        int numberOfUnits = 1;
        if (shift) {
            numberOfUnits = totalUnits;
        } else if (alt && (control || meta)) {
            numberOfUnits = Math.min(50, totalUnits);
        } else if (alt) {
            numberOfUnits = Math.min(10, totalUnits);
        } else if (control || meta) {
            numberOfUnits = Math.min(5, totalUnits);
        } else if (this.almostAllTrigger) {
            numberOfUnits = totalUnits - 1;
            this.usedZeroAttack = true;
        }
        return numberOfUnits;
    }

    private Country getCountryAtPoint(Point p) {
        return this.getCountryAtPoint(p, false);
    }

    private Country getCountryAtPoint(Point p, boolean generous) {
        if (generous) {
            for (int i = 0; i < this.countries.size(); ++i) {
                Country c = (Country)this.countries.get(i);
                if (!c.getBounds().contains(p)) continue;
                return c;
            }
        } else {
            for (int i = 0; i < this.countries.size(); ++i) {
                Country c = (Country)this.countries.get(i);
                if (!c.contains(p)) continue;
                return c;
            }
        }
        return null;
    }

    private UnitStack getSelectableUnitStackAt(Point p) {
        if (this.world.airAttackInProgress()) {
            return null;
        }
        if (!this.control.controlsAnyone()) {
            return null;
        }
        UnitStack bestMatch = null;
        int bestMatchValue = 1000000;
        for (int j = 0; j < this.countries.size(); ++j) {
            Country c = (Country)this.countries.get(j);
            Rectangle cb = c.getBounds();
            int extraTestSize = 25;
            Rectangle testRect = new Rectangle(cb.x - extraTestSize, cb.y - extraTestSize, cb.width + extraTestSize + extraTestSize, cb.height + extraTestSize + extraTestSize);
            if (!testRect.contains(p)) continue;
            UnitStackGroup units = c.getUnitStackGroup();
            for (int i = 0; i < units.size(); ++i) {
                int distance;
                UnitStack u = units.get(i);
                Point up = u.getDrawPoint();
                if (!new Rectangle(up, u.getDimension()).contains(p) || (distance = Math.abs(p.x - u.getWidth() / 2 - up.x) + Math.abs(p.y - u.getHeight() / 2 - up.y)) >= bestMatchValue || !this.control.controlsID(u.getOwner().getID())) continue;
                bestMatch = u;
                bestMatchValue = distance;
            }
        }
        return bestMatch;
    }

    private void selectExcitedUnits() {
        if (this.world.airAttackInProgress()) {
            return;
        }
        if (this.excitedUnits != null) {
            UnitStack clickedOn = this.excitedUnits;
            int origCountryID = clickedOn.getOriginalCountryID();
            Country c = this.world.countryWithID(origCountryID);
            if (!clickedOn.equals(this.activeUnitStack)) {
                if (clickedOn.getUnit().isCastle() && this.control.controlsID(clickedOn.getOwner().getID())) {
                    VoxClient.clickSound.play();
                    this.toggleRecruitPanel(c);
                    return;
                }
                if (clickedOn.getUnit().getMovement() > 0 && this.control.controlsID(clickedOn.getOwner().getID())) {
                    VoxClient.clickSound.play();
                    this.activeUnitStack = clickedOn;
                    this.setCursor(cursorEmpty);
                    if (c == null) {
                        SS.debug("c == null in selectUnitStatckAt. uh oh");
                    }
                    this.activeUnitStackCountry = c;
                    return;
                }
            }
        }
    }

    private void switchSelectedUnit(Country c, Point p) {
        UnitStack clickedOn = c.getUnitStackAtPoint(p, this.control.getPlayer(this.control.getGuiOwner()));
        if (clickedOn != null && !clickedOn.equals(this.activeUnitStack)) {
            if (clickedOn.getUnit().getMovement() > 0 && this.control.controlsID(clickedOn.getOwner().getID())) {
                VoxClient.clickSound.play();
                if (this.excitedUnits != null) {
                    this.excitedUnits.setExcited(false);
                }
                this.activeUnitStack = clickedOn;
                this.setCursor(cursorEmpty);
                SS.debug("visuals selected a unit group 2", 1);
                c.pushToBack(this.activeUnitStack);
                this.activeUnitStackCountry = c;
                this.lastMouseMovedAt = p;
            } else {
                this.clearActiveUnitStack();
            }
        } else {
            this.clearActiveUnitStack();
        }
    }

    private void clearActiveUnitStack() {
        this.activeUnitStack = null;
        this.activeStackIsBought = false;
        this.sameCountryClickCount = 0;
        if (this.excitedUnits != null) {
            this.excitedUnits.setExcited(false);
            this.excitedUnits = null;
        }
        this.setCursor(cursorSelect);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this.activeUnitStack != null) {
            this.setCursor(cursorEmpty);
        } else {
            this.setCursor(cursorSelect);
        }
        this.scrollingState = 0;
    }

    public void mouseExited(MouseEvent e) {
        SS.debug("mouse left visuals: " + e, 1);
        this.setCursor(null);
        Rectangle areaRect = this.lastMouseMovedAt == null ? null : new Rectangle(this.lastMouseMovedAt.x - 50, this.lastMouseMovedAt.y - 50, 100, 100);
        this.lastMouseMovedAt = null;
        if (Prefs.getBoolean("autoScroll2", false)) {
            Point exitPoint = SwingUtilities.convertPoint(this, e.getPoint(), this.getParent());
            if (exitPoint.getY() <= 0.0) {
                this.scrollingState = 1;
            } else if (exitPoint.getY() > (double)this.getParent().getHeight()) {
                this.scrollingState = 2;
            } else if (exitPoint.getX() <= 0.0) {
                this.scrollingState = 3;
            } else if (exitPoint.getX() > (double)this.getParent().getWidth()) {
                this.scrollingState = 4;
            }
        }
        if (areaRect != null) {
            this.repaint(areaRect);
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    public void mouseMoved(MouseEvent e) {
        if (!this.active || this.bonusMode) {
            return;
        }
        this.lastMouseMovedAt = e.getPoint();
        this.countryUnderMouse = this.getCountryAtPoint(this.lastMouseMovedAt);
        if (this.countryUnderMouse == null) {
            this.countryUnderMouse = this.getCountryAtPoint(this.lastMouseMovedAt, true);
        }
        if (!this.undoTriggerPressed) {
            if (this.activeUnitStack == null) {
                UnitStack over = this.getSelectableUnitStackAt(this.lastMouseMovedAt);
                if (over != this.excitedUnits) {
                    if (over != null) {
                        this.setCursor(cursorOverUnit);
                        if (this.excitedUnits != null) {
                            this.excitedUnits.setExcited(false);
                            if (this.excitedUnits.getUnit().isCastle()) {
                                this.excitedUnits.getOriginalCountry(this.world).pushToFront(this.excitedUnits);
                            }
                            this.repaint(this.excitedUnits.getBounds());
                        }
                        this.excitedUnits = over;
                        over.setExcited(true);
                        if (this.countryUnderMouse == null) {
                            this.countryUnderMouse = over.getOriginalCountry(this.world);
                        }
                        this.countryUnderMouse.pushToBack(over);
                        this.repaint(over.getBounds());
                    } else if (this.excitedUnits != null) {
                        this.excitedUnits.setExcited(false);
                        if (this.excitedUnits.getUnit().isCastle()) {
                            this.excitedUnits.getOriginalCountry(this.world).pushToFront(this.excitedUnits);
                        }
                        this.setCursor(cursorSelect);
                        this.repaint(this.excitedUnits.getBounds());
                        this.excitedUnits = null;
                    }
                }
            } else {
                Rectangle unitRect = new Rectangle(this.lastMouseMovedAt.x - 50, this.lastMouseMovedAt.y - 50, 100, 100);
                if (this.activeUnitStack.getDrawPoint() != null) {
                    unitRect = unitRect.union(new Rectangle(this.activeUnitStack.getDrawPoint().x - 50, this.activeUnitStack.getDrawPoint().y - 50, 100, 100));
                }
                this.repaint(unitRect);
            }
        }
        if (Prefs.getBoolean("autoScroll2", false) && SwingUtilities.convertPoint(this, this.lastMouseMovedAt, this.getParent()).getX() < 2.0) {
            this.scrollingState = 3;
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public void keyPressed(KeyEvent e) {
        String stringTyped;
        if (e.getKeyCode() == 49) {
            this.setPlacingKey(1);
        } else if (e.getKeyCode() == 50) {
            this.setPlacingKey(2);
        } else if (e.getKeyCode() == 51) {
            this.setPlacingKey(3);
        } else if (e.getKeyCode() == 52) {
            this.setPlacingKey(4);
        } else if (e.getKeyCode() == 53) {
            this.setPlacingKey(5);
        } else if (e.getKeyCode() == 54) {
            this.setPlacingKey(6);
        } else if (e.getKeyCode() == 55) {
            this.setPlacingKey(7);
        } else if (e.getKeyCode() == 56) {
            this.setPlacingKey(8);
        } else if (e.getKeyCode() == 57) {
            this.setPlacingKey(9);
        }
        if (e.getKeyCode() == 90) {
            this.almostAllTrigger = true;
            this.repaint();
        }
        this.cacheModKeys(e);
        this.keyPressedBuffer.append(e.getKeyChar());
        if (this.keyPressedBuffer.length() > 15) {
            this.keyPressedBuffer.deleteCharAt(0);
        }
        if ((stringTyped = this.keyPressedBuffer.toString().toLowerCase()).endsWith("nolab")) {
            this.hideBonusLabels = !this.hideBonusLabels;
            this.repaint();
        }
        if (stringTyped.endsWith("yeslab")) {
            this.showBonusLabels = !this.showBonusLabels;
            this.repaint();
        }
        if (stringTyped.endsWith("noarm")) {
            this.hideArmies = !this.hideArmies;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
        if (this.placingKey > 0) {
            this.setPlacingKey(0);
        }
        if (e.getKeyCode() == 90) {
            this.almostAllTrigger = false;
            this.repaint();
        }
        if (e.getKeyCode() == 27) {
            this.escapeKeyPressed();
        }
        this.cacheModKeys(e);
    }

    public void escapeKeyPressed() {
        SS.debug("Escape pressed", 1);
        if (this.activeUnitStack != null) {
            this.clearActiveUnitStack();
            this.repaint();
            return;
        }
        if (VoxClient.fullscreen) {
            this.control.goFullscreen();
        }
    }

    public void setPlacingKey(int divisionFactor) {
        if (this.placingKey == divisionFactor) {
            return;
        }
        this.placingKey = divisionFactor;
        if (this.placingKey > 0 && this.activeUnitStack != null) {
            if (this.placingKey == 99) {
                this.almostAllTrigger = true;
            } else {
                this.almostAllTrigger = false;
                this.divisionTotalOriginal = this.activeUnitStack.getCount();
                this.usedPlacedDividerKeyCount = 0;
            }
        } else {
            this.almostAllTrigger = false;
            this.divisionTotalOriginal = 0;
            this.usedPlacedDividerKeyCount = 0;
        }
        SS.debug("Visuals.setPlacingKey(" + divisionFactor + "), divisionTotalOriginal=" + this.divisionTotalOriginal, 1);
        this.repaint();
    }

    public boolean usedPlacedDividerKey() {
        boolean wasValue = this.usedPlacedDividerKey;
        this.usedPlacedDividerKey = false;
        return wasValue;
    }

    public boolean usedZeroAttack() {
        boolean wasValue = this.usedZeroAttack;
        this.usedZeroAttack = false;
        return wasValue;
    }

    protected void cacheModKeys(KeyEvent e) {
        boolean oldShiftPressed = this.shiftPressed;
        boolean oldAltPressed = this.altPressed;
        boolean oldMetaPressed = this.metaPressed;
        boolean oldControlPressed = this.controlPressed;
        this.shiftPressed = e.isShiftDown();
        this.altPressed = e.isAltDown();
        this.metaPressed = e.isMetaDown();
        this.controlPressed = e.isControlDown();
        if (this.shiftPressed != oldShiftPressed || this.altPressed != oldAltPressed || this.metaPressed != oldMetaPressed || this.controlPressed != oldControlPressed) {
            this.repaint();
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        boolean oldShiftPressed = this.shiftPressed;
        boolean oldAltPressed = this.altPressed;
        boolean oldMetaPressed = this.metaPressed;
        boolean oldControlPressed = this.controlPressed;
        this.shiftPressed = false;
        this.altPressed = false;
        this.metaPressed = false;
        this.controlPressed = false;
        this.almostAllTrigger = false;
        if (this.shiftPressed != oldShiftPressed || this.altPressed != oldAltPressed || this.metaPressed != oldMetaPressed || this.controlPressed != oldControlPressed) {
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public String toString() {
        return "<Visuals>";
    }

    public void endOfRound() {
        this.clearActiveUnitStack();
        if (this.infoPanel != null) {
            this.infoPanel.fireTableDataChanged();
        }
    }

    public void placeUnits(UnitStackGroup placingUnits) {
        this.placingUnits = placingUnits;
    }

    private boolean thereAreUnitsToPlace() {
        return this.placingUnits != null && this.placingUnits.size() > 0;
    }

    public boolean isOpaque() {
        return true;
    }

    public void doneBuying() {
        if (this.buyPanel != null) {
            this.buyPanel.clearActiveUnitPanel();
            this.remove(this.buyPanel);
        }
        if (this.activeStackIsBought) {
            this.clearActiveUnitStack();
        }
        this.repaint();
        this.buyPanelIsVisable = false;
    }

    public void setPlacerUnits(UnitStack placer) {
        this.activeUnitStack = placer;
        this.activeStackIsBought = true;
        this.sameCountryClickCount = 0;
        this.repaint();
    }

    public void setActive(boolean newState) {
        this.active = newState;
    }

    public JToolTip createToolTip() {
        MultiLineToolTip tip = new MultiLineToolTip();
        tip.setComponent(this);
        return tip;
    }

    public String getToolTipText(MouseEvent event) {
        Country c = this.getCountryAtPoint(event.getPoint());
        if (c != null) {
            int cont = c.getContinentID();
            Continent continent = this.control.getContinent(cont);
            return ("".equals(c.getName()) ? "territory" : c.getName()) + (c.getBonus() != 0 ? " " + Translator.getString("bonus") + ": " + c.getBonus() : "") + (continent.getBonus() != 0 ? "\n" + (this.control.getContinentSize(continent) > 1 ? "1/" + this.control.getContinentSize(continent) + " " + Translator.getString("oftooltip") + " " : "") + continent.getName() + " " + "" + Translator.getString("bonus") + ": " + continent.getBonus() : "");
        }
        return null;
    }

    public void setLoadText(String text) {
        this.loadText = text;
        if (text == null) {
            Ticker.keepMeTicking(this);
        }
        this.repaint();
    }

    private BufferedImage createBackgroundImage(Graphics2D screenG) {
        int borderWidth;
        BufferedImage image;
        boolean setLoadText;
        boolean bl = setLoadText = screenG == null;
        if (screenG == null) {
            if (this.control == null) {
                return null;
            }
            if (setLoadText) {
                this.setLoadText("creating image buffer");
            }
            if (this.control == null || this.displayWidth < 1 || this.displayHeight < 1) {
                return null;
            }
            image = GraphicsTool.createBufferedImage(this.displayWidth, this.displayHeight, 3);
        } else {
            GraphicsConfiguration gc = screenG.getDeviceConfiguration();
            image = gc.createCompatibleImage(this.displayWidth, this.displayHeight, 3);
        }
        Graphics2D backG = image.createGraphics();
        backG.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (setLoadText) {
            this.setLoadText("rendering background");
        }
        if (this.background != null) {
            backG.drawImage(this.background, 0, 0, this.displayWidth, this.displayHeight, this);
        }
        if (setLoadText) {
            this.setLoadText("rendering foreground");
        }
        this.drawForeground2(backG);
        if (this.mapBackground != null) {
            this.background = null;
            this.foreground = null;
        }
        if (setLoadText) {
            this.setLoadText("rendering lines");
        }
        GraphicsTool.drawLines(backG, this.lines, this.linesColor);
        if (setLoadText) {
            this.setLoadText("rendering shapes");
        }
        if ((borderWidth = this.control.ops.borderWidth) > 0) {
            Country c;
            int i;
            this.contBorderColor = GraphicsTool.transparent(Color.cyan, 0.44f);
            backG.setColor(this.contBorderColor);
            backG.setColor(Color.BLACK);
            backG.setStroke(new BasicStroke(borderWidth, 1, 1));
            for (i = 0; i < this.countries.size(); ++i) {
                c = (Country)this.countries.get(i);
                backG.draw(c.getShape());
            }
            backG.setStroke(new BasicStroke(borderWidth, 1, 1));
            for (i = 0; i < this.countries.size(); ++i) {
                c = (Country)this.countries.get(i);
                backG.setColor(this.control.getContinentColor(c.getContinentID()));
                backG.draw(c.getShape());
            }
        }
        backG.dispose();
        return image;
    }

    private void drawForeground2(Graphics2D g) {
        if (this.foreground == null) {
            SS.debug("Vox Visuals: drawForeground2 called with foreground == null!", 1);
            return;
        }
        Shape oldClip = g.getClip();
        g.setClip(null);
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (c.isWater()) continue;
            g.setClip(c.getShape());
            g.drawImage(this.foreground, 0, 0, this.displayWidth, this.displayHeight, null);
        }
        g.setClip(oldClip);
    }

    public void loadTheme(String named) {
        SS.debug("loadTheme: " + named, 1);
        boolean changed = false;
        try {
            if (named == null) {
                named = Prefs.get("theme", "Black");
            }
            if (this.currentTheme != null && !named.equals(this.currentTheme)) {
                changed = true;
            }
            this.currentTheme = named;
            this.background = null;
            this.foreground = null;
            this.overground = null;
            this.linesColor = Color.WHITE;
            boolean foundTheme = false;
            String[] themeLocations = new String[]{DesktopTool.supportFolderPath() + "Themes" + File.separator + named};
            for (int l = 0; l < themeLocations.length; ++l) {
                try {
                    File themeDir = new File(themeLocations[l]);
                    if (themeDir == null || !themeDir.isDirectory()) continue;
                    foundTheme = true;
                    File[] themeFiles = themeDir.listFiles();
                    for (int i = 0; i < themeFiles.length; ++i) {
                        String lowerName = themeFiles[i].getName().toLowerCase();
                        if (themeFiles[i].getName().equalsIgnoreCase("black.color")) {
                            this.linesColor = Color.BLACK;
                            continue;
                        }
                        if (lowerName.startsWith("background.")) {
                            this.setLoadText("loading background");
                            this.background = new ImageIcon(themeFiles[i].getPath()).getImage();
                            continue;
                        }
                        if (lowerName.startsWith("foreground.")) {
                            this.setLoadText("loading foreground");
                            this.foreground = new ImageIcon(themeFiles[i].getPath()).getImage();
                            this.customForeground = true;
                            this.mapBackground = null;
                            continue;
                        }
                        if (lowerName.startsWith("overground.")) {
                            this.setLoadText("loading overground");
                            this.overground = new ImageIcon(themeFiles[i].getPath()).getImage();
                            continue;
                        }
                        if (lowerName.equals("unit_castle.png") || lowerName.equals("unit_knight.png") || lowerName.equals("unit_pawn.png") || lowerName.startsWith("updater")) continue;
                        System.out.println(themeFiles[i].getName() + " was not loaded as an theme file");
                    }
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!foundTheme) {
                SS.debug("Vox -> Couldn't find the specified theme (" + named + ")", 1);
                this.desiredTheme = named;
                this.setForeground();
                this.mapBackground = this.createBackgroundImage(null);
                if (!"black".equalsIgnoreCase(named)) {
                    PluginManager.getInstance().lookForTheme(named, this.control.window);
                }
                return;
            }
            if (this.foreground == null) {
                this.setForeground();
            }
            Prefs.put("theme", named);
            this.mapBackground = this.createBackgroundImage(null);
        }
        catch (OutOfMemoryError memerr) {
            memerr.printStackTrace();
            this.setLoadText("Out of Memory Error V - " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch") + ", VM: " + System.getProperty("java.version") + " / " + System.getProperty("java.class.version") + ", maxmem " + Runtime.getRuntime().maxMemory() / 1000000L);
        }
        catch (Throwable exc) {
            exc.printStackTrace();
        }
        this.setLoadText("loading more resources");
    }

    private void setForeground() {
        this.foreground = GraphicsTool.getImageFromJAR("foreground.jpg");
        this.customForeground = false;
        this.mapBackground = null;
    }

    private void drawOverground(Graphics2D g) {
        if (this.overground != null) {
            g.drawImage(this.overground, 0, 0, this.displayWidth, this.displayHeight, null);
        }
    }

    private void drawExplosions(Graphics2D g) {
    }

    public void toggleContainsPlayerInfo() {
        this.setContainsPlayerInfo(!this.drawInfoPanel);
    }

    public void setContainsPlayerInfo(boolean drawInfoPanelNew) {
        if (this.infoPanel != null) {
            this.remove(this.infoPanelView);
            this.infoPanel.exitSlaveMode();
            this.infoPanel = null;
            this.infoPanelView = null;
        }
        if (drawInfoPanelNew) {
            try {
                boolean userInitiated = false;
                this.infoPanel = new PlayerInfoController(this.control);
                this.infoPanel.show(this.control, userInitiated, true);
                this.infoPanelView = this.infoPanel.getViewAndEnterSlaveMode();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            String pointString = this.control.playerInfoPointString;
            if (pointString == null || "null".equals(pointString)) {
                this.infoPanelView.setLocation(0, 0);
            } else {
                Point p = GraphicsTool.pointFromString(pointString);
                if (p.x < 0) {
                    p.setLocation(0, p.y);
                }
                if (p.y < 0) {
                    p.setLocation(p.x, 0);
                }
                if (p.x > this.displayWidth) {
                    p.setLocation(0, p.y);
                }
                if (p.y > this.displayHeight) {
                    p.setLocation(p.x, 0);
                }
                this.infoPanelView.setLocation(p);
            }
            this.add(this.infoPanelView);
        }
        this.drawInfoPanel = drawInfoPanelNew;
        this.repaint();
    }

    public void moveInfoPanel(int x, int y) {
        if (!this.drawInfoPanel) {
            return;
        }
        Point oldLocation = this.infoPanelView.getLocation();
        int newX = Math.max(oldLocation.x + x, -200);
        newX = Math.min(newX, this.getWidth() - 50);
        int newY = Math.max(oldLocation.y + y, -50);
        newY = Math.min(newY, this.getHeight() - 50);
        this.infoPanelView.setLocation(newX, newY);
    }

    public void toggleBonusView() {
        this.bonusMode = !this.bonusMode;
        this.repaint();
    }

    private Rectangle addFlashingCountriesToRedrawArea(Rectangle redrawArea) {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.flashing) continue;
            Rectangle cRect = c.getBounds();
            redrawArea = redrawArea == null ? cRect : redrawArea.union(cRect);
        }
        return redrawArea;
    }

    protected void orderExplosion(int code) {
        this.orderExplosion(code, false);
    }

    protected void orderExplosion(int code, boolean nuke) {
        Country c = this.world.countryWithID(code);
        Point loc = new Point((int)c.getBounds().getX() + this.rand.nextInt((int)c.getBounds().getWidth()), (int)c.getBounds().getY() + this.rand.nextInt((int)c.getBounds().getHeight()));
        this.orderExplosionAtPoint(loc, nuke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderExplosionAtPoint(Point loc, boolean nuke) {
        Object object = this.dirtyRectLock;
        synchronized (object) {
            int start = this.rand.nextInt(this.animationPoint.length);
            for (int c = 0; c < this.animationPoint.length; ++c) {
                int i = (start + c) % this.animationPoint.length;
                if (this.animationPoint[i] != null) continue;
                this.animationFrameCount[i] = 0;
                this.animationNumber[i] = nuke ? 0 : this.rand.nextInt(explosionFramesArrays.length - 1) + 1;
                this.animationPoint[i] = new Point(loc.x - Visuals.animationFrameSize[this.animationNumber[i]].width / 2, loc.y - Visuals.animationFrameSize[this.animationNumber[i]].height / 2);
                return;
            }
        }
    }

    public void advanceFrames() {
        Rectangle redrawArea = null;
        if ((double)this.flashCountryAlpha < 0.4) {
            this.flashCountryAlphaDescending = false;
        } else if ((double)this.flashCountryAlpha > 0.95) {
            this.flashCountryAlphaDescending = true;
        }
        this.flashCountryAlpha = this.flashCountryAlphaDescending ? (float)((double)this.flashCountryAlpha - 0.03) : (float)((double)this.flashCountryAlpha + 0.03);
        redrawArea = this.addFlashingCountriesToRedrawArea(redrawArea);
        if (this.notices != null) {
            for (int i = 0; i < this.notices.size(); ++i) {
                VisualsNotice n = (VisualsNotice)this.notices.get(i);
                if (n.stillDrawing()) continue;
                redrawArea = redrawArea == null ? n.getBounds(null) : redrawArea.union(n.getBounds(null));
            }
        }
        this.dirtyRect(redrawArea);
        if (this.dirtyRect != null) {
            this.repaint(this.dirtyRect);
            this.dirtyRect = null;
        }
        if (this.scrollingState > 0) {
            Runnable scroll = new Runnable(){

                public void run() {
                    int increment = 10;
                    if (Visuals.this.scrollingState == 1) {
                        JScrollBar bar = Visuals.this.control.scroller.getVerticalScrollBar();
                        bar.setValue(bar.getValue() - increment);
                    } else if (Visuals.this.scrollingState == 2) {
                        JScrollBar bar = Visuals.this.control.scroller.getVerticalScrollBar();
                        bar.setValue(bar.getValue() + increment);
                    } else if (Visuals.this.scrollingState == 3) {
                        JScrollBar bar = Visuals.this.control.scroller.getHorizontalScrollBar();
                        bar.setValue(bar.getValue() - increment);
                    } else if (Visuals.this.scrollingState == 4) {
                        JScrollBar bar = Visuals.this.control.scroller.getHorizontalScrollBar();
                        bar.setValue(bar.getValue() + increment);
                    }
                }
            };
            EventThread.runInEventThread(scroll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dirtyRect(Rectangle r) {
        if (r == null) {
            return;
        }
        Object object = this.dirtyRectLock;
        synchronized (object) {
            this.dirtyRect = this.dirtyRect == null ? r : r.union(this.dirtyRect);
        }
    }

    public void repaint(Rectangle r) {
        r = new Rectangle(r);
        r.grow(30, 30);
        if (r.height < 40) {
            r.grow(0, 40 - r.height);
        }
        if (r.width < 40) {
            r.grow(40 - r.width, 0);
        }
        super.repaint(r);
    }

    public void showNotice(String text, Point op) {
        this.showNotice(text, op, 5000L);
    }

    public void showNotice(String text, Point op, long length) {
        if (this.notices == null) {
            this.notices = new ArrayList();
        }
        Point p = new Point(Math.max(100, op.x), Math.max(70, op.y));
        SS.debug(p.x + "," + p.y + " notice: " + text, 1);
        VisualsNotice n = new VisualsNotice(text, p, length);
        this.notices.add(n);
        this.repaint(n.getBounds());
    }

    public void drawNotices(Graphics2D g) {
        if (this.notices == null) {
            return;
        }
        Font font = g.getFont();
        for (int i = 0; i < this.notices.size(); ++i) {
            VisualsNotice n = (VisualsNotice)this.notices.get(i);
            boolean stillDrawing = n.draw(g);
            if (stillDrawing) continue;
            this.notices.remove(n);
            this.repaint(n.getBounds(font));
            --i;
        }
    }

    public void toggleRecruitPanel() {
        this.toggleRecruitPanel(null);
    }

    public void toggleRecruitPanel(Country c) {
        if (this.buyPanelIsVisable || !this.control.controlsAnyone()) {
            this.doneBuying();
        } else if (this.gameOverText == null) {
            this.buyingRound(c);
        }
    }

    protected void buyingRound(Country c) {
        boolean firstTime = false;
        if (this.buyPanel == null) {
            firstTime = true;
            this.buyPanel = new RecruitPanel(this.control);
        }
        if (c == null) {
            c = this.getCastleCountry();
        }
        int x = 0;
        int y = 0;
        int recruitHeight = 140;
        int recruitWidth = 190;
        int buffer = 10;
        if (c != null) {
            x = c.getBounds().x + c.getBounds().width + buffer;
            y = c.getBounds().y;
            if (x + recruitWidth > this.displayWidth) {
                x = c.getBounds().x - recruitWidth - buffer;
            }
            if (y < 10) {
                y = 0;
            }
            if (x < 0) {
                x = c.getBounds().x + c.getBounds().width / 2 - recruitWidth / 2;
                y = c.getBounds().y + c.getBounds().height + buffer;
            }
            if (y + recruitHeight > this.displayHeight) {
                x = c.getBounds().x + c.getBounds().width / 2 - recruitWidth / 2;
                y = c.getBounds().y - recruitHeight - buffer;
            }
        }
        this.buyPanel.setLocation(x, y);
        this.buyPanel.updateMoney();
        this.add(this.buyPanel);
        this.setComponentZOrder(this.buyPanel, 0);
        this.buyPanelIsVisable = true;
        this.buyPanel.revalidate();
        this.repaint();
    }

    protected void updateMoney() {
        this.control.updateRecruitButton();
        if (this.buyPanel != null) {
            this.buyPanel.updateMoney();
            this.buyPanel.repaint();
        }
    }

    public void gameOver(final StatsHistory statsHistory) {
        this.gameOverText = StringTool.wrapLines(statsHistory.getEndText(), 50);
        Runnable chartRunnable = new Runnable(){

            public void run() {
                Visuals.this.chart = statsHistory.getChart(Visuals.this.control);
                if (Visuals.this.chart != null) {
                    Visuals.this.chart.setLocation(0, 0);
                    Dimension dim = new Dimension(Visuals.this.displayWidth, Visuals.this.displayHeight);
                    Visuals.this.chart.setSize(dim);
                    Visuals.this.add(Visuals.this.chart);
                    Visuals.this.setComponentZOrder(Visuals.this.chart, 0);
                }
                Visuals.this.repaint();
            }
        };
        try {
            SwingUtilities.invokeAndWait(chartRunnable);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setPlayerID(int ID) {
        this.doneBuying();
        this.buyPanel = null;
    }

    public boolean playerHasCastleInRegion(int x, int y, int width, int height) {
        Rectangle region = new Rectangle(x, y, width, height);
        for (int i = 0; i < this.countries.size(); ++i) {
            UnitStack castle;
            Country c = (Country)this.countries.get(i);
            if (!c.hasCastle() || !this.control.controlsID((castle = c.getCastle()).getOwner().getID()) || !c.getBounds().intersects(region)) continue;
            SS.debug(c.getBounds() + " intersects " + region);
            return true;
        }
        return false;
    }

    public Country getCastleCountry() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.hasCastle(this.control.getPlayer(this.control.getGuiOwner()))) continue;
            return c;
        }
        return null;
    }

    public Country getCastleCountry(int ownerID) {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.hasCastle() || c.getOwner().getID() != ownerID) continue;
            return c;
        }
        return null;
    }

    public Country getLargestCountry(int ownerID) {
        int largestCount = 0;
        Country largestCountry = null;
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (c.getOwner().getID() != ownerID) continue;
            int count = c.getUnitCosts(ownerID);
            if (c.hasCastle()) {
                count *= 2;
            }
            if (count <= largestCount) continue;
            largestCount = count;
            largestCountry = c;
        }
        return largestCountry;
    }

    public Point getCastlePoint() {
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            if (!c.hasCastle() || !this.control.controlsID(c.getOwner().getID())) continue;
            return c.getCenter();
        }
        return null;
    }

    public static void reloadTheme(String theme) {
        if (viewList.size() > 0) {
            try {
                GraphicsTool.releaseManagedImagesColored();
                GraphicsTool.releaseManagedImages();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        int n = viewList.size();
        for (int i = 0; i < n; ++i) {
            Visuals view = (Visuals)viewList.get(i);
            SS.debug("reloadTheme(" + theme + ") desiredTheme=" + view.desiredTheme);
            if (!theme.equals(view.desiredTheme)) continue;
            view.desiredTheme = null;
            view.loadTheme(theme);
            view.setLoadText(null);
        }
    }

    void kill() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.removeFocusListener(this);
        viewList.remove(this);
        Ticker.stopMeTicking(this);
        this.control = null;
        this.mapBackground = null;
        this.contLabelLocation = null;
        this.contName = null;
        this.background = null;
        this.foreground = null;
        this.overground = null;
        if (this.world != null) {
            this.world.killed = true;
        }
        this.world = null;
    }

    public void lostServer() {
        this.gameOverText = "No connection to game server";
        this.repaint();
    }

    protected void restart() {
        this.notices = null;
    }

    public void setExtraLines(List lines) {
        this.lines = lines;
        for (int j = lines.size() - 1; j > -1; --j) {
            ExtraLine line = (ExtraLine)lines.get(j);
            if (!line.above) continue;
            lines.remove(line);
            if (this.aboveLines == null) {
                this.aboveLines = new ArrayList();
            }
            this.aboveLines.add(line);
        }
    }

    public void resizeExtraLines(double currentZoom) {
        ExtraLine line;
        int j;
        if (this.lines != null) {
            for (j = 0; j < this.lines.size(); ++j) {
                line = (ExtraLine)this.lines.get(j);
                line.resize(currentZoom);
            }
        }
        if (this.aboveLines != null) {
            for (j = 0; j < this.aboveLines.size(); ++j) {
                line = (ExtraLine)this.aboveLines.get(j);
                line.resize(currentZoom);
            }
        }
    }

    static {
        viewList = new Vector();
        arial24 = new Font("Arial", 0, 24);
        arial32 = new Font("Arial", 0, 32);
        loadingFont = new Font("Arial", 0, 48);
        sansSerif12 = new Font("SansSerif", 0, 12);
        sansSerifBold12 = new Font("SansSerif", 1, 12);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Point cursorHotSpot = new Point(0, 0);
        cursorEmpty = toolkit.createCustomCursor(GraphicsTool.getImageFromJAR("cursor_empty.png"), cursorHotSpot, "empty");
        cursorSelect = toolkit.createCustomCursor(GraphicsTool.getImageFromJAR("cursor_selecting.png"), cursorHotSpot, "selecting");
        cursorOverUnit = toolkit.createCustomCursor(GraphicsTool.getImageFromJAR("cursor_over_unit.png"), cursorHotSpot, "overunit");
    }
}

