/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.StringTool;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.TableSorter;
import com.sillysoft.tools.Translator;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.JoinTableCellRenderer;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxTracker;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSButton;
import com.sillysoft.widgets.SSCheckBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSLinkingTextPane;
import com.sillysoft.widgets.SSRootPane;
import com.sillysoft.widgets.SSTable;
import com.sillysoft.widgets.SSTextField;
import com.sillysoft.widgets.SearchField;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class VJoinGame
extends AbstractTableModel
implements Runnable,
ActionListener {
    private SSFrame joinWindow;
    private SSTable joinListTable;
    private TableSorter sorter;
    private JTextPane infoText;
    private SSButton joinButton;
    private SSCheckBox guestOnly;
    private SSTextField ipField;
    private SearchField searchField;
    public String weeklyMap;
    private JLabel weeklyMapLabel;
    private JLabel weeklyMapNextLabel;
    private JPanel connectPanel;
    private JProgressBar connectBar;
    private static VJoinGame singleton;
    protected static final int COL_STATUS = 0;
    private static final int COL_HOST = 1;
    private static final int COL_MAP = 2;
    private static final int COL_ROUND = 3;
    private static final int COL_CONNECTED = 4;
    protected static final int COL_HUMANS = 5;
    protected static final int COL_PLAYERS_LEFT = 5;
    protected static final int COL_TURN_TIME = 6;
    private static final int COL_VERSION = 7;
    private static final int COL_TIMESTAMP = 8;
    private static final int COL_IP = 9;
    protected static final int COL_TIME_STARTED = 10;
    protected static final int COL_TIME_ENDED = 11;
    private static final int COL_PLAYER_NAMES = 12;
    private static final int COL_DESCRIPTION = 13;
    private static final int COL_GUEST_NAMES = 14;
    private static final int COL_PORT = 15;
    private static final int COL_HOST_RATING = 16;
    protected static final int COL_WAITING = 17;
    protected static final int COL_CONNECTEDNAMES = 18;
    Vector rows;
    Vector rowsAll;
    private String[] keys = new String[]{"S", Translator.getString("Host"), Translator.getString("Map"), Translator.getString("Round"), Translator.getString("Connected"), Translator.getString("Humans"), Translator.getString("TurnTime"), Translator.getString("Version"), "Date", "IP", "timeStartedGMT", "playerNames", "gameDescription", "guestNames", "port", "hostRating"};
    private static boolean joinListThreadRunning;
    String lastSearchTermLower;

    public static void show() {
        if (singleton == null) {
            singleton = new VJoinGame();
        }
        singleton.go();
    }

    public int getColumnCount() {
        return 7;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int row, int col) {
        if (row >= this.rows.size()) {
            return "";
        }
        return ((Object[])this.rows.get(row))[col];
    }

    public String getColumnName(int col) {
        return this.keys[col];
    }

    private VJoinGame() {
        this.joinWindow = new SSFrame(Translator.getString("JoinAGame"));
        this.joinWindow.setLocationID("Join");
        this.joinWindow.setResizeID("Join");
        this.rows = new Vector();
        this.rowsAll = new Vector();
        this.ipField = new SSTextField(12);
        this.sorter = new TableSorter("VJoinGameSortOrder", this);
        this.joinListTable = new SSTable(this.sorter);
        this.joinListTable.setShowVerticalLines(false);
        this.joinListTable.setShowHorizontalLines(false);
        this.joinListTable.setShowGrid(false);
        this.sorter.setTableHeader(this.joinListTable.getTableHeader());
        this.joinListTable.setSelectionMode(0);
        this.joinListTable.setColumnSelectionAllowed(false);
        this.joinListTable.setRowSelectionAllowed(true);
        ListSelectionModel rowSM = this.joinListTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    VJoinGame.this.selectRow(-1);
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    VJoinGame.this.selectRow(selectedRow);
                }
            }
        });
        this.joinListTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    VJoinGame.this.joinSelectedGame();
                }
            }
        });
        JoinTableCellRenderer renderer = new JoinTableCellRenderer(this);
        this.joinListTable.setDefaultRenderer(Object.class, renderer);
        JPanel rootPane = new JPanel();
        rootPane.setLayout(new BorderLayout());
        int off = 20;
        Font smallFont = new Font("Arial", 0, 10);
        JPanel center = new JPanel();
        SSRootPane south = new SSRootPane();
        JPanel north = new JPanel();
        north.setBorder(new EmptyBorder(5, 10, 0, 10));
        north.setLayout(new BoxLayout(north, 1));
        JPanel northTop = new JPanel();
        northTop.setLayout(new BoxLayout(northTop, 0));
        this.weeklyMapLabel = new JLabel(Translator.getString("JoinGameWelcome"));
        northTop.add(this.weeklyMapLabel);
        JLabel label = new JLabel("                                ");
        northTop.add(label);
        northTop.add(Box.createHorizontalGlue());
        this.searchField = new SearchField(SS.isMacintosh105 ? "" : Translator.getString("Search"));
        this.searchField.setSendsNotificationForEachKeystroke(true);
        this.searchField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VJoinGame.this.doSearch(VJoinGame.this.searchField.getText());
            }
        });
        northTop.add(this.searchField);
        north.add(northTop);
        rootPane.add((Component)north, "North");
        JScrollPane scrollpane = new JScrollPane(this.joinListTable);
        scrollpane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        scrollpane.setPreferredSize(new Dimension(750, (int)Math.min(300.0, SwingTool.getUsableDimension().getHeight() - 400.0)));
        scrollpane.setBorder(null);
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 1));
        centerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        centerPanel.add(scrollpane);
        centerPanel.add(Box.createVerticalStrut(7));
        this.infoText = new SSLinkingTextPane();
        this.infoText.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        this.selectRow(-1);
        scrollpane = new JScrollPane(this.infoText);
        scrollpane.setPreferredSize(new Dimension(600, 140));
        scrollpane.setMaximumSize(new Dimension(6000, 200));
        centerPanel.add(scrollpane);
        rootPane.add((Component)centerPanel, "Center");
        south.setLayout(new BoxLayout(south, 1));
        south.setBorder(new EmptyBorder(0, 10, 10, 10));
        this.weeklyMapNextLabel = new JLabel("          ");
        this.guestOnly = new SSCheckBox(Translator.getString("Joinasaguestonly"), Prefs.getBoolean("guestOnly", false));
        this.guestOnly.setFocusable(false);
        JPanel privateGamePanel = new JPanel(new FlowLayout(0));
        privateGamePanel.add(new JLabel(Translator.getString("Orentertheserver'saddress")));
        privateGamePanel.add(this.ipField);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(privateGamePanel);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.guestOnly);
        south.add(panel);
        JPanel southBottom = new JPanel();
        southBottom.setLayout(new BoxLayout(southBottom, 0));
        this.connectPanel = new JPanel();
        this.connectPanel.setPreferredSize(new Dimension(80, 16));
        this.connectPanel.setMinimumSize(new Dimension(80, 16));
        southBottom.add(this.connectPanel);
        southBottom.add(Box.createHorizontalGlue());
        SSButton button = new SSButton(Translator.getString("Cancel"));
        button.setPreferredWidth(150);
        button.setActionCommand("cancel");
        button.addActionListener(this);
        southBottom.add(button);
        button = new SSButton(Translator.getString("Refresh"));
        button.setPreferredWidth(150);
        button.setActionCommand("refresh");
        button.addActionListener(this);
        button.setFocusable(false);
        southBottom.add(button);
        this.joinButton = new SSButton(Translator.getString("JoinGame"));
        this.joinButton.setPreferredWidth(150);
        this.joinButton.setActionCommand("join");
        this.joinButton.addActionListener(this);
        southBottom.add(this.joinButton);
        south.add(southBottom);
        rootPane.add((Component)south, "South");
        rootPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        rootPane.setMinimumSize(new Dimension(300, 300));
        this.joinWindow.setContentPane(rootPane);
        this.joinWindow.setJMenuBar(SSApp.getInstance().makeCommonMenuBar(this.joinWindow));
        this.joinListTable.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "join");
        this.joinListTable.getActionMap().put("join", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                VJoinGame.this.joinSelectedGame();
            }
        });
        this.connectBar = new JProgressBar();
        this.connectBar.putClientProperty("JProgressBar.style", "circular");
        this.joinWindow.pack();
        this.joinListTable.requestFocusInWindow();
        this.joinListTable.setColumnWidth(0, 8);
        this.joinListTable.setColumnWidth(1, 100);
        this.joinListTable.setColumnWidth(2, 135);
        this.joinListTable.setColumnWidth(3, 40);
        this.joinListTable.setColumnWidth(4, 40);
        this.joinListTable.setColumnWidth(5, 40);
        this.joinListTable.setColumnWidth(6, 50);
    }

    private void go() {
        this.joinWindow.show();
        this.joinWindow.getRootPane().setDefaultButton(this.joinButton);
        if (!joinListThreadRunning) {
            this.connectPanel.add(this.connectBar);
            this.connectBar.setIndeterminate(true);
            this.infoText.setText(Translator.getString("connectingtotheLuxTracker"));
            new Thread((Runnable)this, "VJoinGame-getList").start();
        }
    }

    public void run() {
        if (joinListThreadRunning) {
            return;
        }
        joinListThreadRunning = true;
        boolean error = false;
        try {
            String contents = VoxTracker.getHostList();
            this.rowsAll = new Vector();
            this.infoText.setText("0 " + Translator.getString("hostsfound") + ". ");
            String host = XMLTool.extract("host", contents);
            int h = 1;
            while (host != null) {
                try {
                    Object[] obs = new Object[]{URLDecoder.decode(XMLTool.extract("playerNames", host), "UTF-8").indexOf(SSApp.getInstance().getDefaultJoinName()) != -1 ? "\u265f" : " ", URLDecoder.decode(XMLTool.extract("name", host), "UTF-8"), URLDecoder.decode(XMLTool.extract("boardSize", host), "UTF-8"), (!"0".equals(URLDecoder.decode(XMLTool.extract("gameEnded", host), "UTF-8")) && !XMLTool.extract("round", host).startsWith("F ") ? "F " : "") + XMLTool.extract("round", host), XMLTool.extract("numberOfPlayers", host), URLDecoder.decode(XMLTool.extract("humans2", host), "UTF-8"), XMLTool.extract("turnTimer", host), XMLTool.extract("version", host), XMLTool.extract("timestamp", host), XMLTool.extract("ip", host), URLDecoder.decode(XMLTool.extract("gameStarted", host), "UTF-8"), URLDecoder.decode(XMLTool.extract("gameEnded", host), "UTF-8"), URLDecoder.decode(XMLTool.extract("playerNames", host), "UTF-8"), URLDecoder.decode(XMLTool.extract("description", host), "UTF-8"), URLDecoder.decode(XMLTool.extract("guestNames", host), "UTF-8"), XMLTool.extract("port", host), XMLTool.extract("hostRating", host), XMLTool.extract("waitingFor", host), XMLTool.extract("connectedNames", host)};
                    if ("en".equals(Translator.getLocale().getLanguage())) {
                        obs[6] = ((String)obs[6]).replaceAll(",", ".");
                    }
                    this.rowsAll.add(obs);
                }
                catch (Exception e) {
                    System.out.println("Error parsing a host in the game tracker: " + e);
                }
                if (h == 1) {
                    this.infoText.setText("1 " + Translator.getString("hostfound"));
                } else {
                    this.infoText.setText(h + " " + Translator.getString("hostsfound") + ". " + Translator.getString("Selectagametogetinfo"));
                }
                host = XMLTool.extract("host", contents, h);
                ++h;
            }
            String temp = XMLTool.extract("weeklyMap", contents);
            if (temp != null) {
                this.weeklyMapLabel.setText(Translator.getString("Weeklymap") + ": " + temp);
                this.weeklyMap = temp;
            }
            if ((temp = XMLTool.extract("weeklyMapNext", contents)) != null) {
                this.weeklyMapNextLabel.setText(Translator.getString("Weeklymapnext") + ": " + temp);
            }
        }
        catch (Throwable t) {
            error = true;
            this.rowsAll = new Vector();
            this.infoText.setText(Translator.getString("LuxTrackerError"));
            System.out.println("Lux -> Couldn't retrieve the game list from the LuxTracker: " + t);
        }
        int selectedRow = this.joinListTable.getSelectedRow();
        this.rows = this.rowsAll;
        this.connectBar.setIndeterminate(false);
        this.connectPanel.remove(this.connectBar);
        this.connectPanel.revalidate();
        this.connectPanel.repaint();
        this.fireTableDataChanged();
        if (this.joinListTable.getRowCount() > selectedRow) {
            if (selectedRow > -1) {
                this.joinListTable.setRowSelectionInterval(selectedRow, selectedRow);
                this.selectRow(selectedRow);
            }
            if (!this.ipField.hasFocus()) {
                this.joinListTable.requestFocus();
            }
        }
        joinListThreadRunning = false;
        if (error) {
            this.infoText.setText(Translator.getString("LuxTrackerError"));
        }
    }

    private void doSearch(String searchTerm) {
        String lowerTerm = searchTerm.toLowerCase();
        if (lowerTerm.equals(this.lastSearchTermLower)) {
            return;
        }
        this.lastSearchTermLower = lowerTerm;
        this.rows = new Vector();
        for (int i = 0; i < this.rowsAll.size(); ++i) {
            try {
                if (((String)((Object[])this.rowsAll.get(i))[1]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[2]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[12]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[13]).toLowerCase().indexOf(lowerTerm) == -1 && ((String)((Object[])this.rowsAll.get(i))[14]).toLowerCase().indexOf(lowerTerm) == -1) continue;
                this.rows.add(this.rowsAll.get(i));
                continue;
            }
            catch (Exception e) {
                System.out.println("search error 2873: " + e);
            }
        }
        this.fireTableDataChanged();
    }

    public void joinSelectedGame() {
        String userkey;
        String nick = SSApp.getInstance().getDefaultJoinName();
        if ("".equals(nick)) {
            nick = "no name" + new Random().nextInt(100);
        }
        if (nick.length() > 64) {
            nick = nick.substring(0, 64);
            nick = nick.trim();
        }
        int port = 3319;
        String address = this.ipField.getText().trim();
        if (address.indexOf(":") != -1) {
            port = Integer.parseInt(address.substring(address.indexOf(":") + 1));
            address = address.substring(0, address.indexOf(":"));
        }
        boolean internetPublic = false;
        if ("".equals(address)) {
            if (this.getSelectedRow() == -1) {
                SS.beep();
                return;
            }
            internetPublic = true;
            address = (String)((Object[])this.rows.get(this.getSelectedRow()))[9];
            Object portObject = ((Object[])this.rows.get(this.getSelectedRow()))[15];
            if (portObject != null) {
                try {
                    port = Integer.parseInt((String)portObject);
                }
                catch (Exception e) {
                    SS.debug("ERROR parsing the port of a host: " + portObject);
                }
            }
        }
        if ((userkey = Prefs.get("regCode", "")).equals("")) {
            String unregID = Prefs.get("unregID", "" + SS.rand.nextInt(100000));
            Prefs.put("unregID", unregID);
            userkey = "unreg" + unregID;
        }
        VoxClient client = new VoxClient(address, port, nick, userkey, true, this.guestOnly.isSelected());
        this.joinWindow.hide();
    }

    private int getSelectedRow() {
        int viewRow = this.joinListTable.getSelectedRow();
        if (viewRow == -1) {
            return viewRow;
        }
        return this.sorter.modelIndex(viewRow);
    }

    public int getTranslatedRow(int viewRow) {
        if (viewRow == -1) {
            return viewRow;
        }
        return this.sorter.modelIndex(viewRow);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if ("join".equals(event.getActionCommand())) {
                this.joinSelectedGame();
            } else if ("cancel".equals(event.getActionCommand())) {
                this.joinWindow.hide();
            } else if ("refresh".equals(event.getActionCommand())) {
                this.go();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void selectRow(int row) {
        if (row == -1) {
            this.infoText.setText(Translator.getString("Selectagametogetinfo"));
        } else {
            long gameStart = 0L;
            long gameEnd = 0L;
            try {
                gameStart = Long.parseLong((String)((Object[])this.rows.get(this.getSelectedRow()))[10]);
                gameEnd = Long.parseLong((String)((Object[])this.rows.get(this.getSelectedRow()))[11]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Date now = new Date();
            Date start = new Date(gameStart);
            String minutes = (start.getMinutes() < 10 ? "0" : "") + start.getMinutes();
            if (start.getMinutes() < 10) {
                minutes = "0" + start.getMinutes();
            }
            String guests = (String)((Object[])this.rows.get(this.getSelectedRow()))[14];
            String waitingFor = (String)((Object[])this.rows.get(this.getSelectedRow()))[17];
            String connectedNames = (String)this.getValueAt(this.getSelectedRow(), 18);
            if (connectedNames == null) {
                connectedNames = "";
            }
            SimpleDateFormat timeFormat = Translator.getLocale().equals(Locale.JAPANESE) ? new SimpleDateFormat("a h:mm") : new SimpleDateFormat("h:mm a");
            String timeString = timeFormat.format((Object)start);
            this.infoText.setText((gameEnd == 0L ? Translator.getString("Gameisinround") + " " + this.getValueAt(this.getSelectedRow(), 3) + ", " + Translator.getString("hasbeengoingonfor") + " " + StringTool.timeFormat(now.getTime() - gameStart) : Translator.getString("Gameoverinround") + " " + this.getValueAt(this.getSelectedRow(), 3).toString().substring(2) + ", " + Translator.getString("lastedfor") + " " + StringTool.timeFormat(gameEnd - gameStart)) + "." + "\n\n" + Translator.getString("Players") + ": " + this.getValueAt(this.getSelectedRow(), 12) + ("".equals(waitingFor) ? "" : "\n" + Translator.getString("Waitingfor") + ": " + waitingFor) + ("".equals(guests) ? "" : "\n" + Translator.getString("Guests") + ": " + guests) + ("".equals(connectedNames) ? "" : "\n" + Translator.getString("Connected") + ": " + connectedNames) + "\n" + Translator.getString("Description") + ": " + this.getValueAt(this.getSelectedRow(), 13));
            this.infoText.setCaretPosition(0);
        }
    }

    static {
        joinListThreadRunning = false;
    }
}

