/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class UnitStackGroup {
    private List list;

    public UnitStackGroup() {
        this.list = new Vector();
    }

    public UnitStackGroup(UnitStack ug) {
        this.list = new Vector();
        this.list.add(ug);
    }

    public UnitStackGroup(List list) {
        this.list = list;
    }

    public UnitStackGroup(String XML, CountriesManager master) {
        this.list = new ArrayList();
        String item = XMLTool.extract("vunits", XML);
        int h = 1;
        while (item != null) {
            UnitStack object = new UnitStack(item, master);
            this.list.add(object);
            item = XMLTool.extract("vunits", XML, h);
            ++h;
        }
    }

    public UnitStack get(int i) {
        if (i > this.list.size()) {
            SS.debug("UnitStackGroup.get with an index too high. USG contains: " + this);
        }
        return (UnitStack)this.list.get(i);
    }

    public UnitStack remove(int i) {
        if (this.list.size() == 0) {
            SS.debug("UnitStackGroup.remove(int i) called while EMPTY - " + i);
            return null;
        }
        return (UnitStack)this.list.remove(i);
    }

    public boolean remove(UnitStack ug) {
        return this.list.remove(ug);
    }

    public void removeEmpties() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getCount() != 0) continue;
            this.remove(i);
            --i;
        }
    }

    public String toStringXML() {
        return XMLTool.getListXML(this.list, "vunits");
    }

    public void consolidateUnits() {
        for (int i = 0; i < this.size(); ++i) {
            for (int j = 0; j < this.size(); ++j) {
                if (i == j) continue;
                UnitStack us1 = this.get(i);
                UnitStack us2 = this.get(j);
                if (!us1.getOwner().equals(us2.getOwner()) || us1.getUnit().getType() != us2.getUnit().getType()) continue;
                us1.setCount(us1.getCount() + us2.getCount());
                us1.addCarry(us2.getCarriedUnits());
                this.list.remove(us2);
                this.consolidateUnits();
                return;
            }
        }
    }

    public void orderUnits() {
        boolean changeMade = true;
        while (changeMade) {
            changeMade = false;
            for (int i = 0; i < this.size() - 1; ++i) {
                if (this.get(i).getUnit().getType() <= this.get(i + 1).getUnit().getType()) continue;
                UnitStack move = this.get(i);
                this.remove(move);
                this.list.add(i + 1, move);
                changeMade = true;
            }
        }
    }

    public int size() {
        return this.list.size();
    }

    public int getTotalUnitCount() {
        int result = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            result += this.get(i).getCount();
        }
        return result;
    }

    public boolean contains(UnitStack ug) {
        return this.list.contains(ug);
    }

    public boolean pushToBack(UnitStack ug) {
        if (this.list.remove(ug)) {
            this.list.add(ug);
            return true;
        }
        return false;
    }

    public boolean pushToFront(UnitStack ug) {
        if (this.list.remove(ug)) {
            this.list.add(0, ug);
            return true;
        }
        return false;
    }

    public void add(UnitStack ug) {
        if (ug == null || ug.getCount() == 0) {
            return;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (!ug.equals(this.list.get(i))) continue;
            UnitStack group = (UnitStack)this.list.get(i);
            group.setCount(group.getCount() + ug.getCount());
            group.addCarry(ug.getCarriedUnits());
            return;
        }
        UnitStack ugnew = new UnitStack(ug.getUnit(), ug.getCount(), ug.getOriginalCountryID(), ug.getCarriedUnits(), ug.getCarriedUnitsAir(), ug.getCarriedUnitsMissiles());
        ugnew.setDrawPoint(ug.getDrawPoint());
        ugnew.setLandingCountry(ug.getLandingCountryID());
        this.list.add(ugnew);
    }

    public void add(UnitStackGroup other) {
        if (other == null) {
            return;
        }
        for (int i = 0; i < other.size(); ++i) {
            this.add(other.get(i));
        }
    }

    public Team getTeam() {
        return this.getDominantOwner().getTeam();
    }

    public Player getDominantOwner() {
        HashMap<Player, Integer> countMap = new HashMap<Player, Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Player owner = this.get(i).getOwner();
            Integer count = (Integer)countMap.get(owner);
            if (count == null) {
                countMap.put(owner, new Integer(this.get(i).getCount()));
                continue;
            }
            countMap.put(owner, new Integer(this.get(i).getCount() + count));
        }
        int biggestCount = 0;
        Player result = null;
        for (Object key : countMap.keySet()) {
            if ((Integer)countMap.get(key) <= biggestCount) continue;
            biggestCount = (Integer)countMap.get(key);
            result = (Player)key;
        }
        return result;
    }

    public void setOriginalCountry(Country orig) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setOriginalCountry(orig);
        }
    }

    public boolean containsLoadedTransport() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getUnit().transportCapacity() <= 0 || this.get(i).getCarriedUnitCount() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getTransportWeight() {
        int weight = 0;
        for (int i = 0; i < this.size(); ++i) {
            weight += this.get(i).getUnit().transportWeight() * this.get(i).getCount();
        }
        return weight;
    }

    public UnitStackGroup takeWeight(int takeWeight) {
        UnitStackGroup result = new UnitStackGroup();
        for (int i = 0; i < this.size(); ++i) {
            UnitStack group = this.get(i);
            int takeUnits = takeWeight / group.getUnit().transportWeight();
            takeUnits = Math.min(takeUnits, group.getCount());
            group.setCount(group.getCount() - takeUnits);
            result.add(new UnitStack(group.getUnit(), takeUnits, group.getOriginalCountryID()));
            if ((takeWeight -= group.getUnit().transportWeight() * takeUnits) != 0) continue;
            return result;
        }
        return result;
    }

    public int calculateDiceRollKills(boolean attacking) {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).calculateDiceRollKills(attacking);
        }
        return result;
    }

    public void killUnits(int numberToKill) {
        if (numberToKill == 0) {
            return;
        }
        if (numberToKill > this.getTotalUnitCount() && (numberToKill = this.getTotalUnitCount()) == 0) {
            return;
        }
        int leastCost = 1000000;
        UnitStack leastCostGroup = null;
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).getUnit().getCost() >= leastCost) continue;
            leastCost = this.get(i).getUnit().getCost();
            leastCostGroup = this.get(i);
        }
        if (leastCostGroup == null) {
            SS.debug("leastCostGroup == null in " + this);
            return;
        }
        leastCostGroup.removeOne();
        this.remove(leastCostGroup);
        this.add(leastCostGroup);
        this.removeEmpties();
        if (numberToKill == 1) {
            return;
        }
        this.killUnits(numberToKill - 1);
    }

    public String toString() {
        String result = "<UnitStackGroup: ";
        for (int i = 0; i < this.size(); ++i) {
            result = result + this.get(i);
        }
        result = result + ">";
        return result;
    }

    public UnitStackGroup removeExpireAfterAttackUnits() {
        UnitStackGroup result = new UnitStackGroup();
        for (int i = 0; i < this.size(); ++i) {
            UnitStack us = this.get(i);
            if (!us.getUnit().expiresAfterAttack()) continue;
            result.add(this.remove(i));
            --i;
        }
        return result;
    }

    public UnitStackGroup removeNonLandableAirUnits() {
        UnitStackGroup result = new UnitStackGroup();
        for (int i = 0; i < this.size(); ++i) {
            UnitStack us = this.get(i);
            if (!us.getUnit().isAir()) continue;
            result.add(this.remove(i));
            --i;
        }
        return result;
    }

    protected Object clone() {
        UnitStackGroup result = new UnitStackGroup();
        for (int i = 0; i < this.size(); ++i) {
            UnitStack us = this.get(i);
            result.add((UnitStack)us.clone());
        }
        return result;
    }

    public int getCost() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            result += this.get(i).getUnit().getCost() * this.get(i).getCount();
        }
        return result;
    }

    public int getNukeLevel() {
        int result = 0;
        for (int i = 0; i < this.size(); ++i) {
            UnitStack us = this.get(i);
            result = Math.max(result, us.getUnit().getNukeLevel());
        }
        return result;
    }

    public void nukeAtLevel(int percent) {
        for (int i = 0; i < this.size(); ++i) {
            UnitStack us = this.get(i);
            int dead = (int)((float)us.getCount() * ((float)percent / 100.0f));
            us.setCount(us.getCount() - dead);
        }
        this.removeEmpties();
    }

    public void setLandingCountry(Country orig) {
        for (int i = 0; i < this.size(); ++i) {
            this.get(i).setLandingCountry(orig);
        }
    }

    public boolean isOnlyAirplanes() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isAir() && !this.get(i).expiresAfterAttack()) continue;
            return false;
        }
        return true;
    }

    public boolean hasCastle() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getUnit().isCastle()) continue;
            return true;
        }
        return false;
    }

    public UnitStack getCastle() {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getUnit().isCastle()) continue;
            return this.get(i);
        }
        return null;
    }
}

