/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitPack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.VoxWorld;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class UnitStack
implements XMLSerializable {
    public static final float unitTransparency = 0.3f;
    private int count = 0;
    private Unit unit;
    private Point drawPoint;
    private int originalCountryID;
    private int landingCountryID = -1;
    private boolean excited = false;
    public static final int diceSize = 6;
    UnitStackGroup carriedUnits;
    UnitStackGroup carriedUnitsAir;
    UnitStackGroup carriedUnitsMissiles;

    public UnitStack(String XML, CountriesManager master) {
        try {
            this.count = Integer.parseInt(XMLTool.extractAttribute("number", XML));
            this.originalCountryID = Integer.parseInt(XMLTool.extractAttribute("originalCountryID", XML));
            int owner = Integer.parseInt(XMLTool.extractAttribute("owner", XML));
            this.unit = UnitPack.createUnit(XMLTool.extractAttribute("unitType", XML), master.getPlayer(owner));
            this.drawPoint = GraphicsTool.pointFromString(XMLTool.extractAttribute("drawPoint", XML));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toStringXML() {
        return "<UnitStack number=\"" + this.count + "\" unitType=\"" + this.unit.toString() + "\" owner=\"" + this.unit.getOwner().getID() + "\" originalCountryID=\"" + this.originalCountryID + "\" drawPoint=\"" + GraphicsTool.stringFromPoint(this.drawPoint) + "\" />";
    }

    public UnitStack(Unit u) {
        this(u, 1);
    }

    public UnitStack(Unit u, int numberOfUnits) {
        this(u, numberOfUnits, -1, null, null, null);
    }

    public UnitStack(Unit u, int numberOfUnits, int originalCountryID) {
        this(u, numberOfUnits, originalCountryID, null, null, null);
    }

    public UnitStack(Unit u, int numberOfUnits, int originalCountryID, UnitStackGroup carriedUnits, UnitStackGroup carriedUnitsAir, UnitStackGroup carriedUnitsMissiles) {
        this.unit = u;
        this.setCount(numberOfUnits);
        this.originalCountryID = originalCountryID;
        this.carriedUnits = carriedUnits;
        this.carriedUnitsAir = carriedUnitsAir;
        this.carriedUnitsMissiles = carriedUnitsMissiles;
    }

    public void setOriginalCountry(Country orig) {
        this.originalCountryID = orig == null ? -1 : orig.getID();
    }

    public int getOriginalCountryID() {
        return this.originalCountryID;
    }

    public Country getOriginalCountry(VoxWorld world) {
        return world.countryWithID(this.originalCountryID);
    }

    public void setLandingCountry(Country orig) {
        this.landingCountryID = orig == null ? -1 : orig.getID();
    }

    public void setLandingCountry(int orig) {
        this.landingCountryID = orig;
    }

    public int getLandingCountryID() {
        return this.landingCountryID;
    }

    public void setDrawPoint(Point dp) {
        this.drawPoint = dp;
    }

    public Point getDrawPoint() {
        return this.drawPoint;
    }

    public Point getCenterPoint() {
        return new Point(this.drawPoint.x + this.getWidth() / 2, this.drawPoint.y + this.getHeight() / 2);
    }

    public int getCount() {
        return this.count;
    }

    public void addOne() {
        ++this.count;
    }

    public Unit removeOne() {
        --this.count;
        return this.unit;
    }

    public void setCount(int newCount) {
        if (newCount < 0) {
            throw new IllegalArgumentException("UnitStacks can not have a negative count");
        }
        this.count = newCount;
    }

    public Player getOwner() {
        return this.unit.getOwner();
    }

    public Team getTeam() {
        return this.unit.getOwner().getTeam();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public boolean isOfType(Unit u) {
        return u.getType() == this.unit.getType();
    }

    public String getImageFilename() {
        return this.unit.getImageFilename();
    }

    public int getWidth() {
        return this.unit.getWidth();
    }

    public int getHeight() {
        return this.unit.getHeight();
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public Rectangle getBounds() {
        return new Rectangle(this.drawPoint, this.getDimension());
    }

    public void drawCenteredAtWithBubble(Graphics2D g, Point point, String theme) {
        Point topLeft = new Point(point.x - this.getWidth() / 2, point.y - this.getHeight() / 2);
        this.drawAt(g, topLeft, theme);
        if (!this.getUnit().isFort() && !this.getUnit().isCastle()) {
            this.drawBubbleNumber(g, topLeft.x + this.unit.getNumberOffsetX(), topLeft.y + this.unit.getNumberOffsetY());
        }
    }

    public void draw(Graphics2D g, String theme) {
        this.drawAt(g, this.drawPoint, theme);
    }

    public void drawAt(Graphics2D g, Point point, String theme) {
        if (point == null) {
            SS.debug("XX UnitStack.drawAt() was called with a null point ?? " + this.drawPoint);
            return;
        }
        Color paintColor = this.getOwner().getColor();
        if (this.excited) {
            paintColor = Color.WHITE;
            paintColor = GraphicsTool.getContrastingBase(this.getOwner().getColor(), 0.85f);
        }
        g.drawImage(GraphicsTool.getManagedImage("Themes/" + theme + "/" + this.getImageFilename()), point.x, point.y, this.getWidth(), this.getHeight(), null);
        g.drawImage(GraphicsTool.getManagedImageColored("Themes/" + theme + "/" + this.getImageFilename(), paintColor, 0.3f), point.x, point.y, this.getWidth(), this.getHeight(), null);
    }

    public void drawBubbleNumber(Graphics2D g) {
        this.drawBubbleNumber(g, this.drawPoint.x + this.unit.getNumberOffsetX(), this.drawPoint.y + this.unit.getNumberOffsetY());
    }

    public void drawBubbleNumber(Graphics2D g, int x, int y) {
        g.drawImage(GraphicsTool.getBubbleFor(this.count, this.getOwner().getColor()), x, y, null);
        g.setColor(GraphicsTool.getContrastingBase(this.getOwner().getColor(), 0.6f));
        int textX = x + 8;
        int textY = y + 14;
        if (this.count < 10) {
            textX = x + 8;
            textY = y + 16;
        } else {
            textX = this.count < 100 ? x + 4 : (this.count < 1000 ? x + 3 : (this.count < 10000 ? x + 5 : (this.count < 100000 ? x + 5 : (this.count < 1000000 ? x + 3 : x + 4))));
        }
        if (this.count < 100000) {
            g.drawString(String.valueOf(this.count), textX, textY);
        } else if (this.count < 10000000) {
            g.drawString(String.valueOf(this.count / 1000) + "k", textX, textY);
        } else {
            g.drawString(String.valueOf(this.count / 1000000) + "M", textX, textY);
        }
    }

    public void drawHalfSizeCentered(Graphics2D g, Point point, String theme) {
        g.drawImage(GraphicsTool.getManagedImageColored("Themes/" + theme + "/" + this.getImageFilename(), this.getOwner().getColor(), 0.3f), point.x - this.getWidth() / 4, point.y - this.getHeight() / 4, this.getWidth() / 2, this.getHeight() / 2, null);
        int x = this.unit.getNumberOffsetX();
        int y = this.unit.getNumberOffsetY();
        if (!this.getUnit().isFort() && !this.getUnit().isCastle()) {
            GraphicsTool.drawBoxedString(g, "" + this.count, point.x + x / 2, point.y + y / 2, 1, 1, this.getOwner().getColor(), Color.BLACK, 1, Color.BLACK);
        }
        if (this.getCarriedUnitCount() > 0) {
            GraphicsTool.drawBoxedString(g, "" + this.getCarriedUnitCount(), point.x + x, point.y + y, 1, 1, this.getOwner().getColor(), Color.BLACK, 1, Color.BLACK);
        }
    }

    public void drawTwoThirdsCentered(Graphics2D g, Point point, String theme) {
        if (point == null) {
            return;
        }
        g.drawImage(GraphicsTool.getManagedImageColored("Themes/" + theme + "/" + this.getImageFilename(), this.getOwner().getColor(), 0.3f), point.x - (int)((double)this.getWidth() * 0.33), point.y - (int)((double)this.getHeight() * 0.33), (int)((double)this.getWidth() * 0.66), (int)((double)this.getHeight() * 0.66), null);
        int x = this.unit.getNumberOffsetX();
        int y = this.unit.getNumberOffsetY();
    }

    public boolean equals(Object other) {
        if (!(other instanceof UnitStack)) {
            return false;
        }
        UnitStack otherUG = (UnitStack)other;
        return this.unit.getOwner().equals(otherUG.unit.getOwner()) && otherUG.isOfType(this.unit) && this.originalCountryID == otherUG.originalCountryID && this.landingCountryID == otherUG.landingCountryID;
    }

    public boolean equalsIgnoringOriginalCountry(Object other) {
        if (!(other instanceof UnitStack)) {
            return false;
        }
        UnitStack otherUG = (UnitStack)other;
        return this.unit.getOwner().equals(otherUG.unit.getOwner()) && otherUG.isOfType(this.unit);
    }

    public String toString() {
        return "<US: " + this.count + " " + this.unit + " owned by " + this.unit.getOwner() + (this.originalCountryID == -1 ? "" : " oCountry: " + this.originalCountryID) + (this.landingCountryID == -1 ? "" : " landingCountry: " + this.landingCountryID) + (this.drawPoint == null ? "" : " dp: " + this.drawPoint.x + "," + this.drawPoint.y) + (this.carriedUnits == null || this.carriedUnits.getTotalUnitCount() == 0 ? "" : " carriedUnits: " + this.carriedUnits) + (this.carriedUnitsAir == null || this.carriedUnitsAir.getTotalUnitCount() == 0 ? "" : " carriedUnitsAir: " + this.carriedUnitsAir) + (this.carriedUnitsMissiles == null || this.carriedUnitsMissiles.getTotalUnitCount() == 0 ? "" : " carriedUnitsMissiles: " + this.carriedUnitsMissiles) + ">";
    }

    public int calculateDiceRollKills(boolean attacking) {
        int unitValue = attacking ? this.unit.getAttack() : this.unit.getDefend();
        int totalUnitStackPower = unitValue * this.count;
        int assuredUnitKills = totalUnitStackPower / 6;
        int nonAssuredRemainer = totalUnitStackPower % 6;
        int unitKills = assuredUnitKills;
        if (SS.rand.nextInt(6) + 1 <= nonAssuredRemainer) {
            ++unitKills;
        }
        return unitKills;
    }

    public UnitStack splitOffGroup(int numberOfUnits) {
        UnitStackGroup carrySplit;
        int takeWeight;
        if (numberOfUnits > this.getCount()) {
            throw new IllegalArgumentException(this + " splitOffGroup does not contain enough units: " + numberOfUnits + " vs " + this.getCount());
        }
        UnitStack result = new UnitStack(this.unit, numberOfUnits);
        if (this.carriedUnits != null && this.carriedUnits.getTotalUnitCount() > 0 && (takeWeight = numberOfUnits * this.unit.transportCapacity()) > 0) {
            carrySplit = this.carriedUnits.takeWeight(takeWeight);
            result.addCarry(carrySplit);
        }
        if (this.carriedUnitsAir != null && this.carriedUnitsAir.getTotalUnitCount() > 0 && (takeWeight = numberOfUnits * this.unit.transportCapacityAir()) > 0) {
            carrySplit = this.carriedUnitsAir.takeWeight(takeWeight);
            result.addCarry(carrySplit);
        }
        if (this.carriedUnitsMissiles != null && this.carriedUnitsMissiles.getTotalUnitCount() > 0 && (takeWeight = numberOfUnits * this.unit.transportCapacityMissiles()) > 0) {
            carrySplit = this.carriedUnitsMissiles.takeWeight(takeWeight);
            result.addCarry(carrySplit);
        }
        this.setCount(this.getCount() - numberOfUnits);
        return result;
    }

    public UnitStackGroup getCarriedUnits() {
        if (this.carriedUnits == null) {
            this.carriedUnits = new UnitStackGroup();
        }
        return this.carriedUnits;
    }

    public UnitStackGroup getCarriedUnitsAir() {
        if (this.carriedUnitsAir == null) {
            this.carriedUnitsAir = new UnitStackGroup();
        }
        return this.carriedUnitsAir;
    }

    public UnitStackGroup getCarriedUnitsMissiles() {
        if (this.carriedUnitsMissiles == null) {
            this.carriedUnitsMissiles = new UnitStackGroup();
        }
        return this.carriedUnitsMissiles;
    }

    public int getCarriedUnitCount() {
        return this.carriedUnits == null ? 0 : this.carriedUnits.getTotalUnitCount();
    }

    public int getCarriedUnitCountAir() {
        return this.carriedUnitsAir == null ? 0 : this.carriedUnitsAir.getTotalUnitCount();
    }

    public int getCarriedUnitCountMissiles() {
        return this.carriedUnitsMissiles == null ? 0 : this.carriedUnitsMissiles.getTotalUnitCount();
    }

    public int getRemainingCarryCapacity() {
        return this.unit.transportCapacity() * this.count - (this.carriedUnits == null ? 0 : this.carriedUnits.getTransportWeight());
    }

    public int getRemainingCarryCapacityAir() {
        return this.unit.transportCapacityAir() * this.count - (this.carriedUnitsAir == null ? 0 : this.carriedUnitsAir.getTransportWeight());
    }

    public int getRemainingCarryCapacityMissiles() {
        return this.unit.transportCapacityMissiles() * this.count - (this.carriedUnitsMissiles == null ? 0 : this.carriedUnitsMissiles.getTransportWeight());
    }

    public void addCarry(UnitStack carry) {
        if (carry.expiresAfterAttack()) {
            if (this.carriedUnitsMissiles == null) {
                this.carriedUnitsMissiles = new UnitStackGroup();
            }
            this.carriedUnitsMissiles.add(carry);
            return;
        }
        if (carry.getUnit().isAir()) {
            if (this.carriedUnitsAir == null) {
                this.carriedUnitsAir = new UnitStackGroup();
            }
            this.carriedUnitsAir.add(carry);
            return;
        }
        if (this.carriedUnits == null) {
            this.carriedUnits = new UnitStackGroup();
        }
        this.carriedUnits.add(carry);
    }

    public void addCarry(UnitStackGroup carryList) {
        for (int i = 0; i < carryList.size(); ++i) {
            this.addCarry(carryList.get(i));
        }
    }

    public void removeCarry() {
        this.carriedUnits = null;
    }

    public void removeCarryAir() {
        this.carriedUnitsAir = null;
    }

    public void removeCarry(UnitStack carry) {
        for (int i = 0; i < this.carriedUnits.size(); ++i) {
            if (!carry.equals(this.carriedUnits.get(i))) continue;
            UnitStack group = this.carriedUnits.get(i);
            group.setCount(group.getCount() - carry.getCount());
            if (group.getCount() == 0) {
                this.carriedUnits.remove(group);
            }
            return;
        }
        throw new IllegalArgumentException("UnitStack.removeCarry did not find the unit to remove");
    }

    protected Object clone() {
        UnitStack result = new UnitStack(this.getUnit(), this.getCount(), this.getOriginalCountryID(), (UnitStackGroup)this.getCarriedUnits().clone(), this.carriedUnitsAir == null ? null : (UnitStackGroup)this.carriedUnitsAir.clone(), this.carriedUnitsMissiles == null ? null : (UnitStackGroup)this.carriedUnitsMissiles.clone());
        if (this.drawPoint != null) {
            result.drawPoint = (Point)this.drawPoint.clone();
        }
        return result;
    }

    public int getCost() {
        return this.getUnit().getCost() * this.getCount();
    }

    public boolean isAir() {
        return this.unit.isAir();
    }

    public boolean isWater() {
        return this.unit.isWater();
    }

    public int getMovement() {
        return this.unit.getMovement();
    }

    public int getAttackMovement() {
        return this.unit.getAttackMovement();
    }

    public boolean expiresAfterAttack() {
        return this.unit.expiresAfterAttack();
    }

    public void setExcited(boolean b) {
        this.excited = b;
    }

    public boolean containsPoint(Point p) {
        return new Rectangle(this.getDrawPoint(), this.getDimension()).contains(p);
    }

    public int getUnitAttack() {
        return this.unit.getAttack();
    }

    public int getUnitDefend() {
        return this.unit.getDefend();
    }
}

