/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.jidesoft.chart.axis.Axis;
import com.jidesoft.chart.axis.AxisPlacement;
import com.jidesoft.chart.model.ChartModel;
import com.jidesoft.chart.model.ChartPoint;
import com.jidesoft.chart.model.Chartable;
import com.jidesoft.chart.model.DefaultChartModel;
import com.jidesoft.chart.style.ChartStyle;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.vox.SSJideChart;
import com.sillysoft.vox.StatsHistory;
import com.sillysoft.vox.VoxClient;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;

public class StatsHistoryChart
extends JPanel {
    public StatsHistoryChart(VoxClient vc, StatsHistory history) {
        super(new BorderLayout());
        SSJideChart jideChart = new SSJideChart(vc.visuals);
        this.setPreferredSize(new Dimension(500, 500));
        NumericRange yRange = new NumericRange(0.0, (double)history.highY);
        NumericRange xRange = new NumericRange(0.0, (double)(history.values.size() - 1));
        Axis xAxis = new Axis((Range)xRange);
        Axis yAxis = new Axis((Range)yRange);
        yAxis.setPlacement(AxisPlacement.FLOATING);
        xAxis.setPlacement(AxisPlacement.FLOATING);
        yAxis.setTicksVisible(false);
        for (int j = 0; j < history.numPlayers; ++j) {
            DefaultChartModel pModel = new DefaultChartModel();
            for (int r = 0; r < history.values.size(); ++r) {
                int v = ((int[])history.values.get(r))[j];
                ChartPoint p = new ChartPoint((double)r, (double)v);
                pModel.addPoint((Chartable)p);
            }
            ChartStyle pStyle = new ChartStyle(vc.getPlayer(j).getColor());
            pStyle.setLineStroke(new BasicStroke(3.0f, 1, 1));
            jideChart.addModel((ChartModel)pModel, pStyle);
        }
        jideChart.setAntiAliasing(true);
        jideChart.setHighQuality(true);
        jideChart.setHorizontalGridLinesVisible(false);
        jideChart.setVerticalGridLinesVisible(false);
        jideChart.setShadowVisible(true);
        jideChart.setXAxis(xAxis);
        jideChart.setYAxis(yAxis);
        jideChart.setChartBackground(GraphicsTool.TRANSPARENT);
        jideChart.setOpaque(false);
        jideChart.setToolTipText("chart tooltip");
        this.setOpaque(false);
        this.add((Component)((Object)jideChart), "Center");
    }

    public static void main(String[] args) {
    }
}

