/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.Stats;
import com.sillysoft.vox.StatsHistoryChart;
import com.sillysoft.vox.VoxClient;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class StatsHistory
implements XMLSerializable {
    int numPlayers;
    List values;
    int highY = 100;
    public String gameOverText;
    public String winningTeamName;

    public void addRound(int numPlayers, Stats stats) {
        this.numPlayers = numPlayers;
        int[] roundValues = new int[numPlayers];
        for (int j = 0; j < numPlayers; ++j) {
            roundValues[j] = stats.getArmies(j) + stats.getOwned(j) + stats.getIncome(j);
        }
        if (this.values == null) {
            this.values = new ArrayList();
        }
        this.values.add(roundValues);
    }

    public String getEndText() {
        return this.gameOverText;
    }

    public String toStringXML() {
        String gameOverExport;
        if (this.values == null) {
            this.values = new ArrayList();
        }
        if ((gameOverExport = this.gameOverText) != null) {
            gameOverExport = this.gameOverText.replaceAll("\"", "&quot;");
        }
        StringBuffer buf = new StringBuffer("<StatsHistory numPlayers=\"" + this.numPlayers + "\" winningTeamName=\"" + this.winningTeamName + "\" gameOverText=\"" + gameOverExport + "\" >");
        for (int j = 0; j < this.values.size(); ++j) {
            int[] roundValues = (int[])this.values.get(j);
            buf.append("<round number=\"" + j + "\" ");
            for (int k = 0; k < roundValues.length; ++k) {
                buf.append("p" + k + "=\"" + roundValues[k] + "\" ");
            }
            buf.append("/>");
        }
        buf.append("</StatsHistory>");
        return buf.toString();
    }

    public StatsHistory() {
    }

    public StatsHistory(String XML) {
        SS.debug("Create StatsHistory from XML " + XML, 1);
        try {
            this.numPlayers = Integer.parseInt(XMLTool.extractAttribute("numPlayers", XML));
            this.gameOverText = XMLTool.extractAttribute("gameOverText", XML);
            this.gameOverText = URLDecoder.decode(this.gameOverText, "UTF-8");
            this.gameOverText = this.gameOverText.replaceAll("```", "\n");
            this.winningTeamName = XMLTool.extractAttribute("winningTeamName", XML);
            this.values = new ArrayList();
            String item = XMLTool.extractContained("round", XML, 0);
            int h = 1;
            while (item != null) {
                int[] roundValues = new int[this.numPlayers];
                for (int j = 0; j < roundValues.length; ++j) {
                    roundValues[j] = Integer.parseInt(XMLTool.extractAttribute("p" + j, item));
                    this.highY = Math.max(this.highY, roundValues[j]);
                }
                this.values.add(roundValues);
                item = XMLTool.extractContained("round", XML, h);
                ++h;
            }
        }
        catch (Exception e) {
            SS.debug("Error creating StatsHistory from XML: " + XML);
            e.printStackTrace();
        }
    }

    public StatsHistoryChart getChart(VoxClient vc) {
        try {
            return new StatsHistoryChart(vc, this);
        }
        catch (Throwable t) {
            SS.debug("charting error: " + t);
            return null;
        }
    }
}

