/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.SS;
import com.sillysoft.vox.Continent;
import com.sillysoft.vox.CountriesManager;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.UnitStackGroup;
import java.util.List;

public class Stats {
    CountriesManager control;
    private boolean armiesDirty;
    private boolean ownedDirty;
    private boolean incomesDirty;
    private int[] armies;
    private int[] owned;
    private int[] incomes;
    private long turnTimerStart = -1L;

    public Stats(CountriesManager control, int numberOfPlayers) {
        this.control = control;
        int players = numberOfPlayers;
        this.armiesDirty = true;
        this.ownedDirty = true;
        this.incomesDirty = true;
        this.armies = new int[players];
        this.owned = new int[players];
        this.incomes = new int[players];
    }

    public synchronized void setCountryOwner(int countryCode, int ownerCode) {
        this.ownedDirty = true;
        this.incomesDirty = true;
        if (ownerCode == -1) {
            return;
        }
        this.armiesDirty = true;
    }

    public synchronized void setCountryArmies(int countryCode, int armies) {
        int owner = -1;
        if (owner != -1) {
            this.armiesDirty = true;
        }
    }

    public void gameOver(String endText) {
    }

    public void selectCountry(int code) {
    }

    public void explode(int code) {
    }

    public synchronized int getArmies(int player) {
        if (this.armiesDirty) {
            for (int p = 0; p < this.armies.length; ++p) {
                this.armies[p] = 0;
            }
            List countries = this.control.getCountries();
            for (int i = 0; i < countries.size(); ++i) {
                UnitStackGroup ugs = ((Country)countries.get(i)).getUnitStackGroup();
                for (int u = 0; u < ugs.size(); ++u) {
                    int owner = ugs.get(u).getOwner().getID();
                    if (owner == -1 || owner >= this.armies.length) continue;
                    int n = owner;
                    this.armies[n] = this.armies[n] + ugs.get(u).getCost();
                }
            }
            for (int p = 0; p < this.armies.length; ++p) {
                int n = p;
                this.armies[n] = this.armies[n] + this.control.getWorld().getArmyCountMoving(p);
            }
            this.armiesDirty = false;
        }
        if (player < 0 || player > this.armies.length) {
            Thread.dumpStack();
            SS.debug("Stats.getArmies() Bad Index: " + player);
            return 0;
        }
        return this.armies[player];
    }

    public synchronized int getOwned(int player) {
        if (this.ownedDirty) {
            this.countOwned();
        }
        return this.owned[player];
    }

    private void countOwned() {
        try {
            this.ownedDirty = true;
            for (int p = 0; p < this.owned.length; ++p) {
                this.owned[p] = 0;
            }
            List countries = this.control.getCountries();
            for (int i = 0; i < countries.size(); ++i) {
                int owner = ((Country)countries.get(i)).getOwner().getID();
                if (owner == -1 || owner >= this.owned.length) continue;
                int n = owner;
                this.owned[n] = this.owned[n] + 1;
            }
            this.ownedDirty = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized int getIncome(int player) {
        if (this.incomesDirty) {
            if (this.ownedDirty) {
                this.countOwned();
            }
            try {
                for (int p = 0; p < this.incomes.length; ++p) {
                    this.incomes[p] = 0;
                }
                List countries = this.control.getCountries();
                for (int i = 0; i < countries.size(); ++i) {
                    int owner = ((Country)countries.get(i)).getOwner().getID();
                    int bonus = ((Country)countries.get(i)).getBonus();
                    if (owner == -1 || owner >= this.incomes.length) continue;
                    int n = owner;
                    this.incomes[n] = this.incomes[n] + bonus;
                }
                List continents = this.control.getContinents();
                for (int i = 0; i < continents.size(); ++i) {
                    Continent cont = (Continent)continents.get(i);
                    Team owner = cont.getTeamOwner(countries);
                    if (owner == null || cont.getBonus() == 0) continue;
                    int[] countriesOwnedPerPlayer = new int[this.incomes.length];
                    int contSize = 0;
                    for (int c = 0; c < countries.size(); ++c) {
                        Country cc = (Country)countries.get(c);
                        if (cc.getContinentID() != cont.getID()) continue;
                        int ID = cc.getOwner().getID();
                        if (ID != -1) {
                            int n = ID;
                            countriesOwnedPerPlayer[n] = countriesOwnedPerPlayer[n] + 1;
                        }
                        ++contSize;
                    }
                    int incomeGivenForCont = 0;
                    for (int p = 0; p < this.incomes.length; ++p) {
                        if (countriesOwnedPerPlayer[p] <= 0) continue;
                        int partialIncome = (int)Math.round((double)(countriesOwnedPerPlayer[p] * cont.getBonus()) * 1.0 / (double)contSize);
                        int n = p;
                        this.incomes[n] = this.incomes[n] + partialIncome;
                        incomeGivenForCont += partialIncome;
                    }
                    if (incomeGivenForCont >= cont.getBonus()) continue;
                    SS.debug("Team-owned continent " + cont.getName() + " did not give out full income (due to rounding). Gave " + incomeGivenForCont + "/" + cont.getBonus());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            for (int p = 0; p < this.incomes.length; ++p) {
                this.incomes[p] = Math.max(this.incomes[p], 0);
            }
            this.incomesDirty = false;
        }
        return this.incomes[player];
    }

    public synchronized int getCards(int player) {
        if (player < 0) {
            return 0;
        }
        return 0;
    }

    public void kill() {
        this.control = null;
        this.owned = null;
        this.armies = null;
        this.incomes = null;
    }

    public void recalculate() {
        this.armiesDirty = true;
        this.ownedDirty = true;
        this.incomesDirty = true;
    }

    public void reset() {
    }

    public void dirtyIncomes() {
        this.incomesDirty = true;
    }

    public void dirtyArmies(int player) {
        this.armiesDirty = true;
    }

    public long getTurnTimerStart() {
        return this.turnTimerStart;
    }

    public int getLargestPlayer() {
        int largestArmies = 0;
        int largestPlayerID = -1;
        for (int i = 0; i < this.armies.length; ++i) {
            if (this.getArmies(i) <= largestArmies) continue;
            largestPlayerID = i;
            largestArmies = this.getArmies(i);
        }
        return largestPlayerID;
    }
}

