/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitStack;
import com.sillysoft.vox.UnitStackGroup;
import com.sillysoft.vox.Visuals;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.widgets.MultiLineToolTip;
import com.sillysoft.widgets.SSButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;

public class RecruitPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    JLabel moneyLeftLabel;
    SSButton undoButton;
    VoxClient control;
    UnitStackGroup boughtUnits;
    Player player;
    public static int LEAST_COST = 3;
    public static final float TRANSPARENT_PERCENT = 0.8f;
    UnitPanel[] unitPanels;
    protected UnitPanel activeUnitPanel = null;
    private Point lastMousePressedAt;
    private Point lastMouseMovedAt;
    private Random rand = new Random();

    public RecruitPanel(VoxClient control) {
        this.setBackground(GraphicsTool.transparent(Color.WHITE, 0.8f));
        this.control = control;
        this.player = control.getPlayer(control.getGuiOwner());
        List units = control.getGuiWorld().getBuyableUnitsForPlayer(this.player);
        LEAST_COST = ((Unit)units.get(0)).getCost();
        JPanel unitsPanel = GraphicsTool.getNonOpaqueJPanel();
        unitsPanel.setLayout(new FlowLayout(0, 0, 0));
        this.unitPanels = new UnitPanel[units.size()];
        for (int i = 0; i < units.size(); ++i) {
            this.unitPanels[i] = new UnitPanel((Unit)units.get(i), this);
            unitsPanel.add(this.unitPanels[i]);
        }
        this.unitPanels[0].setToolTipText("Pawns cost 3. \nBetter at defending.");
        this.unitPanels[1].setToolTipText("Knights cost 5. \nMoves 2. Much better on attack.");
        this.unitPanels[2].setToolTipText("Castles cost 80. \nRecruit units and epic defence.");
        this.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 2));
        this.setLayout(new BoxLayout(this, 1));
        this.add(unitsPanel);
        JPanel lowerPanel = GraphicsTool.getNonOpaqueJPanel();
        lowerPanel.setToolTipText("Recruit new units onto your Castles");
        lowerPanel.setLayout(new BoxLayout(lowerPanel, 1));
        lowerPanel.setBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1));
        this.moneyLeftLabel = new JLabel(control.getGuiWorld().getPlayerMoney(this.player) + " Gold");
        this.moneyLeftLabel.setOpaque(false);
        this.moneyLeftLabel.setAlignmentX(0.5f);
        lowerPanel.add(this.moneyLeftLabel);
        JPanel buttonRow = GraphicsTool.getNonOpaqueJPanel(new FlowLayout(1, 0, 0));
        this.undoButton = new SSButton(Translator.getString("Undo"));
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RecruitPanel.this.undoAllBuilds(RecruitPanel.this.player);
            }
        });
        this.undoButton.setBackground(GraphicsTool.TRANSPARENT);
        this.undoButton.setOpaque(false);
        this.undoButton.setFocusable(false);
        buttonRow.add(this.undoButton);
        SSButton button = new SSButton(Translator.getString("Hide"));
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                RecruitPanel.this.doneBuying();
            }
        });
        button.setBackground(GraphicsTool.TRANSPARENT);
        button.setOpaque(false);
        button.setFocusable(false);
        buttonRow.add(button);
        lowerPanel.add(buttonRow);
        this.add(lowerPanel);
        this.debug("new RecruitPanel");
        this.setSize(this.getPreferredSize());
    }

    public boolean clickedOnUnit(Unit u) {
        if (u.getCost() > this.control.getGuiWorld().getPlayerMoney(this.player)) {
            VoxClient.invalidSound.play();
            return false;
        }
        VoxClient.clickSound.play();
        int number = this.control.getGuiWorld().getPlayerMoney(this.player) / u.getCost();
        if (u.isFort() || u.isCastle()) {
            number = 1;
        }
        UnitStack placer = new UnitStack(u, number);
        this.control.visuals.setPlacerUnits(placer);
        return true;
    }

    public void updateMoney() {
        int moneyLeft = this.control.getGuiWorld().getPlayerMoney(this.player);
        SS.debug("RecruitPanel.updateMoney: " + moneyLeft, 1);
        this.moneyLeftLabel.setText(Translator.getString("Recruitwith") + " " + moneyLeft + " " + Translator.getString("Gold"));
        for (int i = 0; i < this.unitPanels.length; ++i) {
            this.unitPanels[i].setGrey(moneyLeft < this.unitPanels[i].unit.getCost());
        }
        if (moneyLeft < LEAST_COST) {
            this.doneBuying();
        }
        this.undoButton.setEnabled(this.control.getGuiWorld().hasBuildCommands());
    }

    public void doneBuying() {
        this.clearActiveUnitPanel();
        this.boughtUnits = null;
        this.control.doneBuying();
    }

    public void clearActiveUnitPanel() {
        if (this.activeUnitPanel != null) {
            this.activeUnitPanel.red = false;
            this.activeUnitPanel.repaint();
        }
    }

    public void undoAllBuilds(Player player) {
        this.control.getGuiWorld().undoAllBuilds(player);
        this.control.visuals.repaint();
        this.control.commandUndone();
        this.undoButton.setEnabled(false);
        Unit u = this.activeUnitPanel.unit;
        int number = this.control.getGuiWorld().getPlayerMoney(player) / u.getCost();
        if (u.isFort() || u.isCastle()) {
            number = 1;
        }
        UnitStack placer = new UnitStack(u, number);
        this.control.visuals.setPlacerUnits(placer);
    }

    public void mousePressed(MouseEvent e) {
        this.debug("mousePressed");
        this.lastMousePressedAt = e.getPoint();
        this.repaint();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        SS.debug("mouse entered visuals buying");
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public boolean isFocusable() {
        return true;
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public String toString() {
        return "<RecruitPanel>";
    }

    private void debug(Object output) {
        System.out.println(this + ": " + output);
    }

    private class UnitPanel
    extends JPanel {
        protected Unit unit;
        protected boolean grey = false;
        protected boolean red = false;
        protected RecruitPanel vb;

        public UnitPanel(Unit u, RecruitPanel vb) {
            this.vb = vb;
            this.unit = u;
            this.setOpaque(false);
            this.setLayout(new BorderLayout());
            JPanel textPanel = GraphicsTool.getNonOpaqueJPanel();
            textPanel.setLayout(new BoxLayout(textPanel, 1));
            final Unit finalu = u;
            JLabel title = GraphicsTool.getJLabelWithFont(u.toString(), Visuals.sansSerifBold12);
            title.setAlignmentX(0.5f);
            textPanel.add(title);
            JPanel imagePanel = GraphicsTool.getNonOpaqueJPanel();
            imagePanel.add(new JLabel(this.scale50(GraphicsTool.getManagedImageColored("Themes/" + RecruitPanel.this.control.visuals.currentTheme + "/" + u.getImageFilename(), RecruitPanel.this.player.getColor(), 0.3f))));
            imagePanel.setPreferredSize(new Dimension(u.getWidth(), u.getHeight()));
            this.add((Component)textPanel, "North");
            this.add((Component)imagePanel, "Center");
            final RecruitPanel vbf = vb;
            this.addMouseListener(new MouseListener(){

                public void mousePressed(MouseEvent e) {
                    if (RecruitPanel.this.clickedOnUnit(finalu)) {
                        vbf.clearActiveUnitPanel();
                        UnitPanel.this.activate();
                    }
                }

                public void mouseClicked(MouseEvent e) {
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                }

                public void mouseExited(MouseEvent e) {
                }
            });
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.DARK_GRAY, 1), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.setMinimumSize(new Dimension(118, 90));
            this.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 90));
        }

        private ImageIcon scale50(Image src) {
            int w = 50;
            int h = 50;
            int type = 2;
            BufferedImage dst = new BufferedImage(w, h, type);
            Graphics2D g2 = dst.createGraphics();
            g2.drawImage(src, 0, 0, w, h, this);
            g2.dispose();
            return new ImageIcon(dst);
        }

        public JToolTip createToolTip() {
            MultiLineToolTip tip = new MultiLineToolTip();
            tip.setComponent(this);
            return tip;
        }

        protected void setGrey(boolean b) {
            this.grey = b;
            if (this.grey) {
                this.red = false;
            }
            this.repaint();
        }

        public void paintChildren(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.red) {
                g.setColor(new Color(0.8f, 0.0f, 0.0f, 0.8f));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            super.paintChildren(g1);
            if (this.grey) {
                g.setColor(GraphicsTool.transparent(Color.DARK_GRAY, 0.8f));
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public void paintComponent(Graphics g1) {
            Graphics2D g = (Graphics2D)g1;
            g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paintComponent(g1);
        }

        public void activate() {
            this.vb.activeUnitPanel = this;
            this.red = true;
            this.repaint();
        }
    }
}

