/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.lux.gui.MarketingScreen;
import com.sillysoft.tools.ArrayTool;
import com.sillysoft.tools.Prefs;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxGUI;
import com.sillysoft.widgets.MusicEngine;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSBindingControlManager;
import com.sillysoft.widgets.SSCheckBoxBinding;
import com.sillysoft.widgets.SSComboBox;
import com.sillysoft.widgets.SSFrame;
import com.sillysoft.widgets.SSOptionPane;
import com.sillysoft.widgets.SSSlider;
import com.sillysoft.widgets.SSTextField;
import com.sillysoft.widgets.SoundEffect;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PreferencesWindowVox {
    private static PreferencesWindowVox instance = null;
    private SSFrame window;
    private SSCheckBoxBinding useSounds;
    private SSCheckBoxBinding allowNetworkPlayers;
    private SSCheckBoxBinding internetPublic;
    private SSCheckBoxBinding turnTimerSwitch;
    SSSlider gameSpeed;
    SSSlider volume;
    SSSlider soundVolume;
    SSTextField turnTime;
    private SSComboBox languageChoice;
    final Object[] languages = new Object[]{"Deutsch", "English"};
    final String[] languageCodes = new String[]{"de", "en"};

    public static void show() {
        if (instance == null) {
            instance = new PreferencesWindowVox();
        }
        instance.showFrame();
    }

    public void showFrame() {
        this.window.show();
    }

    public PreferencesWindowVox() {
        this.window = new SSFrame("Castle Vox " + Translator.getString("Preferences"));
        this.window.setLocationID("Prefs");
        this.window.setResizable(false);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        ActionListener changeActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SSCheckBoxBinding source = (SSCheckBoxBinding)e.getSource();
                source.saveAnyChanges();
                PreferencesWindowVox.this.internetPublic.setEnabled(PreferencesWindowVox.this.allowNetworkPlayers.isSelected());
                if (VoxGUI.getInstance().isDemo() && PreferencesWindowVox.this.internetPublic.isSelected()) {
                    PreferencesWindowVox.this.internetPublic.setSelected(false);
                    Prefs.putBoolean("internetPublic", false);
                    MarketingScreen.show("online_vox", "internetPublic", true, SSApp.getInstance());
                }
                if (!Prefs.getBoolean("playMusic", true)) {
                    MusicEngine.fadeOutMusic();
                } else if (!MusicEngine.isMusicPlaying()) {
                    MusicEngine.startTrackSequence(VoxClient.musicSequenceForMap(Prefs.get("mapSelector", "Tutorial Map")));
                }
            }
        };
        this.volume = new SSSlider(0, 140, Prefs.getInt("musicVolume", 70));
        this.volume.setMajorTickSpacing(35);
        this.volume.setMinorTickSpacing(7);
        this.volume.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel sideLabel = new JLabel(Translator.getString("off"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volume.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("loud"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.volume.getMaximum()), sideLabel);
        this.volume.setLabelTable(labelTable);
        this.volume.setPaintLabels(true);
        this.volume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Prefs.putInt("musicVolume", PreferencesWindowVox.this.volume.getValue());
                System.out.println("volume = " + PreferencesWindowVox.this.volume.getValue());
                MusicEngine.setVolume();
            }
        });
        JPanel spacerPanel = new JPanel();
        spacerPanel.add(this.volume);
        panel.add(new JLabel("  " + Translator.getString("Musicvolume") + ":"));
        panel.add(spacerPanel);
        this.soundVolume = new SSSlider(0, 200, Prefs.getInt("soundVolume", 100));
        this.soundVolume.setMajorTickSpacing(50);
        this.soundVolume.setMinorTickSpacing(10);
        this.soundVolume.setPaintTicks(true);
        labelTable = new Hashtable();
        sideLabel = new JLabel(Translator.getString("off"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.soundVolume.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("loud"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.soundVolume.getMaximum()), sideLabel);
        this.soundVolume.setLabelTable(labelTable);
        this.soundVolume.setPaintLabels(true);
        this.soundVolume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SS.debug("Set sound effect volume to be " + (double)PreferencesWindowVox.this.soundVolume.getValue() / 100.0);
                Prefs.putInt("soundVolume", PreferencesWindowVox.this.soundVolume.getValue());
                SoundEffect.setSoundVolume((double)PreferencesWindowVox.this.soundVolume.getValue() / 100.0);
            }
        });
        spacerPanel = new JPanel();
        spacerPanel.add(this.soundVolume);
        panel.add(new JLabel("  " + Translator.getString("Soundsvolume") + ":"));
        panel.add(spacerPanel);
        this.languageChoice = new SSComboBox(this.languages);
        this.languageChoice.setMaximumRowCount(25);
        ActionListener localeActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!Prefs.get("locale", "unknown").equals(PreferencesWindowVox.this.languageCodes[PreferencesWindowVox.this.languageChoice.getSelectedIndex()])) {
                    Prefs.put("locale", PreferencesWindowVox.this.languageCodes[PreferencesWindowVox.this.languageChoice.getSelectedIndex()]);
                    String translatedWarning = Translator.getString("Youmustrestart", PreferencesWindowVox.this.languageCodes[PreferencesWindowVox.this.languageChoice.getSelectedIndex()]);
                    String englishWarning = Translator.getString("Youmustrestart", "en");
                    String warning = englishWarning.equals(translatedWarning) ? translatedWarning : translatedWarning + "\n\n" + englishWarning;
                    SSOptionPane.showMessageDialog(PreferencesWindowVox.this.window, (Object)warning);
                }
            }
        };
        this.languageChoice.addActionListener(localeActionListener);
        JPanel languagePanel = new JPanel();
        languagePanel.setLayout(new BoxLayout(languagePanel, 0));
        languagePanel.add(new JLabel("  " + Translator.getString("Language") + ":"));
        languagePanel.add(new JLabel(" "));
        languagePanel.add(this.languageChoice);
        languagePanel.add(new JLabel("                        "));
        languagePanel.setAlignmentX(0.0f);
        panel.add(languagePanel);
        panel.add(new JLabel(" "));
        if (Prefs.get("locale", null) == null) {
            String defaultLanguage = Locale.getDefault().getLanguage();
            int langIndex = ArrayTool.arrayIndex(this.languageCodes, defaultLanguage);
            if (langIndex == -1) {
                Prefs.put("locale", "en");
                this.languageChoice.setSelectedItem("English");
            } else {
                Prefs.put("locale", this.languageCodes[langIndex]);
                this.languageChoice.setSelectedItem(this.languages[langIndex]);
            }
        } else {
            int languageIndex = ArrayTool.arrayIndex(this.languageCodes, Prefs.get("locale", "en"));
            if (languageIndex == -1) {
                languageIndex = ArrayTool.arrayIndex(this.languageCodes, "en");
            }
            this.languageChoice.setSelectedItem(this.languages[languageIndex]);
        }
        SSCheckBoxBinding checkBox = new SSCheckBoxBinding(Translator.getString("Autoshrinklargemaps"), "autoShrink", true);
        checkBox.addActionListener(changeActionListener);
        panel.add(checkBox);
        checkBox = new SSCheckBoxBinding(Translator.getString("Autogrowmaps"), "autoGrow", false);
        checkBox.addActionListener(changeActionListener);
        panel.add(checkBox);
        checkBox = new SSCheckBoxBinding(Translator.getString("recruitpanelatstart"), "showRecruits", false);
        checkBox.addActionListener(changeActionListener);
        panel.add(checkBox);
        panel.add(new JLabel(" "));
        this.allowNetworkPlayers = new SSCheckBoxBinding(Translator.getString("AllowNetworkPlayers"), "allowNetworkPlayers", false);
        this.allowNetworkPlayers.addActionListener(changeActionListener);
        panel.add(this.allowNetworkPlayers);
        this.internetPublic = new SSCheckBoxBinding(Translator.getString("InternetPublic"), "internetPublic", false);
        this.internetPublic.addActionListener(changeActionListener);
        panel.add(this.internetPublic);
        this.internetPublic.setEnabled(Prefs.getBoolean("allowNetworkPlayers", false));
        panel.add(new JLabel(" "));
        this.turnTimerSwitch = new SSCheckBoxBinding(Translator.getString("Turntimelimitof") + " ", "turnTimer", false);
        this.turnTimerSwitch.addActionListener(changeActionListener);
        this.turnTimerSwitch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PreferencesWindowVox.this.turnTime.setEnabled(((SSCheckBoxBinding)e.getSource()).isSelected());
            }
        });
        this.turnTime = new SSTextField(4);
        this.turnTime.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                float timeMinutes = 2.0f;
                int timeSeconds = 120;
                try {
                    timeMinutes = Float.parseFloat(PreferencesWindowVox.this.turnTime.getText());
                    timeSeconds = (int)(timeMinutes * 60.0f);
                    int minTurnTime = 15;
                    timeSeconds = Math.max(timeSeconds, minTurnTime);
                }
                catch (NumberFormatException ex) {
                    System.out.println("Error: couldn't parse turn time");
                }
                Prefs.putInt("turnTimerSeconds", timeSeconds);
                System.out.println("Turn Timer in Seconds = " + timeSeconds);
            }
        });
        JPanel timerPanel = new JPanel();
        timerPanel.setLayout(new BoxLayout(timerPanel, 0));
        timerPanel.add(this.turnTimerSwitch);
        JPanel textSpacer = new JPanel(new FlowLayout());
        textSpacer.add(this.turnTime);
        textSpacer.setMaximumSize(new Dimension(70, 100));
        timerPanel.add(textSpacer);
        timerPanel.add(new JLabel(Translator.getString("minutes")));
        timerPanel.setAlignmentX(0.0f);
        panel.add(timerPanel);
        this.gameSpeed = new SSSlider(0, 1010, Prefs.getInt("battleDelay", 757));
        this.gameSpeed.setMajorTickSpacing(250);
        this.gameSpeed.setMinorTickSpacing(50);
        this.gameSpeed.setPaintTicks(true);
        labelTable = new Hashtable();
        sideLabel = new JLabel(Translator.getString("fast"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.gameSpeed.getMinimum()), sideLabel);
        sideLabel = new JLabel(Translator.getString("slow"));
        sideLabel.setFont(new Font(sideLabel.getFont().getName(), 0, sideLabel.getFont().getSize() - 2));
        labelTable.put(new Integer(this.gameSpeed.getMaximum()), sideLabel);
        this.gameSpeed.setLabelTable(labelTable);
        this.gameSpeed.setPaintLabels(true);
        this.gameSpeed.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Prefs.putInt("battleDelay", PreferencesWindowVox.this.gameSpeed.getValue());
                System.out.println("game speed = " + PreferencesWindowVox.this.gameSpeed.getValue());
            }
        });
        spacerPanel = new JPanel();
        spacerPanel.add(this.gameSpeed);
        panel.add(new JLabel("  " + Translator.getString("Battlespeed") + ":"));
        panel.add(spacerPanel);
        SSBindingControlManager.loadValues();
        String turnTimeString = "" + (float)Prefs.getInt("turnTimerSeconds", 120) / 60.0f;
        if (turnTimeString.endsWith(".0")) {
            turnTimeString = turnTimeString.substring(0, turnTimeString.length() - 2);
        }
        this.turnTime.setText(turnTimeString);
        this.turnTime.setEnabled(this.turnTimerSwitch.isSelected());
        if (SS.isMacintosh) {
            this.window.setJMenuBar(SSApp.getInstance().makeCommonMenuBar(this.window));
        }
        this.window.setContentPane(panel);
        this.window.pack();
    }
}

