/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.SwingTool;
import com.sillysoft.tools.TableSorter;
import com.sillysoft.tools.Translator;
import com.sillysoft.vox.Vox;
import com.sillysoft.vox.VoxClient;
import com.sillysoft.vox.VoxOptions;
import com.sillysoft.widgets.FitTableColumnsAction;
import com.sillysoft.widgets.HeaderPanel;
import com.sillysoft.widgets.SSTable;
import com.sillysoft.widgets.watermark.WatermarkViewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class PlayerInfoController
extends AbstractTableModel
implements MouseListener,
MouseMotionListener,
ActionListener {
    private int currentPlayer = 0;
    public Vector deadPlayers = new Vector();
    public Vector playingPlayers = new Vector();
    public int alivePlayers = 0;
    public int[] playerPositions;
    VoxClient control;
    VoxOptions options = null;
    SSTable playerTableView;
    JScrollPane scrollpane;
    private TableSorter sorter;
    private int numberRows;
    private String lastMap;
    private Object[] keys = new Object[]{"", Translator.getString("Player"), Translator.getString("Brain"), Translator.getString("Land"), Translator.getString("Army"), Translator.getString("Gain")};
    private Point pressedPoint;
    private int savedContextMenuRow;
    private Point lastMouseDragPoint;
    Color ROW_COLOR_1 = new Color(1.0f, 1.0f, 1.0f, 0.9f);
    Color ROW_COLOR_2 = new Color(1.0f, 1.0f, 1.0f, 0.8f);

    public PlayerInfoController(VoxClient control) {
        this.sorter = new TableSorter("PlayerInfoSortOrder", this);
        this.playerTableView = new SSTable(this.sorter);
        this.sorter.setTableHeader(this.playerTableView.getTableHeader());
        if (this.options != null && control.ops != this.options) {
            this.reset();
            this.options = control.ops;
        }
        this.control = control;
        this.playerTableView.setDefaultRenderer(Object.class, new CustomTableCellRenderer(this, control));
        this.playerTableView.setGridColor(this.ROW_COLOR_1);
        WatermarkViewport viewport = new WatermarkViewport(null, null);
        viewport.setView(this.playerTableView);
        this.scrollpane = new JScrollPane();
        this.scrollpane.setViewport(viewport);
        this.scrollpane.setBorder(null);
        this.scrollpane.setOpaque(false);
        this.playerTableView.setBorder(null);
        this.playerTableView.setOpaque(false);
        this.playerTableView.addMouseListener(this);
        this.playerTableView.addMouseMotionListener(this);
        HeaderPanel panel = new HeaderPanel("pi_header_texture.png", "pi_country.png");
        panel = new HeaderPanel("pi_header_texture.png", "pi_army.png");
        panel = new HeaderPanel("pi_header_texture.png", "pi_income.png");
        this.playerTableView.getTableHeader().revalidate();
    }

    public void show(VoxClient control, boolean userInitiated, boolean forSlaveMode) {
        this.control = control;
        this.numberRows = control.getNumberOfPlayers() - 1;
        SS.debug("PlayerInfoController: show() with numberRows = " + this.numberRows, 1);
        this.reloadTableData();
        int height = SwingTool.TABLE_HEADER_HEIGHT + this.numberRows * this.playerTableView.getRowHeight();
        this.scrollpane.setPreferredSize(new Dimension(460, height));
        this.scrollpane.revalidate();
    }

    boolean isActive() {
        return this.control != null;
    }

    public int getRowCount() {
        return this.numberRows;
    }

    public int getColumnCount() {
        return this.keys.length;
    }

    public Object getValueAt(int row, int col) {
        try {
            int player = row + 1;
            switch (col) {
                case 0: {
                    return "";
                }
                case 1: {
                    return this.control.getPlayer(player).getTeam().getSymbol() + " " + this.control.getPlayer(player).getName();
                }
                case 2: {
                    return this.control.getPlayer(player).getControllerName();
                }
                case 3: {
                    return String.valueOf(this.control.stats.getOwned(player));
                }
                case 4: {
                    return String.valueOf(this.control.stats.getArmies(player));
                }
                case 5: {
                    return String.valueOf(this.control.stats.getIncome(player));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public String getColumnName(int col) {
        return this.keys[col].toString();
    }

    public Class getColumnClass(int columnIndex) {
        try {
            return this.getValueAt(1, columnIndex).getClass();
        }
        catch (Exception e) {
            return Object.class;
        }
    }

    public synchronized void reset() {
        this.deadPlayers = new Vector();
        this.playingPlayers = new Vector();
        this.alivePlayers = 0;
        this.playerPositions = null;
    }

    public synchronized void reloadTableData() {
        try {
            if (this.playerPositions == null) {
                this.playerPositions = new int[this.numberRows];
                for (int i = 0; i < this.playerPositions.length; ++i) {
                    this.playerPositions[i] = 0;
                }
            }
            this.alivePlayers = this.getRowCount() - this.deadPlayers.size();
            int player = 0;
            if (this.deadPlayers.size() > 0) {
                for (int row = this.getRowCount() - 1; row >= 0; --row) {
                    if (this.getRowCount() - row > this.deadPlayers.size()) continue;
                    this.playerPositions[row] = player = ((Integer)this.deadPlayers.get(this.getRowCount() - row - 1)).intValue();
                }
            }
            int offset = 0;
            for (int i = 0; i < this.alivePlayers; ++i) {
                player = (offset + 0) % this.getRowCount();
                while (this.deadPlayers.contains(new Integer(player))) {
                    player = (++offset + 0) % this.getRowCount();
                }
                this.playerPositions[i] = player;
                ++offset;
            }
        }
        catch (Exception e) {
            System.out.println("PI caught a hiccup in reloadTableData: " + e);
        }
        this.fireTableDataChanged();
    }

    void kill() {
        this.playerTableView.setDefaultRenderer(Object.class, null);
        this.playerTableView = null;
        this.control = null;
    }

    public JComponent getViewAndEnterSlaveMode() {
        this.scrollpane.setFocusable(false);
        this.scrollpane.setVerticalScrollBarPolicy(21);
        this.playerTableView.setFocusable(false);
        this.playerTableView.setDragEnabled(false);
        this.playerTableView.setRowSelectionAllowed(false);
        this.playerTableView.setColumnSelectionAllowed(false);
        int useWidth = 300;
        int optimalWidth = this.playerTableView.getOptimalWidth();
        if (optimalWidth > useWidth) {
            useWidth = Math.min(350, optimalWidth);
        }
        SwingUtilities.invokeLater(new FitTableColumnsAction(this.playerTableView, useWidth));
        this.scrollpane.setSize(useWidth + 2, SwingTool.TABLE_HEADER_HEIGHT + 16 * this.numberRows);
        return this.scrollpane;
    }

    public void exitSlaveMode() {
        this.playerTableView.removeMouseListener(this);
        this.playerTableView.removeMouseMotionListener(this);
    }

    public void mousePressed(MouseEvent e) {
        int contextMenuRow2;
        this.lastMouseDragPoint = this.pressedPoint = e.getPoint();
        Point loc_in_parent = this.scrollpane.getLocation();
        this.lastMouseDragPoint.translate(loc_in_parent.x, loc_in_parent.y);
        int contextMenuRow = this.playerTableView.rowAtPoint(e.getPoint());
        this.savedContextMenuRow = contextMenuRow2 = this.getTranslatedRow(contextMenuRow + 1);
        int contextMenuCol = this.playerTableView.columnAtPoint(e.getPoint());
        int contextMenuCol2 = this.playerTableView.convertColumnIndexToModel(contextMenuCol);
        SS.debug("pressed at: " + e.getPoint() + ", parent point is: " + this.lastMouseDragPoint + ", row=" + contextMenuRow2 + ", col=" + contextMenuCol2);
        if ((e.isPopupTrigger() || e.getButton() == 3) && contextMenuCol2 == 2) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Human");
            menuItem.addActionListener(this);
            popup.add(menuItem);
            Object[] bots = Vox.getBots();
            for (int j = 0; j < bots.length; ++j) {
                JMenuItem menuItem2 = new JMenuItem((String)bots[j]);
                menuItem2.addActionListener(this);
                popup.add(menuItem2);
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void actionPerformed(ActionEvent ae) {
        String newAI = ae.getActionCommand();
        String command = "/setAI " + this.savedContextMenuRow + " " + newAI;
        SS.debug(command);
        this.control.dealWithCommand(command);
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        Point loc_in_parent = this.scrollpane.getLocation();
        e.translatePoint(loc_in_parent.x, loc_in_parent.y);
        int xoffset = e.getX() - this.lastMouseDragPoint.x;
        int yoffset = e.getY() - this.lastMouseDragPoint.y;
        this.control.visuals.moveInfoPanel(xoffset, yoffset);
        this.lastMouseDragPoint.setLocation(this.lastMouseDragPoint.getX() + (double)xoffset, this.lastMouseDragPoint.getY() + (double)yoffset);
    }

    public int getTranslatedRow(int viewRow) {
        if (viewRow == -1) {
            return viewRow;
        }
        int translatedRow = this.sorter.modelIndex(viewRow - 1) + 1;
        return translatedRow;
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        VoxClient control;
        private PlayerInfoController parent;

        public CustomTableCellRenderer(PlayerInfoController theParent, VoxClient control) {
            this.parent = theParent;
            this.control = control;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            try {
                int player = row + 1;
                if (value.equals("")) {
                    cell.setBackground(this.control.getPlayer(PlayerInfoController.this.getTranslatedRow(player)).getColor());
                } else {
                    Font f;
                    if (row % 2 == 0) {
                        cell.setBackground(PlayerInfoController.this.ROW_COLOR_1);
                    } else {
                        cell.setBackground(PlayerInfoController.this.ROW_COLOR_2);
                    }
                    if (this.control.stats.getArmies(PlayerInfoController.this.getTranslatedRow(player)) == 0) {
                        cell.setForeground(Color.GRAY);
                    } else {
                        cell.setForeground(Color.BLACK);
                    }
                    if (!SS.isMacintosh && !SS.isVista && column > 0 && (f = GraphicsTool.getDejaFontSized(12)) != null) {
                        cell.setFont(f);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return cell;
        }
    }
}

