/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.tools.XMLSerializable;
import com.sillysoft.tools.XMLTool;
import com.sillysoft.vox.IDable;
import com.sillysoft.vox.Team;
import java.awt.Color;
import org.xml.sax.Attributes;

public class Player
implements XMLSerializable,
IDable {
    private int ID;
    private Team team;
    private Color color;
    private String name;
    private String agentType;
    protected String controlledBy;
    protected String controlledByPrevious;
    protected String controlledByKey;
    protected String controlledByKeyPrevious;
    public static final Player WATER = new Player("Water", Team.WATER, Color.BLUE);
    protected boolean agentOverride = false;
    protected boolean controlledBySaved = false;
    protected String startingMoney;
    protected static boolean exportingWithKeys = false;

    public Player(String XML) {
        try {
            this.ID = Integer.parseInt(XMLTool.extractAttribute("id", XML));
            this.name = XMLTool.extractAttribute("name", XML);
            this.agentType = XMLTool.extractAttribute("agentType", XML);
            this.controlledBy = XMLTool.extractAttribute("controlledBy", XML);
            if ("null".equals(this.controlledBy)) {
                this.controlledBy = null;
            }
            this.color = GraphicsTool.colorFromString(XMLTool.extractAttribute("color", XML));
            this.team = new Team(XMLTool.extractAttribute("teamName", XML), XMLTool.extractAttribute("teamSymbol", XML));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toStringXML() {
        return "<player id=\"" + this.ID + "\" name=\"" + this.name + "\" color=\"" + GraphicsTool.stringFromColor(this.color) + "\" agentType=\"" + this.agentType + "\" " + (this.controlledBy != null ? "controlledBy=\"" + this.controlledBy + "\" " : (exportingWithKeys && this.controlledByPrevious != null ? "controlledBy=\"" + this.controlledByPrevious + "\" " : "")) + (exportingWithKeys && this.controlledByKey != null ? "cKey=\"" + this.controlledByKey + "\" " : (exportingWithKeys && this.controlledByKeyPrevious != null ? "cKey=\"" + this.controlledByKeyPrevious + "\" " : "")) + "teamName=\"" + this.team.getName() + "\" teamSymbol=\"" + this.team.getSymbol() + "\" />";
    }

    public Player(String name, Team team) {
        this(name, team, Color.BLACK);
    }

    public Player(String name, Team team, Color color) {
        this.ID = -1;
        this.team = team;
        this.color = color;
        this.name = name;
    }

    public Player(Attributes att, Team team) {
        try {
            this.ID = Integer.parseInt(att.getValue("id"));
        }
        catch (Exception e) {
            throw new RuntimeException("Player ID is not an integer (" + att.getValue("id") + ")");
        }
        this.team = team;
        this.color = GraphicsTool.colorFromString(att.getValue("color"));
        this.name = att.getValue("name");
        this.agentType = att.getValue("agent");
        if (this.agentType != null) {
            this.agentOverride = true;
            if ("boring".equals(this.agentType)) {
                this.agentType = "Boring";
            }
            SS.debug("Player " + this.name + " has over-ride agent type of " + att.getValue("agent"), 1);
        }
        this.controlledBy = att.getValue("controlledBy");
        if (this.controlledBy != null) {
            this.controlledBySaved = true;
            SS.debug("Player " + this.name + " has over-ride controlledBy of " + this.controlledBy, 1);
        }
        this.startingMoney = att.getValue("money");
        if (this.startingMoney != null) {
            SS.debug("Player " + this.name + " has starting money of " + this.startingMoney, 1);
        }
    }

    public Team getTeam() {
        return this.team;
    }

    public String getName() {
        return this.name;
    }

    public String name() {
        return this.name;
    }

    public String getBrain() {
        if (this.isHuman()) {
            return this.controlledBy;
        }
        return this.agentType;
    }

    public String getAgentType() {
        if (this.isHuman()) {
            return "Human";
        }
        return this.agentType;
    }

    public void setAgentType(String type) {
        if (!this.agentOverride || "Human".equals(type)) {
            this.agentType = type;
        } else {
            SS.debug("Disregard setAgentType(" + type + ") from override", 1);
        }
    }

    public String getControllerName() {
        if (this.controlledBy != null) {
            return this.controlledBy;
        }
        return this.agentType;
    }

    public boolean isHuman() {
        return "Human".equalsIgnoreCase(this.agentType) || this.controlledBy != null;
    }

    public Color getColor() {
        return this.color;
    }

    public int getID() {
        return this.ID;
    }

    public String toString() {
        return "<Player " + this.name + " :: " + this.team + ">";
    }

    public boolean equals(Object other) {
        if (other instanceof Player) {
            Player c = (Player)other;
            return c.name.equals(this.name) && c.ID == this.ID;
        }
        return false;
    }
}

