/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.ExtraLine;
import com.sillysoft.tools.GraphicsTool;
import com.sillysoft.tools.SS;
import com.sillysoft.vox.Continent;
import com.sillysoft.vox.Country;
import com.sillysoft.vox.Player;
import com.sillysoft.vox.Team;
import com.sillysoft.vox.Unit;
import com.sillysoft.vox.UnitPack;
import com.sillysoft.vox.VoxServer;
import java.awt.Point;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class MapLoader
extends DefaultHandler {
    private VoxServer control;
    private int width = -1;
    private int height = -1;
    private String title;
    private String theme;
    private StringBuffer buffer;
    private Country currentCountry;
    private GeneralPath shape = new GeneralPath();
    private List countries = new ArrayList();
    private Continent currentCont;
    private List continents = new ArrayList();
    private int nextContID = 0;
    private List teams = new ArrayList();
    private List players = new ArrayList();
    private Team currentTeam;
    private int gameRound = 1;
    private List lines = new ArrayList();
    private ExtraLine currentLine;

    public static void loadMap(String path, VoxServer control) throws SAXException {
        SS.debug(" ");
        SS.debug("Loading map at path " + path);
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            SAXParser saxParser = spf.newSAXParser();
            XMLReader parser = saxParser.getXMLReader();
            MapLoader handler = new MapLoader(control);
            parser.setContentHandler(handler);
            parser.parse(new File(path).toURI().toString());
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new SAXException(e);
        }
    }

    public MapLoader(VoxServer control) {
        this.control = control;
    }

    private Player getPlayerWithID(String id) throws SAXException {
        int intID;
        try {
            intID = Integer.parseInt(id);
        }
        catch (Exception e) {
            throw new SAXException("Player/owner ID '" + id + "' is not an integer", e);
        }
        return this.getPlayerWithID(intID);
    }

    private Player getPlayerWithID(int id) {
        for (int i = 0; i < this.players.size(); ++i) {
            if (((Player)this.players.get(i)).getID() != id) continue;
            return (Player)this.players.get(i);
        }
        throw new RuntimeException("Couldn't find any player with ID=" + id + ". Note that all player tags must be declared before any country tags.");
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes att) throws SAXException {
        if ("team".equalsIgnoreCase(qualifiedName)) {
            this.currentTeam = new Team(att);
            this.teams.add(this.currentTeam);
        } else if ("player".equalsIgnoreCase(qualifiedName)) {
            this.players.add(new Player(att, this.currentTeam));
        } else if ("continent".equalsIgnoreCase(qualifiedName)) {
            this.currentCont = new Continent(att);
            this.currentCont.setID(this.nextContID);
            ++this.nextContID;
        } else if ("country".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry = new Country(att);
        } else if ("unit".equalsIgnoreCase(qualifiedName)) {
            int number;
            try {
                number = Integer.parseInt(att.getValue("number"));
            }
            catch (Exception e) {
                throw new RuntimeException("Unit number '" + att.getValue("number") + "' is not an integer.");
            }
            Unit u = UnitPack.createUnit(att.getValue("type"), this.getPlayerWithID(att.getValue("owner")));
            if (u != null) {
                this.currentCountry.addUnits(u, number);
            }
        }
        this.buffer = new StringBuffer();
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String value = new String(ch, start, length);
        this.buffer.append(value);
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) throws SAXException {
        if ("width".equalsIgnoreCase(qualifiedName)) {
            if (this.width == -1) {
                this.width = Integer.parseInt(this.buffer.toString());
            }
            if (this.currentLine != null) {
                this.currentLine.width = Integer.parseInt(this.buffer.toString());
            }
        } else if ("height".equalsIgnoreCase(qualifiedName)) {
            this.height = Integer.parseInt(this.buffer.toString());
        } else if ("title".equalsIgnoreCase(qualifiedName)) {
            this.title = this.buffer.toString();
        } else if ("theme".equalsIgnoreCase(qualifiedName)) {
            this.theme = this.buffer.toString();
        } else if ("gameRound".equalsIgnoreCase(qualifiedName)) {
            this.gameRound = Integer.parseInt(this.buffer.toString());
        } else if ("polygon".equalsIgnoreCase(qualifiedName)) {
            StringTokenizer tok = new StringTokenizer(this.buffer.toString(), " ,");
            int firstX = Integer.parseInt(tok.nextToken());
            int firstY = this.height - Integer.parseInt(tok.nextToken());
            this.shape.moveTo(firstX, firstY);
            while (tok.hasMoreTokens()) {
                int x = Integer.parseInt(tok.nextToken());
                int y = this.height - Integer.parseInt(tok.nextToken());
                this.shape.lineTo(x, y);
            }
            this.shape.closePath();
        } else if ("adjoining".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setAdjoiningList(this.buffer.toString());
        } else if ("water".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setWater(this.buffer.toString().equals("true"));
        } else if ("voxPoints".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setVoxPoints(this.buffer.toString());
        } else if ("income".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setBonus(this.buffer.toString());
        } else if ("name".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setName(this.buffer.toString());
        } else if ("id".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setID(this.buffer.toString());
        } else if ("initialOwner".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setOwner(this.getPlayerWithID(this.buffer.toString()));
        } else if ("armylocation".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setLabelLocation(this.buffer.toString());
        } else if ("country".equalsIgnoreCase(qualifiedName)) {
            this.currentCountry.setShape(this.shape);
            this.currentCountry.setContinentID(this.currentCont.getID());
            this.shape = new GeneralPath();
            this.countries.add(this.currentCountry);
            this.currentCountry = null;
        } else if ("playerInfoLocation".equalsIgnoreCase(qualifiedName)) {
            this.control.setPlayerInfoLocation(this.buffer.toString());
        } else if ("countryBorderWidth".equalsIgnoreCase(qualifiedName)) {
            this.control.setCountryBorderWidth(this.buffer.toString());
        } else if ("continentname".equalsIgnoreCase(qualifiedName)) {
            this.currentCont.setName(this.buffer.toString());
        } else if ("bonus".equalsIgnoreCase(qualifiedName)) {
            this.currentCont.setBonus(this.buffer.toString());
        } else if ("labellocation".equalsIgnoreCase(qualifiedName)) {
            this.currentCont.setLabelLocation(this.buffer.toString());
        } else if ("color".equalsIgnoreCase(qualifiedName)) {
            if (this.currentCont != null) {
                this.currentCont.setColor(this.buffer.toString());
            } else if (this.currentLine != null) {
                this.currentLine.color = GraphicsTool.colorFromString(this.buffer.toString());
            }
        } else if ("position".equalsIgnoreCase(qualifiedName)) {
            String pos = this.buffer.toString();
            StringTokenizer tok = new StringTokenizer(pos, " ,");
            Point from = new Point(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            Point to = new Point(Integer.parseInt(tok.nextToken()), Integer.parseInt(tok.nextToken()));
            this.currentLine = new ExtraLine(from, to, 3, null, false);
        } else if ("above".equalsIgnoreCase(qualifiedName)) {
            if (this.currentLine != null && "true".equals(this.buffer.toString())) {
                this.currentLine.above = true;
            }
        } else if ("line".equalsIgnoreCase(qualifiedName)) {
            this.lines.add(this.currentLine);
            this.currentLine = null;
        } else if ("continent".equalsIgnoreCase(qualifiedName)) {
            this.continents.add(this.currentCont);
            this.currentCont = null;
        }
    }

    public void endDocument() throws SAXException {
        SS.debug("Finished reading in a map file. Finalizing...");
        for (int i = 0; i < this.countries.size(); ++i) {
            Country c = (Country)this.countries.get(i);
            c.resolveAdjoiningList(this.countries);
        }
        if (this.players == null || this.players.size() == 0) {
            throw new SAXException("You must set the players. \nAnd make sure to set their team IDs. \n(Set Scenario Player Info in the Editor)");
        }
        this.control.setMapInfo(this.width, this.height, this.title, this.theme);
        this.control.setCountries(this.countries);
        this.control.setContinents(this.continents);
        this.control.setLines(this.lines);
        this.control.setPlayers(this.players);
        this.control.setTeams(this.teams);
        this.control.finishedLoading();
        this.control.setGameRound(this.gameRound);
        this.control = null;
        this.buffer = null;
        this.currentTeam = null;
        this.currentCountry = null;
        this.countries = null;
        this.players = null;
        this.teams = null;
    }
}

