/*
 * Decompiled with CFR 0.152.
 */
package com.sillysoft.vox;

import com.sillysoft.tools.StringTool;
import com.sillysoft.vox.VJoinGame;
import com.sillysoft.widgets.SSApp;
import com.sillysoft.widgets.SSTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

class JoinTableCellRenderer
extends DefaultTableCellRenderer {
    private VJoinGame parent;
    private Color greenHost = new Color(20, 205, 10);
    private Color yellowHost = new Color(200, 200, 10);
    private Color orangeHost = new Color(220, 80, 10);
    private Color redHost = new Color(205, 20, 10);

    public JoinTableCellRenderer(VJoinGame theParent) {
        this.parent = theParent;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        cell.setForeground(isSelected ? Color.WHITE : Color.BLACK);
        if (table.getModel().getValueAt(row, 17).toString().indexOf(SSApp.getInstance().getDefaultJoinName()) != -1) {
            cell.setFont(new Font(cell.getFont().getName(), 1, cell.getFont().getSize()));
        }
        String s1 = table.getModel().getValueAt(row, 5).toString();
        int numerator = StringTool.getNumerator(s1);
        int denominator = StringTool.getDenominator(s1);
        if (Long.parseLong(table.getModel().getValueAt(row, 11).toString()) == 0L && s1.indexOf("/") != -1 && numerator < denominator && " ".equals(table.getModel().getValueAt(row, 0))) {
            cell.setForeground(this.greenHost);
        }
        String timer = table.getModel().getValueAt(row, 6).toString();
        if (column == 6 && timer.indexOf("minute") != -1) {
            cell.setForeground(this.redHost);
        }
        if (!isSelected) {
            if (row % 2 == 0) {
                cell.setBackground(SSTable.ROW_COLOR_2);
            } else {
                cell.setBackground(Color.WHITE);
            }
        }
        return cell;
    }
}

